/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.TcConfigDocument;
import java.util.List;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.views.AutolockWrapper;
import org.terracotta.dso.views.BootClassWrapper;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.DistributedMethodWrapper;
import org.terracotta.dso.views.ExcludeWrapper;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.dso.views.NamedLockWrapper;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class DeleteAction
extends Action {
    private ConfigViewPart fPart;

    public DeleteAction(ConfigViewPart part) {
        this.fPart = part;
        this.setText("Delete");
        this.setToolTipText("Delete");
        String iconPath = "images/eclipse/delete_edit.gif";
        this.setImageDescriptor(TcPlugin.getImageDescriptor(iconPath));
    }

    public boolean canActionBeAdded() {
        List list = SelectionUtil.toList(this.getSelection());
        if (list != null && list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Object element = list.get(i);
                if (element instanceof RootWrapper || element instanceof NamedLockWrapper || element instanceof AutolockWrapper || element instanceof BootClassWrapper || element instanceof TransientFieldWrapper || element instanceof DistributedMethodWrapper || element instanceof IncludeWrapper || element instanceof ExcludeWrapper) continue;
                return false;
            }
        }
        return list != null;
    }

    private ISelection getSelection() {
        ISelectionProvider provider = this.fPart.getSite().getSelectionProvider();
        if (provider != null) {
            return provider.getSelection();
        }
        return null;
    }

    public void run() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        DeleteOperation operation = new DeleteOperation();
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing DeleteOperation", ee);
        }
    }

    class DeleteOperation
    extends AbstractOperation {
        TcConfigDocument.TcConfig fPreConfig;
        TcConfigDocument.TcConfig fPostConfig;

        DeleteOperation() {
            super("Delete config elements");
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            this.fPreConfig = (TcConfigDocument.TcConfig)DeleteAction.this.fPart.getConfig().copy();
            DeleteAction.this.fPart.removeSelectedItem();
            this.fPostConfig = (TcConfigDocument.TcConfig)DeleteAction.this.fPart.getConfig().copy();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.setConfig(this.fPostConfig);
            }
            catch (Exception e) {
                throw new ExecutionException("Redoing delete", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
            try {
                this.setConfig(this.fPreConfig);
            }
            catch (Exception e) {
                throw new ExecutionException("Undoing delete", (Throwable)e);
            }
            return Status.OK_STATUS;
        }

        private void setConfig(TcConfigDocument.TcConfig config) throws Exception {
            TcPlugin plugin = TcPlugin.getDefault();
            IJavaProject javaProject = DeleteAction.this.fPart.getJavaProject();
            XmlOptions xmlOpts = plugin.getXmlOptions();
            TcConfigDocument doc = TcConfigDocument.Factory.newInstance((XmlOptions)xmlOpts);
            doc.setTcConfig(config);
            plugin.setConfigurationFromString(javaProject.getProject(), plugin.configDocumentAsString(doc));
        }
    }
}

