/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import java.text.MessageFormat;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.terracotta.dso.views.BootClassWrapper;
import org.terracotta.dso.views.ConfigViewPart;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.RootsWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.dso.views.TransientFieldsWrapper;

public class ConfigViewStatusBarUpdater
implements ISelectionChangedListener {
    private ConfigViewPart fConfigViewPart;
    private IStatusLineManager fStatusLineManager;
    private final long LABEL_FLAGS = JavaElementLabels.DEFAULT_QUALIFIED | 0x40000000000L | 0x80000000000L | 1L | 2L | 0x20L | 0x10L | 0x4000L | 0x200000L;

    public ConfigViewStatusBarUpdater(ConfigViewPart configViewPart, IStatusLineManager statusLineManager) {
        this.fConfigViewPart = configViewPart;
        this.fStatusLineManager = statusLineManager;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        String statusBarMessage = this.formatMessage(event.getSelection());
        this.fStatusLineManager.setMessage(statusBarMessage);
    }

    protected String formatMessage(ISelection sel) {
        if (sel instanceof IStructuredSelection && !sel.isEmpty()) {
            IStructuredSelection selection = (IStructuredSelection)sel;
            int nElements = selection.size();
            if (nElements > 1) {
                return MessageFormat.format("{0} items selected", String.valueOf(nElements));
            }
            Object elem = selection.getFirstElement();
            if (elem instanceof RootWrapper) {
                String rootField = ((RootWrapper)elem).getFieldName();
                IField field = this.fConfigViewPart.getField(rootField);
                if (field != null && field.exists()) {
                    return this.formatJavaElement((IJavaElement)field);
                }
                return MessageFormat.format("Root field {0} does not exist.", rootField);
            }
            if (elem instanceof RootsWrapper) {
                int rootCount = ((RootsWrapper)elem).sizeOfRootArray();
                String noun = rootCount == 1 ? "root" : "roots";
                return MessageFormat.format("{0} {1} declared", rootCount, noun);
            }
            if (elem instanceof BootClassWrapper) {
                String bootClassName = ((BootClassWrapper)elem).getClassName();
                IType bootType = this.fConfigViewPart.getType(bootClassName);
                if (bootType != null) {
                    return this.formatJavaElement((IJavaElement)bootType);
                }
                return MessageFormat.format("Boot class {0} does not exist.", bootClassName);
            }
            if (elem instanceof TransientFieldWrapper) {
                String transientField = ((TransientFieldWrapper)elem).getFieldName();
                IField field = this.fConfigViewPart.getField(transientField);
                if (field != null && field.exists()) {
                    return this.formatJavaElement((IJavaElement)field);
                }
                return MessageFormat.format("Transient field {0} does not exist.", transientField);
            }
            if (elem instanceof TransientFieldsWrapper) {
                int transientFieldCount = ((TransientFieldsWrapper)elem).sizeOfFieldNameArray();
                String noun = transientFieldCount == 1 ? "field" : "fields";
                return MessageFormat.format("{0} transient {1} declared", transientFieldCount, noun);
            }
        }
        return "";
    }

    private String formatJavaElement(IJavaElement element) {
        return JavaElementLabels.getElementLabel((IJavaElement)element, (long)this.LABEL_FLAGS);
    }
}

