/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import com.terracottatech.config.QualifiedClassName;
import com.terracottatech.config.QualifiedFieldName;
import com.terracottatech.config.TcConfigDocument;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.operations.UndoRedoActionGroup;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;
import org.terracotta.dso.ConfigurationAdapter;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.MultiChangeSignaller;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.views.AutolockWrapper;
import org.terracotta.dso.views.BootClassWrapper;
import org.terracotta.dso.views.ConfigRefreshAction;
import org.terracotta.dso.views.ConfigTransferDropAdapter;
import org.terracotta.dso.views.ConfigUI;
import org.terracotta.dso.views.ConfigViewStatusBarUpdater;
import org.terracotta.dso.views.ConfigViewer;
import org.terracotta.dso.views.DeleteAction;
import org.terracotta.dso.views.DistributedMethodWrapper;
import org.terracotta.dso.views.ExcludeWrapper;
import org.terracotta.dso.views.IncludeActionGroup;
import org.terracotta.dso.views.IncludeWrapper;
import org.terracotta.dso.views.LockActionGroup;
import org.terracotta.dso.views.LockLevelAction;
import org.terracotta.dso.views.LockWrapper;
import org.terracotta.dso.views.NamedLockWrapper;
import org.terracotta.dso.views.OnLoadAction;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.ui.util.SelectionUtil;

public class ConfigViewPart
extends ViewPart
implements ISelectionChangedListener,
IPartListener,
IMenuListener,
IDoubleClickListener,
IResourceChangeListener,
IResourceDeltaVisitor {
    public static final String ID_CONFIG_VIEW_PART = "org.terracotta.dso.ui.views.configView";
    private static TcPlugin fPlugin = TcPlugin.getDefault();
    ConfigViewer fConfigViewer;
    ConfigRefreshAction fRefreshAction;
    DeleteAction fDeleteAction;
    IncludeActionGroup fIncludeActionGroup;
    LockActionGroup fLockActionGroup;
    UndoRedoActionGroup fUndoRedoActionGroup;
    IJavaProject m_javaProject;
    private ConfigAdapter m_configAdapter;
    private static String REFRESH = ActionFactory.REFRESH.getId();
    private static String DELETE = ActionFactory.DELETE.getId();

    public void createPartControl(Composite parent) {
        this.createViewer(parent);
        this.initDragAndDrop(parent);
        IStatusLineManager slManager = this.getViewSite().getActionBars().getStatusLineManager();
        this.fConfigViewer.addSelectionChangedListener(new ConfigViewStatusBarUpdater(this, slManager));
        this.getSite().setSelectionProvider((ISelectionProvider)this.fConfigViewer);
        this.fConfigViewer.initContextMenu(this, this.getSite());
        this.fConfigViewer.addDoubleClickListener(this);
        this.makeActions();
        this.fillViewMenu();
        this.getSite().getPage().addPartListener((IPartListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        this.m_configAdapter = new ConfigAdapter();
        fPlugin.addConfigurationListener(this.m_configAdapter);
    }

    public void menuAboutToShow(IMenuManager menu) {
        this.fillConfigViewerContextMenu(menu);
    }

    private void createViewer(Composite parent) {
        this.fConfigViewer = new ConfigViewer(parent, this);
        this.fConfigViewer.addKeyListener(this.createKeyListener());
        this.fConfigViewer.addSelectionChangedListener(this);
    }

    private void initDragAndDrop(Composite parent) {
        this.addDropAdapters((StructuredViewer)this.fConfigViewer);
    }

    private void addDropAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        int ops = 23;
        viewer.addDropSupport(ops, transfers, (DropTargetListener)new ConfigTransferDropAdapter(this, viewer));
    }

    public static void createStandardGroups(IMenuManager menu) {
        if (!menu.isEmpty()) {
            return;
        }
        menu.add((IContributionItem)new Separator("group.new"));
        menu.add((IContributionItem)new GroupMarker("group.goto"));
        menu.add((IContributionItem)new Separator("group.open"));
        menu.add((IContributionItem)new GroupMarker("group.show"));
        menu.add((IContributionItem)new Separator("group.reorganize"));
        menu.add((IContributionItem)new Separator("group.generate"));
        menu.add((IContributionItem)new Separator("group.search"));
        menu.add((IContributionItem)new Separator("group.build"));
        menu.add((IContributionItem)new Separator("additions"));
        menu.add((IContributionItem)new Separator("group.viewerSetup"));
        menu.add((IContributionItem)new Separator("group.properties"));
    }

    protected void fillConfigViewerContextMenu(IMenuManager menu) {
        ConfigViewPart.createStandardGroups(menu);
        menu.appendToGroup("group.show", (IAction)this.fRefreshAction);
        if (this.fDeleteAction.canActionBeAdded()) {
            menu.appendToGroup("group.show", (IAction)this.fDeleteAction);
        }
        this.fIncludeActionGroup.setContext(new ActionContext(this.getSelection()));
        this.fIncludeActionGroup.fillContextMenu(menu);
        this.fIncludeActionGroup.setContext(null);
        this.fLockActionGroup.setContext(new ActionContext(this.getSelection()));
        this.fLockActionGroup.fillContextMenu(menu);
        this.fLockActionGroup.setContext(null);
    }

    public void setConfig(final TcConfigDocument.TcConfig config) {
        this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

            public void run() {
                String configPath = "";
                if (config == null) {
                    ConfigViewPart.this.m_javaProject = null;
                } else if (ConfigViewPart.this.m_javaProject != null) {
                    IProject project = ConfigViewPart.this.m_javaProject.getProject();
                    IFile configFile = TcPlugin.getDefault().getConfigurationFile(project);
                    if (configFile != null) {
                        configPath = project.getName() + '/' + configFile.getProjectRelativePath().toOSString();
                    }
                }
                ConfigViewPart.this.setTitleToolTip(configPath);
                ConfigViewPart.this.setContentDescription(configPath);
                ConfigViewPart.this.fConfigViewer.setConfig(config);
                ConfigViewPart.this.fRefreshAction.setEnabled(config != null);
                ConfigViewPart.this.fDeleteAction.setEnabled(config != null && ConfigViewPart.this.fDeleteAction.canActionBeAdded());
            }
        });
    }

    private void updateView() {
        this.fConfigViewer.refresh();
        this.fConfigViewer.expandAll();
    }

    private KeyListener createKeyListener() {
        KeyAdapter keyListener = new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                ConfigViewPart.this.handleKeyEvent(event);
            }
        };
        return keyListener;
    }

    protected void handleKeyEvent(KeyEvent event) {
        if (event.stateMask == 0) {
            if (event.keyCode == 0x100000E) {
                if (this.fRefreshAction != null && this.fRefreshAction.isEnabled()) {
                    this.fRefreshAction.run();
                    return;
                }
            } else if (event.keyCode == Action.findKeyCode((String)"DELETE") && this.fDeleteAction != null && this.fDeleteAction.isEnabled()) {
                this.fDeleteAction.run();
                return;
            }
        }
    }

    private void makeActions() {
        this.fRefreshAction = new ConfigRefreshAction(this);
        this.fDeleteAction = new DeleteAction(this);
        this.fIncludeActionGroup = new IncludeActionGroup(this);
        this.fLockActionGroup = new LockActionGroup(this);
        this.fUndoRedoActionGroup = new UndoRedoActionGroup((IWorkbenchPartSite)this.getViewSite(), (IUndoContext)ResourcesPlugin.getWorkspace().getAdapter(IUndoContext.class), true);
    }

    private void fillViewMenu() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        IToolBarManager toolBar = actionBars.getToolBarManager();
        actionBars.setGlobalActionHandler(REFRESH, (IAction)this.fRefreshAction);
        actionBars.setGlobalActionHandler(DELETE, (IAction)this.fDeleteAction);
        toolBar.add((IAction)this.fRefreshAction);
        toolBar.add((IAction)this.fDeleteAction);
        viewMenu.add((IAction)this.fRefreshAction);
        viewMenu.add((IAction)this.fDeleteAction);
        this.fIncludeActionGroup.fillActionBars(actionBars);
        this.fLockActionGroup.fillActionBars(actionBars);
        this.fUndoRedoActionGroup.fillActionBars(actionBars);
    }

    public void refresh() {
        this.updateView();
    }

    void removeSelectedItem() {
        ISelection sel = this.getSelection();
        if (!sel.isEmpty() && sel instanceof StructuredSelection) {
            IProject project = this.m_javaProject.getProject();
            StructuredSelection ss = (StructuredSelection)sel;
            Object[] objects = ss.toArray();
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = objects.length - 1; i >= 0; --i) {
                Object wrapper;
                Object obj = objects[i];
                if (obj instanceof RootWrapper) {
                    wrapper = (RootWrapper)obj;
                    ((RootWrapper)wrapper).remove();
                    signaller.rootsChanged = true;
                    continue;
                }
                if (obj instanceof LockWrapper) {
                    wrapper = (LockWrapper)obj;
                    ((LockWrapper)wrapper).remove();
                    if (wrapper instanceof NamedLockWrapper) {
                        signaller.namedLocksChanged = true;
                        continue;
                    }
                    signaller.autolocksChanged = true;
                    continue;
                }
                if (obj instanceof BootClassWrapper) {
                    wrapper = (BootClassWrapper)obj;
                    ((BootClassWrapper)wrapper).remove();
                    signaller.bootClassesChanged = true;
                    continue;
                }
                if (obj instanceof TransientFieldWrapper) {
                    wrapper = (TransientFieldWrapper)obj;
                    ((TransientFieldWrapper)wrapper).remove();
                    signaller.transientFieldsChanged = true;
                    continue;
                }
                if (obj instanceof DistributedMethodWrapper) {
                    wrapper = (DistributedMethodWrapper)obj;
                    ((DistributedMethodWrapper)wrapper).remove();
                    signaller.distributedMethodsChanged = true;
                    continue;
                }
                if (obj instanceof IncludeWrapper) {
                    wrapper = (IncludeWrapper)obj;
                    ((IncludeWrapper)wrapper).remove();
                    signaller.includeRulesChanged = true;
                    continue;
                }
                if (!(obj instanceof ExcludeWrapper)) continue;
                wrapper = (ExcludeWrapper)obj;
                ((ExcludeWrapper)wrapper).remove();
                signaller.excludeRulesChanged = true;
            }
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.removeConfigurationListener(this.m_configAdapter);
                fPlugin.saveConfiguration(project);
                fPlugin.addConfigurationListener(this.m_configAdapter);
            }
            signaller.signal(project);
        }
    }

    void addRoot(IField field) {
        this.addRoots(new IField[]{field});
    }

    void addRoots(IField[] fields) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < fields.length; ++i) {
                configHelper.ensureRoot(fields[i], signaller);
            }
            signaller.signal(project);
        }
    }

    void addInclude(IJavaElement element) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            configHelper.ensureAdaptable(element);
        }
    }

    void addIncludes(IJavaElement[] elements) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            for (int i = 0; i < elements.length; ++i) {
                configHelper.ensureAdaptable(elements[i]);
            }
        }
    }

    void setIncludeExpression(String classExpression) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof IncludeWrapper) {
            IncludeWrapper wrapper = (IncludeWrapper)element;
            wrapper.setClassExpression(classExpression);
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            fPlugin.fireIncludeRuleChanged(project, wrapper.getIndex());
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
            this.fConfigViewer.update(element, null);
        }
    }

    void setHonorTransient(boolean honor) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof IncludeWrapper) {
            IncludeWrapper wrapper = (IncludeWrapper)element;
            wrapper.setHonorTransient(honor);
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            fPlugin.fireIncludeRuleChanged(project, wrapper.getIndex());
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
        }
    }

    void setOnLoad(OnLoadAction action, String handler) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof IncludeWrapper) {
            IncludeWrapper wrapper = (IncludeWrapper)element;
            if (action.isNoop()) {
                wrapper.unsetOnLoad();
            } else if (action.isExecute()) {
                wrapper.setOnLoadExecute(handler);
            } else if (action.isMethod()) {
                wrapper.setOnLoadMethod(handler);
            }
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            fPlugin.fireIncludeRuleChanged(project, wrapper.getIndex());
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
        }
    }

    void addExclude(IJavaElement element) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            configHelper.ensureExcluded(element);
        }
    }

    void addExcludes(IJavaElement[] elements) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            for (int i = 0; i < elements.length; ++i) {
                configHelper.ensureExcluded(elements[i]);
            }
        }
    }

    void setLockExpression(String classExpression) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof LockWrapper) {
            LockWrapper wrapper = (LockWrapper)element;
            wrapper.setMethodExpression(classExpression);
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            if (wrapper instanceof NamedLockWrapper) {
                fPlugin.fireNamedLockChanged(project, wrapper.getIndex());
            } else {
                fPlugin.fireAutolockChanged(project, wrapper.getIndex());
            }
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
            this.fConfigViewer.update(element, null);
        }
    }

    void setLockName(String lockName) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof NamedLockWrapper) {
            NamedLockWrapper wrapper = (NamedLockWrapper)element;
            wrapper.setLockName(lockName);
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            fPlugin.fireNamedLockChanged(project, wrapper.getIndex());
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
            this.fConfigViewer.update(element, null);
        }
    }

    void setLockLevel(LockLevelAction action) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof LockWrapper) {
            LockWrapper wrapper = (LockWrapper)element;
            wrapper.setLevel(action.getLevel());
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            if (wrapper instanceof NamedLockWrapper) {
                fPlugin.fireNamedLockChanged(project, wrapper.getIndex());
            } else {
                fPlugin.fireAutolockChanged(project, wrapper.getIndex());
            }
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
        }
    }

    void setAutoSynchronized(boolean autoSynchronized) {
        ISelection selection = this.getSelection();
        Object element = SelectionUtil.getSingleElement(selection);
        if (element instanceof AutolockWrapper) {
            AutolockWrapper wrapper = (AutolockWrapper)element;
            if (autoSynchronized) {
                wrapper.setAutoSynchronized(autoSynchronized);
            } else {
                wrapper.unsetAutoSynchronized();
            }
            IProject project = this.m_javaProject.getProject();
            fPlugin.removeConfigurationListener(this.m_configAdapter);
            fPlugin.fireAutolockChanged(project, wrapper.getIndex());
            if (fPlugin.getConfigurationEditor(project) == null) {
                fPlugin.saveConfiguration(project);
            }
            fPlugin.addConfigurationListener(this.m_configAdapter);
        }
    }

    void addTransientField(IField field) {
        this.addTransientFields(new IField[]{field});
    }

    void addTransientFields(IField[] fields) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < fields.length; ++i) {
                configHelper.ensureTransient(fields[i], signaller);
            }
            signaller.signal(project);
        }
    }

    void addDistributedMethod(IMethod method) {
        this.addDistributedMethods(new IMethod[]{method});
    }

    void addDistributedMethods(IMethod[] methods) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < methods.length; ++i) {
                configHelper.ensureDistributedMethod(methods[i], signaller);
            }
            signaller.signal(project);
        }
    }

    void addAdditionalBootJarClass(IType type) {
        this.addAdditionalBootJarClasses(new IType[]{type});
    }

    void addAdditionalBootJarClasses(IType[] types) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < types.length; ++i) {
                configHelper.ensureBootJarClass(types[i], signaller);
            }
            signaller.signal(project);
        }
    }

    void addAutolock(IJavaElement element) {
        this.addAutolocks(new IJavaElement[]{element});
    }

    void addAutolocks(IJavaElement[] elements) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < elements.length; ++i) {
                configHelper.ensureAutolocked(elements[i], signaller);
            }
            signaller.signal(project);
        }
    }

    void addNamedLock(IJavaElement element) {
        this.addNamedLocks(new IJavaElement[]{element});
    }

    void addNamedLocks(IJavaElement[] elements) {
        if (this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            MultiChangeSignaller signaller = new MultiChangeSignaller();
            for (int i = 0; i < elements.length; ++i) {
                configHelper.ensureNameLocked(elements[i], signaller);
            }
            signaller.signal(project);
        }
    }

    public void setFocus() {
        this.fConfigViewer.setFocus();
    }

    IType getType(String typeName) {
        if (this.m_javaProject != null) {
            try {
                return JdtUtils.findType(this.m_javaProject, typeName);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    IField getField(String fieldName) {
        if (fieldName != null && this.m_javaProject != null) {
            IProject project = this.m_javaProject.getProject();
            ConfigurationHelper configHelper = fPlugin.getConfigurationHelper(project);
            return configHelper.getField(fieldName);
        }
        return null;
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.fDeleteAction.setEnabled(this.fDeleteAction.canActionBeAdded());
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        if (this.fIncludeActionGroup != null) {
            this.fIncludeActionGroup.dispose();
        }
        if (this.fLockActionGroup != null) {
            this.fLockActionGroup.dispose();
        }
        if (this.fUndoRedoActionGroup != null) {
            this.fUndoRedoActionGroup.dispose();
        }
        fPlugin.removeConfigurationListener(this.m_configAdapter);
        this.getViewSite().getPage().removePartListener((IPartListener)this);
        super.dispose();
    }

    public IJavaProject getJavaProject() {
        return this.m_javaProject;
    }

    public TcConfigDocument.TcConfig getConfig() {
        if (this.m_javaProject != null) {
            return fPlugin.getConfiguration(this.m_javaProject.getProject());
        }
        return null;
    }

    protected ISelection getSelection() {
        return this.fConfigViewer.getSelection();
    }

    private void initFromJavaProject(IJavaProject javaProject) {
        if (javaProject == null || !javaProject.equals(this.m_javaProject)) {
            TcConfigDocument.TcConfig config = null;
            this.m_javaProject = javaProject;
            if (this.m_javaProject != null) {
                IProject project = javaProject.getProject();
                if (TcPlugin.getDefault().hasTerracottaNature(project)) {
                    config = fPlugin.getConfiguration(project);
                }
            }
            this.setConfig(config);
        }
    }

    public void partActivated(IWorkbenchPart part) {
        ISelection selection;
        IWorkbenchWindow window;
        if (part != this && (window = part.getSite().getWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) != null) {
            this.initFromJavaProject(ActionUtil.locateSelectedJavaProject(selection));
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
        ISelection selection;
        IWorkbenchWindow window;
        if (part == this && (window = part.getSite().getWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) != null) {
            this.initFromJavaProject(ActionUtil.locateSelectedJavaProject(selection));
        }
    }

    public void doubleClick(DoubleClickEvent event) {
        StructuredSelection ss;
        ISelection sel = event.getSelection();
        if (!sel.isEmpty() && sel instanceof StructuredSelection && (ss = (StructuredSelection)sel).size() == 1) {
            Object obj = ss.getFirstElement();
            IField member = null;
            if (obj instanceof RootWrapper) {
                member = this.getField(((RootWrapper)obj).getFieldName());
            } else if (obj instanceof QualifiedFieldName) {
                member = this.getField(((QualifiedFieldName)obj).getStringValue());
            } else if (obj instanceof QualifiedClassName) {
                member = this.getType(((QualifiedClassName)obj).getStringValue());
            } else if (obj instanceof BootClassWrapper) {
                member = this.getType(((BootClassWrapper)obj).getClassName());
            } else if (obj instanceof TransientFieldWrapper) {
                member = this.getField(((TransientFieldWrapper)obj).getFieldName());
            }
            if (member != null) {
                ConfigUI.jumpToMember((IJavaElement)member);
            }
        }
    }

    public boolean visit(IResourceDelta delta) {
        if (this.fConfigViewer == null || this.fConfigViewer.getTree().isDisposed() || PlatformUI.getWorkbench().isClosing()) {
            return false;
        }
        final IProject project = this.isAffected(delta);
        if (project != null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    ConfigViewPart.this.m_javaProject = JavaCore.create((IProject)project);
                    ConfigViewPart.this.setConfig(fPlugin.getConfiguration(project));
                }
            });
            return false;
        }
        return true;
    }

    private IProject isAffected(IResourceDelta delta) {
        IResource res = delta.getResource();
        IProject project = null;
        if (res instanceof IProject && (delta.getKind() == 1 || (delta.getFlags() & 0x80000) != 0)) {
            project = (IProject)delta.getResource();
            return project;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        for (int i = 0; i < children.length; ++i) {
            project = this.isAffected(children[i]);
            if (project == null) continue;
            return project;
        }
        return null;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        switch (event.getType()) {
            case 1: {
                try {
                    event.getDelta().accept((IResourceDeltaVisitor)this);
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                break;
            }
            case 2: 
            case 4: {
                this.setConfig(null);
            }
        }
    }

    class ConfigAdapter
    extends ConfigurationAdapter {
        ConfigAdapter() {
        }

        public void configurationChanged(IProject project) {
            if (TcPlugin.getDefault().hasTerracottaNature(project)) {
                if (ConfigViewPart.this.m_javaProject != null && ConfigViewPart.this.m_javaProject.getProject().equals(project)) {
                    ConfigViewPart.this.m_javaProject = JavaCore.create((IProject)project);
                    ConfigViewPart.this.setConfig(fPlugin.getConfiguration(project));
                }
            } else {
                ConfigViewPart.this.setConfig(null);
            }
        }

        public void rootChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshRoot(index);
        }

        public void rootsChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshRoots();
        }

        public void distributedMethodsChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshDistributedMethods();
        }

        public void distributedMethodChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshDistributedMethod(index);
        }

        public void bootClassesChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshBootClasses();
        }

        public void bootClassChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshBootClass(index);
        }

        public void transientFieldsChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshTransientFields();
        }

        public void transientFieldChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshTransientField(index);
        }

        public void namedLockChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshNamedLock(index);
        }

        public void namedLocksChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshNamedLocks();
        }

        public void autolockChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshAutolock(index);
        }

        public void autolocksChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshAutolocks();
        }

        public void includeRuleChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshIncludeRule(index);
        }

        public void includeRulesChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshInstrumentationRules();
        }

        public void excludeRuleChanged(IProject project, int index) {
            ConfigViewPart.this.fConfigViewer.refreshExcludeRule(index);
        }

        public void excludeRulesChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshInstrumentationRules();
        }

        public void instrumentationRulesChanged(IProject project) {
            ConfigViewPart.this.fConfigViewer.refreshInstrumentationRules();
        }
    }
}

