/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.views.AdditionalBootJarClassesWrapper;
import org.terracotta.dso.views.BootClassWrapper;
import org.terracotta.dso.views.ConfigViewer;
import org.terracotta.dso.views.DistributedMethodsWrapper;
import org.terracotta.dso.views.InstrumentedClassesWrapper;
import org.terracotta.dso.views.LocksWrapper;
import org.terracotta.dso.views.RootWrapper;
import org.terracotta.dso.views.RootsWrapper;
import org.terracotta.dso.views.TransientFieldWrapper;
import org.terracotta.dso.views.TransientFieldsWrapper;

class ConfigLabelProvider
extends LabelProvider {
    private ConfigViewer fViewer;
    private static Image m_rootsImage;
    private static Image m_bootClassesImage;
    private static Image m_distributedMethodsImage;
    private static Image m_instrumentedClassesImage;
    private static Image m_locksImage;
    private static Image m_transientsImage;
    private static Image m_missingElementImage;
    private static JavaElementLabelProvider m_javaLabelProvider;

    ConfigLabelProvider(ConfigViewer viewer) {
        this.fViewer = viewer;
    }

    public String getText(Object element) {
        if (element instanceof RootsWrapper) {
            return "Roots";
        }
        if (element instanceof InstrumentedClassesWrapper) {
            return "Instrumented classes";
        }
        if (element instanceof LocksWrapper) {
            return "Locks";
        }
        if (element instanceof DistributedMethodsWrapper) {
            return "Distributed methods";
        }
        if (element instanceof AdditionalBootJarClassesWrapper) {
            return "Additional boot classes";
        }
        if (element instanceof TransientFieldsWrapper) {
            return "Transient fields";
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        if (element instanceof RootWrapper) {
            RootWrapper wrapper = (RootWrapper)element;
            if (wrapper.isSetFieldName()) {
                return this.getJavaElementImage((IJavaElement)this.fViewer.getPart().getField(wrapper.getFieldName()));
            }
            if (wrapper.isSetFieldExpression()) {
                return null;
            }
        } else {
            if (element instanceof RootsWrapper) {
                return m_rootsImage;
            }
            if (element instanceof LocksWrapper) {
                return m_locksImage;
            }
            if (element instanceof DistributedMethodsWrapper) {
                return m_distributedMethodsImage;
            }
            if (element instanceof AdditionalBootJarClassesWrapper) {
                return m_bootClassesImage;
            }
            if (element instanceof TransientFieldsWrapper) {
                return m_transientsImage;
            }
            if (element instanceof InstrumentedClassesWrapper) {
                return m_instrumentedClassesImage;
            }
            if (element instanceof BootClassWrapper) {
                String className = ((BootClassWrapper)element).getClassName();
                return this.getJavaElementImage((IJavaElement)this.fViewer.getPart().getType(className));
            }
            if (element instanceof TransientFieldWrapper) {
                String fieldName = ((TransientFieldWrapper)element).getFieldName();
                return this.getJavaElementImage((IJavaElement)this.fViewer.getPart().getField(fieldName));
            }
        }
        return null;
    }

    private Image getJavaElementImage(IJavaElement element) {
        if (element != null) {
            return m_javaLabelProvider.getImage((Object)element);
        }
        return m_missingElementImage;
    }

    static {
        m_javaLabelProvider = new JavaElementLabelProvider(256);
        m_rootsImage = TcPlugin.createImage("/images/eclipse/roots.gif");
        m_locksImage = TcPlugin.createImage("/images/eclipse/locks.gif");
        m_transientsImage = TcPlugin.createImage("/images/eclipse/transients.gif");
        m_bootClassesImage = TcPlugin.createImage("/images/eclipse/jar_obj.gif");
        m_distributedMethodsImage = TcPlugin.createImage("/images/eclipse/jmeth_obj.gif");
        m_instrumentedClassesImage = TcPlugin.createImage("/images/eclipse/class_obj.gif");
        m_missingElementImage = TcPlugin.createImage("/images/eclipse/hprio_tsk.gif");
    }
}

