/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.views;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.terracotta.dso.BootJarHelper;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.views.ConfigUI;

public class BootJarView
extends ViewPart
implements IResourceChangeListener,
IResourceDeltaVisitor,
ISelectionChangedListener,
IPartListener {
    public static final String ID_BOOTJAR_VIEW_PART = "org.terracotta.dso.ui.views.bootJarView";
    private TableViewer viewer;
    private IFile bootJarFile = this.getBootJarFile();
    private IJavaProject lastJavaProject;
    private static final String EMPTY_CONTENT_ELEM = "No boot JAR found.";
    private static final Object[] EMPTY_CONTENT = new Object[]{"No boot JAR found."};

    public void createPartControl(Composite parent) {
        this.viewer = new TableViewer(parent, 770);
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ViewLabelProvider());
        this.viewer.setInput((Object)this.getViewSite());
        this.viewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().getPage().addPartListener((IPartListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    public IFile getBootJarFile() {
        IProject project;
        IFile localBootJar;
        IJavaProject javaProject;
        ISelection selection;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) != null && (javaProject = ActionUtil.locateSelectedJavaProject(selection)) != null && (localBootJar = (project = javaProject.getProject()).getFile(BootJarView.safeGetInstallBootJarName(javaProject))) != null) {
            this.lastJavaProject = javaProject;
            return localBootJar;
        }
        return null;
    }

    private static String getDefaultBootJarPath() {
        IPath path;
        String bootJarName = BootJarView.safeGetInstallBootJarName();
        if (bootJarName != null && (path = BootJarHelper.getHelper().getBootJarPath(bootJarName)) != null) {
            return path.toOSString();
        }
        return null;
    }

    private static String safeGetInstallBootJarName(IJavaProject javaProject) {
        try {
            String portablePath = null;
            IPath jrePath = JavaRuntime.computeJREEntry((IJavaProject)javaProject).getPath();
            if (jrePath != null) {
                portablePath = jrePath.toPortableString();
            }
            return BootJarHelper.getHelper().getBootJarName(portablePath);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    private static String safeGetInstallBootJarName() {
        try {
            return BootJarHelper.getHelper().getBootJarName();
        }
        catch (CoreException ce) {
            ce.printStackTrace();
            return null;
        }
    }

    public boolean visit(IResourceDelta delta) {
        if (this.viewer == null || this.viewer.getTable().isDisposed() || PlatformUI.getWorkbench().isClosing()) {
            return false;
        }
        IResource res = delta.getResource();
        if (res instanceof IProject) {
            IProject project = (IProject)res;
            if (delta.getKind() == 1 && TcPlugin.getDefault().hasTerracottaNature(project) || (delta.getFlags() & 0x80000) != 0) {
                this.reset();
                return false;
            }
        }
        if (this.isAffected(delta)) {
            this.reset();
            return false;
        }
        return true;
    }

    private boolean isAffected(IResourceDelta delta) {
        IResource res = delta.getResource();
        if (res instanceof IFile && res.equals(this.bootJarFile)) {
            return true;
        }
        IResourceDelta[] children = delta.getAffectedChildren();
        for (int i = 0; i < children.length; ++i) {
            if (!this.isAffected(children[i])) continue;
            return true;
        }
        return false;
    }

    public void resourceChanged(final IResourceChangeEvent event) {
        int type = event.getType();
        if (type == 4 || type == 2) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    BootJarView.this.clear();
                }
            });
        } else if (type == 1) {
            this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    try {
                        BootJarView.this.bootJarFile = BootJarView.this.getBootJarFile();
                        event.getDelta().accept((IResourceDeltaVisitor)BootJarView.this);
                    }
                    catch (CoreException ce) {
                        ce.printStackTrace();
                    }
                }
            });
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        Object obj;
        StructuredSelection ss;
        ISelection sel = event.getSelection();
        if (!sel.isEmpty() && this.bootJarFile != null && sel instanceof StructuredSelection && (ss = (StructuredSelection)sel).size() == 1 && (obj = ss.getFirstElement()) instanceof String) {
            String typeName = (String)obj;
            try {
                IJavaProject javaProject = JavaCore.create((IProject)this.bootJarFile.getProject());
                IType type = JdtUtils.findType(javaProject, typeName);
                if (type != null) {
                    ConfigUI.jumpToMember((IJavaElement)type);
                }
            }
            catch (JavaModelException jme) {
                jme.printStackTrace();
            }
        }
    }

    public void partActivated(IWorkbenchPart part) {
        IJavaProject javaProject;
        ISelection selection;
        IWorkbenchWindow window;
        if (part != this && (window = part.getSite().getWorkbenchWindow()) != null && (selection = window.getSelectionService().getSelection()) != null && (javaProject = ActionUtil.locateSelectedJavaProject(selection)) != null && !javaProject.equals(this.lastJavaProject)) {
            this.bootJarFile = this.getBootJarFile();
            this.reset();
        }
    }

    public void partBroughtToTop(IWorkbenchPart part) {
    }

    public void partClosed(IWorkbenchPart part) {
    }

    public void partDeactivated(IWorkbenchPart part) {
    }

    public void partOpened(IWorkbenchPart part) {
    }

    void reset() {
        this.viewer.setContentProvider((IContentProvider)new ViewContentProvider());
        this.viewer.setInput((Object)this.getViewSite());
    }

    void clear() {
        this.bootJarFile = null;
        this.reset();
    }

    public void dispose() {
        this.viewer.removeSelectionChangedListener((ISelectionChangedListener)this);
        this.getSite().getPage().removePartListener((IPartListener)this);
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        super.dispose();
    }

    static class ViewLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ViewLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return this.getText(obj);
        }

        public Image getColumnImage(Object obj, int index) {
            return this.getImage(obj);
        }

        public Image getImage(Object obj) {
            String imgName = obj != BootJarView.EMPTY_CONTENT_ELEM ? "org.eclipse.jdt.ui.class_obj.gif" : "org.eclipse.jdt.ui.error_obj.gif";
            return JavaPluginImages.get((String)imgName);
        }
    }

    class ViewContentProvider
    implements IStructuredContentProvider {
        ViewContentProvider() {
        }

        public void inputChanged(Viewer v, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object[] getElements(Object parent) {
            ArrayList<String> list = new ArrayList<String>();
            if (BootJarView.this.bootJarFile != null && !BootJarView.this.bootJarFile.isSynchronized(0)) {
                try {
                    BootJarView.this.bootJarFile.refreshLocal(0, null);
                }
                catch (CoreException ce) {
                    // empty catch block
                }
            }
            String fileName = null;
            String tip = "";
            String desc = "";
            if (!(BootJarView.this.bootJarFile != null && BootJarView.this.bootJarFile.exists() && BootJarView.this.bootJarFile.getProject().isOpen() && TcPlugin.getDefault().hasTerracottaNature(BootJarView.this.bootJarFile.getProject()))) {
                tip = fileName = BootJarView.getDefaultBootJarPath();
                desc = "System bootjar: " + new File(fileName).getName();
            } else {
                fileName = BootJarView.this.bootJarFile.getLocation().toOSString();
                tip = desc = BootJarView.this.bootJarFile.getProject().getName() + '/' + BootJarView.this.bootJarFile.getName();
            }
            File file = new File(fileName);
            BootJarView.this.setTitleToolTip(tip);
            BootJarView.this.setContentDescription(desc);
            if (fileName == null || !file.exists()) {
                return EMPTY_CONTENT;
            }
            ZipFile zipFile = null;
            try {
                zipFile = new ZipFile(fileName);
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    ZipEntry e = entries.nextElement();
                    String name = e.getName();
                    if (!name.endsWith(".class") || name.startsWith("com/tc")) continue;
                    name = name.substring(0, name.lastIndexOf(46)).replace('/', '.').replace('$', '.');
                    list.add(name);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
            finally {
                if (zipFile != null) {
                    try {
                        zipFile.close();
                    }
                    catch (IOException ioe) {}
                }
            }
            Collections.sort(list);
            return list.toArray();
        }
    }
}

