/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;

public class RenameFieldChange
extends Change {
    private String fNewFieldName;
    private String fOldFieldName;
    private String fProjectName;

    public RenameFieldChange(IField field, String newTypeName) {
        IType type = field.getDeclaringType();
        String parentType = PatternHelper.getFullyQualifiedName(type);
        String fieldName = field.getElementName();
        this.fOldFieldName = parentType + "." + fieldName;
        this.fNewFieldName = parentType + "." + newTypeName;
        this.fProjectName = field.getAncestor(2).getElementName();
    }

    public RenameFieldChange(String oldFieldName, String newFieldName, String projectName) {
        this.fNewFieldName = newFieldName;
        this.fOldFieldName = oldFieldName;
        this.fProjectName = projectName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return "TCRenameFieldConfigUpdate";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) {
        TcPlugin plugin = TcPlugin.getDefault();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fProjectName);
        plugin.getConfigurationHelper(project).renameRoot(this.fOldFieldName, this.fNewFieldName);
        return new RenameFieldChange(this.fNewFieldName, this.fOldFieldName, this.fProjectName);
    }
}

