/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.refactoring;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jdt.core.IType;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.terracotta.dso.TcPlugin;

public class MoveTypeChange
extends Change {
    private String fNewTypeName;
    private String fNewProjectName;
    private String fOldTypeName;
    private String fOldProjectName;

    public MoveTypeChange(IType srcType, String newTypeName, String newProjectName) {
        this(srcType.getFullyQualifiedName(), srcType.getAncestor(2).getElementName(), newTypeName, newProjectName);
    }

    public MoveTypeChange(String oldTypeName, String oldProjectName, String newTypeName, String newProjectName) {
        this.fNewTypeName = newTypeName;
        this.fNewProjectName = newProjectName;
        this.fOldTypeName = oldTypeName;
        this.fOldProjectName = oldProjectName;
    }

    public Object getModifiedElement() {
        return null;
    }

    public String getName() {
        return "TCMoveTypeConfigUpdate";
    }

    public void initializeValidationData(IProgressMonitor pm) {
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change perform(IProgressMonitor pm) {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject project = workspace.getRoot().getProject(this.fOldProjectName);
        TcPlugin.getDefault().replaceConfigText(project, this.fOldTypeName, this.fNewTypeName);
        return new MoveTypeChange(this.fNewTypeName, this.fNewProjectName, this.fOldTypeName, this.fOldProjectName);
    }
}

