/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.launch;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.ui.launcher.EclipseApplicationLaunchConfiguration;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.launch.IDSOLaunchDelegate;
import org.terracotta.dso.launch.LaunchHelper;

public class DSOEclipseApplicationLaunchConfiguration
extends EclipseApplicationLaunchConfiguration
implements IDSOLaunchDelegate {
    private final LaunchHelper fLaunchHelper = new LaunchHelper(this);

    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        ILaunchConfigurationWorkingCopy wc = this.fLaunchHelper.setup(config, mode, launch, monitor);
        if (wc != null) {
            super.launch((ILaunchConfiguration)wc, mode, launch, monitor);
        }
    }

    public IJavaProject getJavaProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IJavaProject javaProject;
        String projectName = this.getJavaProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (javaProject = JavaCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && javaProject.exists()) {
            return javaProject;
        }
        return null;
    }

    public String getJavaProjectName(ILaunchConfiguration configuration) throws CoreException {
        IProject[] projs;
        String appNameRoot = configuration.getAttribute("application", (String)null);
        if (appNameRoot == null) {
            String msg = "No application specified for launch configuration '" + configuration.getName() + "'";
            Status status = new Status(4, TcPlugin.getPluginId(), 1, msg, null);
            throw new CoreException((IStatus)status);
        }
        appNameRoot = appNameRoot.substring(0, appNameRoot.lastIndexOf(46));
        for (IProject proj : projs = ResourcesPlugin.getWorkspace().getRoot().getProjects()) {
            IPluginModelBase base = PluginRegistry.findModel((IProject)proj);
            if (base == null || !appNameRoot.equals(base.getPluginBase().getId())) continue;
            return proj.getName();
        }
        String msg = "Unable to determine project for pluginId '" + appNameRoot + "'";
        Status status = new Status(4, TcPlugin.getPluginId(), 1, msg, null);
        throw new CoreException((IStatus)status);
    }

    public IVMInstall getVMInstall(ILaunchConfiguration configuration) throws CoreException {
        String vm = configuration.getAttribute("vminstall", (String)null);
        IVMInstall launcher = DSOEclipseApplicationLaunchConfiguration.getVMInstall(vm);
        if (launcher == null) {
            String msg = "Cannot locate VMInstall for '" + vm + "'";
            Status status = new Status(4, TcPlugin.getPluginId(), 1, msg, null);
            throw new CoreException((IStatus)status);
        }
        return launcher;
    }

    public static IVMInstall getVMInstall(String name) {
        if (name != null) {
            IVMInstall[] installs;
            for (IVMInstall install : installs = DSOEclipseApplicationLaunchConfiguration.getAllVMInstances()) {
                if (!install.getName().equals(name)) continue;
                return install;
            }
        }
        return JavaRuntime.getDefaultVMInstall();
    }

    public static IVMInstall[] getAllVMInstances() {
        IVMInstallType[] types;
        ArrayList<IVMInstall> res = new ArrayList<IVMInstall>();
        for (IVMInstallType type : types = JavaRuntime.getVMInstallTypes()) {
            IVMInstall[] installs;
            for (IVMInstall install : installs = type.getVMInstalls()) {
                res.add(install);
            }
        }
        return res.toArray(new IVMInstall[res.size()]);
    }
}

