/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.launch;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.launch.IDSOLaunchConfigurationConstants;
import org.terracotta.ui.util.SWTUtil;

public class ConfigurationTab
extends AbstractLaunchConfigurationTab
implements IDSOLaunchConfigurationConstants {
    private Text fServerText;
    private Button fConfigServerButton;
    private Text fConfigServerText;
    private Button fConfigFileButton;
    private Text fConfigFileText;
    private Button fConfigBrowseButton;
    private ModifyListener fBasicModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent evt) {
            ConfigurationTab.this.updateLaunchConfigurationDialog();
        }
    };
    private SelectionAdapter fConfigSelector = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget == ConfigurationTab.this.fConfigServerButton) {
                ConfigurationTab.this.fConfigServerText.setEnabled(true);
                ConfigurationTab.this.fConfigFileText.setEnabled(false);
            } else {
                ConfigurationTab.this.fConfigServerText.setEnabled(false);
                ConfigurationTab.this.fConfigFileText.setEnabled(true);
            }
        }
    };

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        comp.setLayout((Layout)new GridLayout());
        Group group = new Group(comp, 0);
        group.setText("Server specification");
        group.setLayout((Layout)new GridLayout());
        group.setLayoutData((Object)new GridData(768));
        this.fServerText = new Text((Composite)group, 2052);
        this.fServerText.setLayoutData((Object)new GridData(768));
        this.fServerText.addModifyListener(this.fBasicModifyListener);
        group = new Group(comp, 0);
        group.setText("Configuration specification");
        group.setLayout((Layout)new GridLayout(3, false));
        group.setLayoutData((Object)new GridData(768));
        this.fConfigServerButton = new Button((Composite)group, 16);
        this.fConfigServerButton.setText("Server");
        this.fConfigServerButton.addSelectionListener((SelectionListener)this.fConfigSelector);
        this.fConfigServerText = new Text((Composite)group, 2052);
        this.fConfigServerText.addModifyListener(this.fBasicModifyListener);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fConfigServerText.setLayoutData((Object)gridData);
        this.fConfigFileButton = new Button((Composite)group, 16);
        this.fConfigFileButton.setText("File");
        this.fConfigFileButton.addSelectionListener((SelectionListener)this.fConfigSelector);
        this.fConfigFileText = new Text((Composite)group, 2052);
        this.fConfigFileText.setLayoutData((Object)new GridData(768));
        this.fConfigFileText.addModifyListener(this.fBasicModifyListener);
        this.fConfigBrowseButton = new Button((Composite)group, 8);
        this.fConfigBrowseButton.setText("Browse...");
        SWTUtil.applyDefaultButtonSize(this.fConfigBrowseButton);
        this.fConfigBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(ConfigurationTab.this.getShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle("Terracotta");
                dialog.setMessage("Locate Terracotta configuration file");
                dialog.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
                dialog.addFilter(new ViewerFilter(){

                    public boolean select(Viewer viewer, Object parentElement, Object element) {
                        if (element instanceof IProject || element instanceof IFolder) {
                            return true;
                        }
                        if (element instanceof IFile) {
                            IFile file = (IFile)element;
                            return file.getProjectRelativePath().getFileExtension().equals("xml");
                        }
                        return false;
                    }
                });
                dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                if (dialog.open() == 0) {
                    IResource resource = (IResource)dialog.getFirstResult();
                    String arg = resource.getFullPath().toString();
                    IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                    String fileLoc = variableManager.generateVariableExpression("workspace_loc", arg);
                    ConfigurationTab.this.fConfigFileText.setText(fileLoc);
                }
            }
        });
    }

    public boolean isValid(ILaunchConfiguration config) {
        this.setMessage(null);
        this.setErrorMessage(null);
        return this.validateServer() | this.validateConfigSpec();
    }

    private boolean validateServer() {
        return this.validateServerSpec(this.fServerText.getText());
    }

    private boolean validateConfigSpec() {
        if (this.fConfigServerButton.getSelection()) {
            return this.validateServerSpec(this.fConfigServerText.getText());
        }
        String configSpec = this.fConfigFileText.getText().trim();
        if (configSpec != null && !configSpec.startsWith("$")) {
            try {
                IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                variableManager.validateStringVariables(configSpec);
                configSpec = variableManager.performStringSubstitution(configSpec);
            }
            catch (CoreException ce) {
                this.setErrorMessage(ce.getMessage());
                this.updateLaunchConfigurationDialog();
                return false;
            }
            if (configSpec == null || configSpec.length() == 0) {
                this.setErrorMessage("Configuration file path is empty.");
                return false;
            }
            Path configSpecPath = new Path(configSpec);
            if (!configSpecPath.toFile().exists()) {
                this.setErrorMessage("File '" + configSpec + "' does not exist.");
                return false;
            }
        }
        return true;
    }

    IResource getResource(String path) {
        Path containerPath = new Path(path);
        return ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)containerPath);
    }

    private boolean validateServerSpec(String text) {
        String[] elems;
        if (text != null && text.length() > 0 && (elems = StringUtils.split((String)text, (String)",")) != null && elems.length > 0) {
            for (int i = 0; i < elems.length; ++i) {
                String host;
                String elem = elems[i];
                int colonIndex = elem.indexOf(58);
                String string = host = colonIndex == -1 ? elem : elem.substring(0, colonIndex);
                if (host == null || host.length() == 0) {
                    this.setErrorMessage("Malformed server list");
                    return false;
                }
                if (colonIndex == -1) continue;
                String port = "";
                try {
                    port = elem.substring(colonIndex + 1);
                    if (port == null || port.length() <= 0) continue;
                    Integer.parseInt(port);
                    continue;
                }
                catch (NumberFormatException nfe) {
                    this.setErrorMessage("Cannot parse port '" + port + "'");
                    return false;
                }
            }
        }
        return true;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        try {
            IProject project = this.getProject((ILaunchConfiguration)configuration);
            IFile configFile = TcPlugin.getDefault().getConfigurationFile(project);
            if (configFile != null) {
                String arg = configFile.getFullPath().toString();
                IStringVariableManager variableManager = VariablesPlugin.getDefault().getStringVariableManager();
                String configSpec = variableManager.generateVariableExpression("workspace_loc", arg);
                configuration.setAttribute(ID_CONFIG_FILE_SPEC, configSpec);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String serverSpec = configuration.getAttribute(ID_SERVER_SPEC, "");
            this.fServerText.setText(serverSpec);
        }
        catch (CoreException ce) {
            // empty catch block
        }
        try {
            String configFileSpec = configuration.getAttribute(ID_CONFIG_FILE_SPEC, (String)null);
            if (configFileSpec != null) {
                this.fConfigFileText.setText(configFileSpec);
                this.fConfigFileButton.setSelection(true);
            }
        }
        catch (CoreException ce) {
            // empty catch block
        }
        try {
            String configServerSpec = configuration.getAttribute(ID_CONFIG_SERVER_SPEC, (String)null);
            if (configServerSpec != null) {
                this.fConfigServerText.setText(configServerSpec);
                this.fConfigServerButton.setSelection(true);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private IProject getProject(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, (String)null);
        if (projectName != null && (projectName = projectName.trim()).length() > 0) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        }
        return null;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String serverSpec = this.fServerText.getText().trim();
        configuration.setAttribute(ID_SERVER_SPEC, serverSpec != null && serverSpec.length() > 0 ? serverSpec : null);
        if (this.fConfigFileButton.getSelection()) {
            String spec = this.fConfigFileText.getText().trim();
            configuration.setAttribute(ID_CONFIG_FILE_SPEC, spec != null && spec.length() > 0 ? spec : null);
            configuration.setAttribute(ID_CONFIG_SERVER_SPEC, (String)null);
        } else {
            String spec = this.fConfigServerText.getText().trim();
            configuration.setAttribute(ID_CONFIG_SERVER_SPEC, spec != null && spec.length() > 0 ? spec : null);
            configuration.setAttribute(ID_CONFIG_FILE_SPEC, (String)null);
        }
    }

    public String getName() {
        return "Terracotta";
    }
}

