/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xmlbeans;

import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Spinner;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolder;
import org.terracotta.dso.editors.xmlbeans.XmlObjectHolderHelper;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class XmlIntegerSpinner
implements XmlObjectHolder {
    private final XmlObjectHolderHelper m_helper = new XmlObjectHolderHelper();
    private final Spinner m_spinner;
    private final FocusListener m_focusListener;
    private final SelectionListener m_selectionListener;
    private final KeyListener m_keyListener;
    private boolean m_listening;

    public static XmlIntegerSpinner newInstance(Spinner spinner) {
        XmlIntegerSpinner result = new XmlIntegerSpinner(spinner);
        result.addListeners();
        return result;
    }

    protected void addListeners() {
        this.m_spinner.addFocusListener(this.m_focusListener);
        this.m_spinner.addSelectionListener(this.m_selectionListener);
        this.m_spinner.addKeyListener(this.m_keyListener);
        this.m_listening = true;
    }

    protected XmlIntegerSpinner(Spinner spinner) {
        this.m_spinner = spinner;
        this.m_focusListener = new SpinnerFocusAdapter();
        this.m_selectionListener = new SpinnerSelectionAdapter();
        this.m_keyListener = new SpinnerKeyAdapter();
    }

    protected void ensureXmlObject() {
        ConfigurationEditorPanel parent = (ConfigurationEditorPanel)SWTUtil.getAncestorOfClass(ConfigurationEditorPanel.class, (Control)this.m_spinner);
        if (parent != null) {
            parent.ensureXmlObject();
        }
    }

    public void setup(XmlObject parent) {
        this.m_listening = false;
        this.m_helper.setup(parent);
        this.setSelection(this.integerValue());
        this.m_listening = true;
    }

    public void init(Class parentClass, String elementName) {
        this.m_helper.init(parentClass, elementName);
        this.setSelection(this.m_helper.defaultIntegerValue());
        this.m_spinner.setMinimum(this.m_helper.minInclusive().intValue());
        this.m_spinner.setMaximum(this.m_helper.maxInclusive().intValue());
        this.m_spinner.setPageIncrement(1);
    }

    public void tearDown() {
        this.m_helper.tearDown();
        this.m_listening = false;
        this.setSelection(this.m_helper.defaultIntegerValue());
    }

    public Integer integerValue() {
        return this.isSet() ? this.m_helper.getIntegerValue() : this.m_helper.defaultIntegerValue();
    }

    public boolean isRequired() {
        return this.m_helper.isRequired();
    }

    public boolean isSet() {
        return this.m_helper.isSet();
    }

    public void set() {
        this.m_listening = false;
        int iVal = this.getSelection();
        if (this.m_helper.hasDefault() && this.m_helper.defaultIntegerValue().equals(iVal)) {
            this.unset();
        } else {
            this.ensureXmlObject();
            this.m_helper.set(Integer.toString(iVal));
        }
        this.m_listening = true;
    }

    public void unset() {
        if (!this.isRequired()) {
            this.m_listening = false;
            this.m_helper.unset();
            Integer iVal = this.m_helper.defaultIntegerValue();
            this.setSelection(iVal);
            this.m_listening = true;
        }
    }

    public synchronized void addXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.addXmlObjectStructureListener(listener);
    }

    public synchronized void removeXmlObjectStructureListener(XmlObjectStructureListener listener) {
        this.m_helper.removeXmlObjectStructureListener(listener);
    }

    public int getSelection() {
        return this.m_spinner.getSelection();
    }

    public void setSelection(int value) {
        int curVal = this.m_spinner.getSelection();
        if (curVal != value) {
            this.m_spinner.setSelection(value);
        }
    }

    private class SpinnerKeyAdapter
    extends KeyAdapter {
        private SpinnerKeyAdapter() {
        }

        public void keyPressed(KeyEvent e) {
            if (!XmlIntegerSpinner.this.m_listening) {
                return;
            }
            switch (e.keyCode) {
                case 0x100000E: {
                    XmlIntegerSpinner.this.unset();
                }
            }
        }
    }

    private class SpinnerSelectionAdapter
    extends SelectionAdapter {
        private SpinnerSelectionAdapter() {
        }

        public void widgetSelected(SelectionEvent se) {
            if (XmlIntegerSpinner.this.m_listening && !XmlIntegerSpinner.this.m_spinner.isFocusControl()) {
                XmlIntegerSpinner.this.set();
            }
        }
    }

    private class SpinnerFocusAdapter
    extends FocusAdapter {
        private SpinnerFocusAdapter() {
        }

        public void focusLost(FocusEvent e) {
            if (XmlIntegerSpinner.this.m_listening) {
                XmlIntegerSpinner.this.set();
            }
        }
    }
}

