/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.xml;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.terracotta.dso.editors.xml.ColorManager;
import org.terracotta.dso.editors.xml.XMLConfiguration;
import org.terracotta.dso.editors.xml.XMLDocumentProvider;

public class XMLEditor
extends TextEditor
implements IGotoMarker {
    private ColorManager colorManager = new ColorManager();

    public XMLEditor() {
        this.setSourceViewerConfiguration((SourceViewerConfiguration)new XMLConfiguration(this.colorManager));
        this.setDocumentProvider((IDocumentProvider)new XMLDocumentProvider());
    }

    public IDocument getDocument() {
        return this.getDocumentProvider().getDocument((Object)this.getEditorInput());
    }

    public void addTextInputListener(ITextInputListener listener) {
        this.getSourceViewer().addTextInputListener(listener);
    }

    public void removeTextInputListener(ITextInputListener listener) {
        this.getSourceViewer().removeTextInputListener(listener);
    }

    public void dispose() {
        this.colorManager.dispose();
        super.dispose();
    }

    public void doSave(IProgressMonitor progressMonitor) {
    }

    public void doSaveWork(IProgressMonitor progressMonitor) {
        this.updateState(this.getEditorInput());
        this.validateState(this.getEditorInput());
        this.performSave(true, progressMonitor);
    }

    public StyledText getTextWidget() {
        return this.getSourceViewer().getTextWidget();
    }

    public int getTopIndex() {
        return this.getSourceViewer().getTopIndex();
    }

    public void setTopIndex(int index) {
        this.getSourceViewer().setTopIndex(index);
    }

    public Point getScrollLocation() {
        Point loc = new Point(0, 0);
        ScrollBar vertBar = this.getSourceViewer().getTextWidget().getVerticalBar();
        ScrollBar horzBar = this.getSourceViewer().getTextWidget().getHorizontalBar();
        if (vertBar != null) {
            loc.y = vertBar.getSelection();
        }
        if (horzBar != null) {
            loc.x = horzBar.getSelection();
        }
        return loc;
    }

    public void setScrollLocation(Point loc) {
        StyledText textWidget = this.getSourceViewer().getTextWidget();
        ScrollBar vertBar = textWidget.getVerticalBar();
        ScrollBar horzBar = textWidget.getHorizontalBar();
        if (vertBar != null) {
            vertBar.setSelection(loc.y);
        }
        if (horzBar != null) {
            horzBar.setSelection(loc.x);
        }
        textWidget.layout(false);
        textWidget.redraw();
    }
}

