/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors.chooser;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.chooser.FileBehavior;

public class ConfigFileBehavior
extends FileBehavior {
    private static final String SELECT_CONFIG_FILE_LOCATION = "Select Config File Location";

    public String getTitle() {
        return SELECT_CONFIG_FILE_LOCATION;
    }

    protected boolean filterSelect(Viewer viewer, Object parentElement, Object element) {
        boolean result = super.filterSelect(viewer, parentElement, element);
        if (result && element instanceof IFile) {
            result = "xml".equals(((IFile)element).getFileExtension());
        }
        return result;
    }

    public ISelectionStatusValidator getValidator() {
        return new ISelectionStatusValidator(){

            public IStatus validate(Object[] selection) {
                ConfigFileBehavior.this.m_selectedValue = null;
                for (Object element : selection) {
                    IFile file;
                    if (!(element instanceof IFile) || !"xml".equals((file = (IFile)element).getFileExtension())) continue;
                    ConfigFileBehavior.this.m_selectedValue = file.getProjectRelativePath().toString();
                }
                String id = TcPlugin.getPluginId();
                if (ConfigFileBehavior.this.m_selectedValue == null) {
                    return new Status(4, id, 4, "", null);
                }
                return new Status(0, id, 0, "", null);
            }
        };
    }
}

