/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoClientDebugging;
import com.terracottatech.config.RuntimeOutputOptions;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class RuntimeOutputOptionsPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoClientDebugging m_dsoClientDebugging;
    private RuntimeOutputOptions m_runtimeOutputOptions;
    private final Layout m_layout = new Layout(this);

    public RuntimeOutputOptionsPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_runtimeOutputOptions == null) {
            this.removeListeners();
            this.m_runtimeOutputOptions = this.m_dsoClientDebugging.addNewRuntimeOutputOptions();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_runtimeOutputOptions != null && (this.m_runtimeOutputOptions.isSetAutoLockDetails() || this.m_runtimeOutputOptions.isSetCaller() || this.m_runtimeOutputOptions.isSetFullStack());
    }

    private void testRemoveRuntimeOutputOptions() {
        if (!this.hasAnySet() && this.m_dsoClientDebugging.getRuntimeOutputOptions() != null) {
            this.m_dsoClientDebugging.unsetRuntimeOutputOptions();
            this.m_runtimeOutputOptions = null;
            this.fireXmlObjectStructureChanged();
        }
        this.fireClientChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoClientDebugging);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testRemoveRuntimeOutputOptions();
    }

    private void addListeners() {
        ((XmlBooleanToggle)this.m_layout.m_autoLockDetailsCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_callerCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_fullStackCheck.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlBooleanToggle)this.m_layout.m_autoLockDetailsCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_callerCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_fullStackCheck.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setRuntimeOutputOptions(this.m_runtimeOutputOptions);
    }

    public void setup(DsoClientDebugging dsoClientDebugging) {
        this.removeListeners();
        this.setEnabled(true);
        this.m_dsoClientDebugging = dsoClientDebugging;
        this.m_runtimeOutputOptions = this.m_dsoClientDebugging != null ? this.m_dsoClientDebugging.getRuntimeOutputOptions() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoClientDebugging = null;
        this.m_runtimeOutputOptions = null;
        this.m_layout.tearDown();
        this.setEnabled(false);
    }

    private class Layout {
        private static final String RUNTIME_OUTPUT_OPTIONS = "Runtime Output Options";
        private static final String AUTOLOCK_DETAILS = "Autolock Details";
        private static final String CALLER = "Caller";
        private static final String FULL_STACK = "Full Stack";
        private final Button m_autoLockDetailsCheck;
        private final Button m_callerCheck;
        private final Button m_fullStackCheck;

        void setRuntimeOutputOptions(RuntimeOutputOptions runtimeOutputOptions) {
            ((XmlBooleanToggle)this.m_autoLockDetailsCheck.getData()).setup((XmlObject)runtimeOutputOptions);
            ((XmlBooleanToggle)this.m_callerCheck.getData()).setup((XmlObject)runtimeOutputOptions);
            ((XmlBooleanToggle)this.m_fullStackCheck.getData()).setup((XmlObject)runtimeOutputOptions);
        }

        void tearDown() {
            ((XmlBooleanToggle)this.m_autoLockDetailsCheck.getData()).tearDown();
            ((XmlBooleanToggle)this.m_callerCheck.getData()).tearDown();
            ((XmlBooleanToggle)this.m_fullStackCheck.getData()).tearDown();
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Group runtimeOutputOptionsGroup = new Group(parent, 32);
            runtimeOutputOptionsGroup.setText(RUNTIME_OUTPUT_OPTIONS);
            GridLayout gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 3;
            runtimeOutputOptionsGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            runtimeOutputOptionsGroup.setLayoutData((Object)new GridData(770));
            this.m_autoLockDetailsCheck = new Button((Composite)runtimeOutputOptionsGroup, 32);
            this.m_autoLockDetailsCheck.setText(AUTOLOCK_DETAILS);
            RuntimeOutputOptionsPanel.this.initBooleanField(this.m_autoLockDetailsCheck, RuntimeOutputOptions.class, "auto-lock-details");
            this.m_callerCheck = new Button((Composite)runtimeOutputOptionsGroup, 32);
            this.m_callerCheck.setText(CALLER);
            RuntimeOutputOptionsPanel.this.initBooleanField(this.m_callerCheck, RuntimeOutputOptions.class, "caller");
            this.m_fullStackCheck = new Button((Composite)runtimeOutputOptionsGroup, 32);
            this.m_fullStackCheck.setText(FULL_STACK);
            RuntimeOutputOptionsPanel.this.initBooleanField(this.m_fullStackCheck, RuntimeOutputOptions.class, "full-stack");
        }
    }
}

