/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.ClassExpression;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Include;
import com.terracottatech.config.InstrumentedClasses;
import com.terracottatech.config.OnLoad;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.chooser.ClassBehavior;
import org.terracotta.dso.editors.chooser.ExpressionChooser;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.ui.util.SWTUtil;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class InstrumentedClassesPanel
extends ConfigurationEditorPanel {
    private IProject m_project;
    private DsoApplication m_dsoApp;
    private InstrumentedClasses m_instrumentedClasses;
    private final Layout m_layout = new Layout(this);
    private TableSelectionListener m_tableSelectionListener = new TableSelectionListener();
    private TableDataListener m_tableDataListener = new TableDataListener();
    private AddRuleHandler m_addRuleHandler = new AddRuleHandler();
    private RemoveRuleHandler m_removeRuleHandler = new RemoveRuleHandler();
    private MoveUpHandler m_moveUpHandler = new MoveUpHandler();
    private MoveDownHandler m_moveDownHandler = new MoveDownHandler();
    private HonorTransientHandler m_honorTransientHandler = new HonorTransientHandler();
    private OnLoadDoNothingHandler m_onLoadDoNothingHandler = new OnLoadDoNothingHandler();
    private OnLoadCallMethodHandler m_onLoadCallMethodHandler = new OnLoadCallMethodHandler();
    private OnLoadCallMethodTextHandler m_onLoadCallMethodTextHandler = new OnLoadCallMethodTextHandler();
    private OnLoadExecuteCodeHandler m_onLoadExecuteCodeHandler = new OnLoadExecuteCodeHandler();
    private OnLoadExecuteCodeTextHandler m_onLoadExecuteCodeTextHandler = new OnLoadExecuteCodeTextHandler();
    private static final String INCLUDE = "include";
    private static final String EXCLUDE = "exclude";

    public InstrumentedClassesPanel(Composite parent, int style) {
        super(parent, style);
    }

    public boolean hasAnySet() {
        return this.m_instrumentedClasses != null && (this.m_instrumentedClasses.sizeOfExcludeArray() > 0 || this.m_instrumentedClasses.sizeOfIncludeArray() > 0);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_instrumentedClasses == null) {
            this.removeListeners();
            this.m_instrumentedClasses = this.m_dsoApp.addNewInstrumentedClasses();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testInstrumentedClasses() {
        if (!this.hasAnySet() && this.m_dsoApp.getInstrumentedClasses() != null) {
            this.m_dsoApp.unsetInstrumentedClasses();
            this.m_instrumentedClasses = null;
            this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoApp);
        }
        this.handleTableSelection();
    }

    private void addListeners() {
        this.m_layout.m_table.addSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.addListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_addButton.addSelectionListener((SelectionListener)this.m_addRuleHandler);
        this.m_layout.m_removeButton.addSelectionListener((SelectionListener)this.m_removeRuleHandler);
        this.m_layout.m_moveUpButton.addSelectionListener((SelectionListener)this.m_moveUpHandler);
        this.m_layout.m_moveDownButton.addSelectionListener((SelectionListener)this.m_moveDownHandler);
        this.m_layout.m_honorTransientCheck.addSelectionListener((SelectionListener)this.m_honorTransientHandler);
        this.m_layout.m_doNothingRadio.addSelectionListener((SelectionListener)this.m_onLoadDoNothingHandler);
        this.m_layout.m_callAMethodRadio.addSelectionListener((SelectionListener)this.m_onLoadCallMethodHandler);
        this.m_layout.m_callAMethodText.addFocusListener((FocusListener)this.m_onLoadCallMethodTextHandler);
        this.m_layout.m_executeCodeRadio.addSelectionListener((SelectionListener)this.m_onLoadExecuteCodeHandler);
        this.m_layout.m_executeCodeText.addFocusListener((FocusListener)this.m_onLoadExecuteCodeTextHandler);
    }

    private void removeListeners() {
        this.m_layout.m_table.removeSelectionListener((SelectionListener)this.m_tableSelectionListener);
        this.m_layout.m_table.removeListener(36, (Listener)this.m_tableDataListener);
        this.m_layout.m_addButton.removeSelectionListener((SelectionListener)this.m_addRuleHandler);
        this.m_layout.m_removeButton.removeSelectionListener((SelectionListener)this.m_removeRuleHandler);
        this.m_layout.m_moveUpButton.removeSelectionListener((SelectionListener)this.m_moveUpHandler);
        this.m_layout.m_moveDownButton.removeSelectionListener((SelectionListener)this.m_moveDownHandler);
        this.m_layout.m_honorTransientCheck.removeSelectionListener((SelectionListener)this.m_honorTransientHandler);
        this.m_layout.m_doNothingRadio.removeSelectionListener((SelectionListener)this.m_onLoadDoNothingHandler);
        this.m_layout.m_callAMethodRadio.removeSelectionListener((SelectionListener)this.m_onLoadCallMethodHandler);
        this.m_layout.m_callAMethodText.removeFocusListener((FocusListener)this.m_onLoadCallMethodTextHandler);
        this.m_layout.m_executeCodeRadio.removeSelectionListener((SelectionListener)this.m_onLoadExecuteCodeHandler);
        this.m_layout.m_executeCodeText.removeFocusListener((FocusListener)this.m_onLoadExecuteCodeTextHandler);
    }

    public void updateChildren() {
        this.initTableItems();
        this.handleTableSelection();
    }

    public void updateModel() {
        this.removeListeners();
        this.updateChildren();
        this.addListeners();
    }

    public void setup(IProject project, DsoApplication dsoApp) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_project = project;
        this.m_dsoApp = dsoApp;
        this.m_instrumentedClasses = this.m_dsoApp != null ? this.m_dsoApp.getInstrumentedClasses() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoApp = null;
        this.m_instrumentedClasses = null;
        this.setEnabled(false);
    }

    private void initTableItems() {
        this.m_layout.m_table.removeAll();
        if (this.m_instrumentedClasses == null) {
            return;
        }
        SWTUtil.makeTableComboItem(this.m_layout.m_table, 0, new String[]{INCLUDE, EXCLUDE});
        this.updateRules();
        if (this.m_layout.m_table.getItemCount() > 0) {
            this.m_layout.m_table.setSelection(0);
        }
    }

    private TableItem createIncludeTableItem(Include include) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        item.setText(0, INCLUDE);
        item.setText(1, include.getClassExpression() + "");
        item.setData((Object)include);
        return item;
    }

    private TableItem createExcludeTableItem(ClassExpression exclude) {
        TableItem item = new TableItem(this.m_layout.m_table, 0);
        item.setText(0, EXCLUDE);
        item.setText(1, exclude.getStringValue());
        item.setData((Object)exclude);
        return item;
    }

    private void updateRules() {
        this.m_layout.m_table.removeAll();
        if (this.m_instrumentedClasses != null) {
            XmlObject[] classes = this.m_instrumentedClasses.selectPath("*");
            for (int i = 0; i < classes.length; ++i) {
                if (classes[i] instanceof Include) {
                    this.createIncludeTableItem((Include)classes[i]);
                    continue;
                }
                this.createExcludeTableItem((ClassExpression)classes[i]);
            }
        }
    }

    private void internalAddInclude(String classExpr) {
        this.ensureXmlObject();
        Include include = this.m_instrumentedClasses.addNewInclude();
        include.setClassExpression(classExpr);
        this.createIncludeTableItem(include);
        this.m_layout.m_table.select(this.m_layout.m_table.getItemCount() - 1);
    }

    XmlObject getSelectedRule() {
        int i = this.m_layout.m_table.getSelectionIndex();
        return i != -1 ? this.getRuleAt(i) : null;
    }

    OnLoad ensureSelectedOnLoad() {
        Include include;
        XmlObject rule = this.getSelectedRule();
        OnLoad onLoad = null;
        if (rule instanceof Include && (onLoad = (include = (Include)rule).getOnLoad()) == null) {
            onLoad = include.addNewOnLoad();
        }
        return onLoad;
    }

    XmlObject getRuleAt(int index) {
        TableItem item = this.m_layout.m_table.getItem(index);
        return (XmlObject)item.getData();
    }

    void setRuleAt(int index, XmlObject rule) {
        try {
            TableItem item = this.m_layout.m_table.getItem(index);
            item.setData((Object)rule);
            if (rule instanceof Include) {
                Include include = (Include)rule;
                item.setText(0, INCLUDE);
                item.setText(1, include.getClassExpression() + "");
            } else {
                ClassExpression exclude = (ClassExpression)rule;
                item.setText(0, EXCLUDE);
                item.setText(1, exclude.getStringValue());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    String getExpressionAt(int index) {
        XmlObject rule = this.getRuleAt(index);
        if (rule instanceof Include) {
            return ((Include)rule).getClassExpression();
        }
        return ((ClassExpression)rule).getStringValue();
    }

    int indexOfInclude(Include include) {
        int index = -1;
        if (this.m_instrumentedClasses != null) {
            Include[] includes = this.m_instrumentedClasses.getIncludeArray();
            for (int i = 0; i < includes.length; ++i) {
                if (includes[i] != include) continue;
                return i;
            }
        }
        return index;
    }

    int indexOfExclude(ClassExpression exclude) {
        int index = -1;
        if (this.m_instrumentedClasses != null) {
            ClassExpression[] excludes = this.m_instrumentedClasses.xgetExcludeArray();
            for (int i = 0; i < excludes.length; ++i) {
                if (excludes[i] != exclude) continue;
                return i;
            }
        }
        return index;
    }

    public void removeRule(int index) {
        XmlObject rule = this.getRuleAt(index);
        Node ruleNode = rule.getDomNode();
        Node topNode = this.m_instrumentedClasses.getDomNode();
        topNode.removeChild(ruleNode);
    }

    public void moveRuleUp(int index) {
        XmlObject rule = this.getRuleAt(index);
        Node ruleNode = rule.getDomNode();
        Node topNode = this.m_instrumentedClasses.getDomNode();
        NodeList topNodeList = topNode.getChildNodes();
        int listSize = topNodeList.getLength();
        for (int i = 0; i < listSize; ++i) {
            if (ruleNode != topNodeList.item(i)) continue;
            while (--i >= 0) {
                Node prevNode = topNodeList.item(i);
                if (prevNode.getNodeType() != 1) continue;
                topNode.removeChild(ruleNode);
                topNode.insertBefore(ruleNode, prevNode);
                this.fireInstrumentationRulesChanged();
                return;
            }
        }
    }

    public void moveRuleDown(int index) {
        XmlObject rule = this.getRuleAt(index);
        Node ruleNode = rule.getDomNode();
        Node topNode = this.m_instrumentedClasses.getDomNode();
        NodeList topNodeList = topNode.getChildNodes();
        int listSize = topNodeList.getLength();
        for (int i = 0; i < listSize; ++i) {
            if (ruleNode != topNodeList.item(i)) continue;
            while (++i < listSize) {
                Node nextNode = topNodeList.item(i);
                if (nextNode.getNodeType() != 1) continue;
                while (++i < listSize) {
                    nextNode = topNodeList.item(i);
                    if (nextNode.getNodeType() != 1) continue;
                    topNode.removeChild(ruleNode);
                    topNode.insertBefore(ruleNode, nextNode);
                    this.fireInstrumentationRulesChanged();
                    return;
                }
                topNode.removeChild(ruleNode);
                topNode.appendChild(ruleNode);
                this.updateRules();
                return;
            }
        }
    }

    public void replace(int index, XmlObject newRule) {
        Node newRuleNode = newRule.getDomNode();
        XmlObject rule = this.getRuleAt(index);
        Node ruleNode = rule.getDomNode();
        Node topNode = this.m_instrumentedClasses.getDomNode();
        topNode.replaceChild(newRuleNode, ruleNode);
        this.fireInstrumentationRulesChanged();
    }

    public void toggleRuleType(int index) {
        String expr = this.getExpressionAt(index);
        XmlObject xmlObj = this.getRuleAt(index);
        if (xmlObj instanceof Include) {
            ClassExpression ce = this.m_instrumentedClasses.addNewExclude();
            ce.setStringValue(expr);
            xmlObj = ce;
        } else {
            Include include = this.m_instrumentedClasses.addNewInclude();
            include.setClassExpression(expr);
            xmlObj = include;
        }
        this.replace(index, xmlObj);
    }

    private void handleTableSelection() {
        int index = this.m_layout.m_table.getSelectionIndex();
        if (index == -1) {
            this.m_layout.m_removeButton.setEnabled(false);
            this.m_layout.m_moveUpButton.setEnabled(false);
            this.m_layout.m_moveDownButton.setEnabled(false);
            this.m_layout.resetIncludeAttributes();
            return;
        }
        int count = this.m_layout.m_table.getItemCount();
        this.m_layout.m_removeButton.setEnabled(true);
        if (index == 0) {
            this.m_layout.m_moveUpButton.setEnabled(false);
            this.m_layout.m_moveDownButton.setEnabled(count > 1);
        } else if (index == count - 1) {
            this.m_layout.m_moveUpButton.setEnabled(true);
            this.m_layout.m_moveDownButton.setEnabled(false);
        } else {
            this.m_layout.m_moveUpButton.setEnabled(true);
            this.m_layout.m_moveDownButton.setEnabled(true);
        }
        TableItem item = this.m_layout.m_table.getItem(index);
        if (item.getText(0).equals(INCLUDE)) {
            this.initIncludeAttributes();
        } else if (item.getText(0).equals(EXCLUDE)) {
            this.m_layout.resetIncludeAttributes();
        }
    }

    private void initIncludeAttributes() {
        int selected = this.m_layout.m_table.getSelectionIndex();
        XmlObject rule = (XmlObject)this.m_layout.m_table.getItem(selected).getData();
        if (rule instanceof Include) {
            Include include = (Include)rule;
            this.m_layout.resetIncludeAttributes();
            this.m_layout.enableIncludeAttributes();
            this.m_layout.setInclude(include);
        }
    }

    private void handleRemoveOnLoad() {
        this.m_layout.m_callAMethodText.setText("");
        this.m_layout.m_callAMethodText.setEnabled(false);
        this.m_layout.m_executeCodeText.setText("");
        this.m_layout.m_executeCodeText.setEnabled(false);
        Include include = (Include)this.getSelectedRule();
        include.unsetOnLoad();
        this.fireIncludeRuleChanged(this.indexOfInclude(include));
    }

    public void includeRuleChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            int selIndex = this.m_layout.m_table.getSelectionIndex();
            this.updateRules();
            if (selIndex != -1) {
                this.m_layout.m_table.setSelection(selIndex);
                this.handleTableSelection();
            }
        }
    }

    public void excludeRulesChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.initTableItems();
        }
    }

    public void excludeRuleChanged(IProject project, int index) {
        if (project.equals(this.getProject())) {
            int selIndex = this.m_layout.m_table.getSelectionIndex();
            this.updateRules();
            if (selIndex != -1) {
                this.m_layout.m_table.setSelection(selIndex);
                this.handleTableSelection();
            }
        }
    }

    public void includeRulesChanged(IProject project) {
    }

    class OnLoadCallMethodTextHandler
    extends FocusAdapter {
        OnLoadCallMethodTextHandler() {
        }

        public void focusLost(FocusEvent e) {
            InstrumentedClassesPanel.this.ensureSelectedOnLoad().setMethod(InstrumentedClassesPanel.this.m_layout.m_callAMethodText.getText());
            InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude((Include)InstrumentedClassesPanel.this.getSelectedRule()));
        }
    }

    class OnLoadExecuteCodeTextHandler
    extends FocusAdapter {
        OnLoadExecuteCodeTextHandler() {
        }

        public void focusLost(FocusEvent e) {
            InstrumentedClassesPanel.this.ensureSelectedOnLoad().setExecute(InstrumentedClassesPanel.this.m_layout.m_executeCodeText.getText());
            InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude((Include)InstrumentedClassesPanel.this.getSelectedRule()));
        }
    }

    class OnLoadExecuteCodeHandler
    extends SelectionAdapter {
        OnLoadExecuteCodeHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_executeCodeText.setEnabled(true);
            InstrumentedClassesPanel.this.m_layout.m_callAMethodText.setText("");
            InstrumentedClassesPanel.this.m_layout.m_callAMethodText.setEnabled(false);
            InstrumentedClassesPanel.this.ensureSelectedOnLoad().unsetMethod();
            InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude((Include)InstrumentedClassesPanel.this.getSelectedRule()));
        }
    }

    class OnLoadCallMethodHandler
    extends SelectionAdapter {
        OnLoadCallMethodHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_callAMethodText.setEnabled(true);
            InstrumentedClassesPanel.this.m_layout.m_executeCodeText.setText("");
            InstrumentedClassesPanel.this.m_layout.m_executeCodeText.setEnabled(false);
            InstrumentedClassesPanel.this.ensureSelectedOnLoad().unsetExecute();
            InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude((Include)InstrumentedClassesPanel.this.getSelectedRule()));
        }
    }

    class OnLoadDoNothingHandler
    extends SelectionAdapter {
        OnLoadDoNothingHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.handleRemoveOnLoad();
        }
    }

    class HonorTransientHandler
    extends SelectionAdapter {
        HonorTransientHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude((Include)InstrumentedClassesPanel.this.getSelectedRule()));
        }
    }

    class MoveDownHandler
    extends SelectionAdapter {
        MoveDownHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_table.forceFocus();
            int index = InstrumentedClassesPanel.this.m_layout.m_table.getSelectionIndex();
            InstrumentedClassesPanel.this.moveRuleDown(index);
            InstrumentedClassesPanel.this.m_layout.m_table.setSelection(index - 1);
        }
    }

    class MoveUpHandler
    extends SelectionAdapter {
        MoveUpHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_table.forceFocus();
            int index = InstrumentedClassesPanel.this.m_layout.m_table.getSelectionIndex();
            InstrumentedClassesPanel.this.moveRuleUp(index);
            InstrumentedClassesPanel.this.m_layout.m_table.setSelection(index - 1);
        }
    }

    class RemoveRuleHandler
    extends SelectionAdapter {
        RemoveRuleHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_table.forceFocus();
            int[] selection = InstrumentedClassesPanel.this.m_layout.m_table.getSelectionIndices();
            for (int i = selection.length - 1; i >= 0; --i) {
                InstrumentedClassesPanel.this.removeRule(selection[i]);
            }
            InstrumentedClassesPanel.this.fireInstrumentationRulesChanged();
            InstrumentedClassesPanel.this.testInstrumentedClasses();
        }
    }

    class AddRuleHandler
    extends SelectionAdapter {
        AddRuleHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.m_layout.m_table.forceFocus();
            ClassBehavior behavior = new ClassBehavior();
            ExpressionChooser chooser = new ExpressionChooser(InstrumentedClassesPanel.this.getShell(), behavior.getTitle(), "Enter Fully Qualified Class Name", InstrumentedClassesPanel.this.m_project, behavior);
            chooser.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent updateEvent) {
                    String[] items = (String[])updateEvent.data;
                    for (int i = 0; i < items.length; ++i) {
                        InstrumentedClassesPanel.this.internalAddInclude(items[i]);
                    }
                    InstrumentedClassesPanel.this.fireInstrumentationRulesChanged();
                }
            });
            chooser.open();
        }
    }

    class TableDataListener
    implements Listener {
        TableDataListener() {
        }

        public void handleEvent(Event event) {
            TableItem item = (TableItem)event.item;
            int index = InstrumentedClassesPanel.this.m_layout.m_table.indexOf(item);
            if (event.index == 0) {
                this.toggleRuleTypeLater(index);
            } else {
                XmlObject xmlObj = (XmlObject)item.getData();
                String text = item.getText(event.index).trim();
                if (xmlObj instanceof ClassExpression) {
                    ClassExpression exclude = (ClassExpression)xmlObj;
                    if (text.length() == 0) {
                        item.setText(exclude.getStringValue());
                        this.removeRuleLater(index);
                    } else {
                        exclude.setStringValue(text);
                        InstrumentedClassesPanel.this.fireExcludeRuleChanged(InstrumentedClassesPanel.this.indexOfExclude(exclude));
                    }
                } else {
                    Include include = (Include)xmlObj;
                    if (text.length() == 0) {
                        item.setText(include.getClassExpression());
                        this.removeRuleLater(index);
                    } else {
                        include.setClassExpression(text);
                        InstrumentedClassesPanel.this.fireIncludeRuleChanged(InstrumentedClassesPanel.this.indexOfInclude(include));
                    }
                }
            }
        }

        private void toggleRuleTypeLater(final int index) {
            InstrumentedClassesPanel.this.getDisplay().asyncExec(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    InstrumentedClassesPanel.this.m_layout.m_table.setRedraw(false);
                    try {
                        InstrumentedClassesPanel.this.toggleRuleType(index);
                        InstrumentedClassesPanel.this.m_layout.m_table.setSelection(index);
                        InstrumentedClassesPanel.this.handleTableSelection();
                    }
                    finally {
                        InstrumentedClassesPanel.this.m_layout.m_table.setRedraw(true);
                    }
                }
            });
        }

        private void removeRuleLater(final int index) {
            InstrumentedClassesPanel.this.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    InstrumentedClassesPanel.this.removeRule(index);
                    InstrumentedClassesPanel.this.fireInstrumentationRulesChanged();
                    InstrumentedClassesPanel.this.testInstrumentedClasses();
                }
            });
        }
    }

    class TableSelectionListener
    extends SelectionAdapter {
        TableSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            InstrumentedClassesPanel.this.handleTableSelection();
        }
    }

    private class Layout {
        private static final int RULE_COLUMN = 0;
        private static final int EXPRESSION_COLUMN = 1;
        private static final String UP = "/com/tc/admin/icons/view_menu.gif";
        private static final String DOWN = "/com/tc/admin/icons/hide_menu.gif";
        private static final String INSTRUMENTATION_RULES = "Instrumentation Rules";
        private static final String RULE = "Rule";
        private static final String EXPRESSION = "Expression";
        private static final String DETAILS = "Details";
        private static final String ADD = "Add...";
        private static final String REMOVE = "Remove";
        private static final String RAISE_PRIORITY = "Raise priority";
        private static final String LOWER_PRIORITY = "Lower priority";
        private static final String HONOR_TRANSIENT = "Honor Transient";
        private static final String ON_LOAD = "On Load Behavior";
        private static final String DO_NOTHING = "Do Nothing";
        private static final String CALL_A_METHOD = "Call a Method";
        private static final String EXECUTE_CODE = "Execute Code";
        private Table m_table;
        private Button m_honorTransientCheck;
        private Button m_doNothingRadio;
        private Button m_callAMethodRadio;
        private Text m_callAMethodText;
        private Button m_executeCodeRadio;
        private Text m_executeCodeText;
        private Button m_addButton;
        private Button m_removeButton;
        private Button m_moveUpButton;
        private Button m_moveDownButton;
        private Group m_onLoadGroup;
        private Group m_detailGroup;

        private void resetIncludeAttributes() {
            this.m_detailGroup.setEnabled(false);
            this.m_onLoadGroup.setEnabled(false);
            this.m_honorTransientCheck.setSelection(false);
            this.m_honorTransientCheck.setEnabled(false);
            this.m_doNothingRadio.setSelection(false);
            this.m_doNothingRadio.setEnabled(false);
            this.m_callAMethodRadio.setSelection(false);
            this.m_callAMethodRadio.setEnabled(false);
            this.m_callAMethodText.setText("");
            this.m_callAMethodText.setEnabled(false);
            this.m_executeCodeRadio.setSelection(false);
            this.m_executeCodeRadio.setEnabled(false);
            this.m_executeCodeText.setText("");
            this.m_executeCodeText.setEnabled(false);
        }

        private void enableIncludeAttributes() {
            this.m_detailGroup.setEnabled(true);
            this.m_onLoadGroup.setEnabled(true);
            this.m_honorTransientCheck.setEnabled(true);
            this.m_doNothingRadio.setEnabled(true);
            this.m_callAMethodRadio.setEnabled(true);
            this.m_executeCodeRadio.setEnabled(true);
        }

        private void setInclude(Include include) {
            ((XmlBooleanToggle)this.m_honorTransientCheck.getData()).setup((XmlObject)include);
            if (include != null) {
                OnLoad onLoad = include.getOnLoad();
                if (onLoad != null) {
                    if (onLoad.isSetExecute()) {
                        this.m_executeCodeRadio.setSelection(true);
                        this.m_executeCodeText.setText(onLoad.getExecute());
                        this.m_executeCodeText.setEnabled(true);
                        this.m_callAMethodText.setEnabled(false);
                    } else if (onLoad.isSetMethod()) {
                        this.m_callAMethodRadio.setSelection(true);
                        this.m_callAMethodText.setText(onLoad.getMethod());
                        this.m_executeCodeText.setEnabled(false);
                        this.m_callAMethodText.setEnabled(true);
                    }
                } else {
                    this.m_doNothingRadio.setSelection(true);
                }
            }
        }

        private Layout(Composite parent) {
            Composite comp = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Composite sidePanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            sidePanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            sidePanel.setLayoutData((Object)new GridData(1808));
            Label label = new Label(sidePanel, 0);
            label.setText(INSTRUMENTATION_RULES);
            label.setLayoutData((Object)new GridData(2));
            this.m_table = new Table(sidePanel, 68098);
            this.m_table.setHeaderVisible(true);
            this.m_table.setLinesVisible(true);
            SWTUtil.makeTableColumnsResizeWeightedWidth(sidePanel, this.m_table, new int[]{1, 4});
            SWTUtil.makeTableColumnsEditable(this.m_table, new int[]{1});
            GridData gridData = new GridData(1808);
            gridData.heightHint = SWTUtil.tableRowsToPixels(this.m_table, 3);
            this.m_table.setLayoutData((Object)gridData);
            TableColumn ruleColumn = new TableColumn(this.m_table, 0, 0);
            ruleColumn.setResizable(true);
            ruleColumn.setText(RULE);
            ruleColumn.pack();
            TableColumn expressionColumn = new TableColumn(this.m_table, 0, 1);
            expressionColumn.setResizable(true);
            expressionColumn.setText(EXPRESSION);
            expressionColumn.pack();
            this.m_detailGroup = new Group(sidePanel, 32);
            this.m_detailGroup.setText(DETAILS);
            this.m_detailGroup.setEnabled(false);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 5;
            gridLayout.marginWidth = 5;
            this.m_detailGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            this.m_detailGroup.setLayoutData((Object)new GridData(768));
            this.m_honorTransientCheck = new Button((Composite)this.m_detailGroup, 32);
            this.m_honorTransientCheck.setText(HONOR_TRANSIENT);
            this.m_honorTransientCheck.setEnabled(false);
            InstrumentedClassesPanel.this.initBooleanField(this.m_honorTransientCheck, Include.class, "honor-transient");
            this.m_onLoadGroup = new Group((Composite)this.m_detailGroup, 32);
            this.m_onLoadGroup.setText(ON_LOAD);
            this.m_onLoadGroup.setEnabled(false);
            gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 5;
            gridLayout.marginWidth = 5;
            this.m_onLoadGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            this.m_onLoadGroup.setLayoutData((Object)new GridData(1808));
            this.m_doNothingRadio = new Button((Composite)this.m_onLoadGroup, 16);
            this.m_doNothingRadio.setText(DO_NOTHING);
            this.m_doNothingRadio.setEnabled(false);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.m_doNothingRadio.setLayoutData((Object)gridData);
            this.m_callAMethodRadio = new Button((Composite)this.m_onLoadGroup, 16);
            this.m_callAMethodRadio.setText(CALL_A_METHOD);
            this.m_callAMethodRadio.setEnabled(false);
            this.m_callAMethodText = new Text((Composite)this.m_onLoadGroup, 2048);
            this.m_callAMethodText.setEnabled(false);
            int width = SWTUtil.textColumnsToPixels((Control)this.m_callAMethodText, 50);
            gridData = new GridData(512);
            gridData.minimumWidth = width;
            this.m_callAMethodText.setLayoutData((Object)gridData);
            this.m_executeCodeRadio = new Button((Composite)this.m_onLoadGroup, 16);
            this.m_executeCodeRadio.setEnabled(false);
            this.m_executeCodeRadio.setText(EXECUTE_CODE);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            this.m_executeCodeRadio.setLayoutData((Object)gridData);
            this.m_executeCodeText = new Text((Composite)this.m_onLoadGroup, 2050);
            this.m_executeCodeText.setEnabled(false);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            gridData.minimumHeight = SWTUtil.textRowsToPixels((Control)this.m_executeCodeText, 4);
            this.m_executeCodeText.setLayoutData((Object)gridData);
            Composite buttonPanel = new Composite(comp, 0);
            gridLayout = new GridLayout();
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            buttonPanel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            buttonPanel.setLayoutData((Object)new GridData(2));
            new Label(buttonPanel, 0);
            this.m_addButton = new Button(buttonPanel, 8);
            this.m_addButton.setText(ADD);
            this.m_addButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_addButton);
            this.m_removeButton = new Button(buttonPanel, 8);
            this.m_removeButton.setText(REMOVE);
            this.m_removeButton.setEnabled(false);
            this.m_removeButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_removeButton);
            new Label(buttonPanel, 0);
            this.m_moveUpButton = new Button(buttonPanel, 8);
            this.m_moveUpButton.setText(LOWER_PRIORITY);
            this.m_moveUpButton.setEnabled(false);
            this.m_moveUpButton.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(UP)));
            this.m_moveUpButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_moveUpButton);
            this.m_moveDownButton = new Button(buttonPanel, 8);
            this.m_moveDownButton.setText(RAISE_PRIORITY);
            this.m_moveDownButton.setEnabled(false);
            this.m_moveDownButton.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(DOWN)));
            this.m_moveDownButton.setLayoutData((Object)new GridData(2));
            SWTUtil.applyDefaultButtonSize(this.m_moveDownButton);
        }
    }
}

