/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoClientDebugging;
import com.terracottatech.config.InstrumentationLogging;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.xmlbeans.XmlBooleanToggle;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTUtil;

public class InstrumentationLoggingPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private DsoClientDebugging m_dsoClientDebugging;
    private InstrumentationLogging m_instrumentationLogging;
    private final Layout m_layout = new Layout(this);

    public InstrumentationLoggingPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_instrumentationLogging == null) {
            this.removeListeners();
            this.m_instrumentationLogging = this.m_dsoClientDebugging.addNewInstrumentationLogging();
            this.updateChildren();
            this.addListeners();
        }
    }

    public void structureChanged(XmlObjectStructureChangeEvent ae) {
        this.testRemoveInstrumenationLogging();
    }

    private void testRemoveInstrumenationLogging() {
        if (!this.hasAnySet() && this.m_dsoClientDebugging.getInstrumentationLogging() != null) {
            this.m_dsoClientDebugging.unsetInstrumentationLogging();
            this.m_instrumentationLogging = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        }
        this.fireClientChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_dsoClientDebugging);
    }

    public boolean hasAnySet() {
        return this.m_instrumentationLogging != null && (this.m_instrumentationLogging.isSetClass1() || this.m_instrumentationLogging.isSetHierarchy() || this.m_instrumentationLogging.isSetLocks() || this.m_instrumentationLogging.isSetTransientRoot() || this.m_instrumentationLogging.isSetRoots() || this.m_instrumentationLogging.isSetDistributedMethods());
    }

    private void addListeners() {
        ((XmlBooleanToggle)this.m_layout.m_classCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_hierarchyCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_locksCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_transientRootCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodsCheck.getData()).addXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_rootsCheck.getData()).addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlBooleanToggle)this.m_layout.m_classCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_hierarchyCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_locksCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_transientRootCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodsCheck.getData()).removeXmlObjectStructureListener(this);
        ((XmlBooleanToggle)this.m_layout.m_rootsCheck.getData()).removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setInstrumentationLogging(this.m_instrumentationLogging);
    }

    public void setup(DsoClientDebugging dsoClientDebugging) {
        this.removeListeners();
        this.setEnabled(true);
        this.m_dsoClientDebugging = dsoClientDebugging;
        this.m_instrumentationLogging = this.m_dsoClientDebugging != null ? this.m_dsoClientDebugging.getInstrumentationLogging() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_dsoClientDebugging = null;
        this.m_instrumentationLogging = null;
        ((XmlBooleanToggle)this.m_layout.m_classCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_hierarchyCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_locksCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_transientRootCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_distributedMethodsCheck.getData()).tearDown();
        ((XmlBooleanToggle)this.m_layout.m_rootsCheck.getData()).tearDown();
        this.setEnabled(false);
    }

    private class Layout {
        private static final String INSTRUMENTATION_LOGGING = "Instrumentation Logging";
        private static final String CLASS = "Class";
        private static final String HIERARCHY = "Hierarchy";
        private static final String LOCKS = "Locks";
        private static final String TRANSIENT_ROOT = "Transient Root";
        private static final String DISTRIBUTED_METHODS = "Distributed Methods";
        private static final String ROOTS = "Roots";
        private final Button m_classCheck;
        private final Button m_hierarchyCheck;
        private final Button m_locksCheck;
        private final Button m_transientRootCheck;
        private final Button m_distributedMethodsCheck;
        private final Button m_rootsCheck;

        void setInstrumentationLogging(InstrumentationLogging instrumentationLogging) {
            ((XmlBooleanToggle)this.m_classCheck.getData()).setup((XmlObject)instrumentationLogging);
            ((XmlBooleanToggle)this.m_hierarchyCheck.getData()).setup((XmlObject)instrumentationLogging);
            ((XmlBooleanToggle)this.m_locksCheck.getData()).setup((XmlObject)instrumentationLogging);
            ((XmlBooleanToggle)this.m_transientRootCheck.getData()).setup((XmlObject)instrumentationLogging);
            ((XmlBooleanToggle)this.m_distributedMethodsCheck.getData()).setup((XmlObject)instrumentationLogging);
            ((XmlBooleanToggle)this.m_rootsCheck.getData()).setup((XmlObject)instrumentationLogging);
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Group instrumentationLoggingGroup = new Group(parent, 32);
            instrumentationLoggingGroup.setText(INSTRUMENTATION_LOGGING);
            GridLayout gridLayout = new GridLayout();
            gridLayout.verticalSpacing = 3;
            instrumentationLoggingGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            GridData gridData = new GridData(770);
            instrumentationLoggingGroup.setLayoutData((Object)gridData);
            this.m_classCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_classCheck.setText(CLASS);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_classCheck, InstrumentationLogging.class, "class1");
            this.m_hierarchyCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_hierarchyCheck.setText(HIERARCHY);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_hierarchyCheck, InstrumentationLogging.class, "hierarchy");
            this.m_locksCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_locksCheck.setText(LOCKS);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_locksCheck, InstrumentationLogging.class, "locks");
            this.m_transientRootCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_transientRootCheck.setText(TRANSIENT_ROOT);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_transientRootCheck, InstrumentationLogging.class, "transient-root");
            this.m_distributedMethodsCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_distributedMethodsCheck.setText(DISTRIBUTED_METHODS);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_distributedMethodsCheck, InstrumentationLogging.class, "distributed-methods");
            this.m_rootsCheck = new Button((Composite)instrumentationLoggingGroup, 32);
            this.m_rootsCheck.setText(ROOTS);
            InstrumentationLoggingPanel.this.initBooleanField(this.m_rootsCheck, InstrumentationLogging.class, "roots");
        }
    }
}

