/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.DsoServerData;
import com.terracottatech.config.Server;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Spinner;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.GarbageCollectionPanel;
import org.terracotta.dso.editors.PersistencePanel;
import org.terracotta.dso.editors.ServersPanel;
import org.terracotta.dso.editors.xmlbeans.XmlIntegerSpinner;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.ui.util.SWTLayout;
import org.terracotta.ui.util.SWTUtil;

public class DsoServerDataPanel
extends ConfigurationEditorPanel
implements XmlObjectStructureListener {
    private Server m_server;
    private DsoServerData m_dsoServerData;
    private Layout m_layout = new Layout(this);

    public DsoServerDataPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_dsoServerData == null) {
            this.removeListeners();
            this.m_dsoServerData = this.m_server.addNewDso();
            this.updateChildren();
            this.addListeners();
        }
    }

    public boolean hasAnySet() {
        return this.m_dsoServerData != null && (this.m_dsoServerData.isSetGarbageCollection() || this.m_dsoServerData.isSetPersistence() || this.m_dsoServerData.isSetClientReconnectWindow());
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testUnsetDsoServerData();
    }

    private void testUnsetDsoServerData() {
        if (!this.hasAnySet() && this.m_server.getDso() != null) {
            this.m_server.unsetDso();
            this.m_dsoServerData = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        }
        this.fireServerChanged();
    }

    void fireServerChanged() {
        ServersPanel serversPanel = (ServersPanel)SWTUtil.getAncestorOfClass(ServersPanel.class, (Control)this);
        serversPanel.fireServerChanged(this.m_server);
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_server);
    }

    private void addListeners() {
        ((XmlIntegerSpinner)this.m_layout.m_clientReconnectWindowSpinner.getData()).addXmlObjectStructureListener(this);
        this.m_layout.m_garbageCollectionPanel.addXmlObjectStructureListener(this);
        this.m_layout.m_persistencePanel.addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        ((XmlIntegerSpinner)this.m_layout.m_clientReconnectWindowSpinner.getData()).removeXmlObjectStructureListener(this);
        this.m_layout.m_garbageCollectionPanel.removeXmlObjectStructureListener(this);
        this.m_layout.m_persistencePanel.removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setDsoServerData(this.m_dsoServerData);
    }

    public void setup(Server server) {
        this.setEnabled(true);
        this.removeListeners();
        this.m_server = server;
        this.m_dsoServerData = this.m_server != null ? this.m_server.getDso() : null;
        this.updateChildren();
        this.addListeners();
    }

    public void tearDown() {
        this.removeListeners();
        this.m_server = null;
        this.m_dsoServerData = null;
        this.m_layout.tearDown();
        this.setEnabled(false);
    }

    private class Layout
    implements SWTLayout {
        private static final String CLIENT_RECONNECT = "Client re-connect";
        private static final String CLIENT_RECONNECT_WINDOW = "Window (sec.)";
        private Spinner m_clientReconnectWindowSpinner;
        private GarbageCollectionPanel m_garbageCollectionPanel;
        private PersistencePanel m_persistencePanel;

        void tearDown() {
            ((XmlIntegerSpinner)this.m_clientReconnectWindowSpinner.getData()).tearDown();
            this.m_garbageCollectionPanel.tearDown();
            this.m_persistencePanel.tearDown();
        }

        public void reset() {
            this.setDsoServerData(null);
        }

        private void setDsoServerData(DsoServerData dsoServerData) {
            ((XmlIntegerSpinner)this.m_clientReconnectWindowSpinner.getData()).setup((XmlObject)dsoServerData);
            this.m_garbageCollectionPanel.setup(dsoServerData);
            this.m_persistencePanel.setup(dsoServerData);
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Group clientReconnectGroup = new Group(parent, 0);
            clientReconnectGroup.setText(CLIENT_RECONNECT);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            clientReconnectGroup.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            Label label = new Label((Composite)clientReconnectGroup, 0);
            label.setText(CLIENT_RECONNECT_WINDOW);
            this.m_clientReconnectWindowSpinner = new Spinner((Composite)clientReconnectGroup, 2048);
            DsoServerDataPanel.this.initIntegerSpinnerField(this.m_clientReconnectWindowSpinner, DsoServerData.class, "client-reconnect-window");
            clientReconnectGroup.setLayoutData((Object)new GridData(768));
            this.m_garbageCollectionPanel = new GarbageCollectionPanel(parent, 0);
            this.m_garbageCollectionPanel.setLayoutData(new GridData(768));
            this.m_persistencePanel = new PersistencePanel(parent, 0);
            this.m_persistencePanel.setLayoutData(new GridData(768));
        }
    }
}

