/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.Application;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.TcConfigDocument;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.BootClassesPanel;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.ConfigurationEditorRoot;
import org.terracotta.dso.editors.DistributedMethodsPanel;
import org.terracotta.dso.editors.InstrumentedClassesPanel;
import org.terracotta.dso.editors.LocksPanel;
import org.terracotta.dso.editors.RootsPanel;
import org.terracotta.dso.editors.TransientFieldsPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;

public class DsoApplicationPanel
extends ConfigurationEditorPanel
implements ConfigurationEditorRoot,
XmlObjectStructureListener {
    private IProject m_project;
    private TcConfigDocument.TcConfig m_config;
    private Application m_application;
    private DsoApplication m_dsoApp;
    private final Layout m_layout = new Layout(this);

    public DsoApplicationPanel(Composite parent, int style) {
        super(parent, style);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
    }

    private void addListeners() {
        this.m_layout.m_instrumentedClasses.addXmlObjectStructureListener(this);
        this.m_layout.m_transientFields.addXmlObjectStructureListener(this);
        this.m_layout.m_locks.addXmlObjectStructureListener(this);
        this.m_layout.m_roots.addXmlObjectStructureListener(this);
        this.m_layout.m_distributedMethods.addXmlObjectStructureListener(this);
        this.m_layout.m_bootClasses.addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        this.m_layout.m_instrumentedClasses.removeXmlObjectStructureListener(this);
        this.m_layout.m_transientFields.removeXmlObjectStructureListener(this);
        this.m_layout.m_locks.removeXmlObjectStructureListener(this);
        this.m_layout.m_roots.removeXmlObjectStructureListener(this);
        this.m_layout.m_distributedMethods.removeXmlObjectStructureListener(this);
        this.m_layout.m_bootClasses.removeXmlObjectStructureListener(this);
    }

    public void ensureXmlObject() {
        if (this.m_dsoApp == null) {
            this.removeListeners();
            if (this.m_application == null) {
                this.m_application = this.m_config.addNewApplication();
            }
            this.m_dsoApp = this.m_application.addNewDso();
            this.initPanels();
            this.addListeners();
        }
    }

    public void setupInternal() {
        TcPlugin plugin = TcPlugin.getDefault();
        this.m_config = plugin.getConfiguration(this.m_project);
        this.m_application = this.m_config != null ? this.m_config.getApplication() : null;
        this.m_dsoApp = this.m_application != null ? this.m_application.getDso() : null;
        this.initPanels();
    }

    private void initPanels() {
        this.m_layout.m_instrumentedClasses.setup(this.m_project, this.m_dsoApp);
        this.m_layout.m_transientFields.setup(this.m_project, this.m_dsoApp);
        this.m_layout.m_locks.setup(this.m_project, this.m_dsoApp);
        this.m_layout.m_roots.setup(this.m_project, this.m_dsoApp);
        this.m_layout.m_distributedMethods.setup(this.m_project, this.m_dsoApp);
        this.m_layout.m_bootClasses.setup(this.m_project, this.m_dsoApp);
    }

    public void updateInstrumentedClassesPanel() {
        this.m_layout.m_instrumentedClasses.updateModel();
    }

    public void updateTransientsPanel() {
        this.m_layout.m_transientFields.updateModel();
    }

    public void updateLocksPanel() {
        this.m_layout.m_locks.updateModel();
    }

    public void updateRootsPanel() {
        this.m_layout.m_roots.updateModel();
    }

    public void updateDistributedMethodsPanel() {
        this.m_layout.m_distributedMethods.updateModel();
    }

    public void updateBootClassesPanel() {
        this.m_layout.m_bootClasses.updateModel();
    }

    public void setup(IProject project) {
        this.m_project = project;
        this.setEnabled(true);
        this.removeListeners();
        this.setupInternal();
        this.addListeners();
    }

    public IProject getProject() {
        return this.m_project;
    }

    public void tearDown() {
        this.removeListeners();
        this.m_layout.m_instrumentedClasses.tearDown();
        this.m_layout.m_transientFields.tearDown();
        this.m_layout.m_locks.tearDown();
        this.m_layout.m_roots.tearDown();
        this.m_layout.m_distributedMethods.tearDown();
        this.m_layout.m_bootClasses.tearDown();
        this.setEnabled(false);
    }

    public void transientFieldsChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_transientFields.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void bootClassesChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_bootClasses.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void distributedMethodsChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_distributedMethods.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void instrumentationRulesChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_instrumentedClasses.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void namedLocksChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_locks.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void autolocksChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_locks.setup(this.m_project, this.m_dsoApp);
        }
    }

    public void rootsChanged(IProject project) {
        if (project.equals(this.getProject())) {
            this.m_layout.m_roots.setup(this.m_project, this.m_dsoApp);
        }
    }

    private static class Layout {
        private static final String ROOTS_ICON = "/com/tc/admin/icons/hierarchicalLayout.gif";
        private static final String LOCKS_ICON = "/com/tc/admin/icons/deadlock_view.gif";
        private static final String TRANSIENT_FIELDS_ICON = "/com/tc/admin/icons/transient.gif";
        private static final String INSTRUMENTED_CLASSES_ICON = "/com/tc/admin/icons/class_obj.gif";
        private static final String DISTRIBUTED_METHODS_ICON = "/com/tc/admin/icons/jmeth_obj.gif";
        private static final String BOOT_CLASSES_ICON = "/com/tc/admin/icons/jar_obj.gif";
        private static final String ROOTS = "Roots";
        private static final String LOCKS = "Locks";
        private static final String TRANSIENT_FIELDS = "Transient Fields";
        private static final String INSTRUMENTED_CLASSES = "Instrumented Classes";
        private static final String DISTRIBUTED_METHODS = "Distributed Methods";
        private static final String BOOT_CLASSES = "Boot Classes";
        private final RootsPanel m_roots;
        private final LocksPanel m_locks;
        private final TransientFieldsPanel m_transientFields;
        private final InstrumentedClassesPanel m_instrumentedClasses;
        private final DistributedMethodsPanel m_distributedMethods;
        private final BootClassesPanel m_bootClasses;
        private final TabFolder m_tabFolder;

        private Layout(Composite parent) {
            this.m_tabFolder = new TabFolder(parent, 2048);
            TabItem rootsTab = new TabItem(this.m_tabFolder, 0);
            rootsTab.setText(ROOTS);
            rootsTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(ROOTS_ICON)));
            ScrolledComposite scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_roots = new RootsPanel((Composite)scroll, 0);
            rootsTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_roots);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_roots.computeSize(-1, -1));
            TabItem locksTab = new TabItem(this.m_tabFolder, 0);
            locksTab.setText(LOCKS);
            locksTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(LOCKS_ICON)));
            scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_locks = new LocksPanel((Composite)scroll, 0);
            locksTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_locks);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_locks.computeSize(-1, -1));
            TabItem transientFieldsTab = new TabItem(this.m_tabFolder, 0);
            transientFieldsTab.setText(TRANSIENT_FIELDS);
            transientFieldsTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(TRANSIENT_FIELDS_ICON)));
            scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_transientFields = new TransientFieldsPanel((Composite)scroll, 0);
            transientFieldsTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_transientFields);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_transientFields.computeSize(-1, -1));
            TabItem instrumentedClassesTab = new TabItem(this.m_tabFolder, 0);
            instrumentedClassesTab.setText(INSTRUMENTED_CLASSES);
            instrumentedClassesTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(INSTRUMENTED_CLASSES_ICON)));
            scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_instrumentedClasses = new InstrumentedClassesPanel((Composite)scroll, 0);
            instrumentedClassesTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_instrumentedClasses);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_instrumentedClasses.computeSize(-1, -1));
            TabItem distributedMethodsTab = new TabItem(this.m_tabFolder, 0);
            distributedMethodsTab.setText(DISTRIBUTED_METHODS);
            distributedMethodsTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(DISTRIBUTED_METHODS_ICON)));
            scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_distributedMethods = new DistributedMethodsPanel((Composite)scroll, 0);
            distributedMethodsTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_distributedMethods);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_distributedMethods.computeSize(-1, -1));
            TabItem bootClassesTab = new TabItem(this.m_tabFolder, 0);
            bootClassesTab.setText(BOOT_CLASSES);
            bootClassesTab.setImage(new Image((Device)parent.getDisplay(), this.getClass().getResourceAsStream(BOOT_CLASSES_ICON)));
            scroll = new ScrolledComposite((Composite)this.m_tabFolder, 512);
            this.m_bootClasses = new BootClassesPanel((Composite)scroll, 0);
            bootClassesTab.setControl((Control)scroll);
            scroll.setContent((Control)this.m_bootClasses);
            scroll.setExpandHorizontal(true);
            scroll.setExpandVertical(true);
            scroll.setMinSize(this.m_bootClasses.computeSize(-1, -1));
            this.m_tabFolder.pack();
            this.m_tabFolder.setSelection(rootsTab);
        }
    }
}

