/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.editors;

import com.terracottatech.config.Client;
import com.terracottatech.config.TcConfigDocument;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditorPanel;
import org.terracotta.dso.editors.ConfigurationEditorRoot;
import org.terracotta.dso.editors.DsoClientDataPanel;
import org.terracotta.dso.editors.ModulesPanel;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureChangeEvent;
import org.terracotta.dso.editors.xmlbeans.XmlObjectStructureListener;
import org.terracotta.dso.editors.xmlbeans.XmlStringField;
import org.terracotta.ui.util.SWTUtil;

public class ClientsPanel
extends ConfigurationEditorPanel
implements ConfigurationEditorRoot,
XmlObjectStructureListener {
    private IProject m_project;
    private TcConfigDocument.TcConfig m_config;
    private Client m_client;
    private final Layout m_layout = new Layout(this);
    private final LogsBrowseSelectionHandler m_logsBrowseSelectionHandler = new LogsBrowseSelectionHandler();

    public ClientsPanel(Composite parent, int style) {
        super(parent, style);
        SWTUtil.setBGColorRecurse(this.getDisplay().getSystemColor(1), (Control)this);
    }

    public boolean hasAnySet() {
        return this.m_client.isSetDso() || this.m_client.isSetLogs() || this.m_layout.m_modulesPanel.hasAnySet();
    }

    public void ensureXmlObject() {
        super.ensureXmlObject();
        if (this.m_client == null) {
            this.removeListeners();
            this.m_client = this.m_config.addNewClients();
            this.updateChildren();
            this.addListeners();
        }
    }

    private void testUnsetClients() {
        if (!this.hasAnySet() && this.m_config.getClients() != null) {
            this.m_config.unsetClients();
            this.m_client = null;
            this.fireXmlObjectStructureChanged();
            this.updateChildren();
        }
        this.fireClientChanged();
    }

    private void fireXmlObjectStructureChanged() {
        this.fireXmlObjectStructureChanged((XmlObject)this.m_config);
    }

    public void structureChanged(XmlObjectStructureChangeEvent e) {
        this.testUnsetClients();
    }

    private void addListeners() {
        this.m_layout.m_logsBrowse.addSelectionListener((SelectionListener)this.m_logsBrowseSelectionHandler);
        ((XmlStringField)this.m_layout.m_logsLocation.getData()).addXmlObjectStructureListener(this);
        this.m_layout.m_dsoClientDataPanel.addXmlObjectStructureListener(this);
        this.m_layout.m_modulesPanel.addXmlObjectStructureListener(this);
    }

    private void removeListeners() {
        this.m_layout.m_logsBrowse.removeSelectionListener((SelectionListener)this.m_logsBrowseSelectionHandler);
        ((XmlStringField)this.m_layout.m_logsLocation.getData()).removeXmlObjectStructureListener(this);
        this.m_layout.m_dsoClientDataPanel.removeXmlObjectStructureListener(this);
        this.m_layout.m_modulesPanel.removeXmlObjectStructureListener(this);
    }

    private void updateChildren() {
        this.m_layout.setup(this.m_client);
    }

    public void setup(IProject project) {
        TcPlugin plugin = TcPlugin.getDefault();
        this.removeListeners();
        this.setEnabled(true);
        this.m_project = project;
        this.m_config = plugin.getConfiguration(project);
        this.m_client = this.m_config != null ? this.m_config.getClients() : null;
        this.updateChildren();
        this.addListeners();
    }

    public IProject getProject() {
        return this.m_project;
    }

    public void tearDown() {
        this.removeListeners();
        this.m_layout.tearDown();
        this.setEnabled(false);
    }

    private class LogsBrowseSelectionHandler
    extends SelectionAdapter {
        private LogsBrowseSelectionHandler() {
        }

        public void widgetSelected(SelectionEvent e) {
            IFolder folder = SWTUtil.openSelectFolderDialog(ClientsPanel.this.m_project, "Select logs folder", "Choose a folder for the log area");
            if (folder != null) {
                ClientsPanel.this.setStringField(ClientsPanel.this.m_layout.m_logsLocation, folder.getProjectRelativePath().toString());
            }
        }
    }

    private class Layout {
        private static final String LOGS = "Logs";
        private static final String BROWSE = "Browse...";
        private final Button m_logsBrowse;
        private final Text m_logsLocation;
        private final DsoClientDataPanel m_dsoClientDataPanel;
        private final ModulesPanel m_modulesPanel;

        void setup(Client client) {
            ((XmlStringField)this.m_logsLocation.getData()).setup((XmlObject)client);
            this.m_dsoClientDataPanel.setup(client);
            this.m_modulesPanel.setup(client);
        }

        void tearDown() {
            ((XmlStringField)this.m_logsLocation.getData()).tearDown();
            this.m_dsoClientDataPanel.tearDown();
            this.m_modulesPanel.tearDown();
        }

        private Layout(Composite parent) {
            parent.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            Composite panel = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.marginHeight = 10;
            gridLayout.marginWidth = 10;
            panel.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            panel.setLayoutData((Object)new GridData(1808));
            Composite comp = new Composite(panel, 0);
            gridLayout = new GridLayout(3, false);
            gridLayout.marginHeight = 0;
            gridLayout.marginWidth = 0;
            comp.setLayout((org.eclipse.swt.widgets.Layout)gridLayout);
            comp.setLayoutData((Object)new GridData(768));
            Label logsLabel = new Label(comp, 0);
            logsLabel.setText(LOGS);
            this.m_logsLocation = new Text(comp, 2048);
            this.m_logsLocation.setLayoutData((Object)new GridData(768));
            ClientsPanel.this.initStringField(this.m_logsLocation, Client.class, "logs");
            this.m_logsBrowse = new Button(comp, 8);
            this.m_logsBrowse.setText(BROWSE);
            SWTUtil.applyDefaultButtonSize(this.m_logsBrowse);
            this.m_dsoClientDataPanel = new DsoClientDataPanel(panel, 0);
            this.m_dsoClientDataPanel.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            this.m_dsoClientDataPanel.setLayoutData(new GridData(768));
            this.m_modulesPanel = new ModulesPanel(panel, 0);
            this.m_modulesPanel.setLayout((org.eclipse.swt.widgets.Layout)new GridLayout());
            this.m_modulesPanel.setLayoutData(new GridData(1808));
        }
    }
}

