/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.terracotta.dso.TcPlugin;
import org.terracotta.ui.util.SWTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelaunchDialog
extends MessageDialog
implements SelectionListener {
    private final IProject fProject;
    private Tree fTree;
    private TreeItem fServersItem;
    private TreeItem fLaunchesItem;
    private final List<ILaunch> fServerLaunches;
    private final List<ILaunch> fLaunches;
    private Button fDisableRelaunchQueryButton;
    private static String DISABLE_RELAUNCH_QUERY_MSG = "Don't bother me with this anymore";
    private static String TITLE = "Terracotta";
    private static String MSG = "The configuration file changed. Relaunch all related launch targets?";
    public static final int CONTINUE_ID = 0;
    public static final int TERMINATE_ID = 1;
    private static String CONTINUE_LABEL = "Continue";
    private static String TERMINATE_LABEL = "Terminate";
    private static String RESTART_LABEL = "Restart";
    private static int MAX_VISIBLE_LAUNCH_ITEMS = 10;

    public RelaunchDialog(Shell shell, IProject project, List<ILaunch> serverLaunches, List<ILaunch> launches) {
        super(shell, TITLE, null, MSG, 0, new String[]{CONTINUE_LABEL, TERMINATE_LABEL, RESTART_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fProject = project;
        this.fServerLaunches = serverLaunches;
        this.fLaunches = launches;
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        return super.createDialogArea(parent);
    }

    protected Control createCustomArea(Composite parent) {
        ILaunch launch;
        Iterator<ILaunch> iter;
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTree = new Tree(comp, 2082);
        if (this.fServerLaunches.size() > 0) {
            this.fServersItem = new TreeItem(this.fTree, 0);
            iter = this.fServerLaunches.iterator();
            this.fServersItem.setText("Terracotta Server instances");
            this.fServersItem.setChecked(true);
            while (iter.hasNext()) {
                launch = iter.next();
                TreeItem serverLaunchItem = new TreeItem(this.fServersItem, 0);
                serverLaunchItem.setData((Object)launch);
                serverLaunchItem.setText(this.computeName(launch));
                serverLaunchItem.setChecked(true);
            }
            this.fServersItem.setExpanded(true);
        }
        if (this.fLaunches.size() > 0) {
            this.fLaunchesItem = new TreeItem(this.fTree, 0);
            this.fLaunchesItem.setText("DSO Applications");
            this.fLaunchesItem.setChecked(true);
            iter = this.fLaunches.iterator();
            while (iter.hasNext()) {
                launch = iter.next();
                String label = this.computeName(launch);
                if (label == null) {
                    iter.remove();
                    continue;
                }
                TreeItem launchItem = new TreeItem(this.fLaunchesItem, 0);
                launchItem.setData((Object)launch);
                launchItem.setText(label);
                launchItem.setChecked(true);
            }
            this.fLaunchesItem.setExpanded(true);
        }
        GridData gridData = new GridData(1808);
        this.fTree.setLayoutData((Object)gridData);
        parent.pack();
        Rectangle r = new Rectangle(0, 0, 0, 0);
        for (int i = 0; i < this.fTree.getItemCount(); ++i) {
            r = RelaunchDialog.mergeBounds(this.fTree.getItem(i), r);
        }
        gridData = new GridData(1808);
        gridData.heightHint = Math.min(r.height, this.fTree.getItemHeight() * MAX_VISIBLE_LAUNCH_ITEMS) + 10;
        gridData.widthHint = Math.min(r.width, SWTUtil.textColumnsToPixels((Control)this.fTree, 100));
        this.fTree.setLayoutData((Object)gridData);
        this.fTree.addSelectionListener((SelectionListener)this);
        this.fDisableRelaunchQueryButton = new Button(comp, 32);
        this.fDisableRelaunchQueryButton.setLayoutData((Object)new GridData());
        this.fDisableRelaunchQueryButton.setText(DISABLE_RELAUNCH_QUERY_MSG);
        this.fDisableRelaunchQueryButton.setSelection(!TcPlugin.getDefault().getQueryRestartOption(this.fProject));
        this.fDisableRelaunchQueryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean disableQueryRelaunch = RelaunchDialog.this.fDisableRelaunchQueryButton.getSelection();
                TcPlugin.getDefault().setQueryRestartOption(RelaunchDialog.this.fProject, !disableQueryRelaunch);
            }
        });
        return parent;
    }

    protected void setReturnCode(int code) {
        super.setReturnCode(code);
        if (code != 0) {
            TreeItem item;
            int i;
            if (this.fServersItem != null) {
                int serverLaunchCount = this.fServersItem.getItemCount();
                for (i = 0; i < serverLaunchCount; ++i) {
                    item = this.fServersItem.getItem(i);
                    if (item.getChecked()) continue;
                    this.fServerLaunches.remove(item.getData());
                }
            }
            if (this.fLaunchesItem != null) {
                int launchCount = this.fLaunchesItem.getItemCount();
                for (i = 0; i < launchCount; ++i) {
                    item = this.fLaunchesItem.getItem(i);
                    if (item.getChecked()) continue;
                    this.fLaunches.remove(item.getData());
                }
            }
        }
    }

    private boolean allChildrenChecked(TreeItem item) {
        int count = item.getItemCount();
        for (int i = 0; i < count; ++i) {
            if (item.getItem(i).getChecked()) continue;
            return false;
        }
        return true;
    }

    private void handleCheckChanged(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        boolean isChecked = item.getChecked();
        if (parentItem == null) {
            for (int i = 0; i < item.getItemCount(); ++i) {
                TreeItem child = item.getItem(i);
                child.setChecked(isChecked);
            }
        } else if (!isChecked) {
            parentItem.setChecked(false);
        } else if (this.allChildrenChecked(parentItem)) {
            parentItem.setChecked(true);
        }
    }

    public void widgetSelected(SelectionEvent e) {
        if (e.detail == 32) {
            this.handleCheckChanged((TreeItem)e.item);
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
    }

    private static Rectangle mergeBounds(TreeItem item, Rectangle r) {
        r = r.union(item.getBounds());
        for (int i = 0; i < item.getItemCount(); ++i) {
            r = RelaunchDialog.mergeBounds(item.getItem(i), r);
        }
        return r;
    }

    private static IProcess getProcess(ILaunch launch) {
        IDebugTarget debugTarget = launch.getDebugTarget();
        if (debugTarget != null) {
            return debugTarget.getProcess();
        }
        IProcess[] processes = launch.getProcesses();
        if (processes != null && processes.length > 0) {
            return processes[0];
        }
        return null;
    }

    protected String computeName(ILaunch launch) {
        String label = null;
        IProcess process = RelaunchDialog.getProcess(launch);
        if (process == null) {
            return null;
        }
        ILaunchConfiguration config = process.getLaunch().getLaunchConfiguration();
        label = process.getAttribute(IProcess.ATTR_PROCESS_LABEL);
        if (label == null) {
            if (config == null) {
                label = process.getLabel();
            } else if (DebugUITools.isPrivate((ILaunchConfiguration)config)) {
                label = process.getLabel();
            } else {
                String type = null;
                try {
                    type = config.getType().getName();
                }
                catch (CoreException e) {
                    // empty catch block
                }
                StringBuffer buffer = new StringBuffer();
                buffer.append(config.getName());
                if (type != null) {
                    buffer.append(" [");
                    buffer.append(type);
                    buffer.append("] ");
                }
                buffer.append(process.getLabel());
                label = buffer.toString();
            }
        }
        return label;
    }
}

