/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import com.tc.bundles.BundleSpec;
import com.tc.bundles.OSGiToMaven;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.apache.commons.io.FileUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.terracotta.ui.util.SWTUtil;

public class NewAddModuleDialog
extends MessageDialog {
    private final Modules fModules;
    private Combo fGroupIdCombo;
    private static ArrayList<String> fCachedGroupIds = new ArrayList();
    private Composite fTableHolder;
    private Table fTable;
    private SWTUtil.TableWeightedResizeHandler resizeHandler;
    private final SelectionListener fColumnSelectionListener;
    private CLabel fPathLabel;
    private Button fAddRepoButton;
    private Button fShowVersionsButton;
    private TableColumn fVersionColumn;
    private ValueListener m_valueListener;
    private static final String GROUP_ID = "Group Identifier:";
    private static final String REPO = "Repository";
    private static final String NAME = "Name";
    private static final String VERSION = "Version";
    private static final String VERSION_PATTERN = "^[0-9]+\\.[0-9]+\\.[0-9]+(-SNAPSHOT)?$";
    private static final int[] VERSION_WEIGHTS = new int[]{2, 2, 1};
    private static final int[] VERSIONLESS_WEIGHTS = new int[]{3, 3};

    public NewAddModuleDialog(Shell parentShell, String title, String message, Modules modules) {
        super(parentShell, "Select modules", null, "Select modules to add to your configuration", 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.setShellStyle(0x860 | NewAddModuleDialog.getDefaultOrientation() | 0x10);
        this.fModules = modules != null ? (Modules)modules.copy() : Modules.Factory.newInstance();
        this.fColumnSelectionListener = new ColumnSelectionListener();
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        Composite groupComp = new Composite(comp, 0);
        groupComp.setLayout((Layout)new GridLayout(2, false));
        Label groupIdLabel = new Label(groupComp, 0);
        groupIdLabel.setText(GROUP_ID);
        groupIdLabel.setLayoutData((Object)new GridData());
        this.fGroupIdCombo = new Combo(groupComp, 2048);
        this.fGroupIdCombo.setLayoutData((Object)new GridData(768));
        this.fGroupIdCombo.add("org.terracotta.modules");
        for (String groupId : fCachedGroupIds.toArray(new String[0])) {
            this.fGroupIdCombo.add(groupId);
        }
        this.fGroupIdCombo.select(0);
        this.fGroupIdCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAddModuleDialog.this.populateTable();
            }
        });
        this.fGroupIdCombo.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                Shell shell = NewAddModuleDialog.this.getShell();
                if (shell == null || shell.isDisposed()) {
                    return;
                }
                String text = NewAddModuleDialog.this.fGroupIdCombo.getText();
                if (NewAddModuleDialog.this.fGroupIdCombo.indexOf(text) == -1) {
                    NewAddModuleDialog.this.fGroupIdCombo.add(text);
                    fCachedGroupIds.add(text);
                }
                NewAddModuleDialog.this.populateTable();
            }
        });
        this.fTableHolder = new Composite(comp, 0);
        this.fTableHolder.setLayout((Layout)new GridLayout());
        this.fTableHolder.setLayoutData((Object)new GridData(1808));
        this.createTable(this.fTableHolder);
        this.fPathLabel = new CLabel(comp, 0);
        this.fPathLabel.setLayoutData((Object)new GridData(768));
        Composite controlsGroup = new Composite(comp, 0);
        controlsGroup.setLayout((Layout)new GridLayout(2, false));
        controlsGroup.setLayoutData((Object)new GridData(768));
        this.fAddRepoButton = new Button(controlsGroup, 8);
        this.fAddRepoButton.setText("Add repository...");
        this.fAddRepoButton.setLayoutData((Object)new GridData());
        this.fAddRepoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewAddModuleDialog.this.getShell());
                directoryDialog.setText("Terracotta Module Repository Chooser");
                directoryDialog.setMessage("Select a module repository directory");
                String path = directoryDialog.open();
                if (path != null) {
                    File dir = new File(path);
                    NewAddModuleDialog.this.fModules.addRepository(dir.toString());
                    NewAddModuleDialog.this.populateTable();
                }
            }
        });
        this.fShowVersionsButton = new Button(controlsGroup, 32);
        this.fShowVersionsButton.setText("Show Versions");
        this.fShowVersionsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAddModuleDialog.this.addRemoveVersionColumn();
            }
        });
        this.fShowVersionsButton.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
        return comp;
    }

    private void addRemoveVersionColumn() {
        boolean showVersions = this.showVersions();
        int topIndex = this.fTable.getTopIndex();
        int selectionIndex = this.fTable.getSelectionIndex();
        if (showVersions) {
            this.fVersionColumn = new TableColumn(this.fTable, 0);
            this.fVersionColumn.setResizable(true);
            this.fVersionColumn.setText(VERSION);
            this.fVersionColumn.addSelectionListener(this.fColumnSelectionListener);
        } else {
            this.fVersionColumn.dispose();
            this.fVersionColumn = null;
        }
        this.packTable();
        this.populateTable();
        this.fTable.setTopIndex(topIndex);
        if (selectionIndex != -1) {
            this.fTable.setSelection(selectionIndex);
        }
        this.fTable.setFocus();
    }

    private boolean showVersions() {
        return this.fShowVersionsButton != null && this.fShowVersionsButton.getSelection();
    }

    private void createTable(Composite parent) {
        boolean showVersions = this.showVersions();
        this.fTable = new Table(parent, 68098);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.tableRowsToPixels(this.fTable, 10);
        gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.fTable, 100);
        this.fTable.setLayoutData((Object)gridData);
        TableColumn column0 = new TableColumn(this.fTable, 0);
        column0.setResizable(true);
        column0.setText(REPO);
        column0.addSelectionListener(this.fColumnSelectionListener);
        TableColumn column1 = new TableColumn(this.fTable, 0);
        column1.setResizable(true);
        column1.setText(NAME);
        column1.addSelectionListener(this.fColumnSelectionListener);
        TableColumn column2 = null;
        if (showVersions) {
            column2 = new TableColumn(this.fTable, 0);
            column2.setResizable(true);
            column2.setText(VERSION);
            column2.addSelectionListener(this.fColumnSelectionListener);
        }
        this.populateTable();
        this.packTable();
        column0.pack();
        column1.pack();
        if (column2 != null) {
            column2.pack();
        }
        this.fTable.setFocus();
        this.fTable.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                String tip = null;
                TableItem item = NewAddModuleDialog.this.fTable.getItem(new Point(e.x, e.y));
                if (item != null) {
                    ItemData itemData = (ItemData)item.getData();
                    tip = itemData.fArchiveFile.getAbsolutePath();
                }
                NewAddModuleDialog.this.fPathLabel.setText(tip);
            }
        });
        this.fTable.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                NewAddModuleDialog.this.fPathLabel.setText("");
            }
        });
    }

    private void packTable() {
        if (this.resizeHandler != null) {
            this.resizeHandler.dispose();
        }
        int[] colWeights = this.showVersions() ? VERSION_WEIGHTS : VERSIONLESS_WEIGHTS;
        this.resizeHandler = SWTUtil.makeTableColumnsResizeWeightedWidth(this.fTableHolder, this.fTable, colWeights);
    }

    private void populateTable() {
        this.fTable.removeAll();
        File installRoot = new File(System.getProperty("tc.install-root"));
        this.populateTable(new File(installRoot, "platform/modules"), "KIT");
        String[] repos = this.fModules.getRepositoryArray();
        if (repos != null) {
            for (String repo : repos) {
                File repoDir = null;
                if (repo.startsWith("file:")) {
                    try {
                        repoDir = new File(new URL(repo).getFile());
                    }
                    catch (MalformedURLException e) {}
                } else {
                    repoDir = new File(repo);
                }
                if (repoDir == null || !repoDir.exists() || !repoDir.isDirectory()) continue;
                this.populateTable(repoDir, null);
            }
        }
    }

    private void populateTable(File repoDir, String nickname) {
        File[] jarFiles;
        String repo;
        TableItem item;
        String targetGroupId = this.fGroupIdCombo.getText();
        File groupDir = new File(repoDir, targetGroupId.replace('.', File.separatorChar));
        File[] names = groupDir.listFiles();
        boolean showVersions = this.showVersions();
        if (names == null) {
            return;
        }
        block0: for (File nameFile : names) {
            File[] versions = nameFile.listFiles(new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.matches(NewAddModuleDialog.VERSION_PATTERN);
                }
            });
            if (versions == null) continue;
            for (File versionFile : versions) {
                String[] stringArray;
                item = new TableItem(this.fTable, 0);
                repo = nickname != null ? nickname : repoDir.getAbsolutePath();
                String name = nameFile.getName();
                String version = versionFile.getName();
                if (showVersions) {
                    String[] stringArray2 = new String[3];
                    stringArray2[0] = repo;
                    stringArray2[1] = name;
                    stringArray = stringArray2;
                    stringArray2[2] = version;
                } else {
                    String[] stringArray3 = new String[2];
                    stringArray3[0] = repo;
                    stringArray = stringArray3;
                    stringArray3[1] = name;
                }
                String[] strings = stringArray;
                item.setText(strings);
                File archiveFile = new File(versionFile, name + "-" + version + ".jar");
                item.setData((Object)new ItemData(strings, repoDir, archiveFile));
                if (!showVersions) continue block0;
            }
        }
        for (File jarFile : jarFiles = repoDir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            Manifest manifest = NewAddModuleDialog.getManifest(jarFile);
            if (manifest == null) continue;
            String version = BundleSpec.getVersion((Manifest)manifest);
            String symbolicName = BundleSpec.getSymbolicName((Manifest)manifest);
            if (symbolicName == null || version == null) continue;
            String bundleGroupId = OSGiToMaven.groupIdFromSymbolicName((String)symbolicName);
            if (!targetGroupId.equals(bundleGroupId)) {
                if (this.fGroupIdCombo.indexOf(bundleGroupId) == -1) {
                    this.fGroupIdCombo.add(bundleGroupId);
                }
                return;
            }
            item = new TableItem(this.fTable, 0);
            repo = nickname != null ? nickname : repoDir.getAbsolutePath();
            String[] strings = showVersions ? new String[]{repo, OSGiToMaven.artifactIdFromSymbolicName((String)symbolicName), OSGiToMaven.bundleVersionToProjectVersion((String)version)} : new String[]{repo, OSGiToMaven.artifactIdFromSymbolicName((String)symbolicName)};
            item.setText(strings);
            item.setData((Object)new ItemData(strings, repoDir, jarFile));
        }
    }

    private static Manifest getManifest(File file) {
        try {
            return NewAddModuleDialog.getManifest(file.toURI().toURL());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static Manifest getManifest(URL location) {
        try {
            JarFile bundle = new JarFile(FileUtils.toFile((URL)location));
            return bundle.getManifest();
        }
        catch (IOException e) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sort() {
        int i;
        int itemCount = this.fTable.getItemCount();
        if (itemCount == 0 || itemCount == 1) {
            return;
        }
        Comparator<ItemData> comparator = new Comparator<ItemData>(){
            final int sortDirection;
            final TableColumn sortColumn;
            int index;
            {
                this.sortDirection = NewAddModuleDialog.this.fTable.getSortDirection();
                this.sortColumn = NewAddModuleDialog.this.fTable.getSortColumn();
                this.index = this.sortColumn == null ? 0 : NewAddModuleDialog.this.fTable.indexOf(this.sortColumn);
            }

            @Override
            public int compare(ItemData itemData1, ItemData itemData2) {
                if (this.sortDirection == 128 || this.sortDirection == 0) {
                    return itemData1.fStrings[this.index].compareTo(itemData2.fStrings[this.index]);
                }
                return itemData2.fStrings[this.index].compareTo(itemData1.fStrings[this.index]);
            }
        };
        ArrayList<ItemData> selection = new ArrayList<ItemData>();
        for (TableItem item : this.fTable.getSelection()) {
            selection.add((ItemData)item.getData());
        }
        ItemData[] data = new ItemData[this.fTable.getItemCount()];
        for (i = 0; i < this.fTable.getItemCount(); ++i) {
            data[i] = (ItemData)this.fTable.getItem(i).getData();
        }
        Arrays.sort(data, 0, itemCount, comparator);
        this.fTable.setRedraw(false);
        try {
            this.fTable.deselectAll();
            for (i = 0; i < this.fTable.getItemCount(); ++i) {
                TableItem item = this.fTable.getItem(i);
                ItemData itemData = data[i];
                item.setText(itemData.fStrings);
                item.setData((Object)itemData);
                if (!selection.contains(itemData)) continue;
                this.fTable.select(i);
            }
        }
        finally {
            this.fTable.setRedraw(true);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            boolean showVersions = this.showVersions();
            TableItem[] items = this.fTable.getSelection();
            String groupId = this.fGroupIdCombo.getText();
            for (TableItem item : items) {
                Module module = this.fModules.addNewModule();
                module.setGroupId(groupId);
                module.setName(item.getText(1));
                if (!showVersions) continue;
                module.setVersion(item.getText(2));
            }
            if (this.m_valueListener != null) {
                this.m_valueListener.setValue(this.fModules);
            }
        }
        super.buttonPressed(buttonId);
    }

    public void addValueListener(ValueListener listener) {
        this.m_valueListener = listener;
    }

    public static interface ValueListener {
        public void setValue(Modules var1);
    }

    class ItemData {
        String[] fStrings;
        File fRepoDir;
        File fArchiveFile;

        ItemData(String[] strings, File repoDir, File moduleFile) {
            this.fStrings = strings;
            this.fRepoDir = repoDir;
            this.fArchiveFile = moduleFile;
        }
    }

    class ColumnSelectionListener
    extends SelectionAdapter {
        ColumnSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            TableColumn col = (TableColumn)e.widget;
            switch (NewAddModuleDialog.this.fTable.getSortDirection()) {
                case 1024: {
                    NewAddModuleDialog.this.fTable.setSortDirection(128);
                    break;
                }
                default: {
                    NewAddModuleDialog.this.fTable.setSortDirection(1024);
                }
            }
            NewAddModuleDialog.this.fTable.setSortColumn(col);
            NewAddModuleDialog.this.sort();
        }
    }
}

