/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditor;
import org.terracotta.ui.util.SWTUtil;

public class ConfigProblemsDialog
extends MessageDialog {
    private final Shell fParentShell;
    private final IProject fProject;
    private Table fTable;
    private Button fDisableConfigWarningsButton;
    private static String DISABLE_CONFIG_WARNINGS_MSG = "Always proceed even if there are config problems";
    private static String TITLE = "Terracotta";
    private static String MSG = "There are problems with the Terracotta configuration. Continue?";
    private static Image ERROR_IMG = ConfigProblemsDialog.getSharedImage("IMG_OBJS_ERROR_PATH");
    private static Image WARNING_IMG = ConfigProblemsDialog.getSharedImage("IMG_OBJS_WARNING_PATH");
    private static Image INFO_IMG = ConfigProblemsDialog.getSharedImage("IMG_OBJS_INFO_PATH");

    public ConfigProblemsDialog(Shell shell, IProject project) {
        super(shell, TITLE, null, MSG, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fProject = project;
        this.fParentShell = shell;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.fParentShell != null) {
            SWTUtil.placeDialogInCenter(this.fParentShell, shell);
        }
    }

    protected Control createDialogArea(Composite parent) {
        parent.setLayout((Layout)new GridLayout());
        return super.createDialogArea(parent);
    }

    protected Control createCustomArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        comp.setLayoutData((Object)new GridData(1808));
        this.fTable = new Table(comp, 68100);
        this.fTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    ConfigurationEditor configEditor = TcPlugin.getDefault().openConfigurationEditor(ConfigProblemsDialog.this.fProject);
                    TableItem item = ConfigProblemsDialog.this.fTable.getSelection()[0];
                    configEditor.gotoMarker((IMarker)item.getData());
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn fieldCol = new TableColumn(this.fTable, 0);
        fieldCol.setResizable(true);
        fieldCol.setText("Description");
        fieldCol.pack();
        TableColumn nameCol = new TableColumn(this.fTable, 0);
        nameCol.setResizable(true);
        nameCol.setText("Location");
        nameCol.pack();
        SWTUtil.makeTableColumnsResizeWeightedWidth(comp, this.fTable, new int[]{5, 1});
        GridData gridData = new GridData(1808);
        gridData.heightHint = SWTUtil.tableRowsToPixels(this.fTable, 5);
        gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.fTable, 120);
        this.fTable.setLayoutData((Object)gridData);
        IFile configFile = TcPlugin.getDefault().getConfigurationFile(this.fProject);
        IMarker[] markers = null;
        try {
            markers = configFile.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
        }
        catch (CoreException ce) {
            ce.printStackTrace();
        }
        if (markers != null && markers.length > 0) {
            for (IMarker marker : markers) {
                TableItem item = new TableItem(this.fTable, 0);
                item.setData((Object)marker);
                item.setImage(ConfigProblemsDialog.getImage(marker));
                item.setText(new String[]{marker.getAttribute("message", ""), "line " + marker.getAttribute("lineNumber", 0)});
            }
        }
        this.fDisableConfigWarningsButton = new Button(comp, 32);
        this.fDisableConfigWarningsButton.setLayoutData((Object)new GridData());
        this.fDisableConfigWarningsButton.setText(DISABLE_CONFIG_WARNINGS_MSG);
        this.fDisableConfigWarningsButton.setSelection(!TcPlugin.getDefault().getWarnConfigProblemsOption(this.fProject));
        this.fDisableConfigWarningsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean disableWarn = ConfigProblemsDialog.this.fDisableConfigWarningsButton.getSelection();
                TcPlugin.getDefault().setWarnConfigProblemsOption(ConfigProblemsDialog.this.fProject, !disableWarn);
            }
        });
        return parent;
    }

    private static Image getImage(IMarker marker) {
        switch (marker.getAttribute("severity", 0)) {
            case 2: {
                return ERROR_IMG;
            }
            case 1: {
                return WARNING_IMG;
            }
            case 0: {
                return INFO_IMG;
            }
        }
        return null;
    }

    private static Image getSharedImage(String symbolicName) {
        ImageDescriptor imageDesc = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(symbolicName);
        if (imageDesc != null) {
            return JFaceResources.getResources().createImageWithDefault(imageDesc);
        }
        return null;
    }
}

