/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.dialogs;

import com.tc.admin.common.AbstractResolutionAction;
import com.tc.admin.common.AbstractWorkState;
import com.tc.admin.common.BrowserLauncher;
import com.tc.admin.common.NonPortableMessages;
import com.tc.admin.common.NonPortableWorkState;
import com.tc.object.appevent.AbstractApplicationEvent;
import com.tc.object.appevent.AbstractLockEvent;
import com.tc.object.appevent.AbstractLockEventContext;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.Include;
import com.terracottatech.config.LockLevel;
import com.terracottatech.config.NamedLock;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xmlbeans.XmlObject;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IOpenable;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.dialogs.AbstractApplicationEventDialog;
import org.terracotta.dso.util.StackElementInfo;
import org.terracotta.dso.views.ConfigUI;
import org.terracotta.ui.util.SWTUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractLockDialog
extends AbstractApplicationEventDialog {
    private AbstractWorkState fWorkState;
    private List<StackElementInfo> fStackElementInfos;
    private NonPortableWorkState fTargetObjectState;
    private Table fStackTable;
    private LockRulePanel fLockRuleView;
    protected static final Image WRITE_ICON = TcPlugin.createImage("/images/eclipse/occ_write.gif");
    protected static final Image READ_ICON = TcPlugin.createImage("/images/eclipse/occ_read.gif");
    protected static final Image CONCURRENT_ICON = TcPlugin.createImage("/images/eclipse/occ_write.gif");
    protected static final Image SYNCHRONOUS_WRITE_ICON = TcPlugin.createImage("/images/eclipse/sync_write.gif");

    public AbstractLockDialog(Shell parentShell, String title, AbstractLockEvent lockEvent) {
        super(parentShell, title, (AbstractApplicationEvent)lockEvent, new String[]{IDialogConstants.CANCEL_LABEL, IDialogConstants.OK_LABEL}, 1);
        this.fWorkState = this.createWorkState(lockEvent);
        this.populateStackElementInfos();
    }

    protected abstract AbstractWorkState createWorkState(AbstractLockEvent var1);

    protected AbstractWorkState getWorkState() {
        return this.fWorkState;
    }

    protected abstract String getIssueName();

    private AbstractLockEvent getAbstractLockEvent() {
        return (AbstractLockEvent)this.getApplicationEvent();
    }

    private AbstractLockEventContext getAbstractLockEventContext() {
        return this.getAbstractLockEvent().getAbstractLockEventContext();
    }

    private void populateStackElementInfos() {
        int i;
        StackTraceElement[] elements = this.getAbstractLockEventContext().getStackElements();
        ArrayList<StackTraceElement> list = new ArrayList<StackTraceElement>();
        block2: for (int i2 = 0; i2 < elements.length; ++i2) {
            StackTraceElement element = elements[i2];
            if (element.getMethodName().startsWith("__tc_wrapped")) {
                int nextIndex = i2 + 1;
                StackTraceElement nextElement = elements[nextIndex];
                if (nextElement.getLineNumber() >= 0 || element.getLineNumber() < 1) continue;
                try {
                    Field[] fields;
                    for (Field f : fields = nextElement.getClass().getDeclaredFields()) {
                        if (!f.getName().equals("lineNumber")) continue;
                        f.setAccessible(true);
                        f.setInt(nextElement, element.getLineNumber());
                        continue block2;
                    }
                    continue;
                }
                catch (Exception e) {
                    continue;
                }
            }
            list.add(element);
        }
        int startIndex = 0;
        for (i = list.size() - 1; i >= 0; --i) {
            StackTraceElement element = (StackTraceElement)list.get(i);
            if (!element.getMethodName().startsWith("__tc_") && element.getLineNumber() >= 0) continue;
            startIndex = i + 1;
            break;
        }
        this.fStackElementInfos = new ArrayList<StackElementInfo>();
        for (i = startIndex; i < list.size(); ++i) {
            this.fStackElementInfos.add(new StackElementInfo((StackTraceElement)list.get(i)));
        }
    }

    @Override
    protected void createIssueDescriptionArea(Composite parent) {
        this.fStackTable = new Table(parent, 2568);
        GridData gridData = new GridData(1808);
        gridData.widthHint = SWTUtil.textColumnsToPixels((Control)this.fStackTable, 80);
        gridData.heightHint = SWTUtil.textRowsToPixels((Control)this.fStackTable, 8);
        this.fStackTable.setLayoutData((Object)gridData);
    }

    @Override
    protected Control createCustomArea(Composite parent) {
        Control customArea = super.createCustomArea(parent);
        this.fLockRuleView = new LockRulePanel(this.fActionPanel);
        this.populateStackTable();
        this.fSummaryLabel.setText(this.fTargetObjectState != null ? this.fTargetObjectState.summary() : "Thread stack");
        this.fSummaryLabel.setImage(this.fTargetObjectState != null ? AbstractLockDialog.imageFor((AbstractWorkState)this.fTargetObjectState) : null);
        this.fActionTreeViewer.setInput((Object)this.fWorkState);
        this.fActionTreeViewer.expandAll();
        return customArea;
    }

    @Override
    protected boolean anySelectedActions() {
        return this.fWorkState.hasSelectedActions();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void initIssueList() {
        TreeItem treeItem = this.fObjectTree.getItem(0);
        this.fIssueTable.setRedraw(false);
        try {
            this.fIssueTable.setItemCount(0);
            TableItem tableItem = new TableItem(this.fIssueTable, 0);
            tableItem.setData((Object)treeItem);
            tableItem.setImage(this.anyActionSelected() ? RESOLVED_ICON : BLANK_ICON);
            tableItem.setText(this.getIssueName());
            this.fIssueTable.setSelection(0);
        }
        finally {
            this.fIssueTable.setRedraw(true);
        }
    }

    @Override
    protected void handleTreeSelectionChange() {
    }

    @Override
    protected void apply() {
        for (AbstractResolutionAction action : this.fWorkState.getActions()) {
            if (!action.isSelected()) continue;
            action.apply();
        }
        super.apply();
    }

    @Override
    protected void initTreeItem(TreeItem item, DefaultMutableTreeNode node) {
        super.initTreeItem(item, node);
        Object userObject = node.getUserObject();
        if (userObject instanceof NonPortableWorkState) {
            NonPortableWorkState workState = (NonPortableWorkState)userObject;
            String fieldName = this.getAbstractLockEventContext().getFieldName();
            if (fieldName != null && fieldName.equals(workState.getFieldName())) {
                item.setBackground(this.getShell().getDisplay().getSystemColor(7));
                this.fObjectTree.showItem(item);
                this.fTargetObjectState = workState;
            }
        }
    }

    void populateStackTable() {
        Iterator<StackElementInfo> iter = this.fStackElementInfos.iterator();
        while (iter.hasNext()) {
            TableItem item = new TableItem(this.fStackTable, 0);
            StackElementInfo stackElemInfo = iter.next();
            StackTraceElement stackElement = stackElemInfo.getStackElement();
            Image image = BLANK_ICON;
            String typeName = stackElement.getClassName();
            int lineNumber = stackElement.getLineNumber() - 1;
            try {
                IType type = JdtUtils.findType(this.fJavaProject, typeName);
                if (type != null) {
                    ISourceRange srcRange;
                    IBuffer buffer;
                    Region region = null;
                    IMethod method = null;
                    stackElemInfo.setType(type);
                    IMethod[] methods = JdtUtils.findMethods(type, stackElement.getMethodName());
                    if (methods.length == 1) {
                        method = methods[0];
                    }
                    if (lineNumber >= 1 && (buffer = this.getBufferForMember((IJavaElement)type)) != null) {
                        Document document = new Document(buffer.getContents());
                        try {
                            region = document.getLineInformation(lineNumber);
                        }
                        catch (BadLocationException e) {
                            TcPlugin.getDefault().openError("Type (" + type + ") lineNumber(" + lineNumber + ")", e);
                        }
                    } else if (method != null && (srcRange = method.getNameRange()) != null) {
                        region = new Region(srcRange.getOffset(), srcRange.getLength());
                    }
                    if (region != null) {
                        ITypeRoot typeRoot;
                        IJavaElement elem;
                        stackElemInfo.setRegion((IRegion)region);
                        if (method == null && (elem = (typeRoot = type.getTypeRoot()).getElementAt(region.getOffset())) instanceof IMethod) {
                            method = (IMethod)elem;
                        }
                    }
                    if (method != null) {
                        XmlObject lock = this.fConfigHelper.getLock(method);
                        if (lock != null) {
                            LockLevel.Enum level;
                            if (lock instanceof Autolock) {
                                Autolock autolock = (Autolock)lock;
                                level = autolock.getLockLevel();
                            } else {
                                NamedLock namedLock = (NamedLock)lock;
                                level = namedLock.getLockLevel();
                            }
                            if (level == LockLevel.WRITE) {
                                image = WRITE_ICON;
                            } else if (level == LockLevel.READ) {
                                image = READ_ICON;
                            } else if (level == LockLevel.CONCURRENT) {
                                image = CONCURRENT_ICON;
                            } else if (level == LockLevel.SYNCHRONOUS_WRITE) {
                                image = SYNCHRONOUS_WRITE_ICON;
                            }
                        }
                        stackElemInfo.setMethod(method);
                    }
                }
            }
            catch (JavaModelException jme) {
                TcPlugin.getDefault().openError("stackElementInfo(" + stackElemInfo + ")", jme);
            }
            item.setImage(image);
            item.setText(stackElemInfo.toString());
        }
        this.fStackTable.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                e.widget.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        AbstractLockDialog.this.handleStackElementSelectionChange(AbstractLockDialog.this.fStackTable.getSelectionIndex());
                    }
                });
            }
        });
    }

    protected void handleStackElementSelectionChange(int frameElementIndex) {
        IRegion region;
        StackElementInfo stackElementInfo;
        IType type;
        if (frameElementIndex >= 0 && (type = (stackElementInfo = this.fStackElementInfos.get(frameElementIndex)).getType()) != null && (region = stackElementInfo.getRegion()) != null) {
            ConfigUI.jumpToRegion((IJavaElement)type, region);
        }
    }

    private IBuffer getBufferForMember(IJavaElement member) {
        IBuffer buffer = null;
        try {
            IOpenable openable = member.getOpenable();
            if (openable != null && member.exists()) {
                buffer = openable.getBuffer();
            }
        }
        catch (JavaModelException e) {
            TcPlugin.getDefault().openError("member(" + member + ")", e);
        }
        return buffer;
    }

    protected Iterator<StackElementInfo> createStackElementInfoIterator() {
        return this.fStackElementInfos.iterator();
    }

    protected StackElementInfo getStackElementInfo(int index) {
        return this.fStackElementInfos.get(index);
    }

    @Override
    protected AbstractResolutionAction[] createActions(AbstractWorkState workState) {
        ArrayList<MakeTransientAction> list = new ArrayList<MakeTransientAction>();
        String fieldName = this.getAbstractLockEventContext().getFieldName();
        if (fieldName != null && !this.fConfigHelper.isTransient(fieldName)) {
            list.add(new MakeTransientAction());
        }
        return list.toArray(new AbstractResolutionAction[0]);
    }

    @Override
    protected void updateButtons() {
        this.getButton(0).setEnabled(this.anyActionSelected());
    }

    class LockRulePanel
    extends Composite {
        Combo fStackCombo;
        Button fTypeAutoButton;
        Button fTypeNamedButton;
        SelectionAdapter fTypeListener;
        Button fLevelReadButton;
        Button fLevelWriteButton;
        Button fLevelConcurrentButton;
        Button fLevelSyncWriteButton;
        SelectionAdapter fLevelListener;
        Composite fTypeSpecificPanel;
        StackLayout fTypeSpecificStackLayout;
        Button fAutoSyncButton;
        Composite fNamePanel;
        Text fNameText;

        LockRulePanel(Composite parent) {
            super(parent, 0);
            this.setLayout((Layout)new GridLayout());
            this.setLayoutData(new GridData(1808));
            Composite methodChooser = new Composite((Composite)this, 0);
            methodChooser.setLayout((Layout)new GridLayout(2, false));
            methodChooser.setLayoutData((Object)new GridData(768));
            Label label = new Label(methodChooser, 0);
            label.setText("Method");
            label.setLayoutData((Object)new GridData());
            this.fStackCombo = new Combo(methodChooser, 2056);
            this.fStackCombo.setLayoutData((Object)new GridData(768));
            this.fStackCombo.setFont(parent.getFont());
            this.fStackCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LockRulePanel.this.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            AbstractLockDialog.this.handleStackElementSelectionChange(LockRulePanel.this.fStackCombo.getSelectionIndex());
                        }
                    });
                }
            });
            this.populateStackCombo();
            this.fTypeListener = new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (event.widget == LockRulePanel.this.fTypeAutoButton) {
                        LockRulePanel.this.fTypeSpecificStackLayout.topControl = LockRulePanel.this.fAutoSyncButton;
                        LockRulePanel.this.fTypeNamedButton.setSelection(false);
                    } else {
                        LockRulePanel.this.fTypeSpecificStackLayout.topControl = LockRulePanel.this.fNamePanel;
                        LockRulePanel.this.fTypeAutoButton.setSelection(false);
                    }
                    LockRulePanel.this.fTypeSpecificPanel.layout();
                    LockRulePanel.this.fTypeSpecificPanel.redraw();
                }
            };
            Composite detailsGroup = new Composite((Composite)this, 0);
            detailsGroup.setLayout((Layout)new GridLayout(3, false));
            detailsGroup.setLayoutData((Object)new GridData(768));
            Group typeGroup = new Group(detailsGroup, 32);
            typeGroup.setLayout((Layout)new GridLayout());
            typeGroup.setLayoutData((Object)new GridData(1, 1, false, false));
            typeGroup.setText("Lock type");
            Composite autoGroup = new Composite((Composite)typeGroup, 0);
            GridLayout autoGroupLayout = new GridLayout(2, false);
            autoGroupLayout.marginHeight = 0;
            autoGroupLayout.marginWidth = 0;
            autoGroup.setLayout((Layout)autoGroupLayout);
            autoGroup.setLayoutData((Object)new GridData(768));
            this.fTypeAutoButton = new Button(autoGroup, 16);
            this.fTypeAutoButton.setLayoutData((Object)new GridData());
            this.fTypeAutoButton.setText("Auto");
            this.fTypeAutoButton.setSelection(true);
            this.fTypeAutoButton.addSelectionListener((SelectionListener)this.fTypeListener);
            ImageHyperlink autoHelpLink = AbstractLockDialog.this.getFormToolkit().createImageHyperlink(autoGroup, 0);
            autoHelpLink.setImage(AbstractApplicationEventDialog.HELP_ICON);
            autoHelpLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BrowserLauncher.openURL((String)"http://www.terracotta.org/confluence/display/docs1/Concept+and+Architecture+Guide#ConceptandArchitectureGuide-Locks");
                }
            });
            autoHelpLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            Composite namedGroup = new Composite((Composite)typeGroup, 0);
            GridLayout namedGroupLayout = new GridLayout(2, false);
            autoGroupLayout.marginHeight = 0;
            namedGroupLayout.marginWidth = 0;
            namedGroup.setLayout((Layout)autoGroupLayout);
            namedGroup.setLayoutData((Object)new GridData(768));
            this.fTypeNamedButton = new Button(namedGroup, 16);
            this.fTypeNamedButton.setLayoutData((Object)new GridData());
            this.fTypeNamedButton.setText("Named");
            this.fTypeNamedButton.addSelectionListener((SelectionListener)this.fTypeListener);
            ImageHyperlink namedHelpLink = AbstractLockDialog.this.getFormToolkit().createImageHyperlink(namedGroup, 0);
            namedHelpLink.setImage(AbstractApplicationEventDialog.HELP_ICON);
            namedHelpLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(HyperlinkEvent e) {
                    BrowserLauncher.openURL((String)"http://www.terracotta.org/confluence/display/docs1/Concept+and+Architecture+Guide#ConceptandArchitectureGuide-Locks");
                }
            });
            namedHelpLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, false));
            Group levelGroup = new Group(detailsGroup, 32);
            levelGroup.setLayout((Layout)new GridLayout());
            levelGroup.setLayoutData((Object)new GridData(1, 1, false, false));
            levelGroup.setText("Lock level");
            this.fLevelReadButton = new Button((Composite)levelGroup, 16);
            this.fLevelReadButton.setLayoutData((Object)new GridData());
            this.fLevelReadButton.setText("Read");
            this.fLevelWriteButton = new Button((Composite)levelGroup, 16);
            this.fLevelWriteButton.setLayoutData((Object)new GridData());
            this.fLevelWriteButton.setText("Write");
            this.fLevelWriteButton.setSelection(true);
            this.fLevelConcurrentButton = new Button((Composite)levelGroup, 16);
            this.fLevelConcurrentButton.setLayoutData((Object)new GridData());
            this.fLevelConcurrentButton.setText("Concurrent");
            this.fLevelSyncWriteButton = new Button((Composite)levelGroup, 16);
            this.fLevelSyncWriteButton.setLayoutData((Object)new GridData());
            this.fLevelSyncWriteButton.setText("Synchronous-write");
            this.fTypeSpecificPanel = new Composite(detailsGroup, 0);
            this.fTypeSpecificPanel.setLayoutData((Object)new GridData(4, 1, true, false));
            this.fTypeSpecificStackLayout = new StackLayout();
            this.fTypeSpecificPanel.setLayout((Layout)this.fTypeSpecificStackLayout);
            this.fAutoSyncButton = new Button(this.fTypeSpecificPanel, 32);
            this.fAutoSyncButton.setLayoutData((Object)new GridData());
            this.fAutoSyncButton.setText("Auto-synchronize");
            this.fNamePanel = new Composite(this.fTypeSpecificPanel, 0);
            this.fNamePanel.setLayout((Layout)new GridLayout(2, false));
            this.fNamePanel.setLayoutData((Object)new GridData(768));
            Label nameLabel = new Label(this.fNamePanel, 0);
            nameLabel.setLayoutData((Object)new GridData());
            nameLabel.setText("Lock name:");
            this.fNameText = new Text(this.fNamePanel, 2048);
            this.fNameText.setLayoutData((Object)new GridData(768));
            this.fTypeSpecificStackLayout.topControl = this.fAutoSyncButton;
        }

        void populateStackCombo() {
            this.fStackCombo.removeAll();
            Iterator iter = AbstractLockDialog.this.fStackElementInfos.iterator();
            while (iter.hasNext()) {
                this.fStackCombo.add(iter.next().toString());
            }
            this.fStackCombo.select(0);
        }

        StackTraceElement getStackElement() {
            return ((StackElementInfo)AbstractLockDialog.this.fStackElementInfos.get(this.fStackCombo.getSelectionIndex())).getStackElement();
        }

        IMethod getMethod() {
            return ((StackElementInfo)AbstractLockDialog.this.fStackElementInfos.get(this.fStackCombo.getSelectionIndex())).getMethod();
        }

        boolean isAuto() {
            return this.fTypeAutoButton.getSelection();
        }

        String getLockName() {
            return this.fNameText.getText();
        }

        boolean isAutoSynchronized() {
            return this.fAutoSyncButton.getSelection();
        }

        LockLevel.Enum getLockLevel() {
            if (this.fLevelReadButton.getSelection()) {
                return LockLevel.READ;
            }
            if (this.fLevelWriteButton.getSelection()) {
                return LockLevel.WRITE;
            }
            if (this.fLevelConcurrentButton.getSelection()) {
                return LockLevel.CONCURRENT;
            }
            return LockLevel.SYNCHRONOUS_WRITE;
        }
    }

    class AddLockAction
    extends AbstractResolutionAction {
        AddLockAction() {
        }

        public void showControl(Object parentControl) {
            AbstractLockDialog.this.fActionStackLayout.topControl = AbstractLockDialog.this.fLockRuleView;
            AbstractLockDialog.this.fActionPanel.layout();
            AbstractLockDialog.this.fActionPanel.redraw();
        }

        public String getText() {
            return "Add lock";
        }

        public void apply() {
            String expr;
            IMethod method = AbstractLockDialog.this.fLockRuleView.getMethod();
            LockLevel.Enum level = AbstractLockDialog.this.fLockRuleView.getLockLevel();
            try {
                expr = PatternHelper.getJavadocSignature(method);
            }
            catch (Exception e) {
                StackTraceElement stackElement = AbstractLockDialog.this.fLockRuleView.getStackElement();
                expr = "* " + stackElement.getClassName() + "." + stackElement.getMethodName() + "(..)";
            }
            if (AbstractLockDialog.this.fLockRuleView.isAuto()) {
                Autolock lock = AbstractLockDialog.this.fConfigHelper.addNewAutolock(expr, level, AbstractApplicationEventDialog.NULL_SIGNALLER);
                lock.setAutoSynchronized(AbstractLockDialog.this.fLockRuleView.isAutoSynchronized());
            } else {
                AbstractLockDialog.this.fConfigHelper.addNewNamedLock(AbstractLockDialog.this.fLockRuleView.getLockName(), expr, level, AbstractApplicationEventDialog.NULL_SIGNALLER);
            }
        }
    }

    class MakeTransientAction
    extends AbstractResolutionAction {
        MakeTransientAction() {
        }

        public void showControl(Object parentControl) {
            String fieldName = AbstractLockDialog.this.getAbstractLockEventContext().getFieldName();
            String declaringType = fieldName.substring(0, fieldName.lastIndexOf(46));
            Include include = AbstractLockDialog.this.fConfigHelper.includeRuleFor(declaringType);
            if (include != null) {
                AbstractLockDialog.this.fActionStackLayout.topControl = AbstractLockDialog.this.fIncludeRuleView;
                AbstractLockDialog.this.fIncludeRuleView.setInclude(include);
                AbstractLockDialog.this.fActionPanel.layout();
                AbstractLockDialog.this.fActionPanel.redraw();
            }
        }

        public String getText() {
            return NonPortableMessages.getString((String)"DO_NOT_SHARE");
        }

        public void setSelected(boolean selected) {
            super.setSelected(selected);
            String fieldName = AbstractLockDialog.this.getAbstractLockEventContext().getFieldName();
            if (selected) {
                AbstractLockDialog.this.fConfigHelper.ensureTransient(fieldName, AbstractApplicationEventDialog.NULL_SIGNALLER);
            } else {
                AbstractLockDialog.this.fConfigHelper.ensureNotTransient(fieldName, AbstractApplicationEventDialog.NULL_SIGNALLER);
            }
        }
    }
}

