/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class TransientFieldAction
extends BaseAction {
    private IField m_field;

    public TransientFieldAction() {
        super("Transient field", 2);
    }

    public void setField(IField field) {
        this.m_field = field;
        this.setJavaElement((IJavaElement)this.m_field);
        this.setChecked(this.getConfigHelper().isTransient(this.m_field));
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        TransientFieldOperation operation = new TransientFieldOperation(this.m_field, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing TransientFieldOperation", ee);
        }
    }

    class TransientFieldOperation
    extends AbstractOperation {
        private final IField fField;
        private final boolean fMakeTransient;

        public TransientFieldOperation(IField field, boolean makeTransient) {
            super("");
            this.fField = field;
            this.fMakeTransient = makeTransient;
            if (this.fMakeTransient) {
                this.setLabel("Add Transient Field");
            } else {
                this.setLabel("Remove Transient Field");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = TransientFieldAction.this.getConfigHelper();
            if (this.fMakeTransient) {
                helper.ensureTransient(this.fField);
            } else {
                helper.ensureNotTransient(this.fField);
            }
            TransientFieldAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = TransientFieldAction.this.getConfigHelper();
            if (this.fMakeTransient) {
                helper.ensureNotTransient(this.fField);
            } else {
                helper.ensureTransient(this.fField);
            }
            TransientFieldAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

