/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.LockLevel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.BaseAction;
import org.terracotta.dso.dialogs.NamedLockDialog;

public class NameLockedAction
extends BaseAction {
    public NameLockedAction() {
        super("Name Locked", 2);
    }

    public void setJavaElement(IJavaElement element) {
        super.setJavaElement(element);
        this.setChecked(this.getConfigHelper().isNameLocked(element));
    }

    public void performAction(Event event) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        NamedLockOperation operation = new NamedLockOperation(this.m_element, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing NamedLockOperation", ee);
        }
    }

    class NamedLockOperation
    extends AbstractOperation {
        private final IJavaElement fJavaElement;
        private final boolean fAddNamedLock;
        private final String fPattern;
        private String fName;
        private LockLevel.Enum fLevel;
        private boolean fHaveDetails;

        public NamedLockOperation(IJavaElement javaElement, boolean addNamedLock) {
            super("");
            this.fJavaElement = javaElement;
            this.fAddNamedLock = addNamedLock;
            this.fPattern = PatternHelper.getExecutionPattern(this.fJavaElement);
            if (this.fAddNamedLock) {
                this.setLabel("Add Named Lock");
            } else {
                this.setLabel("Remove Named Lock");
            }
            this.fHaveDetails = false;
        }

        private int obtainDetails() {
            Shell shell = ActionUtil.findSelectedEditorPart().getSite().getShell();
            NamedLockDialog dialog = new NamedLockDialog(shell, this.fPattern);
            dialog.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent e) {
                    Object[] values = (Object[])e.data;
                    NamedLockOperation.this.fName = (String)values[0];
                    NamedLockOperation.this.fLevel = (LockLevel.Enum)values[1];
                    NamedLockOperation.this.fHaveDetails = true;
                }
            });
            return dialog.open();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = NameLockedAction.this.getConfigHelper();
            if (this.fAddNamedLock) {
                if (!this.fHaveDetails && this.obtainDetails() != 0) {
                    return Status.CANCEL_STATUS;
                }
                helper.ensureNameLocked(this.fJavaElement, this.fName, this.fLevel);
            } else {
                helper.ensureNotNameLocked(this.fJavaElement);
            }
            NameLockedAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = NameLockedAction.this.getConfigHelper();
            if (this.fAddNamedLock) {
                helper.ensureNotNameLocked(this.fJavaElement);
            } else {
                if (!this.fHaveDetails && this.obtainDetails() != 0) {
                    return Status.CANCEL_STATUS;
                }
                helper.ensureNameLocked(this.fJavaElement, this.fName, this.fLevel);
            }
            NameLockedAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

