/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class DistributedMethodAction
extends BaseAction {
    private IMethod m_method;

    public DistributedMethodAction() {
        super("Distributed method", 2);
    }

    public void setMethod(IMethod method) {
        this.m_method = method;
        this.setJavaElement((IJavaElement)this.m_method);
        this.setChecked(this.getConfigHelper().isDistributedMethod(method));
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        DistributedMethodOperation operation = new DistributedMethodOperation(this.m_method, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing DistributedMethodOperation", ee);
        }
    }

    class DistributedMethodOperation
    extends AbstractOperation {
        private final IMethod fMethod;
        private final boolean fMakeDistributed;

        public DistributedMethodOperation(IMethod method, boolean makeDistributed) {
            super("");
            this.fMethod = method;
            this.fMakeDistributed = makeDistributed;
            if (this.fMakeDistributed) {
                this.setLabel("Add Distibuted Method");
            } else {
                this.setLabel("Remove Distibuted Method");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = DistributedMethodAction.this.getConfigHelper();
            if (this.fMakeDistributed) {
                helper.ensureDistributedMethod(this.fMethod);
            } else {
                helper.ensureLocalMethod(this.fMethod);
            }
            DistributedMethodAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = DistributedMethodAction.this.getConfigHelper();
            if (this.fMakeDistributed) {
                helper.ensureLocalMethod(this.fMethod);
            } else {
                helper.ensureDistributedMethod(this.fMethod);
            }
            DistributedMethodAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

