/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class BootJarTypeAction
extends BaseAction {
    private IType m_type;
    private final SystemTypeSearchRequestor searchRequestor = new SystemTypeSearchRequestor();
    private final SearchParticipant[] searchParticipants = new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};

    public BootJarTypeAction() {
        super("Boot Jar", 2);
    }

    private void determineSystemType(IType type, Menu menu) {
        int filter = 4;
        IJavaElement[] elements = new IJavaElement[]{type.getJavaProject()};
        IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements, (int)filter);
        SearchPattern pattern = SearchPattern.createPattern((IJavaElement)type, (int)0);
        SearchEngine searchEngine = new SearchEngine();
        try {
            this.searchRequestor.setMenu(menu);
            searchEngine.search(pattern, this.searchParticipants, scope, (SearchRequestor)this.searchRequestor, null);
        }
        catch (CoreException ce) {
            this.setChecked(false);
        }
    }

    public void setType(IType type, Menu menu) {
        this.determineSystemType(type, menu);
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        BootJarTypeOperation operation = new BootJarTypeOperation(this.m_type, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing BootJarTypeOperation", ee);
        }
    }

    class BootJarTypeOperation
    extends AbstractOperation {
        private final IType fType;
        private final boolean fMakeBootJarType;

        public BootJarTypeOperation(IType type, boolean makeBootJarType) {
            super("");
            this.fType = type;
            this.fMakeBootJarType = makeBootJarType;
            if (this.fMakeBootJarType) {
                this.setLabel("Add BootJar Type");
            } else {
                this.setLabel("Remove BootJar Type");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = BootJarTypeAction.this.getConfigHelper();
            if (this.fMakeBootJarType) {
                helper.ensureBootJarClass(this.fType);
            } else {
                helper.ensureNotBootJarClass(this.fType);
            }
            BootJarTypeAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = BootJarTypeAction.this.getConfigHelper();
            if (this.fMakeBootJarType) {
                helper.ensureNotBootJarClass(this.fType);
            } else {
                helper.ensureBootJarClass(this.fType);
            }
            BootJarTypeAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }

    private class SystemTypeSearchRequestor
    extends SearchRequestor {
        private Menu fMenu;

        private SystemTypeSearchRequestor() {
        }

        public void acceptSearchMatch(SearchMatch match) {
            Object element = match.getElement();
            if (element instanceof IType) {
                IType type = (IType)element;
                BootJarTypeAction.this.setJavaElement((IJavaElement)(BootJarTypeAction.this.m_type = type));
                boolean isBootClass = TcPlugin.getDefault().isBootClass(type.getJavaProject().getProject(), type);
                BootJarTypeAction.this.setEnabled(!isBootClass);
                BootJarTypeAction.this.setChecked(isBootClass || BootJarTypeAction.this.getConfigHelper().isBootJarClass(type));
                ActionContributionItem item = new ActionContributionItem((IAction)BootJarTypeAction.this);
                item.fill(this.fMenu, -1);
            }
        }

        void setMenu(Menu menu) {
            this.fMenu = menu;
        }
    }
}

