/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import com.tc.util.event.UpdateEvent;
import com.tc.util.event.UpdateEventListener;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.LockLevel;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.MultiChangeSignaller;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.BaseAction;
import org.terracotta.dso.dialogs.AutolockDialog;

public class AutolockAction
extends BaseAction {
    public AutolockAction() {
        super("Autolock", 2);
    }

    public void setJavaElement(IJavaElement element) {
        super.setJavaElement(element);
        this.setChecked(this.getConfigHelper().isAutolocked(element));
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        AutolockOperation operation = new AutolockOperation(this.m_element, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing AutolockOperation", ee);
        }
    }

    class AutolockOperation
    extends AbstractOperation {
        private final IJavaElement fJavaElement;
        private final boolean fAddAutolock;
        private final String fPattern;
        private LockLevel.Enum fLevel;
        private boolean fAutoSync;
        private boolean fHaveDetails;
        private boolean fMadeAdaptable;

        public AutolockOperation(IJavaElement javaElement, boolean addAutolock) {
            super("");
            this.fJavaElement = javaElement;
            this.fAddAutolock = addAutolock;
            this.fPattern = PatternHelper.getExecutionPattern(this.fJavaElement);
            if (this.fAddAutolock) {
                this.setLabel("Add Autolock");
            } else {
                this.setLabel("Remove Autolock");
            }
            this.fHaveDetails = false;
        }

        private void obtainDetails() {
            Shell shell = ActionUtil.findSelectedEditorPart().getSite().getShell();
            AutolockDialog dialog = new AutolockDialog(shell, this.fPattern);
            dialog.addValueListener(new UpdateEventListener(){

                public void handleUpdate(UpdateEvent e) {
                    Object[] values = (Object[])e.data;
                    AutolockOperation.this.fAutoSync = (Boolean)values[0];
                    AutolockOperation.this.fLevel = (LockLevel.Enum)values[1];
                    AutolockOperation.this.fHaveDetails = true;
                }
            });
            dialog.open();
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = AutolockAction.this.getConfigHelper();
            if (this.fAddAutolock) {
                if (!this.fHaveDetails) {
                    this.obtainDetails();
                }
                MultiChangeSignaller signaller = new MultiChangeSignaller();
                if (!helper.isAdaptable(this.fJavaElement)) {
                    helper.ensureAdaptable(this.fJavaElement, signaller);
                    this.fMadeAdaptable = true;
                }
                Autolock lock = helper.addNewAutolock(this.fPattern, this.fLevel, signaller);
                lock.setAutoSynchronized(this.fAutoSync);
                signaller.signal(this.fJavaElement.getJavaProject().getProject());
            } else {
                helper.ensureNotAutolocked(this.fJavaElement);
                if (this.fMadeAdaptable) {
                    helper.ensureNotAdaptable(this.fJavaElement);
                }
            }
            AutolockAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = AutolockAction.this.getConfigHelper();
            if (this.fAddAutolock) {
                helper.ensureNotAutolocked(this.fJavaElement);
                if (this.fMadeAdaptable) {
                    helper.ensureNotAdaptable(this.fJavaElement);
                }
            } else {
                if (!this.fHaveDetails) {
                    this.obtainDetails();
                }
                MultiChangeSignaller signaller = new MultiChangeSignaller();
                if (!helper.isAdaptable(this.fJavaElement)) {
                    helper.ensureAdaptable(this.fJavaElement, signaller);
                    this.fMadeAdaptable = true;
                }
                Autolock lock = helper.addNewAutolock(this.fPattern, this.fLevel, signaller);
                lock.setAutoSynchronized(this.fAutoSync);
                signaller.signal(this.fJavaElement.getJavaProject().getProject());
            }
            AutolockAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

