/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso.actions;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.AbstractOperation;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.actions.BaseAction;

public class AdaptableAction
extends BaseAction {
    public AdaptableAction() {
        super("Instrumented", 2);
    }

    public void setJavaElement(IJavaElement element) {
        if (!(element instanceof IType || element instanceof IPackageFragment || element instanceof IJavaProject)) {
            throw new IllegalArgumentException("Java element must be IType, IPackageFragment, or IJavaProject");
        }
        super.setJavaElement(element);
        if (element instanceof IType) {
            IType type = (IType)element;
            if (this.getConfigHelper().isInstrumentationNotNeeded(type)) {
                this.setEnabled(false);
                this.setChecked(false);
            } else {
                boolean isBootClass = TcPlugin.getDefault().isBootClass(type.getJavaProject().getProject(), type);
                this.setEnabled(!isBootClass);
                this.setChecked(isBootClass || this.getConfigHelper().isAdaptable(type));
            }
        } else {
            this.setChecked(this.getConfigHelper().isAdaptable(element));
        }
    }

    public void performAction() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        IOperationHistory operationHistory = workbench.getOperationSupport().getOperationHistory();
        IUndoContext undoContext = workbench.getOperationSupport().getUndoContext();
        AdaptableOperation operation = new AdaptableOperation(this.m_element, this.isChecked());
        operation.addContext(undoContext);
        try {
            operationHistory.execute((IUndoableOperation)operation, null, null);
        }
        catch (ExecutionException ee) {
            TcPlugin.getDefault().openError("Executing AdaptableOperation", ee);
        }
    }

    class AdaptableOperation
    extends AbstractOperation {
        private final IJavaElement fJavaElement;
        private final boolean fInstrument;

        public AdaptableOperation(IJavaElement javaElement, boolean instrument) {
            super("");
            this.fJavaElement = javaElement;
            this.fInstrument = instrument;
            if (this.fInstrument) {
                this.setLabel("Add Instrumented Type");
            } else {
                this.setLabel("Remove Instrumented Type");
            }
        }

        public IStatus execute(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = AdaptableAction.this.getConfigHelper();
            if (this.fInstrument) {
                helper.ensureAdaptable(this.fJavaElement);
            } else {
                helper.ensureNotAdaptable(this.fJavaElement);
            }
            AdaptableAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus undo(IProgressMonitor monitor, IAdaptable info) {
            ConfigurationHelper helper = AdaptableAction.this.getConfigHelper();
            if (this.fInstrument) {
                helper.ensureNotAdaptable(this.fJavaElement);
            } else {
                helper.ensureAdaptable(this.fJavaElement);
            }
            AdaptableAction.this.inspectCompilationUnit();
            return Status.OK_STATUS;
        }

        public IStatus redo(IProgressMonitor monitor, IAdaptable info) {
            return this.execute(monitor, info);
        }
    }
}

