/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.bundles.EmbeddedOSGiEventHandler;
import com.tc.bundles.EmbeddedOSGiRuntime;
import com.tc.bundles.Resolver;
import com.tc.bundles.ResolverUtils;
import com.tc.config.Loader;
import com.tc.config.schema.dynamic.ParameterSubstituter;
import com.tc.logging.TCLogger;
import com.tc.logging.TCLogging;
import com.tc.object.util.JarResourceLoader;
import com.tc.plugins.ModulesLoader;
import com.tc.properties.TCProperties;
import com.tc.properties.TCPropertiesImpl;
import com.tc.server.ServerConstants;
import com.tc.util.Assert;
import com.tc.util.ProductInfo;
import com.terracottatech.config.BindPort;
import com.terracottatech.config.Client;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import com.terracottatech.config.Server;
import com.terracottatech.config.Servers;
import com.terracottatech.config.TcConfigDocument;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlError;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.ui.JavaElementImageDescriptor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IDecoratorManager;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.terracotta.dso.BootClassHelper;
import org.terracotta.dso.CompilationUnitVisitor;
import org.terracotta.dso.ConfigurationEventManager;
import org.terracotta.dso.ConfigurationHelper;
import org.terracotta.dso.ElementChangedListener;
import org.terracotta.dso.ErrorDialog;
import org.terracotta.dso.FakeDSOClientConfigHelper;
import org.terracotta.dso.IConfigurationListener;
import org.terracotta.dso.JavaElementAdapter;
import org.terracotta.dso.JavaSetupParticipant;
import org.terracotta.dso.LineLengths;
import org.terracotta.dso.ModuleInfo;
import org.terracotta.dso.ModulesConfiguration;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.ProjectNature;
import org.terracotta.dso.QualifiedNames;
import org.terracotta.dso.ResourceDeltaVisitor;
import org.terracotta.dso.ServerTracker;
import org.terracotta.dso.TcPluginStatusConstants;
import org.terracotta.dso.actions.ActionUtil;
import org.terracotta.dso.actions.IProjectAction;
import org.terracotta.dso.dialogs.ConfigProblemsDialog;
import org.terracotta.dso.editors.ConfigurationEditor;
import org.terracotta.dso.wizards.ProjectWizard;
import org.terracotta.modules.configuration.TerracottaConfiguratorModule;

public class TcPlugin
extends AbstractUIPlugin
implements QualifiedNames,
IJavaLaunchConfigurationConstants,
TcPluginStatusConstants {
    private static TcPlugin m_plugin;
    private Loader m_configLoader;
    private CompilationUnitVisitor m_compilationUnitVisitor;
    private ResourceListener m_resourceListener;
    private ResourceDeltaVisitor m_resourceDeltaVisitor;
    private XmlOptions m_xmlOptions;
    private DecoratorUpdateAction m_decoratorUpdateAction;
    private ArrayList<IProjectAction> m_projectActionList;
    private final ConfigurationEventManager m_configurationEventManager;
    public static final String PLUGIN_ID = "org.terracotta.dso";
    public static final String DEFAULT_CONFIG_FILENAME = "tc-config.xml";
    public static final String DEFAULT_SERVER_OPTIONS = "-Xms256m -Xmx256m";
    public static final boolean DEFAULT_AUTO_START_SERVER_OPTION = false;
    public static final boolean DEFAULT_WARN_CONFIG_PROBLEMS_OPTION = true;
    public static final boolean DEFAULT_QUERY_RESTART_OPTION = true;
    public static final String SERVER_NAME_LAUNCH_ATTR = "server.name";
    public static final String SERVER_HOST_LAUNCH_ATTR = "server.host";
    public static final String SERVER_JMX_PORT_LAUNCH_ATTR = "server.jmx-port";
    public static final String SERVER_DSO_PORT_LAUNCH_ATTR = "server.dso-port";
    public static final Server DEFAULT_SERVER_INSTANCE;
    private IPath m_location;
    public static final TcConfigDocument.TcConfig BAD_CONFIG;
    private static final String[] DECORATOR_IDS;

    public TcPlugin() {
        if (m_plugin != null) {
            throw new IllegalStateException("Plugin already instantiated.");
        }
        m_plugin = this;
        this.m_configurationEventManager = new ConfigurationEventManager();
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    private static Server createDefaultServerInstance() {
        Server server = Server.Factory.newInstance();
        server.setName("default");
        server.setHost("localhost");
        BindPort jmxPort = BindPort.Factory.newInstance();
        jmxPort.setBind("0.0.0.0");
        jmxPort.setIntValue(9520);
        server.addNewJmxPort();
        server.setJmxPort(jmxPort);
        BindPort dsoPort = BindPort.Factory.newInstance();
        dsoPort.setBind("0.0.0.0");
        dsoPort.setIntValue(9510);
        server.addNewDsoPort();
        server.setDsoPort(dsoPort);
        server.setBind("0.0.0.0");
        return server;
    }

    public boolean isBootClass(IProject project, ICompilationUnit module) {
        return module != null && this.isBootClass(project, module.findPrimaryType());
    }

    public boolean isBootClass(IProject project, IClassFile classFile) {
        try {
            return classFile != null && this.isBootClass(project, classFile.getType());
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean isBootClass(IProject project, IType type) {
        return this.isBootClass(project, PatternHelper.getFullyQualifiedName(type));
    }

    public boolean isBootClass(IProject project, String name) {
        BootClassHelper bch = this.getBootClassHelper(project);
        return bch != null ? bch.isAdaptable(name) : false;
    }

    public void registerProjectAction(IProjectAction action) {
        if (action != null) {
            this.m_projectActionList.add(action);
        }
    }

    public void notifyProjectActions(IProject project) {
        Iterator<IProjectAction> iter = this.m_projectActionList.iterator();
        while (iter.hasNext()) {
            iter.next().update(project);
        }
    }

    private void addResourceChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this.m_resourceListener, 16);
    }

    public IPath getLocation() {
        return this.m_location;
    }

    public IPath getLibDirPath() {
        return this.getLocation().append("lib");
    }

    public void start(BundleContext context) throws Exception {
        String installRootProp;
        String installRoot;
        super.start(context);
        this.m_configLoader = new Loader();
        URL url = Platform.resolve((URL)context.getBundle().getEntry("/"));
        this.m_location = new Path(url.getPath()).removeTrailingSeparator();
        JavaCore.addElementChangedListener((IElementChangedListener)new ElementChangedListener(), (int)4);
        this.m_resourceListener = new ResourceListener();
        this.addResourceChangeListener();
        IPath tcInstallPath = this.getLocation();
        if (tcInstallPath != null && (installRoot = System.getProperty(installRootProp = "tc.install-root")) == null) {
            System.setProperty(installRootProp, tcInstallPath.toString());
        }
        this.m_xmlOptions = this.createXmlOptions();
        this.m_projectActionList = new ArrayList();
        IAdapterManager manager = Platform.getAdapterManager();
        JavaElementAdapter factory = new JavaElementAdapter();
        manager.registerAdapters((IAdapterFactory)factory, IField.class);
        manager.registerAdapters((IAdapterFactory)factory, IType.class);
        manager.registerAdapters((IAdapterFactory)factory, IMethod.class);
        manager.registerAdapters((IAdapterFactory)factory, IClassFile.class);
    }

    public void stop(BundleContext context) throws Exception {
        ServerTracker.getDefault().shutdownAllServers();
        super.stop(context);
        m_plugin = null;
    }

    public static TcPlugin getDefault() {
        return m_plugin;
    }

    public void setup(IProject project, String configFilePath) {
        boolean isConfigEditorVisible;
        boolean bl = isConfigEditorVisible = this.getConfigurationEditor(project) != null;
        if (isConfigEditorVisible) {
            this.closeConfigurationEditor(project);
        }
        this.clearConfigurationSessionProperties(project);
        this.setConfigurationFilePath(project, configFilePath);
        this.reloadConfiguration(project);
        if (isConfigEditorVisible) {
            this.ensureConfigurationEditor(project);
        }
    }

    public void setup(IProject project, String configFilePath, String serverOpts) {
        this.setPersistentProperty((IResource)project, SERVER_OPTIONS, serverOpts);
        this.setup(project, configFilePath);
    }

    public void setup(IFile configFile) {
        this.setup(configFile.getProject(), configFile.getProjectRelativePath().toString());
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return PlatformUI.getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getActiveWorkbenchShell() {
        IWorkbenchWindow window = TcPlugin.getActiveWorkbenchWindow();
        if (window != null) {
            return window.getShell();
        }
        return null;
    }

    public static IWorkbenchPage getActivePage() {
        IWorkbenchWindow w = TcPlugin.getActiveWorkbenchWindow();
        if (w != null) {
            return w.getActivePage();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTerracottaNature(IJavaProject currentProject) {
        Shell shell = TcPlugin.getActiveWorkbenchShell();
        try {
            ProjectWizard wizard = new ProjectWizard(currentProject);
            WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
            wizard.setWindowTitle("Terracotta Project Wizard");
            dialog.open();
        }
        catch (Exception e) {
            MessageDialog.openInformation((Shell)shell, (String)"Terracotta", (String)("Cannot add Terracotta nature:\n" + ActionUtil.getStatusMessages(e)));
        }
        finally {
            if (shell != null) {
                shell.setCursor(null);
            }
        }
    }

    public void removeTerracottaNature(IJavaProject javaProject) {
        Shell shell = TcPlugin.getActiveWorkbenchShell();
        try {
            TCNatureRemover op = new TCNatureRemover(javaProject);
            new ProgressMonitorDialog(shell).run(true, false, (IRunnableWithProgress)op);
        }
        catch (InvocationTargetException e) {
            this.openError("Cannot remove Terracotta nature", e.getCause());
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public ILaunch launchServer(IJavaProject javaProject, String projectName, String serverName, Server server, IProgressMonitor monitor) throws CoreException {
        IProject project = javaProject.getProject();
        if (!this.validateConfigurationFile(project)) {
            return null;
        }
        ILaunchManager manager = DebugPlugin.getDefault().getLaunchManager();
        String id = ID_JAVA_APPLICATION;
        ILaunchConfigurationType type = manager.getLaunchConfigurationType(id);
        String installPath = this.getLocation().makeAbsolute().toOSString();
        ILaunchConfigurationWorkingCopy wc = type.newInstance(null, projectName + "." + serverName);
        wc.setAttribute(ATTR_PROJECT_NAME, project.getName());
        wc.setAttribute(ATTR_MAIN_TYPE_NAME, ServerConstants.SERVER_MAIN_CLASS_NAME);
        wc.setAttribute(SERVER_NAME_LAUNCH_ATTR, server.getName());
        wc.setAttribute(SERVER_HOST_LAUNCH_ATTR, server.getHost());
        BindPort dsoBindPort = server.getDsoPort();
        int dsoPort = dsoBindPort != null ? dsoBindPort.getIntValue() : 9510;
        wc.setAttribute(SERVER_DSO_PORT_LAUNCH_ATTR, dsoPort);
        BindPort jmxBindPort = server.getJmxPort();
        int jmxPort = jmxBindPort != null ? jmxBindPort.getIntValue() : dsoPort + 10;
        wc.setAttribute(SERVER_JMX_PORT_LAUNCH_ATTR, jmxPort);
        IFile configFile = this.getConfigurationFile(project);
        if (configFile != null) {
            String configPath = configFile.getLocation().toOSString();
            String vmargs = " -Dtc.install-root=\"" + installPath + "\"" + " -Dtc.config=\"" + configPath + "\"" + " -Dtc.server.name=\"" + serverName + "\"" + " -Dcom.sun.management.jmxremote" + " -Dcom.sun.management.jmxremote.authenticate=false";
            String origVMArgs = wc.getAttribute(ATTR_VM_ARGUMENTS, "") + " " + this.getServerOptions(project) + " ";
            wc.setAttribute(ATTR_VM_ARGUMENTS, vmargs + origVMArgs);
            wc.setAttribute(ATTR_CLASSPATH_PROVIDER, "org.terracotta.dso.classpathProvider");
            wc.setAttribute(ATTR_WORKING_DIRECTORY, project.getLocation().makeAbsolute().toOSString());
            return wc.launch("run", monitor);
        }
        System.out.println("No config file specified.  Set in project properties");
        return null;
    }

    public Server getServerByName(IProject project, String name) {
        Servers servers;
        TcConfigDocument.TcConfig config = this.getConfiguration(project);
        if (config != null && (servers = config.getServers()) != null) {
            for (Server server : servers.getServerArray()) {
                String serverName = ParameterSubstituter.substitute((String)server.getName());
                if (serverName == null || !serverName.equals(name)) continue;
                return server;
            }
        }
        return null;
    }

    private Server createLaunchServer(ILaunch launch) {
        ILaunchConfiguration launchConfig = launch.getLaunchConfiguration();
        String name = "";
        String host = "";
        int jmxPort = 0;
        int dsoPort = 0;
        try {
            name = launchConfig.getAttribute(SERVER_NAME_LAUNCH_ATTR, "");
            host = launchConfig.getAttribute(SERVER_HOST_LAUNCH_ATTR, "");
            jmxPort = launchConfig.getAttribute(SERVER_JMX_PORT_LAUNCH_ATTR, 9520);
            dsoPort = launchConfig.getAttribute(SERVER_DSO_PORT_LAUNCH_ATTR, 9510);
        }
        catch (CoreException ce) {
            // empty catch block
        }
        Server server = Server.Factory.newInstance();
        server.setName(name);
        server.setHost(host);
        if (jmxPort > 0) {
            BindPort jmxBindPort = BindPort.Factory.newInstance();
            jmxBindPort.setBind("0.0.0.0");
            jmxBindPort.setIntValue(jmxPort);
            server.addNewJmxPort();
            server.setJmxPort(jmxBindPort);
        }
        if (dsoPort > 0) {
            BindPort dsoBindPort = BindPort.Factory.newInstance();
            dsoBindPort.setBind("0.0.0.0");
            dsoBindPort.setIntValue(dsoPort);
            server.addNewDsoPort();
            server.getDsoPort().setIntValue(dsoPort);
        }
        return server;
    }

    public boolean areEquivalentServers(Server server1, Server server2) {
        return server1 != null && server2 != null && StringUtils.equals((String)server1.getName(), (String)server2.getName()) && StringUtils.equals((String)server1.getHost(), (String)server2.getHost()) && server1.getJmxPort() == server2.getJmxPort() && server1.getDsoPort() == server2.getDsoPort();
    }

    public Server getLaunchedServer(IProject project, ILaunch launch) {
        Servers servers;
        TcConfigDocument.TcConfig config = this.getConfiguration(project);
        if (config != null && (servers = config.getServers()) != null) {
            Server launchServer = this.createLaunchServer(launch);
            for (Server server : servers.getServerArray()) {
                Server serverCopy = (Server)server.copy();
                this.replacePatterns(serverCopy);
                if (!this.areEquivalentServers(launchServer, serverCopy)) continue;
                return server;
            }
        }
        return null;
    }

    public void replacePatterns(Server server) {
        if (server != null) {
            if (server.isSetName()) {
                server.setName(ParameterSubstituter.substitute((String)server.getName()));
            }
            if (server.isSetHost()) {
                server.setHost(ParameterSubstituter.substitute((String)server.getHost()));
            }
            if (server.isSetBind()) {
                server.setBind(ParameterSubstituter.substitute((String)server.getBind()));
            }
        }
    }

    public Server getAnyServer(IProject project) {
        Server[] serverArray;
        Servers servers;
        TcConfigDocument.TcConfig config = this.getConfiguration(project);
        if (config != null && (servers = config.getServers()) != null && (serverArray = servers.getServerArray()).length > 0) {
            Server server = (Server)serverArray[0].copy();
            this.replacePatterns(server);
            return server;
        }
        return DEFAULT_SERVER_INSTANCE;
    }

    public static String getServerName(Server server) {
        String name;
        if (server == null) {
            return null;
        }
        if (server.isSetName()) {
            name = server.getName();
        } else {
            int dsoPort = server.isSetDsoPort() ? server.getDsoPort().getIntValue() : 9510;
            name = server.getHost() + ":" + dsoPort;
        }
        return name;
    }

    private void loadConfiguration(IProject project) throws Exception, ConcurrentModificationException {
        if (!project.isOpen()) {
            return;
        }
        IFile configFile = this.getConfigurationFile(project);
        if (configFile != null) {
            IPath path = configFile.getLocation();
            File file = path.toFile();
            ArrayList errors = new ArrayList();
            if (!configFile.isSynchronized(0)) {
                this.ignoreNextConfigChange();
                configFile.refreshLocal(0, null);
            }
            LineLengths lineLengths = new LineLengths(configFile);
            this.setSessionProperty((IResource)project, CONFIGURATION_LINE_LENGTHS, lineLengths);
            this.clearSAXMarkers((IResource)configFile);
            TcConfigDocument doc = this.m_configLoader.parse(file, this.m_xmlOptions);
            TcConfigDocument.TcConfig config = doc.getTcConfig();
            this.setSessionProperty((IResource)project, CONFIGURATION, config);
            this.m_xmlOptions.setErrorListener(errors);
            if (!doc.validate(this.m_xmlOptions)) {
                this.handleXmlErrors(configFile, lineLengths, errors.iterator());
            }
            this.m_xmlOptions.setErrorListener(null);
            this.clearModulesConfiguration(project);
            Client client = config.getClients();
            if (client != null && client.isSetModules() && client.getModules().sizeOfModuleArray() > 0) {
                ModulesConfiguration modulesConfig = this.createModulesConfiguration(project);
                this.initModules(client.getModules(), modulesConfig);
            }
            this.setBootClassHelper(project, new BootClassHelper(JavaCore.create((IProject)project)));
        }
    }

    private void clearModulesConfiguration(IProject project) {
        this.setSessionProperty((IResource)project, MODULES_CONFIGURATION, null);
    }

    private ModulesConfiguration createModulesConfiguration(IProject project) {
        ModulesConfiguration modulesConfig = new ModulesConfiguration();
        this.setSessionProperty((IResource)project, MODULES_CONFIGURATION, modulesConfig);
        return modulesConfig;
    }

    public ModulesConfiguration getModulesConfiguration(IProject project) {
        return (ModulesConfiguration)this.getSessionProperty((IResource)project, MODULES_CONFIGURATION);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initModules(Modules modules, final ModulesConfiguration modulesConfig) {
        EmbeddedOSGiRuntime osgiRuntime = null;
        try {
            Module[] origModules;
            Modules modulesCopy = (Modules)modules.copy();
            for (Module origModule : origModules = modulesCopy.getModuleArray()) {
                Modules tmpModules = (Modules)modulesCopy.copy();
                tmpModules.setModuleArray(new Module[]{origModule});
                osgiRuntime = EmbeddedOSGiRuntime.Factory.createOSGiRuntime((Modules)tmpModules);
                String[] repositories = ResolverUtils.urlsToStrings((URL[])osgiRuntime.getRepositories());
                Resolver resolver = new Resolver(repositories, ProductInfo.getInstance().version(), ProductInfo.getInstance().timApiVersion());
                Module[] allModules = tmpModules.getModuleArray();
                ModuleInfo origModuleInfo = modulesConfig.getOrAdd(origModule);
                resolver.resolve(new Module[0]);
                for (Module module : allModules) {
                    ModuleInfo moduleInfo = modulesConfig.getOrAdd(module);
                    try {
                        moduleInfo.setLocation(resolver.resolve(module));
                        for (URL location : resolver.getResolvedURLs()) {
                            osgiRuntime.installBundle(location);
                        }
                    }
                    catch (BundleException be) {
                        moduleInfo.setError(be);
                        origModuleInfo.setError(be);
                    }
                }
                osgiRuntime.shutdown();
            }
            osgiRuntime = EmbeddedOSGiRuntime.Factory.createOSGiRuntime((Modules)modulesCopy);
            Resolver resolver = new Resolver(ResolverUtils.urlsToStrings((URL[])osgiRuntime.getRepositories()), ProductInfo.getInstance().version(), ProductInfo.getInstance().timApiVersion());
            Module[] allModules = modulesCopy.getModuleArray();
            resolver.resolve(allModules);
            FakeDSOClientConfigHelper configHelper = new FakeDSOClientConfigHelper();
            HashMap<Bundle, URL> bundleURLs = new HashMap<Bundle, URL>();
            for (URL location : resolver.getResolvedURLs()) {
                try {
                    Bundle b = osgiRuntime.installBundle(location);
                    bundleURLs.put(b, location);
                }
                catch (BundleException be) {
                    be.printStackTrace();
                }
            }
            configHelper.recordBundleURLs(bundleURLs);
            osgiRuntime.registerService("com.tc.object.config.StandardDSOClientConfigHelper", (Object)configHelper, new Hashtable());
            osgiRuntime.registerService(TCLogger.class.getName(), (Object)TCLogging.getLogger(TerracottaConfiguratorModule.class), new Hashtable());
            osgiRuntime.registerService(TCProperties.class.getName(), (Object)TCPropertiesImpl.getProperties(), new Hashtable());
            osgiRuntime.startBundles(resolver.getResolvedURLs(), new EmbeddedOSGiEventHandler(){

                public void callback(Object payload) throws BundleException {
                    Assert.assertTrue((boolean)(payload instanceof Bundle));
                    Bundle bundle = (Bundle)payload;
                    if (bundle != null) {
                        TcPlugin.this.loadModuleConfiguration(bundle, modulesConfig);
                    }
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (osgiRuntime != null) {
                osgiRuntime.shutdown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadModuleConfiguration(Bundle bundle, ModulesConfiguration modulesConfig) throws BundleException {
        String[] paths;
        ModuleInfo moduleInfo = modulesConfig.associateBundle(bundle);
        if (moduleInfo == null) {
            return;
        }
        for (String configPath : paths = ModulesLoader.getConfigPath((Bundle)bundle)) {
            InputStream is = null;
            try {
                is = JarResourceLoader.getJarResource((URL)new URL(bundle.getLocation()), (String)configPath);
            }
            catch (MalformedURLException murle) {
                moduleInfo.setError(new BundleException("Unable to create URL from: " + bundle.getLocation(), (Throwable)murle));
            }
            catch (IOException ioe) {
                moduleInfo.setError(new BundleException("Unable to extract " + configPath + " from URL: " + bundle.getLocation(), (Throwable)ioe));
            }
            if (is == null) continue;
            try {
                DsoApplication application = DsoApplication.Factory.parse((InputStream)is);
                if (application == null) continue;
                ArrayList errors = new ArrayList();
                XmlOptions opts = new XmlOptions();
                opts.setErrorListener(errors);
                if (!application.validate(opts)) {
                    StringBuffer sb = new StringBuffer("Bundle XML fragment invalid");
                    if (errors.size() > 0) {
                        sb.append(": ");
                        Object error = errors.get(0);
                        if (error instanceof XmlError) {
                            sb.append(((XmlError)error).getMessage());
                        } else {
                            sb.append(error.toString());
                        }
                        if (errors.size() > 1) {
                            int remainingErrors = errors.size() - 1;
                            sb.append(MessageFormat.format(", ({0} more)", remainingErrors));
                        }
                    }
                    moduleInfo.setError(new BundleException(sb.toString()));
                }
                modulesConfig.setModuleApplication(moduleInfo, application);
            }
            catch (Exception e) {
                moduleInfo.setError(new BundleException("Failed to parse bundle XML fragment", (Throwable)e));
            }
            finally {
                IOUtils.closeQuietly((InputStream)is);
            }
        }
    }

    public BootClassHelper getBootClassHelper(IProject project) {
        BootClassHelper bch = (BootClassHelper)this.getSessionProperty((IResource)project, BOOT_CLASS_HELPER);
        if (bch == null) {
            bch = new BootClassHelper(JavaCore.create((IProject)project));
            this.setBootClassHelper(project, bch);
        }
        return bch;
    }

    public void setBootClassHelper(IProject project, BootClassHelper helper) {
        this.setSessionProperty((IResource)project, BOOT_CLASS_HELPER, helper);
    }

    private void loadConfiguration(IProject project, String xmlText) throws Exception, ConcurrentModificationException, IOException {
        IFile configFile = this.getConfigurationFile(project);
        if (configFile != null) {
            ArrayList errors = new ArrayList();
            LineLengths lineLengths = new LineLengths(new StringReader(xmlText));
            this.setSessionProperty((IResource)project, CONFIGURATION_LINE_LENGTHS, lineLengths);
            this.clearSAXMarkers((IResource)configFile);
            TcConfigDocument doc = this.m_configLoader.parse(xmlText, this.m_xmlOptions);
            TcConfigDocument.TcConfig config = doc.getTcConfig();
            this.setSessionProperty((IResource)project, CONFIGURATION, config);
            this.m_xmlOptions.setErrorListener(errors);
            if (!doc.validate(this.m_xmlOptions)) {
                this.handleXmlErrors(configFile, lineLengths, errors.iterator());
            }
            this.m_xmlOptions.setErrorListener(null);
            this.clearModulesConfiguration(project);
            Client client = config.getClients();
            if (client != null && client.isSetModules() && client.getModules().sizeOfModuleArray() > 0) {
                ModulesConfiguration modulesConfig = this.createModulesConfiguration(project);
                this.initModules(client.getModules(), modulesConfig);
            }
            this.setBootClassHelper(project, new BootClassHelper(JavaCore.create((IProject)project)));
        }
    }

    public void fileMoved(IFile file, IPath movedFromPath) {
        IProject project = file.getProject();
        IPath path = file.getProjectRelativePath();
        String extension = path.getFileExtension();
        IPath fromPath = movedFromPath.removeFirstSegments(1);
        if (extension.equals("xml")) {
            String configPath = this.getConfigurationFilePath(project);
            if (fromPath.toString().equals(configPath)) {
                this.setConfigurationFilePath(project, path.toString());
            }
        }
    }

    public void replaceConfigText(IProject project, String oldText, String newText) {
        IDocument doc;
        ConfigurationEditor editor = this.getConfigurationEditor(project);
        if (editor != null) {
            doc = editor.getDocument();
        } else {
            try {
                IFile configFile = this.getConfigurationFile(project);
                String content = IOUtils.toString((InputStream)configFile.getContents());
                doc = new Document(content);
            }
            catch (Exception e) {
                this.openError("Problem handling refactor", e);
                return;
            }
        }
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
        int offset = 0;
        try {
            IRegion region;
            while ((region = finder.find(offset, "\\Q" + oldText + "\\E", true, true, true, false)) != null) {
                region = finder.replace(newText, false);
                offset = region.getOffset() + region.getLength();
            }
            IFile configFile = this.getConfigurationFile(project);
            ByteArrayInputStream stream = new ByteArrayInputStream(doc.get().getBytes());
            configFile.setContents((InputStream)stream, true, true, null);
            JavaSetupParticipant.inspectAll();
        }
        catch (Exception e) {
            this.openError("Problem handling refactor", e);
            return;
        }
    }

    public void staleProjectAdded(IProject project) {
        try {
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length - 1];
            for (int i = 0; i < natures.length; ++i) {
                if (natures[i].equals(ProjectNature.NATURE_ID)) continue;
                newNatures[i] = natures[i];
            }
            description.setNatureIds(newNatures);
            project.setDescription(description, null);
            this.updateDecorator("org.terracotta.dso.projectDecorator");
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void fileRemoved(IFile file) {
        IProject project;
        IFile configFile;
        IPath path = file.getProjectRelativePath();
        String extension = path.getFileExtension();
        if (extension.equals("java")) {
            this.getConfigurationHelper(file.getProject()).validateAll();
        } else if (extension.equals("xml") && file.equals(configFile = this.getConfigurationFile(project = file.getProject()))) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    TcPlugin.this.removeTerracottaNature(JavaCore.create((IProject)project));
                }
            });
        }
    }

    public void setConfigurationFromString(IProject project, String xmlText) throws Exception {
        TcConfigDocument.TcConfig config = null;
        try {
            this.loadConfiguration(project, xmlText);
        }
        catch (XmlException xmle) {
            LineLengths lineLengths = this.getConfigurationLineLengths(project);
            this.handleXmlException(this.getConfigurationFile(project), lineLengths, xmle);
        }
        catch (Exception e) {
            this.openError("Loading configuration", e);
        }
        config = (TcConfigDocument.TcConfig)this.getSessionProperty((IResource)project, CONFIGURATION);
        if (config == null) {
            config = BAD_CONFIG;
            this.setSessionProperty((IResource)project, CONFIGURATION, config);
        } else {
            this.getConfigurationHelper(project).validateAll();
        }
        this.fireConfigurationChange(project);
    }

    public LineLengths getConfigurationLineLengths(IProject project) {
        return (LineLengths)this.getSessionProperty((IResource)project, CONFIGURATION_LINE_LENGTHS);
    }

    public ConfigurationHelper getConfigurationHelper(IProject project) {
        ConfigurationHelper helper = (ConfigurationHelper)this.getSessionProperty((IResource)project, CONFIGURATION_HELPER);
        if (helper == null) {
            helper = new ConfigurationHelper(project);
            this.setSessionProperty((IResource)project, CONFIGURATION_HELPER, helper);
        }
        return helper;
    }

    public static TcConfigDocument createTemplateConfigDoc() {
        TcConfigDocument doc = TcConfigDocument.Factory.newInstance();
        TcConfigDocument.TcConfig config = doc.addNewTcConfig();
        Servers servers = config.addNewServers();
        Server server = servers.addNewServer();
        server.setHost("%i");
        server.setName("localhost");
        BindPort dsoPort = BindPort.Factory.newInstance();
        dsoPort.setBind("0.0.0.0");
        dsoPort.setIntValue(9510);
        server.addNewDsoPort();
        server.setDsoPort(dsoPort);
        BindPort jmxPort = BindPort.Factory.newInstance();
        jmxPort.setBind("0.0.0.0");
        jmxPort.setIntValue(9520);
        server.addNewJmxPort();
        server.setJmxPort(jmxPort);
        server.setData("terracotta/server-data");
        server.setLogs("terracotta/server-logs");
        server.setStatistics("terracotta/cluster-statistics");
        Client clients = config.addNewClients();
        clients.setLogs("terracotta/client-logs");
        return doc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TcConfigDocument.TcConfig getConfiguration(IProject project) {
        if (project == null) {
            return null;
        }
        boolean fireChanged = false;
        TcConfigDocument.TcConfig config = null;
        IProject iProject = project;
        synchronized (iProject) {
            config = (TcConfigDocument.TcConfig)this.getSessionProperty((IResource)project, CONFIGURATION);
            if (config == null) {
                try {
                    this.loadConfiguration(project);
                    fireChanged = true;
                }
                catch (XmlException e) {
                    LineLengths lineLengths = this.getConfigurationLineLengths(project);
                    this.handleXmlException(this.getConfigurationFile(project), lineLengths, e);
                }
                catch (Exception e) {
                    this.openError("Loading configuration", e);
                }
                catch (NoClassDefFoundError noClassDef) {
                    this.openError("Loading configuration", noClassDef);
                }
                config = (TcConfigDocument.TcConfig)this.getSessionProperty((IResource)project, CONFIGURATION);
                if (config == null) {
                    config = BAD_CONFIG;
                    this.setSessionProperty((IResource)project, CONFIGURATION, config);
                    fireChanged = true;
                }
            }
        }
        if (fireChanged) {
            if (config != BAD_CONFIG) {
                this.getConfigurationHelper(project).validateAll();
            }
            this.fireConfigurationChange(project);
        }
        return config;
    }

    public void handleXmlException(IFile configFile, LineLengths lineLengths, XmlException e) {
        if (configFile != null) {
            this.handleXmlErrors(configFile, lineLengths, e.getErrors().iterator());
        }
    }

    public void handleXmlErrors(IFile configFile, LineLengths lineLengths, Iterator errors) {
        try {
            while (errors.hasNext()) {
                XmlError error = (XmlError)errors.next();
                HashMap<String, Object> map = new HashMap<String, Object>();
                int line = error.getLine();
                int col = error.getColumn();
                String msg = error.getMessage();
                int severity = this.XmlError2IMarkerSeverity(error.getSeverity());
                int start = lineLengths.offset(line - 1);
                int end = start + (col == -1 ? lineLengths.lineSize(line - 1) : col);
                MarkerUtilities.setMessage(map, (String)msg);
                MarkerUtilities.setLineNumber(map, (int)line);
                MarkerUtilities.setCharStart(map, (int)start);
                MarkerUtilities.setCharEnd(map, (int)end);
                map.put("priority", 2);
                map.put("severity", severity);
                map.put("location", "line " + line);
                MarkerUtilities.createMarker((IResource)configFile, map, (String)"org.terracotta.dso.SAXMarker");
            }
        }
        catch (CoreException ce) {
            this.openError("Error handling XML error", ce);
        }
    }

    private int XmlError2IMarkerSeverity(int severity) {
        switch (severity) {
            case 0: {
                return 2;
            }
            case 2: {
                return 0;
            }
            case 1: {
                return 1;
            }
        }
        return 0;
    }

    ConfigurationEditor[] getConfigurationEditors(IProject project) {
        IWorkbenchWindow[] windows;
        ArrayList<ConfigurationEditor> list = new ArrayList<ConfigurationEditor>();
        for (IWorkbenchWindow window : windows = PlatformUI.getWorkbench().getWorkbenchWindows()) {
            IWorkbenchPage[] pages;
            for (IWorkbenchPage page : pages = window.getPages()) {
                IEditorReference[] editorRefs;
                for (IEditorReference editorRef : editorRefs = page.getEditorReferences()) {
                    IEditorPart editorPart = editorRef.getEditor(false);
                    if (editorPart == null || !(editorPart instanceof ConfigurationEditor)) continue;
                    ConfigurationEditor configEditor = (ConfigurationEditor)editorPart;
                    IFile file = ((IFileEditorInput)editorPart.getEditorInput()).getFile();
                    if (!file.getProject().equals(project)) continue;
                    list.add(configEditor);
                }
            }
        }
        return list.toArray(new ConfigurationEditor[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reloadConfiguration(IProject project) {
        ConfigurationEditor[] configEditors;
        if (project == null) {
            return;
        }
        IProject iProject = project;
        synchronized (iProject) {
            this.clearConfigurationSessionProperties(project);
            this.getConfiguration(project);
        }
        for (ConfigurationEditor configEditor : configEditors = this.getConfigurationEditors(project)) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)configEditor.getEditorInput();
            IFile file = fileEditorInput.getFile();
            configEditor.newInputFile(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearConfigurationSessionProperties(IProject project) {
        if (project == null) {
            return;
        }
        IProject iProject = project;
        synchronized (iProject) {
            IFile file = this.getConfigurationFile(project);
            if (file != null && file.exists()) {
                this.setSessionProperty((IResource)file, ACTIVE_CONFIGURATION_FILE, null);
            }
            this.setSessionProperty((IResource)project, CONFIGURATION_LINE_LENGTHS, null);
            this.setSessionProperty((IResource)project, CONFIGURATION_FILE, null);
            this.setSessionProperty((IResource)project, CONFIGURATION, null);
            this.setConfigurationFileDirty(project, Boolean.FALSE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConfigurationFileDirty(IProject project, Boolean dirty) {
        if (project == null) {
            return;
        }
        IProject iProject = project;
        synchronized (iProject) {
            this.setSessionProperty((IResource)project, IS_DIRTY, dirty);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConfigurationFileDirty(IProject project) {
        if (project == null) {
            throw new IllegalArgumentException("Project is null");
        }
        IProject iProject = project;
        synchronized (iProject) {
            if (project.isOpen()) {
                Boolean dirty = (Boolean)this.getSessionProperty((IResource)project, IS_DIRTY);
                boolean bl = dirty != null ? dirty : false;
                return bl;
            }
            return false;
        }
    }

    public void ignoreNextConfigChange() {
        ResourceDeltaVisitor rdv = this.getResourceDeltaVisitor();
        rdv.fIgnoreNextConfigChange = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveConfiguration(IProject project) {
        IFile configFile = this.getConfigurationFile(project);
        if (configFile == null) return;
        InputStream stream = null;
        try {
            TcConfigDocument.TcConfig config = this.getConfiguration(project);
            if (config != null) {
                this.ignoreNextConfigChange();
                TcConfigDocument configDoc = TcConfigDocument.Factory.newInstance();
                configDoc.setTcConfig(config);
                stream = configDoc.newInputStream(this.getXmlOptions());
                configFile.setContents(stream, true, true, null);
                stream = null;
                this.getConfigurationHelper(project).validateAll();
                this.fireConfigurationChange(project);
            }
            if (stream == null) return;
        }
        catch (Exception e) {
            try {
                this.openError("Error saving '" + configFile.getName() + "'", e);
                if (stream == null) return;
            }
            catch (Throwable throwable) {
                if (stream == null) throw throwable;
                IOUtils.closeQuietly(stream);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)stream);
            return;
        }
        IOUtils.closeQuietly(stream);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveConfigurationQuietly(IProject project) {
        FileWriter outWriter;
        InputStream inStream;
        block4: {
            XmlOptions opts = this.getXmlOptions();
            IFile configFile = this.getConfigurationFile(project);
            TcConfigDocument.TcConfig config = this.getConfiguration(project);
            TcConfigDocument configDoc = TcConfigDocument.Factory.newInstance();
            inStream = null;
            outWriter = null;
            try {
                if (config == null) break block4;
                configDoc.setTcConfig(config);
                inStream = configDoc.newInputStream(opts);
                outWriter = new FileWriter(configFile.getLocation().toOSString());
                CopyUtils.copy((InputStream)inStream, (Writer)outWriter);
            }
            catch (Exception e) {
                try {
                    this.openError("Error saving '" + configFile.getName() + "'", e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(inStream);
                    IOUtils.closeQuietly(outWriter);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)inStream);
                IOUtils.closeQuietly((Writer)outWriter);
            }
        }
        IOUtils.closeQuietly(inStream);
        IOUtils.closeQuietly(outWriter);
    }

    public void setSessionProperty(IResource res, QualifiedName name, Object value) {
        if (res != null && res.exists()) {
            try {
                res.setSessionProperty(name, value);
            }
            catch (CoreException ce) {
                // empty catch block
            }
        }
    }

    public Object getSessionProperty(IResource res, QualifiedName name) {
        if (res != null && res.exists()) {
            try {
                return res.getSessionProperty(name);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        return null;
    }

    public void setPersistentProperty(IResource resource, QualifiedName name, String value) {
        if (resource != null && resource.exists()) {
            try {
                resource.setPersistentProperty(name, value);
            }
            catch (CoreException ce) {
                // empty catch block
            }
        }
    }

    public String getPersistentProperty(IResource resource, QualifiedName name) {
        if (resource != null && resource.exists()) {
            try {
                return resource.getPersistentProperty(name);
            }
            catch (CoreException ce) {
                return null;
            }
        }
        return null;
    }

    public ConfigurationEditor getConfigurationEditor(IProject project) {
        ConfigurationEditor[] configEditors = this.getConfigurationEditors(project);
        IFile configFile = this.getConfigurationFile(project);
        for (ConfigurationEditor configEditor : configEditors) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)configEditor.getEditorInput();
            IFile file = fileEditorInput.getFile();
            if (!file.equals(configFile)) continue;
            return configEditor;
        }
        return null;
    }

    public ConfigurationEditor ensureConfigurationEditor(IProject project) {
        ConfigurationEditor editor = this.getConfigurationEditor(project);
        if (editor == null) {
            try {
                editor = this.openConfigurationEditor(project);
            }
            catch (PartInitException pie) {
                this.openError("Unable to open configuration editor", pie);
            }
        }
        return editor;
    }

    public void setConfigurationFilePath(IProject project, String path) {
        IFile file;
        String oldPath = this.getConfigurationFilePath(project);
        IFile iFile = file = oldPath != null ? project.getFile(oldPath) : null;
        if (file != null && file.exists()) {
            this.clearSAXMarkers((IResource)file);
            this.setSessionProperty((IResource)file, ACTIVE_CONFIGURATION_FILE, null);
        }
        this.setPersistentProperty((IResource)project, CONFIGURATION_FILE_PATH, path);
        file = project.getFile((IPath)new Path(path));
        this.setSessionProperty((IResource)project, CONFIGURATION_FILE, file);
        this.setSessionProperty((IResource)file, ACTIVE_CONFIGURATION_FILE, "true");
    }

    public String getConfigurationFilePath(IProject project) {
        return this.getPersistentProperty((IResource)project, CONFIGURATION_FILE_PATH);
    }

    public IFile getConfigurationFile(IProject project) {
        String path;
        IFile file = (IFile)this.getSessionProperty((IResource)project, CONFIGURATION_FILE);
        if (file == null && (path = this.getConfigurationFilePath(project)) != null) {
            file = project.getFile((IPath)new Path(path));
            this.setSessionProperty((IResource)project, CONFIGURATION_FILE, file);
            this.setSessionProperty((IResource)file, ACTIVE_CONFIGURATION_FILE, "true");
        }
        return file;
    }

    public boolean validateConfigurationFile(final IProject project) {
        final AtomicBoolean result = new AtomicBoolean(true);
        IFile configFile = this.getConfigurationFile(project);
        if (configFile == null) {
            this.setConfigurationFilePath(project, DEFAULT_CONFIG_FILENAME);
            configFile = this.getConfigurationFile(project);
        }
        if (!configFile.exists()) {
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    try {
                        if (!project.isSynchronized(2)) {
                            project.refreshLocal(2, null);
                        }
                    }
                    catch (CoreException ce) {
                        // empty catch block
                    }
                    Shell shell = TcPlugin.getActiveWorkbenchShell();
                    String pageId = "org.terracotta.dso.ui.propertyPages.PropertyPage";
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    PreferenceDialog prefDialog = PreferencesUtil.createPropertyDialogOn((Shell)shell, (IAdaptable)javaProject, (String)pageId, null, null);
                    result.set(prefDialog.open() == 0);
                }
            });
        }
        String markerType = "org.terracotta.dso.ConfigFileNotFoundMarker";
        if (result.get()) {
            try {
                project.deleteMarkers("org.terracotta.dso.ConfigFileNotFoundMarker", false, 0);
            }
            catch (CoreException ce) {}
        } else {
            final HashMap<String, Object> map = new HashMap<String, Object>();
            MarkerUtilities.setMessage(map, (String)"Config file not found");
            map.put("priority", 2);
            map.put("severity", 2);
            map.put("location", configFile.getFullPath().toString());
            Display display = Display.getDefault();
            display.syncExec(new Runnable(){

                public void run() {
                    try {
                        MarkerUtilities.createMarker((IResource)project, (Map)map, (String)"org.terracotta.dso.ConfigFileNotFoundMarker");
                    }
                    catch (CoreException ce) {
                        TcPlugin.this.openError("Problem creating marker 'org.terracotta.dso.ConfigFileNotFoundMarker'", ce);
                    }
                }
            });
        }
        return result.get();
    }

    public void setServerOptions(IProject project, String opts) {
        this.setPersistentProperty((IResource)project, SERVER_OPTIONS, opts);
    }

    public String getServerOptions(IProject project) {
        String options = this.getPersistentProperty((IResource)project, SERVER_OPTIONS);
        return options != null ? options : "";
    }

    public void setAutoStartServerOption(IProject project, boolean autoStartServer) {
        this.setPersistentProperty((IResource)project, AUTO_START_SERVER_OPTION, Boolean.toString(autoStartServer));
    }

    public boolean getAutoStartServerOption(IProject project) {
        String option = this.getPersistentProperty((IResource)project, AUTO_START_SERVER_OPTION);
        return option != null ? Boolean.parseBoolean(option) : false;
    }

    public void setWarnConfigProblemsOption(IProject project, boolean warnConfigProblems) {
        this.setPersistentProperty((IResource)project, WARN_CONFIG_PROBLEMS_OPTION, Boolean.toString(warnConfigProblems));
    }

    public boolean getWarnConfigProblemsOption(IProject project) {
        String option = this.getPersistentProperty((IResource)project, WARN_CONFIG_PROBLEMS_OPTION);
        return option != null ? Boolean.parseBoolean(option) : true;
    }

    public void setQueryRestartOption(IProject project, boolean queryRestart) {
        this.setPersistentProperty((IResource)project, QUERY_RESTART_OPTION, Boolean.toString(queryRestart));
    }

    public boolean getQueryRestartOption(IProject project) {
        String option = this.getPersistentProperty((IResource)project, QUERY_RESTART_OPTION);
        return option != null ? Boolean.parseBoolean(option) : true;
    }

    public boolean hasTerracottaNature(IJavaElement element) {
        return this.hasTerracottaNature(element.getJavaProject().getProject());
    }

    public boolean hasTerracottaNature(IProject project) {
        try {
            return project != null && project.hasNature(ProjectNature.NATURE_ID);
        }
        catch (CoreException coreException) {
            return false;
        }
    }

    public void inspect(ICompilationUnit cu) {
        if (cu != null) {
            this.getCompilationUnitVisitor().inspect(cu);
        }
    }

    private CompilationUnitVisitor getCompilationUnitVisitor() {
        if (this.m_compilationUnitVisitor == null) {
            this.m_compilationUnitVisitor = new CompilationUnitVisitor();
        }
        return this.m_compilationUnitVisitor;
    }

    private ResourceDeltaVisitor getResourceDeltaVisitor() {
        if (this.m_resourceDeltaVisitor == null) {
            this.m_resourceDeltaVisitor = new ResourceDeltaVisitor();
        }
        return this.m_resourceDeltaVisitor;
    }

    public void updateDecorator(String id) {
        this.updateDecorators(new String[]{id});
    }

    private DecoratorUpdateAction getDecoratorUpdateAction() {
        if (this.m_decoratorUpdateAction == null) {
            this.m_decoratorUpdateAction = new DecoratorUpdateAction();
        }
        return this.m_decoratorUpdateAction;
    }

    public void updateDecorators(String[] ids) {
        DecoratorUpdateAction updater = this.getDecoratorUpdateAction();
        updater.setDecorators(ids);
        Display.getDefault().asyncExec((Runnable)updater);
    }

    public void updateDecorators() {
        this.updateDecorators(DECORATOR_IDS);
    }

    public boolean hasSAXMarkers(IResource res) throws CoreException {
        if (res != null && res.exists()) {
            IMarker[] markers = res.findMarkers("org.terracotta.dso.SAXMarker", false, 0);
            return markers.length > 0;
        }
        return false;
    }

    public void clearSAXMarkers(IResource res) {
        if (res != null && res.exists()) {
            try {
                res.deleteMarkers("org.terracotta.dso.SAXMarker", false, 0);
            }
            catch (CoreException ce) {
                this.openError("Error clearing SAX markers on file'" + res.getName() + "'", ce);
            }
        }
    }

    public boolean hasProblemMarkers(IResource res) throws CoreException {
        if (res != null && res.exists()) {
            IMarker[] markers = res.findMarkers("org.eclipse.core.resources.problemmarker", true, 0);
            return markers.length > 0;
        }
        return false;
    }

    public void clearConfigProblemMarkers(IProject project) {
        try {
            IFile configFile = this.getConfigurationFile(project);
            if (configFile != null && configFile.exists()) {
                configFile.deleteMarkers("org.terracotta.dso.ConfigProblemMarker", true, 0);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public void clearConfigProblemMarkersOfType(IProject project, String markerType) {
        try {
            IFile configFile = this.getConfigurationFile(project);
            if (configFile != null && configFile.exists()) {
                configFile.deleteMarkers(markerType, false, 0);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)TcPlugin.getPluginId(), (String)path);
    }

    public ConfigurationEditor openConfigurationEditor(IProject project) throws PartInitException {
        IWorkbenchPage wbPage = TcPlugin.getActivePage();
        if (wbPage != null) {
            IFile configFile = this.getConfigurationFile(project);
            FileEditorInput fileEditorInput = new FileEditorInput(configFile);
            IEditorPart editorPart = wbPage.findEditor((IEditorInput)fileEditorInput);
            if (editorPart != null) {
                if (editorPart instanceof ConfigurationEditor) {
                    wbPage.activate((IWorkbenchPart)editorPart);
                    return (ConfigurationEditor)editorPart;
                }
                wbPage.closeEditor(editorPart, true);
            }
            if (configFile != null) {
                String configEditorID = "editors.configurationEditor";
                return (ConfigurationEditor)IDE.openEditor((IWorkbenchPage)wbPage, (IFile)configFile, (String)configEditorID, (boolean)false);
            }
        }
        return null;
    }

    public void closeConfigurationEditor(IProject project) {
        final ConfigurationEditor configEditor = this.getConfigurationEditor(project);
        if (configEditor != null) {
            if (Display.getCurrent() == null) {
                Display.getDefault().syncExec(new Runnable(){

                    public void run() {
                        configEditor.closeEditor();
                    }
                });
            } else {
                configEditor.closeEditor();
            }
        }
    }

    private XmlOptions createXmlOptions() {
        XmlOptions opts = new XmlOptions();
        opts.setLoadLineNumbers();
        opts.setSavePrettyPrint();
        opts.setSavePrettyPrintIndent(2);
        opts.remove((Object)"LOAD_STRIP_WHITESPACE");
        opts.remove((Object)"LOAD_STRIP_COMMENTS");
        return opts;
    }

    public XmlOptions getXmlOptions() {
        return this.m_xmlOptions;
    }

    public void openError(String msg, Throwable t) {
        ILog log = this.getLog();
        log.log((IStatus)new Status(4, TcPlugin.getPluginId(), 90001, msg, t));
    }

    public void openError(final String msg) {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                ErrorDialog.showError(msg);
            }
        });
    }

    public boolean continueWithConfigProblems(final IProject project) throws CoreException {
        IFile configFile = this.getConfigurationFile(project);
        this.setSessionProperty((IResource)project, CONFIG_PROBLEM_CONTINUE, null);
        if (this.getWarnConfigProblemsOption(project) && this.hasProblemMarkers((IResource)configFile)) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    Shell shell = Display.getDefault().getActiveShell();
                    ConfigProblemsDialog dialog = new ConfigProblemsDialog(shell, project);
                    if (dialog.open() == 0) {
                        TcPlugin.this.setSessionProperty((IResource)project, QualifiedNames.CONFIG_PROBLEM_CONTINUE, Boolean.TRUE);
                    }
                }
            });
            return this.getSessionProperty((IResource)project, CONFIG_PROBLEM_CONTINUE) == Boolean.TRUE;
        }
        return true;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public void fireConfigurationChange(IProject project) {
        this.m_configurationEventManager.fireConfigurationChange(project);
        if (this.hasTerracottaNature(project)) {
            JavaSetupParticipant.inspectAll();
        }
        this.updateDecorators();
    }

    public void fireServerChanged(IProject project, int index) {
        this.m_configurationEventManager.fireServerChanged(project, index);
    }

    public void fireServersChanged(IProject project) {
        this.m_configurationEventManager.fireServersChanged(project);
    }

    public void fireRootChanged(IProject project, int index) {
        this.m_configurationEventManager.fireRootChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.rootDecorator");
    }

    public void fireRootsChanged(IProject project) {
        this.m_configurationEventManager.fireRootsChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.rootDecorator");
    }

    public void fireNamedLockChanged(IProject project, int index) {
        this.m_configurationEventManager.fireNamedLockChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.nameLockedDecorator");
    }

    public void fireNamedLocksChanged(IProject project) {
        this.m_configurationEventManager.fireNamedLocksChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.nameLockedDecorator");
    }

    public void fireAutolockChanged(IProject project, int index) {
        this.m_configurationEventManager.fireAutolockChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.autoLockedDecorator");
    }

    public void fireAutolocksChanged(IProject project) {
        this.m_configurationEventManager.fireAutolocksChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.autoLockedDecorator");
    }

    public void fireIncludeRuleChanged(IProject project, int index) {
        this.m_configurationEventManager.fireIncludeRuleChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorators(new String[]{"org.terracotta.dso.adaptedModuleDecorator", "org.terracotta.dso.adaptedTypeDecorator", "org.terracotta.dso.adaptedPackageFragmentDecorator"});
    }

    public void fireIncludeRulesChanged(IProject project) {
        this.m_configurationEventManager.fireIncludeRulesChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorators(new String[]{"org.terracotta.dso.adaptedModuleDecorator", "org.terracotta.dso.adaptedTypeDecorator", "org.terracotta.dso.adaptedPackageFragmentDecorator"});
    }

    public void fireExcludeRuleChanged(IProject project, int index) {
        this.m_configurationEventManager.fireExcludeRuleChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorators(new String[]{"org.terracotta.dso.excludedTypeDecorator", "org.terracotta.dso.excludedModuleDecorator"});
    }

    public void fireExcludeRulesChanged(IProject project) {
        this.m_configurationEventManager.fireExcludeRulesChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorators(new String[]{"org.terracotta.dso.excludedTypeDecorator", "org.terracotta.dso.excludedModuleDecorator"});
    }

    public void fireInstrumentationRulesChanged(IProject project) {
        this.m_configurationEventManager.fireInstrumentationRulesChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorators(new String[]{"org.terracotta.dso.adaptedModuleDecorator", "org.terracotta.dso.adaptedTypeDecorator", "org.terracotta.dso.adaptedPackageFragmentDecorator", "org.terracotta.dso.excludedTypeDecorator", "org.terracotta.dso.excludedModuleDecorator"});
    }

    public void fireTransientFieldsChanged(IProject project) {
        this.m_configurationEventManager.fireTransientFieldsChanged(project);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.transientDecorator");
    }

    public void fireTransientFieldChanged(IProject project, int index) {
        this.m_configurationEventManager.fireTransientFieldChanged(project, index);
        JavaSetupParticipant.inspectAll();
        this.updateDecorator("org.terracotta.dso.transientDecorator");
    }

    public void fireBootClassesChanged(IProject project) {
        this.m_configurationEventManager.fireBootClassesChanged(project);
        JavaSetupParticipant.inspectAll();
    }

    public void fireBootClassChanged(IProject project, int index) {
        this.m_configurationEventManager.fireBootClassChanged(project, index);
        JavaSetupParticipant.inspectAll();
    }

    public void fireDistributedMethodsChanged(IProject project) {
        this.m_configurationEventManager.fireDistributedMethodsChanged(project);
        this.updateDecorator("org.terracotta.dso.distributedMethodDecorator");
        JavaSetupParticipant.inspectAll();
    }

    public void fireDistributedMethodChanged(IProject project, int index) {
        this.m_configurationEventManager.fireDistributedMethodChanged(project, index);
        this.updateDecorator("org.terracotta.dso.distributedMethodDecorator");
        JavaSetupParticipant.inspectAll();
    }

    public void fireClientChanged(IProject project) {
        this.m_configurationEventManager.fireClientChanged(project);
    }

    public void fireModuleRepoChanged(IProject project, int index) {
        this.m_configurationEventManager.fireModuleRepoChanged(project, index);
    }

    public void fireModuleReposChanged(IProject project) {
        this.m_configurationEventManager.fireModuleReposChanged(project);
    }

    public void fireModuleChanged(IProject project, int index) {
        this.m_configurationEventManager.fireModuleChanged(project, index);
    }

    public void fireModulesChanged(IProject project) {
        this.m_configurationEventManager.fireModulesChanged(project);
    }

    public void addConfigurationListener(IConfigurationListener listener) {
        this.m_configurationEventManager.addConfigurationListener(listener);
    }

    public void removeConfigurationListener(IConfigurationListener listener) {
        this.m_configurationEventManager.removeConfigurationListener(listener);
    }

    public static Image createImage(String path) {
        return new JavaElementImageDescriptor(TcPlugin.getImageDescriptor(path), 0, new Point(16, 16)).createImage(false);
    }

    public static Image createImage(URL path) {
        return new JavaElementImageDescriptor(ImageDescriptor.createFromURL((URL)path), 0, new Point(16, 16)).createImage(false);
    }

    public String configDocumentAsString(TcConfigDocument configDoc) {
        InputStream is = configDoc.newInputStream(this.getXmlOptions());
        StringWriter writer = new StringWriter();
        try {
            CopyUtils.copy((InputStream)is, (Writer)writer);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return writer.toString();
    }

    static {
        DEFAULT_SERVER_INSTANCE = TcPlugin.createDefaultServerInstance();
        BAD_CONFIG = TcPlugin.createTemplateConfigDoc().getTcConfig();
        DECORATOR_IDS = new String[]{"org.terracotta.dso.projectDecorator", "org.terracotta.dso.configFileDecorator", "org.terracotta.dso.serverRunningDecorator", "org.terracotta.dso.adaptedModuleDecorator", "org.terracotta.dso.adaptedTypeDecorator", "org.terracotta.dso.adaptedPackageFragmentDecorator", "org.terracotta.dso.excludedTypeDecorator", "org.terracotta.dso.excludedModuleDecorator", "org.terracotta.dso.distributedMethodDecorator", "org.terracotta.dso.nameLockedDecorator", "org.terracotta.dso.autoLockedDecorator", "org.terracotta.dso.rootDecorator", "org.terracotta.dso.transientDecorator"};
    }

    static class DecoratorUpdateAction
    implements Runnable {
        IDecoratorManager m_decoratorManager = PlatformUI.getWorkbench().getDecoratorManager();
        String[] m_decorators;

        DecoratorUpdateAction() {
        }

        void setDecorators(String[] ids) {
            this.m_decorators = ids;
        }

        public void run() {
            for (String decorator : this.m_decorators) {
                this.m_decoratorManager.update(decorator);
            }
        }
    }

    class ResourceListener
    implements IResourceChangeListener {
        ResourceListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            switch (event.getType()) {
                case 16: {
                    try {
                        event.getDelta().accept((IResourceDeltaVisitor)TcPlugin.this.getResourceDeltaVisitor());
                        break;
                    }
                    catch (CoreException ce) {
                        TcPlugin.this.openError("Error handling resource change event for '" + event.getResource().getName() + "'", ce);
                    }
                }
            }
        }
    }

    class TCNatureRemover
    implements IRunnableWithProgress {
        IJavaProject m_javaProject;

        TCNatureRemover(IJavaProject javaProject) {
            this.m_javaProject = javaProject;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                monitor.beginTask("Removing project nature", 4);
                IProject project = this.m_javaProject.getProject();
                IProjectDescription description = project.getDescription();
                String[] natures = description.getNatureIds();
                ArrayList<String> natureList = new ArrayList<String>();
                for (int i = 0; i < natures.length; ++i) {
                    if (natures[i].equals(ProjectNature.NATURE_ID)) continue;
                    natureList.add(natures[i]);
                }
                description.setNatureIds(natureList.toArray(new String[0]));
                project.setDescription(description, monitor);
                monitor.worked(1);
                monitor.beginTask("Closing configuration editor", 4);
                TcPlugin.this.closeConfigurationEditor(project);
                monitor.worked(2);
                monitor.beginTask("Stopping server", 4);
                final ServerTracker tracker = ServerTracker.getDefault();
                if (tracker.anyRunning(this.m_javaProject)) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            tracker.shutdownAllServers();
                        }
                    });
                }
                monitor.worked(3);
                monitor.beginTask("Removing markers", 4);
                project.deleteMarkers("org.terracotta.dso.baseMarker", true, 2);
                IFile configFile = TcPlugin.this.getConfigurationFile(this.m_javaProject.getProject());
                if (configFile != null && configFile.exists()) {
                    TcPlugin.this.clearSAXMarkers((IResource)configFile);
                }
                TcPlugin.this.clearConfigurationSessionProperties(project);
                TcPlugin.this.notifyProjectActions(project);
                TcPlugin.this.fireConfigurationChange(project);
                monitor.worked(4);
            }
            catch (CoreException e) {
                throw new InvocationTargetException(e);
            }
        }
    }
}

