/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.admin.ConnectionContext;
import com.tc.admin.ConnectionListener;
import com.tc.admin.ServerConnectionManager;
import com.tc.admin.TCStop;
import com.tc.management.beans.L2MBeanNames;
import com.tc.object.appevent.AbstractApplicationEvent;
import com.tc.object.appevent.NonPortableObjectEvent;
import com.tc.object.appevent.ReadOnlyObjectEvent;
import com.tc.object.appevent.UnlockedSharedObjectEvent;
import com.tc.util.concurrent.ThreadUtil;
import com.terracottatech.config.Server;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.window.ApplicationWindow;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.ServerInfo;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.decorator.ServerRunningDecorator;
import org.terracotta.dso.dialogs.AbstractApplicationEventDialog;
import org.terracotta.dso.dialogs.NonPortableObjectDialog;
import org.terracotta.dso.dialogs.ReadOnlyObjectDialog;
import org.terracotta.dso.dialogs.UnlockedSharedObjectDialog;

public class ServerTracker
implements IDebugEventSetListener {
    private static ServerTracker m_instance = new ServerTracker();
    private HashMap<IProcess, ServerInfo> m_servers = new HashMap();
    private static final QualifiedName SERVER_RUNNING_NAME = new QualifiedName("org.terracotta.dso", "ServerRunning");

    private ServerTracker() {
    }

    public static synchronized ServerTracker getDefault() {
        if (m_instance == null) {
            m_instance = new ServerTracker();
        }
        return m_instance;
    }

    public void handleDebugEvents(DebugEvent[] events) {
        ServerInfo serverInfo;
        Object source;
        if (events != null && events.length > 0 && events[0].getKind() == 8 && (source = events[0].getSource()) instanceof IProcess && (serverInfo = this.m_servers.get(source)) != null) {
            this.m_servers.remove(source);
            serverInfo.setStatus(2);
            this.displayStatus("Terracotta Server instance '" + serverInfo.getName() + "' terminated.");
            IJavaProject javaProj = serverInfo.getJavaProject();
            if (!this.anyRunning(javaProj)) {
                this.setRunning(javaProj, null);
            }
        }
    }

    public boolean anyRunning(IJavaProject javaProj) {
        for (IProcess proc : this.m_servers.keySet()) {
            ServerInfo serverInfo = this.m_servers.get(proc);
            IJavaProject project = serverInfo.getJavaProject();
            if (!project.equals(javaProj)) continue;
            return true;
        }
        return false;
    }

    public ServerInfo getServerInfo(IJavaProject javaProj, String name) {
        for (IProcess proc : this.m_servers.keySet()) {
            ServerInfo serverInfo = this.m_servers.get(proc);
            String serverName = serverInfo.getName();
            if (!name.equals(serverName)) continue;
            return serverInfo;
        }
        return null;
    }

    public boolean isRunning(IJavaProject javaProj, String name) {
        ServerInfo serverInfo = this.getServerInfo(javaProj, name);
        return serverInfo != null && serverInfo.isStarted();
    }

    public void setRunning(IJavaProject javaProj, Boolean value) {
        IProject project;
        if (value != null && value.equals(Boolean.FALSE)) {
            value = null;
        }
        if ((project = javaProj.getProject()).isOpen()) {
            try {
                project.setSessionProperty(SERVER_RUNNING_NAME, (Object)value);
                ServerRunningDecorator.updateDecorators();
            }
            catch (CoreException ce) {
                // empty catch block
            }
        }
    }

    public void startServer(IJavaProject javaProject, String name, Server server, IProgressMonitor monitor) throws InvocationTargetException {
        if (this.isRunning(javaProject, name)) {
            this.internalStopServer(javaProject, true, name, server, monitor);
        } else {
            try {
                this.internalStartServer(javaProject, name, server, monitor);
            }
            catch (CoreException ce) {
                throw new InvocationTargetException(ce);
            }
        }
    }

    private void internalStartServer(IJavaProject javaProject, String name, Server server, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Starting Terracotta Server instance '" + name + "' ...", -1);
        TcPlugin plugin = TcPlugin.getDefault();
        String projName = javaProject.getElementName();
        ILaunch launch = plugin.launchServer(javaProject, projName, name, server, null);
        if (launch != null) {
            ServerInfo info = new ServerInfo(javaProject, name, server);
            IProcess[] processes = launch.getProcesses();
            if (processes.length > 0) {
                this.m_servers.put(processes[0], info);
                DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
                this.waitForMBean(javaProject, name, server);
                while (!info.isTerminated() && info.isStarting()) {
                    ThreadUtil.reallySleep((long)1000L);
                }
                monitor.done();
                if (info.isTerminated()) {
                    String msg = "Terracotta Server instance '" + name + "' failed to start.";
                    Status status = new Status(4, TcPlugin.getPluginId(), msg);
                    throw new CoreException((IStatus)status);
                }
                if (info.isStarted()) {
                    this.displayStatus("Terracotta Server instance '" + name + "' started.");
                }
            }
        }
    }

    private void displayStatus(final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                if (window instanceof ApplicationWindow) {
                    ((ApplicationWindow)window).setStatus(msg);
                }
            }
        });
    }

    private void handleApplicationEvent(AbstractApplicationEvent event) {
        Shell shell = TcPlugin.getActiveWorkbenchShell();
        AbstractApplicationEventDialog dialog = null;
        if (event instanceof NonPortableObjectEvent) {
            dialog = new NonPortableObjectDialog(shell, (NonPortableObjectEvent)event);
        } else if (event instanceof UnlockedSharedObjectEvent) {
            dialog = new UnlockedSharedObjectDialog(shell, (UnlockedSharedObjectEvent)event);
        } else if (event instanceof ReadOnlyObjectEvent) {
            dialog = new ReadOnlyObjectDialog(shell, (ReadOnlyObjectEvent)event);
        }
        if (dialog != null) {
            dialog.open();
        }
    }

    private void waitForMBean(IJavaProject javaProject, String name, Server server) {
        String host;
        L2ConnectListener connectListener = new L2ConnectListener(javaProject, name);
        int jmxPort = server.getJmxPort().getIntValue();
        if (jmxPort == 0) {
            jmxPort = 9520;
        }
        if ((host = server.getHost()) == null) {
            host = "localhost";
        }
        ServerConnectionManager connectManager = new ServerConnectionManager(host, jmxPort, false, (ConnectionListener)connectListener);
        connectListener.setServerConnectionManager(connectManager);
        connectManager.setAutoConnect(true);
    }

    public void cancelServer(IJavaProject javaProject) {
        Iterator<IProcess> iter = this.m_servers.keySet().iterator();
        while (iter.hasNext()) {
            IProcess proc = iter.next();
            ServerInfo info = this.m_servers.get(proc);
            if (!info.getJavaProject().equals(javaProject)) continue;
            try {
                proc.terminate();
            }
            catch (DebugException de) {
                iter.remove();
            }
        }
    }

    public void stopServer(IJavaProject javaProject, IProgressMonitor monitor) throws InvocationTargetException {
        this.internalStopServer(javaProject, false, null, null, monitor);
    }

    public void stopServer(IJavaProject javaProject, String name, Server server, IProgressMonitor monitor) throws InvocationTargetException {
        this.internalStopServer(javaProject, false, name, server, monitor);
    }

    private void internalStopServer(IJavaProject javaProject, boolean restart, String name, Server server, IProgressMonitor monitor) throws InvocationTargetException {
        new TCStopper(javaProject, restart, name, server).run(monitor);
    }

    private void doStopServer(IJavaProject targetProj, String targetName, Server server, IProgressMonitor monitor) throws IOException, DebugException {
        for (IProcess proc : this.m_servers.keySet()) {
            String host;
            ServerInfo serverInfo = this.m_servers.get(proc);
            if (serverInfo.isTerminated()) {
                monitor.done();
                return;
            }
            IJavaProject javaProject = serverInfo.getJavaProject();
            String name = serverInfo.getName();
            if (!javaProject.getProject().isOpen() || !targetProj.equals(javaProject) || !targetName.equals(name)) continue;
            int jmxPort = server.getJmxPort().getIntValue();
            if (jmxPort == 0) {
                jmxPort = 9520;
            }
            if ((host = server.getHost()) == null) {
                host = "localhost";
            }
            TCStop stopper = new TCStop(host, jmxPort);
            stopper.stop();
            int count = 0;
            while (true) {
                try {
                    proc.getExitValue();
                    monitor.done();
                    return;
                }
                catch (DebugException de) {
                    if (count++ == 6) {
                        proc.terminate();
                        monitor.done();
                        return;
                    }
                    ThreadUtil.reallySleep((long)1000L);
                    continue;
                }
                break;
            }
        }
    }

    ServerInfo getServerInfoByName(String name) {
        if (name == null) {
            return null;
        }
        for (ServerInfo info : this.m_servers.values()) {
            String serverName = info.getName();
            if (!serverName.equals(name)) continue;
            return info;
        }
        return null;
    }

    public void shutdownAllServers() {
        for (ServerInfo info : this.m_servers.values()) {
            this.cancelServer(info.getJavaProject());
        }
    }

    class TCStopper
    implements IRunnableWithProgress {
        IJavaProject m_javaProject;
        boolean m_restart;
        String m_name;
        Server m_server;

        TCStopper(IJavaProject javaProject) {
            this(javaProject, false, null, null);
        }

        TCStopper(IJavaProject javaProject, boolean restart, String name, Server server) {
            this.m_javaProject = javaProject;
            this.m_restart = restart;
            this.m_name = name;
            this.m_server = server;
        }

        public void run(IProgressMonitor monitor) throws InvocationTargetException {
            try {
                monitor.beginTask("Stopping Terracotta Server instance '" + this.m_name + "' ...", -1);
                ServerTracker.this.doStopServer(this.m_javaProject, this.m_name, this.m_server, monitor);
                if (this.m_restart) {
                    ServerTracker.this.internalStartServer(this.m_javaProject, this.m_name, this.m_server, monitor);
                }
            }
            catch (Exception e) {
                throw new InvocationTargetException(e);
            }
        }
    }

    class DSOAppEventListener
    implements NotificationListener {
        private boolean fHandlingApplicationEvent;

        DSOAppEventListener() {
        }

        public void handleNotification(Notification notification, Object handback) {
            final Object event = notification.getSource();
            if (!this.fHandlingApplicationEvent) {
                this.fHandlingApplicationEvent = true;
                if (event instanceof AbstractApplicationEvent) {
                    Display.getDefault().asyncExec(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public void run() {
                            try {
                                ServerTracker.this.handleApplicationEvent((AbstractApplicationEvent)event);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            finally {
                                DSOAppEventListener.this.fHandlingApplicationEvent = false;
                            }
                        }
                    });
                }
            }
        }
    }

    class L2ConnectListener
    implements ConnectionListener {
        IJavaProject fJavaProject;
        String fName;
        ServerInfo fServerInfo;
        ServerConnectionManager fServerConnectionManager;

        L2ConnectListener(IJavaProject javaProject, String name) {
            this.fJavaProject = javaProject;
            this.fName = name;
            this.fServerInfo = ServerTracker.this.getServerInfo(this.fJavaProject, this.fName);
        }

        void setServerConnectionManager(ServerConnectionManager serverConnectionManager) {
            this.fServerConnectionManager = serverConnectionManager;
        }

        public void handleConnection() {
            block6: {
                if (this.fServerConnectionManager == null) {
                    return;
                }
                if (this.fServerInfo.isTerminated()) {
                    this.stopListening();
                    return;
                }
                try {
                    if (!this.fServerConnectionManager.testIsConnected() || !this.fServerConnectionManager.canShutdown()) break block6;
                    this.fServerInfo.setStatus(1);
                    ServerTracker.this.setRunning(this.fJavaProject, Boolean.TRUE);
                    ConnectionContext cc = this.fServerConnectionManager.getConnectionContext();
                    while (true) {
                        ObjectName on;
                        if ((on = cc.queryName(L2MBeanNames.DSO_APP_EVENTS.getCanonicalName())) != null) {
                            cc.addNotificationListener(on, (NotificationListener)new DSOAppEventListener());
                            break;
                        }
                        ThreadUtil.reallySleep((long)250L);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        public void handleException() {
            if (this.fServerInfo.isTerminated()) {
                this.stopListening();
            }
        }

        private void stopListening() {
            if (this.fServerConnectionManager == null) {
                return;
            }
            this.fServerConnectionManager.tearDown();
            this.fServerConnectionManager = null;
        }
    }
}

