/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.terracottatech.config.AdditionalBootJarClasses;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.DistributedMethods;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Include;
import com.terracottatech.config.InstrumentedClasses;
import com.terracottatech.config.Locks;
import com.terracottatech.config.Module;
import com.terracottatech.config.NamedLock;
import com.terracottatech.config.Root;
import com.terracottatech.config.Roots;
import com.terracottatech.config.TransientFields;
import com.terracottatech.config.WebApplication;
import com.terracottatech.config.WebApplications;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.h2.util.StringUtils;
import org.osgi.framework.Bundle;
import org.terracotta.dso.ModuleInfo;

public class ModulesConfiguration {
    private final List<ModuleInfo> fModuleInfoList = new ArrayList<ModuleInfo>();
    private final DsoApplication fApplication = DsoApplication.Factory.newInstance();

    public ModuleInfo add(Module module) {
        ModuleInfo moduleInfo = new ModuleInfo(module);
        this.fModuleInfoList.add(moduleInfo);
        return moduleInfo;
    }

    public ModuleInfo getOrAdd(Module module) {
        ModuleInfo moduleInfo = this.getModuleInfo(module);
        if (moduleInfo == null) {
            moduleInfo = this.add(module);
        }
        return moduleInfo;
    }

    public static boolean sameModule(Module m1, Module m2) {
        return m1 != null && m2 != null && m1.getName().equals(m2.getName()) && m1.getGroupId().equals(m2.getGroupId()) && StringUtils.equals((String)m1.getVersion(), (String)m2.getVersion());
    }

    public ModuleInfo getModuleInfo(Module module) {
        for (ModuleInfo moduleInfo : this.fModuleInfoList) {
            if (!ModulesConfiguration.sameModule(module, moduleInfo.getModule())) continue;
            return moduleInfo;
        }
        return null;
    }

    public ModuleInfo associateBundle(Bundle bundle) {
        for (ModuleInfo moduleInfo : this.fModuleInfoList) {
            File location = FileUtils.toFile((URL)moduleInfo.getLocation());
            String bundleLocation = bundle.getLocation();
            if (location == null) continue;
            try {
                File bundleFile = new File(new URL(bundleLocation).getPath());
                String bundleFileLocation = bundleFile.getAbsolutePath();
                if (!bundleFileLocation.equals(location.getAbsolutePath())) continue;
                moduleInfo.setBundle(bundle);
                return moduleInfo;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public void setModuleApplication(ModuleInfo moduleInfo, DsoApplication application) {
        moduleInfo.setApplication(application);
        this.merge(application);
    }

    public DsoApplication getApplication() {
        return this.fApplication;
    }

    public void merge(DsoApplication application) {
        ModulesConfiguration.merge(application, this.fApplication);
    }

    public static void merge(DsoApplication src, DsoApplication dest) {
        if (src.isSetInstrumentedClasses()) {
            InstrumentedClasses srcInstrumentedClasses = src.getInstrumentedClasses();
            InstrumentedClasses destInstrumentedClasses = dest.isSetInstrumentedClasses() ? dest.getInstrumentedClasses() : dest.addNewInstrumentedClasses();
            ModulesConfiguration.merge(srcInstrumentedClasses, destInstrumentedClasses);
        }
        if (src.isSetTransientFields()) {
            TransientFields srcTransientFields = src.getTransientFields();
            TransientFields destTransientFields = dest.isSetTransientFields() ? dest.getTransientFields() : dest.addNewTransientFields();
            ModulesConfiguration.merge(srcTransientFields, destTransientFields);
        }
        if (src.isSetLocks()) {
            Locks srcLocks = src.getLocks();
            Locks destLocks = dest.isSetLocks() ? dest.getLocks() : dest.addNewLocks();
            ModulesConfiguration.merge(srcLocks, destLocks);
        }
        if (src.isSetRoots()) {
            Roots srcRoots = src.getRoots();
            Roots destRoots = dest.isSetRoots() ? dest.getRoots() : dest.addNewRoots();
            ModulesConfiguration.merge(srcRoots, destRoots);
        }
        if (src.isSetDistributedMethods()) {
            DistributedMethods srcDistributedMethods = src.getDistributedMethods();
            DistributedMethods destDistributedMethods = dest.isSetDistributedMethods() ? dest.getDistributedMethods() : dest.addNewDistributedMethods();
            ModulesConfiguration.merge(srcDistributedMethods, destDistributedMethods);
        }
        if (src.isSetAdditionalBootJarClasses()) {
            AdditionalBootJarClasses srcBootClasses = src.getAdditionalBootJarClasses();
            AdditionalBootJarClasses destBootClasses = dest.isSetAdditionalBootJarClasses() ? dest.getAdditionalBootJarClasses() : dest.addNewAdditionalBootJarClasses();
            ModulesConfiguration.merge(srcBootClasses, destBootClasses);
        }
        if (src.isSetWebApplications()) {
            WebApplications srcWebApps = src.getWebApplications();
            WebApplications destWebApps = dest.isSetWebApplications() ? dest.getWebApplications() : dest.addNewWebApplications();
            ModulesConfiguration.merge(srcWebApps, destWebApps);
        }
        if (src.isSetDsoReflectionEnabled()) {
            dest.setDsoReflectionEnabled(src.getDsoReflectionEnabled());
        }
    }

    public static void merge(InstrumentedClasses src, InstrumentedClasses dest) {
        Include[] includes = src.getIncludeArray();
        ArrayList<Include> includeList = new ArrayList<Include>(Arrays.asList(includes));
        for (Include include : dest.getIncludeArray()) {
            includeList.add((Include)include.copy());
        }
        dest.setIncludeArray(includeList.toArray(new Include[0]));
    }

    public static void merge(TransientFields src, TransientFields dest) {
        String[] fields = src.getFieldNameArray();
        ArrayList<String> fieldList = new ArrayList<String>(Arrays.asList(fields));
        fieldList.addAll(Arrays.asList(dest.getFieldNameArray()));
        dest.setFieldNameArray(fieldList.toArray(new String[0]));
    }

    public static void merge(Locks src, Locks dest) {
        Autolock[] autolocks = src.getAutolockArray();
        ArrayList<Autolock> autolockList = new ArrayList<Autolock>(Arrays.asList(autolocks));
        for (Autolock autolock : dest.getAutolockArray()) {
            autolockList.add((Autolock)autolock.copy());
        }
        dest.setAutolockArray(autolockList.toArray(new Autolock[0]));
        NamedLock[] namedLocks = src.getNamedLockArray();
        ArrayList<NamedLock> namedLockList = new ArrayList<NamedLock>(Arrays.asList(namedLocks));
        for (NamedLock namedLock : dest.getNamedLockArray()) {
            namedLockList.add((NamedLock)namedLock.copy());
        }
        dest.setNamedLockArray(namedLockList.toArray(new NamedLock[0]));
    }

    public static void merge(Roots src, Roots dest) {
        Root[] roots = src.getRootArray();
        ArrayList<Root> rootList = new ArrayList<Root>(Arrays.asList(roots));
        for (Root root : dest.getRootArray()) {
            rootList.add((Root)root.copy());
        }
        dest.setRootArray(rootList.toArray(new Root[0]));
    }

    public static void merge(DistributedMethods src, DistributedMethods dest) {
        DistributedMethods.MethodExpression[] methodExprs = src.getMethodExpressionArray();
        ArrayList<DistributedMethods.MethodExpression> exprList = new ArrayList<DistributedMethods.MethodExpression>(Arrays.asList(methodExprs));
        for (DistributedMethods.MethodExpression expr : dest.getMethodExpressionArray()) {
            exprList.add((DistributedMethods.MethodExpression)expr.copy());
        }
        dest.setMethodExpressionArray(exprList.toArray(new DistributedMethods.MethodExpression[0]));
    }

    public static void merge(AdditionalBootJarClasses src, AdditionalBootJarClasses dest) {
        String[] includes = src.getIncludeArray();
        ArrayList<String> includeList = new ArrayList<String>(Arrays.asList(includes));
        includeList.addAll(Arrays.asList(dest.getIncludeArray()));
        dest.setIncludeArray(includeList.toArray(new String[0]));
    }

    public static void merge(WebApplications src, WebApplications dest) {
        WebApplication[] webApps = src.getWebApplicationArray();
        ArrayList<WebApplication> webAppList = new ArrayList<WebApplication>(Arrays.asList(webApps));
        for (WebApplication webApp : dest.getWebApplicationArray()) {
            webAppList.add((WebApplication)webApp.copy());
        }
        dest.setWebApplicationArray(webAppList.toArray(new WebApplication[0]));
    }
}

