/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.IDocumentSetupParticipant;
import org.eclipse.core.filebuffers.IFileBuffer;
import org.eclipse.core.filebuffers.IFileBufferListener;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.PlatformUI;
import org.terracotta.dso.TcPlugin;

public class JavaSetupParticipant
implements IDocumentSetupParticipant {
    private static JavaSetupParticipant m_setupParticipant = new JavaSetupParticipant();
    private final ArrayList<IFile> m_fileList = new ArrayList();

    private JavaSetupParticipant() {
        FileBuffers.getTextFileBufferManager().addFileBufferListener(new IFileBufferListener(){

            public void bufferCreated(IFileBuffer buffer) {
                IFile file = JavaSetupParticipant.this.fileForBuffer(buffer);
                if (file != null && JavaSetupParticipant.this.shouldInspect(file)) {
                    JavaSetupParticipant.this.m_fileList.add(file);
                    PlatformUI.getWorkbench().getDisplay().asyncExec((Runnable)new Inspector(file));
                }
            }

            public void bufferDisposed(IFileBuffer buffer) {
                IFile file = JavaSetupParticipant.this.fileForBuffer(buffer);
                if (file != null) {
                    JavaSetupParticipant.this.m_fileList.remove(file);
                }
            }

            public void underlyingFileMoved(IFileBuffer buffer, IPath path) {
                Iterator iter = JavaSetupParticipant.this.m_fileList.iterator();
                while (iter.hasNext()) {
                    IFile file = (IFile)iter.next();
                    if (file.exists()) continue;
                    iter.remove();
                }
                JavaSetupParticipant.this.m_fileList.add(FileBuffers.getWorkspaceFileAtLocation((IPath)path));
            }

            public void underlyingFileDeleted(IFileBuffer buffer) {
                IFile file = JavaSetupParticipant.this.fileForBuffer(buffer);
                if (file != null) {
                    JavaSetupParticipant.this.m_fileList.remove(file);
                }
            }

            public void bufferContentAboutToBeReplaced(IFileBuffer buffer) {
            }

            public void bufferContentReplaced(IFileBuffer buffer) {
            }

            public void stateChanging(IFileBuffer buffer) {
            }

            public void dirtyStateChanged(IFileBuffer buffer, boolean isDirty) {
            }

            public void stateValidationChanged(IFileBuffer buffer, boolean isStateValidated) {
            }

            public void stateChangeFailed(IFileBuffer buffer) {
            }
        });
    }

    private IFile fileForBuffer(IFileBuffer buffer) {
        return FileBuffers.getWorkspaceFileAtLocation((IPath)buffer.getLocation());
    }

    private boolean shouldInspect(IFile file) {
        IPath path = file.getLocation();
        String extension = path.getFileExtension();
        return extension.equals("java") && TcPlugin.getDefault().hasTerracottaNature(file.getProject());
    }

    public void setup(IDocument document) {
    }

    protected void inspectAllBuffers() {
        Iterator<IFile> iter = this.m_fileList.iterator();
        while (iter.hasNext()) {
            IFile file = iter.next();
            if (file.exists()) {
                new Inspector(file).run();
                continue;
            }
            iter.remove();
        }
    }

    public static void inspectAll() {
        if (m_setupParticipant != null) {
            m_setupParticipant.inspectAllBuffers();
        }
    }

    static class Inspector
    implements Runnable {
        private final IFile m_file;

        Inspector(IFile file) {
            this.m_file = file;
        }

        public void run() {
            ICompilationUnit cu;
            if (this.m_file.exists() && (cu = JavaCore.createCompilationUnitFrom((IFile)this.m_file)) != null) {
                TcPlugin.getDefault().inspect(cu);
            }
        }
    }
}

