/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.reflect.ClassInfo;
import com.tc.aspectwerkz.reflect.FieldInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.backport175.bytecode.AnnotationElement;
import com.tc.object.bytecode.aspectwerkz.SimpleClassInfo;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.Annotation;
import org.terracotta.dso.ClassInformationFactory;
import org.terracotta.dso.JavaModelAnnotationInfo;
import org.terracotta.dso.JavaModelFieldInfo;
import org.terracotta.dso.JavaModelMethodInfo;
import org.terracotta.dso.JdtUtils;

public class JavaModelClassInfo
extends SimpleClassInfo {
    private IType fType;
    private String fSuperClassSig;
    private ClassInfo fSuperClass;
    private String[] fInterfaceSigs;
    private ClassInfo[] fInterfaces;
    private JavaModelAnnotationInfo fAnnotationInfo;
    private final Map<IMethod, SoftReference> fMethodInfoCache = new HashMap<IMethod, SoftReference>();
    private final Map<String, SoftReference> fFieldInfoCache = new HashMap<String, SoftReference>();
    private static final String[] NO_INTERFACE_SIGS = new String[0];
    private static final ClassInfo[] NO_INTERFACES = new ClassInfo[0];

    public JavaModelClassInfo(String classname) {
        super(classname);
        this.fInterfaceSigs = NO_INTERFACE_SIGS;
        this.fInterfaces = NO_INTERFACES;
        this.fAnnotationInfo = new JavaModelAnnotationInfo();
    }

    public JavaModelClassInfo(IType type) {
        super(type.getFullyQualifiedName('$'));
        this.fType = type;
        try {
            this.fSuperClassSig = type.getSuperclassTypeSignature();
            if (this.fSuperClassSig != null) {
                this.fSuperClass = new JavaModelClassInfo(JdtUtils.getResolvedTypeName(this.fSuperClassSig, type));
            }
            this.fInterfaceSigs = NO_INTERFACE_SIGS;
            this.fInterfaces = NO_INTERFACES;
            if (type.isClass() || type.isAnnotation() || type.isInterface()) {
                this.fInterfaceSigs = type.getSuperInterfaceTypeSignatures();
                this.fInterfaces = new JavaModelClassInfo[this.fInterfaceSigs.length];
                for (int i = 0; i < this.fInterfaceSigs.length; ++i) {
                    this.fInterfaces[i] = new JavaModelClassInfo(JdtUtils.getResolvedTypeName(this.fInterfaceSigs[i], type));
                }
            }
        }
        catch (JavaModelException jme) {
            this.fInterfaceSigs = NO_INTERFACE_SIGS;
            this.fInterfaces = NO_INTERFACES;
        }
        this.fAnnotationInfo = new JavaModelAnnotationInfo((IMember)type);
    }

    public IType getType() {
        return this.fType;
    }

    public ClassInfo getSuperclass() {
        return this.fSuperClass;
    }

    public ClassInfo[] getInterfaces() {
        return (ClassInfo[])this.fInterfaces.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodInfo getMethod(ClassInformationFactory classInfoFactory, IMethod method) throws JavaModelException {
        Object info = null;
        Map<IMethod, SoftReference> map = this.fMethodInfoCache;
        synchronized (map) {
            SoftReference ref = this.fMethodInfoCache.get(method);
            if (ref != null) {
                info = (MethodInfo)ref.get();
            }
            if (info == null) {
                info = new JavaModelMethodInfo(classInfoFactory, method);
                this.fMethodInfoCache.put(method, new SoftReference<MethodInfo>((MethodInfo)info));
            }
        }
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FieldInfo getField(ClassInformationFactory classInfoFactory, IField field) {
        FieldInfo info = null;
        Map<String, SoftReference> map = this.fFieldInfoCache;
        synchronized (map) {
            String key = field.getElementName();
            SoftReference ref = this.fFieldInfoCache.get(key);
            if (ref != null) {
                info = (FieldInfo)ref.get();
            }
            if (info == null) {
                info = new JavaModelFieldInfo(classInfoFactory, field);
                this.fFieldInfoCache.put(key, new SoftReference<FieldInfo>(info));
            }
        }
        return info;
    }

    public void clearAnnotations() {
        this.fAnnotationInfo.clear();
    }

    public void addAnnotation(Annotation annotation) {
        this.fAnnotationInfo.addAnnotation(annotation);
    }

    public void addAnnotation(String fqcn) {
        this.fAnnotationInfo.addAnnotation(fqcn);
    }

    public AnnotationElement.Annotation[] getAnnotations() {
        return this.fAnnotationInfo.getAnnotations();
    }

    public boolean isStale(IType type) {
        try {
            if (this.fType == null) {
                return true;
            }
            if (this.fType == type) {
                return false;
            }
            String superClassSig = this.fType.getSuperclassTypeSignature();
            if (superClassSig == null && this.fSuperClassSig != null || superClassSig != null && this.fSuperClassSig == null || superClassSig != null && !superClassSig.equals(this.fSuperClassSig)) {
                return true;
            }
            String[] interfaceSigs = this.fType.getSuperInterfaceTypeSignatures();
            if (interfaceSigs.length != this.fInterfaceSigs.length) {
                return true;
            }
            for (int i = 0; i < interfaceSigs.length; ++i) {
                if (interfaceSigs[i].equals(this.fInterfaceSigs[i])) continue;
                return true;
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }
}

