/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import org.eclipse.jdt.core.ElementChangedEvent;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IElementChangedListener;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaElementDelta;
import org.terracotta.dso.TcPlugin;

public class ElementChangedListener
implements IElementChangedListener {
    private static final boolean m_debug = Boolean.getBoolean("ElementChangedListener.debug");

    public void elementChanged(ElementChangedEvent ece) {
        TcPlugin plugin = TcPlugin.getDefault();
        IJavaElementDelta delta = ece.getDelta();
        int kind = delta.getKind();
        int flags = delta.getFlags();
        if (m_debug) {
            ElementChangedListener.dump(delta);
        }
        switch (kind) {
            case 1: 
            case 4: {
                IJavaElement elem;
                if ((flags & 0x80000) == 0 || !plugin.hasTerracottaNature(elem = delta.getElement()) || !(elem instanceof ICompilationUnit)) break;
                TcPlugin.getDefault().inspect((ICompilationUnit)elem);
            }
        }
    }

    private static void dump(IJavaElementDelta delta) {
        int kind = delta.getKind();
        int flags = delta.getFlags();
        StringBuffer sb = new StringBuffer();
        sb.append(delta);
        switch (kind) {
            case 1: {
                sb.append(" ADDED");
                IJavaElement movedFrom = delta.getMovedFromElement();
                if (movedFrom == null) break;
                sb.append("moved_from: " + movedFrom);
                break;
            }
            case 2: {
                sb.append(" REMOVED");
                IJavaElement movedTo = delta.getMovedToElement();
                if (movedTo == null) break;
                sb.append("moved_to: " + movedTo);
                break;
            }
            case 4: {
                sb.append(" CHANGED");
            }
        }
        if ((flags & 1) != 0) {
            sb.append(" F_CONTENT");
        }
        if ((flags & 2) != 0) {
            sb.append(" F_MODIFIERS");
        }
        if ((flags & 8) != 0) {
            sb.append(" F_CHILDREN");
            IJavaElementDelta[] children = delta.getAffectedChildren();
            if (children != null && children.length > 0) {
                sb.append("\n");
                if (children.length == 2 && children[0].getKind() == 1 && children[1].getKind() == 2) {
                    IJavaElement fromElem = children[1].getElement();
                    IJavaElement toElem = children[0].getElement();
                    if (fromElem.getElementType() == toElem.getElementType()) {
                        sb.append(fromElem.getElementName() + " moved to " + toElem.getElementName());
                    }
                }
                for (int i = 0; i < children.length; ++i) {
                    ElementChangedListener.dump(children[i]);
                }
            }
        }
        if ((flags & 0x10) == 16) {
            sb.append(" F_MOVED_FROM");
        }
        if ((flags & 0x20) == 32) {
            sb.append(" F_MOVED_TO");
        }
        if ((flags & 0x40) != 0) {
            sb.append(" F_ADDED_TO_CLASSPATH");
        }
        if ((flags & 0x80) != 0) {
            sb.append(" F_REMOVED_FROM_CLASSPATH");
        }
        if ((flags & 0x100) != 0) {
            sb.append(" F_REORDER");
        }
        if ((flags & 0x200) != 0) {
            sb.append(" F_OPENED");
        }
        if ((flags & 0x400) != 0) {
            sb.append(" F_CLOSED");
        }
        if ((flags & 0x800) != 0) {
            sb.append(" F_SUPER_TYPES");
        }
        if ((flags & 0x1000) != 0) {
            sb.append(" F_SOURCEATTACHED");
        }
        if ((flags & 0x2000) != 0) {
            sb.append(" F_SOURCEDETACHED");
        }
        if ((flags & 0x4000) != 0) {
            sb.append(" F_FINE_GRAINED");
        }
        if ((flags & 0x8000) != 0) {
            sb.append(" F_ARCHIVE_CONTENT_CHANGED");
        }
        if ((flags & 0x10000) != 0) {
            sb.append(" F_PRIMARY_WORKING_COPY");
        }
        if ((flags & 0x20000) != 0) {
            sb.append(" F_CLASSPATH_CHANGED");
        }
        if ((flags & 0x40000) != 0) {
            sb.append(" F_PRIMARY_RESOURCE");
        }
        System.out.println(sb.toString());
    }
}

