/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.aspectwerkz.reflect.MemberInfo;
import com.tc.aspectwerkz.reflect.MethodInfo;
import com.tc.config.schema.dynamic.ParameterSubstituter;
import com.tc.object.NonInstrumentedClasses;
import com.terracottatech.config.AdditionalBootJarClasses;
import com.terracottatech.config.Application;
import com.terracottatech.config.Autolock;
import com.terracottatech.config.ClassExpression;
import com.terracottatech.config.Client;
import com.terracottatech.config.DistributedMethods;
import com.terracottatech.config.DsoApplication;
import com.terracottatech.config.Include;
import com.terracottatech.config.InstrumentedClasses;
import com.terracottatech.config.LockLevel;
import com.terracottatech.config.Locks;
import com.terracottatech.config.Module;
import com.terracottatech.config.Modules;
import com.terracottatech.config.NamedLock;
import com.terracottatech.config.Root;
import com.terracottatech.config.Roots;
import com.terracottatech.config.Servers;
import com.terracottatech.config.TcConfigDocument;
import com.terracottatech.config.TransientFields;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlString;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageDeclaration;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.FindReplaceDocumentAdapter;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.ui.texteditor.MarkerUtilities;
import org.osgi.framework.BundleException;
import org.terracotta.dso.BootClassHelper;
import org.terracotta.dso.JdtUtils;
import org.terracotta.dso.ModuleInfo;
import org.terracotta.dso.ModulesConfiguration;
import org.terracotta.dso.MultiChangeSignaller;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;
import org.terracotta.dso.editors.ConfigurationEditor;

public class ConfigurationHelper {
    private final TcPlugin m_plugin = TcPlugin.getDefault();
    private final IProject m_project;
    private final IJavaProject m_javaProject;
    private final PatternHelper m_patternHelper;
    private final NonInstrumentedClasses m_nonInstrumentedClasses;
    private static String LOCK_PROBLEM_MARKER = "org.terracotta.dso.LockMethodProblemMarker";
    private static String ROOT_PROBLEM_MARKER = "org.terracotta.dso.RootProblemMarker";
    private static String[] PRIMITIVE_NAMES = new String[]{"java.lang.String", "java.lang.Integer", "java.lang.Boolean", "java.lang.Double", "java.lang.Character", "java.lang.Byte"};
    private static ArrayList<String> PRIMITIVES = new ArrayList<String>(Arrays.asList(PRIMITIVE_NAMES));
    private static String TRANSIENT_PROBLEM_MARKER = "org.terracotta.dso.TransientProblemMarker";
    private static String INSTRUMENTED_PROBLEM_MARKER = "org.terracotta.dso.InstrumentedProblemMarker";
    private static String DISTRIBUTED_METHOD_PROBLEM_MARKER = "org.terracotta.dso.DistributedMethodProblemMarker";
    private static String BOOT_CLASS_PROBLEM_MARKER = "org.terracotta.dso.BootClassProblemMarker";
    private static String MODULE_PROBLEM_MARKER = "org.terracotta.dso.ModuleProblemMarker";
    private static String MODULE_REPO_PROBLEM_MARKER = "org.terracotta.dso.ModuleRepoProblemMarker";

    public ConfigurationHelper(IProject project) {
        this.m_project = project;
        this.m_javaProject = JavaCore.create((IProject)this.m_project);
        this.m_patternHelper = PatternHelper.getHelper();
        this.m_nonInstrumentedClasses = new NonInstrumentedClasses();
    }

    public boolean isInstrumentationNotNeeded(ICompilationUnit cu) {
        return this.isInstrumentationNotNeeded(cu.findPrimaryType());
    }

    public boolean isInstrumentationNotNeeded(IClassFile cf) {
        return this.isInstrumentationNotNeeded(cf.findPrimaryType());
    }

    public boolean isInstrumentationNotNeeded(IType type) {
        return this.isInstrumentationNotNeeded(type.getFullyQualifiedName('$'));
    }

    public boolean isInstrumentationNotNeeded(String classname) {
        return this.m_nonInstrumentedClasses.isInstrumentationNotNeeded(classname);
    }

    public boolean isAdaptable(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return this.isAdaptable((ICompilationUnit)element);
        }
        if (element instanceof IClassFile) {
            return this.isAdaptable((IClassFile)element);
        }
        if (element instanceof IType) {
            return this.isAdaptable((IType)element);
        }
        if (element instanceof IPackageDeclaration) {
            return this.isAdaptable((IPackageDeclaration)element);
        }
        if (element instanceof IPackageFragment) {
            return this.isAdaptable((IPackageFragment)element);
        }
        if (element instanceof IJavaProject) {
            return this.isAdaptable((IJavaProject)element);
        }
        return false;
    }

    public boolean isAdaptable(ICompilationUnit module) {
        return this.isAdaptable(module.findPrimaryType());
    }

    public boolean isAdaptable(IClassFile classFile) {
        try {
            return this.isAdaptable(classFile.getType());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAdaptable(IType type) {
        if (type != null) {
            return this.m_plugin.isBootClass(this.m_project, type) || this.isTypeAdaptable(type);
        }
        return false;
    }

    private Boolean isTypeAdaptable(IType type, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesType(expr, type)) continue;
                    return Boolean.TRUE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesType(expr = ((ClassExpression)object).getStringValue(), type)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isTypeAdaptable(IType type) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean adaptable;
            Boolean adaptable2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (adaptable2 = this.isTypeAdaptable(type, instrumentedClasses)) != null) {
                return adaptable2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (adaptable = this.isTypeAdaptable(type, instrumentedClasses)) != null) {
                return adaptable;
            }
        }
        return false;
    }

    private Boolean isAdaptable(IPackageDeclaration packageDecl, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesPackageDeclaration(expr, packageDecl)) continue;
                    return Boolean.TRUE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesPackageDeclaration(expr = ((ClassExpression)object).getStringValue(), packageDecl)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isAdaptable(IPackageDeclaration packageDecl) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean adaptable;
            Boolean adaptable2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (adaptable2 = this.isAdaptable(packageDecl, instrumentedClasses)) != null) {
                return adaptable2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (adaptable = this.isAdaptable(packageDecl, instrumentedClasses)) != null) {
                return adaptable;
            }
        }
        return false;
    }

    private Boolean isAdaptable(IPackageFragment fragment, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesPackageFragment(expr, fragment)) continue;
                    return Boolean.TRUE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesPackageFragment(expr = ((ClassExpression)object).getStringValue(), fragment)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isAdaptable(IPackageFragment fragment) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean adaptable;
            Boolean adaptable2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (adaptable2 = this.isAdaptable(fragment, instrumentedClasses)) != null) {
                return adaptable2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (adaptable = this.isAdaptable(fragment, instrumentedClasses)) != null) {
                return adaptable;
            }
        }
        return false;
    }

    public boolean isAdaptable(IJavaProject javaProject) {
        IPackageFragment[] fragments;
        if (javaProject != null && (fragments = ConfigurationHelper.getSourceFragments(javaProject)).length > 0) {
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isAdaptable(fragments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private Boolean isAdaptable(String classExpr, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesClass(expr, classExpr)) continue;
                    return Boolean.TRUE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesClass(expr = ((ClassExpression)object).getStringValue(), classExpr)) continue;
                return Boolean.FALSE;
            }
        }
        return null;
    }

    public boolean isAdaptable(String classExpr) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean adaptable;
            Boolean adaptable2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (adaptable2 = this.isAdaptable(classExpr, instrumentedClasses)) != null) {
                return adaptable2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (adaptable = this.isAdaptable(classExpr, instrumentedClasses)) != null) {
                return adaptable;
            }
        }
        return this.m_plugin.isBootClass(this.m_project, classExpr);
    }

    public Include includeRuleFor(String classExpr) {
        XmlObject[] objects;
        InstrumentedClasses classes;
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null && (classes = this.getInstrumentedClasses()) != null && (objects = classes.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (!(object instanceof Include) || (expr = ((Include)object).getClassExpression()) == null || !expr.equals(classExpr)) continue;
                return (Include)object;
            }
        }
        return null;
    }

    public Include ensureIncludeRuleFor(String classExpr) {
        Include include = this.includeRuleFor(classExpr);
        if (include == null) {
            include = this.addIncludeRule(classExpr);
            this.m_plugin.fireExcludeRulesChanged(this.m_project);
        }
        return include;
    }

    public boolean declaresRoot(IType type) {
        return this.declaresRoot(type.getFullyQualifiedName());
    }

    public boolean declaresRoot(String typeName) {
        if (typeName == null) {
            return false;
        }
        Roots roots = this.getRoots();
        if (roots != null) {
            for (int i = 0; i < roots.sizeOfRootArray(); ++i) {
                String rootTypeName;
                int dotIndex;
                String rootFieldName = roots.getRootArray(i).getFieldName();
                if (rootFieldName == null || rootFieldName.length() <= 0 || (dotIndex = rootFieldName.lastIndexOf(46)) == -1 || !typeName.equals(rootTypeName = rootFieldName.substring(0, dotIndex))) continue;
                return true;
            }
        }
        return false;
    }

    public void ensureAdaptable(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof ICompilationUnit) {
            this.ensureAdaptable((ICompilationUnit)element, signaller);
        } else if (element instanceof IClassFile) {
            this.ensureAdaptable((IClassFile)element, signaller);
        } else if (element instanceof IType) {
            this.ensureAdaptable((IType)element, signaller);
        } else if (element instanceof IPackageDeclaration) {
            this.ensureAdaptable((IPackageDeclaration)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureAdaptable((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureAdaptable((IJavaProject)element, signaller);
        }
    }

    public void ensureAdaptable(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(ICompilationUnit module, MultiChangeSignaller signaller) {
        this.ensureAdaptable(module.findPrimaryType(), signaller);
    }

    public void ensureAdaptable(IClassFile classFile) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(classFile, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IClassFile classFile, MultiChangeSignaller signaller) {
        try {
            this.ensureAdaptable(classFile.getType(), signaller);
        }
        catch (Exception e) {
            this.openError("Error ensuring '" + classFile.getElementName() + "' instrumented", e);
        }
    }

    public void ensureAdaptable(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IType type, MultiChangeSignaller signaller) {
        if (ConfigurationHelper.isInterface(type)) {
            this.internalEnsureAdaptable(type, signaller);
            return;
        }
        while (type != null && !ConfigurationHelper.isInterface(type)) {
            if (!this.isAdaptable(type)) {
                this.internalEnsureAdaptable(type, signaller);
            }
            IType parentType = type;
            try {
                IType superType;
                String superTypeName;
                String superTypeSig;
                while ((superTypeSig = parentType.getSuperclassTypeSignature()) != null && (superTypeName = JdtUtils.getResolvedTypeName(superTypeSig, type)) != null && !superTypeName.equals("java.lang.Object") && (superType = JdtUtils.findType(this.m_javaProject, superTypeName)) != null) {
                    if (!ConfigurationHelper.isInterface(superType)) {
                        if (this.isAdaptable(superType)) break;
                        this.internalEnsureAdaptable(superType, signaller);
                    }
                    parentType = superType;
                }
            }
            catch (JavaModelException jme) {
                // empty catch block
            }
            type = type.getDeclaringType();
        }
    }

    public void internalEnsureAdaptable(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAdaptable(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAdaptable(IType type, MultiChangeSignaller signaller) {
        int filter;
        IJavaElement[] elements;
        IJavaSearchScope scope;
        String postscript = ConfigurationHelper.isInterface(type) ? "+" : "";
        this.internalEnsureAdaptable(PatternHelper.getFullyQualifiedName(type) + postscript, signaller);
        if (!this.isBootJarClass(type) && (scope = SearchEngine.createJavaSearchScope((IJavaElement[])(elements = new IJavaElement[]{this.m_javaProject}), (int)(filter = 4))).encloses((IJavaElement)type)) {
            this.internalEnsureBootJarClass(type, signaller);
        }
    }

    public void ensureAdaptable(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (packageDecl != null && !this.isAdaptable(packageDecl)) {
            this.internalEnsureAdaptable(packageDecl, signaller);
        }
    }

    public void internalEnsureAdaptable(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAdaptable(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAdaptable(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        this.internalEnsureAdaptable(PatternHelper.getWithinPattern(packageDecl), signaller);
    }

    public void ensureAdaptable(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (fragment != null && !this.isAdaptable(fragment)) {
            this.internalEnsureAdaptable(fragment, signaller);
        }
    }

    public void internalEnsureAdaptable(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAdaptable(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAdaptable(IPackageFragment fragment, MultiChangeSignaller signaller) {
        this.internalEnsureAdaptable(PatternHelper.getWithinPattern(fragment), signaller);
    }

    public void ensureAdaptable(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null && !this.isAdaptable(javaProject)) {
            this.internalEnsureAdaptable(javaProject, signaller);
        }
    }

    public void internalEnsureAdaptable(IJavaProject javaProject, MultiChangeSignaller signaller) {
        IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
        for (int i = 0; i < fragments.length; ++i) {
            if (this.isAdaptable(fragments[i])) continue;
            this.internalEnsureAdaptable(fragments[i], signaller);
        }
    }

    public void ensureAdaptable(String classExpr) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAdaptable(classExpr, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAdaptable(String classExpr, MultiChangeSignaller signaller) {
        if (this.isInstrumentationNotNeeded(classExpr)) {
            return;
        }
        if (this.isAdaptable(classExpr)) {
            this.internalEnsureAdaptable(classExpr, signaller);
        }
    }

    public Include addIncludeRule(String classExpr) {
        InstrumentedClasses classes = this.ensureInstrumentedClasses();
        Include include = classes.addNewInclude();
        include.setClassExpression(classExpr);
        return include;
    }

    public void internalEnsureAdaptable(String classExpr) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAdaptable(classExpr, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAdaptable(String classExpr, MultiChangeSignaller signaller) {
        if (this.isInstrumentationNotNeeded(classExpr)) {
            return;
        }
        this.addIncludeRule(classExpr);
        signaller.includeRulesChanged = true;
    }

    public void ensureNotAdaptable(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof ICompilationUnit) {
            this.ensureNotAdaptable((ICompilationUnit)element, signaller);
        } else if (element instanceof IType) {
            this.ensureNotAdaptable((IType)element, signaller);
        } else if (element instanceof IPackageDeclaration) {
            this.ensureNotAdaptable((IPackageDeclaration)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureNotAdaptable((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureNotAdaptable((IJavaProject)element, signaller);
        }
    }

    public void ensureNotAdaptable(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(ICompilationUnit module, MultiChangeSignaller signaller) {
        if (module != null) {
            this.internalEnsureNotAdaptable(module, signaller);
        }
    }

    public void internalEnsureNotAdaptable(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAdaptable(module, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAdaptable(ICompilationUnit module, MultiChangeSignaller signaller) {
        IType primaryType = module.findPrimaryType();
        if (primaryType != null) {
            this.internalEnsureNotAdaptable(primaryType, signaller);
        }
    }

    public void ensureNotAdaptable(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(IType type, MultiChangeSignaller signaller) {
        if (this.isAdaptable(type)) {
            this.baseEnsureNotAdaptable(type, signaller);
        }
    }

    public void baseEnsureNotAdaptable(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureNotAdaptable(type, signaller);
    }

    public void internalEnsureNotAdaptable(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAdaptable(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAdaptable(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureNotLocked(type, signaller);
        this.internalEnsureNotBootJarClass(type, signaller);
        this.internalEnsureNotAdaptable(PatternHelper.getFullyQualifiedName(type), signaller);
        try {
            IMethod[] methods;
            IType[] childTypes;
            IField[] fields = type.getFields();
            if (fields != null) {
                for (int i = 0; i < fields.length; ++i) {
                    this.internalEnsureNotRoot(fields[i], signaller);
                }
            }
            if ((childTypes = type.getTypes()) != null) {
                for (int i = 0; i < childTypes.length; ++i) {
                    this.internalEnsureNotAdaptable(childTypes[i], signaller);
                    this.internalEnsureNotBootJarClass(childTypes[i], signaller);
                }
            }
            if ((methods = type.getMethods()) != null) {
                for (int i = 0; i < methods.length; ++i) {
                    this.internalEnsureNotLocked(methods[i], signaller);
                    this.internalEnsureLocalMethod(methods[i], signaller);
                }
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        this.testRemoveInstrumentedClasses();
    }

    public void ensureNotAdaptable(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (this.isAdaptable(packageDecl)) {
            this.internalEnsureNotAdaptable(packageDecl, signaller);
        }
    }

    public void internalEnsureNotAdaptable(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAdaptable(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAdaptable(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        this.internalEnsureNotLocked(packageDecl, signaller);
        this.internalEnsureNotAdaptable(PatternHelper.getWithinPattern(packageDecl), signaller);
    }

    public void ensureNotAdaptable(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (this.isAdaptable(fragment)) {
            this.internalEnsureNotAdaptable(fragment, signaller);
        }
    }

    public void internalEnsureNotAdaptable(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAdaptable(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAdaptable(IPackageFragment fragment, MultiChangeSignaller signaller) {
        this.internalEnsureNotLocked(fragment, signaller);
        try {
            ICompilationUnit[] cus = fragment.getCompilationUnits();
            if (cus != null) {
                for (int i = 0; i < cus.length; ++i) {
                    this.internalEnsureNotAdaptable(cus[i], signaller);
                }
            }
        }
        catch (JavaModelException jme) {
            this.internalEnsureNotAdaptable(PatternHelper.getWithinPattern(fragment), signaller);
        }
    }

    public void ensureNotAdaptable(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null) {
            IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
            for (int i = 0; i < fragments.length; ++i) {
                this.internalEnsureNotAdaptable(fragments[i], signaller);
            }
        }
    }

    public void ensureNotAdaptable(String classExpr) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAdaptable(classExpr, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAdaptable(String classExpr, MultiChangeSignaller signaller) {
        if (this.isAdaptable(classExpr)) {
            this.internalEnsureNotAdaptable(classExpr, signaller);
        }
    }

    public void internalEnsureNotAdaptable(String classExpr, MultiChangeSignaller signaller) {
        InstrumentedClasses classes = this.getInstrumentedClasses();
        if (classes != null) {
            int size = classes.sizeOfIncludeArray();
            for (int i = size - 1; i >= 0; --i) {
                String expr = classes.getIncludeArray(i).getClassExpression();
                if (!this.m_patternHelper.matchesClass(expr, classExpr)) continue;
                classes.removeInclude(i);
                signaller.includeRulesChanged = true;
            }
        }
    }

    public boolean isExcluded(IJavaElement element) {
        if (element instanceof ICompilationUnit) {
            return this.isExcluded((ICompilationUnit)element);
        }
        if (element instanceof IType) {
            return this.isExcluded((IType)element);
        }
        if (element instanceof IPackageDeclaration) {
            return this.isExcluded(element.getElementName());
        }
        if (element instanceof IPackageFragment) {
            return this.isExcluded((IPackageFragment)element);
        }
        if (element instanceof IJavaProject) {
            return this.isExcluded((IJavaProject)element);
        }
        return false;
    }

    public boolean isExcluded(ICompilationUnit module) {
        return this.isExcluded(module.findPrimaryType());
    }

    public boolean isExcluded(IType type) {
        return type != null && this.isExcluded(PatternHelper.getFullyQualifiedName(type));
    }

    private Boolean isExcluded(IPackageFragment fragment, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesPackageFragment(expr, fragment)) continue;
                    return Boolean.FALSE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesPackageFragment(expr = ((ClassExpression)object).getStringValue(), fragment)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isExcluded(IPackageFragment fragment) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean excluded;
            Boolean excluded2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (excluded2 = this.isExcluded(fragment, instrumentedClasses)) != null) {
                return excluded2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (excluded = this.isExcluded(fragment, instrumentedClasses)) != null) {
                return excluded;
            }
        }
        return false;
    }

    public boolean isExcluded(IJavaProject javaProject) {
        IPackageFragment[] fragments;
        if (javaProject != null && (fragments = ConfigurationHelper.getSourceFragments(javaProject)).length > 0) {
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isExcluded(fragments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public Boolean isExcluded(String classExpr, InstrumentedClasses instrumentedClasses) {
        XmlObject[] objects;
        if (instrumentedClasses != null && (objects = instrumentedClasses.selectPath("*")) != null && objects.length > 0) {
            for (int i = objects.length - 1; i >= 0; --i) {
                String expr;
                XmlObject object = objects[i];
                if (object instanceof Include) {
                    expr = ((Include)object).getClassExpression();
                    if (!this.m_patternHelper.matchesClass(expr, classExpr)) continue;
                    return Boolean.FALSE;
                }
                if (!(object instanceof ClassExpression) || !this.m_patternHelper.matchesClass(expr = ((ClassExpression)object).getStringValue(), classExpr)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isExcluded(String classExpr) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean excluded;
            Boolean excluded2;
            InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
            if (instrumentedClasses != null && (excluded2 = this.isExcluded(classExpr, instrumentedClasses)) != null) {
                return excluded2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (instrumentedClasses = modulesConfig.getApplication().getInstrumentedClasses()) != null && (excluded = this.isExcluded(classExpr, instrumentedClasses)) != null) {
                return excluded;
            }
        }
        return false;
    }

    public void ensureExcluded(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof ICompilationUnit) {
            this.ensureExcluded((ICompilationUnit)element, signaller);
        } else if (element instanceof IType) {
            this.ensureExcluded((IType)element, signaller);
        } else if (element instanceof IPackageDeclaration) {
            this.ensureExcluded(element.getElementName(), signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureExcluded((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureExcluded((IJavaProject)element, signaller);
        }
    }

    public void ensureExcluded(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(ICompilationUnit module, MultiChangeSignaller signaller) {
        if (module != null) {
            this.internalEnsureExcluded(module, signaller);
        }
    }

    public void internalEnsureExcluded(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureExcluded(module, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureExcluded(ICompilationUnit module, MultiChangeSignaller signaller) {
        this.internalEnsureExcluded(module.findPrimaryType(), signaller);
    }

    public void ensureExcluded(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(IType type, MultiChangeSignaller signaller) {
        if (type != null && !this.isExcluded(type)) {
            this.internalEnsureExcluded(type, signaller);
        }
    }

    public void internalEnsureExcluded(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureExcluded(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureExcluded(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureExcluded(PatternHelper.getFullyQualifiedName(type), signaller);
    }

    public void ensureExcluded(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (fragment != null && !this.isExcluded(fragment)) {
            this.internalEnsureExcluded(fragment, signaller);
        }
    }

    public void internalEnsureExcluded(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureExcluded(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureExcluded(IPackageFragment fragment, MultiChangeSignaller signaller) {
        this.internalEnsureExcluded(PatternHelper.getWithinPattern(fragment), signaller);
    }

    public void ensureExcluded(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null) {
            IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
            for (int i = 0; i < fragments.length; ++i) {
                this.internalEnsureExcluded(fragments[i], signaller);
            }
        }
    }

    public void ensureExcluded(String className) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureExcluded(className, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureExcluded(String className, MultiChangeSignaller signaller) {
        if (className != null && !this.isExcluded(className)) {
            this.internalEnsureExcluded(className, signaller);
        }
    }

    public void internalEnsureExcluded(String className, MultiChangeSignaller signaller) {
        this.ensureInstrumentedClasses().addExclude(className);
        signaller.excludeRulesChanged = true;
    }

    public void ensureNotExcluded(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof ICompilationUnit) {
            this.ensureNotExcluded((ICompilationUnit)element, signaller);
        } else if (element instanceof IType) {
            this.ensureNotExcluded((IType)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureNotExcluded((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureNotExcluded((IJavaProject)element, signaller);
        }
    }

    public void ensureNotExcluded(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(ICompilationUnit module, MultiChangeSignaller signaller) {
        if (module != null) {
            this.internalEnsureNotExcluded(module, signaller);
        }
    }

    public void internalEnsureNotExcluded(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotExcluded(module, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotExcluded(ICompilationUnit module, MultiChangeSignaller signaller) {
        this.internalEnsureNotExcluded(module.findPrimaryType(), signaller);
    }

    public void ensureNotExcluded(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(IType type, MultiChangeSignaller signaller) {
        if (type != null && this.isExcluded(type)) {
            this.baseEnsureNotExcluded(PatternHelper.getFullyQualifiedName(type), signaller);
        }
    }

    public void baseEnsureNotExcluded(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureNotExcluded(type, signaller);
    }

    public void internalEnsureNotExcluded(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotExcluded(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotExcluded(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureNotExcluded(PatternHelper.getFullyQualifiedName(type), signaller);
    }

    public void ensureNotExcluded(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (fragment != null) {
            this.ensureNotExcluded(PatternHelper.getWithinPattern(fragment), signaller);
        }
    }

    public void internalEnsureNotExcluded(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotExcluded(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotExcluded(IPackageFragment fragment, MultiChangeSignaller signaller) {
        this.internalEnsureNotExcluded(PatternHelper.getWithinPattern(fragment), signaller);
    }

    public void ensureNotExcluded(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null) {
            IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
            for (int i = 0; i < fragments.length; ++i) {
                this.internalEnsureNotExcluded(fragments[i], signaller);
            }
        }
    }

    public void ensureNotExcluded(String classExpr) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotExcluded(classExpr, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotExcluded(String classExpr, MultiChangeSignaller signaller) {
        if (this.isExcluded(classExpr)) {
            this.baseEnsureNotExcluded(classExpr, signaller);
        }
    }

    public void baseEnsureNotExcluded(String classExpr, MultiChangeSignaller signaller) {
        this.internalEnsureNotExcluded(classExpr, signaller);
    }

    public void internalEnsureNotExcluded(String classExpr) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotExcluded(classExpr, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotExcluded(String classExpr, MultiChangeSignaller signaller) {
        InstrumentedClasses classes = this.getInstrumentedClasses();
        if (classes != null) {
            int size = classes.sizeOfExcludeArray();
            for (int i = size - 1; i >= 0; --i) {
                String expr = classes.getExcludeArray(i);
                if (!this.m_patternHelper.matchesClass(expr, classExpr)) continue;
                classes.removeExclude(i);
                signaller.excludeRulesChanged = true;
            }
        }
    }

    public static String getFullName(IField field) {
        IType type = field.getDeclaringType();
        String parentType = PatternHelper.getFullyQualifiedName(type);
        String fieldName = field.getElementName();
        return parentType + "." + fieldName;
    }

    public Boolean isRoot(IField field, Roots roots) {
        if (roots != null) {
            for (int i = 0; i < roots.sizeOfRootArray(); ++i) {
                if (!this.m_patternHelper.matchesField(roots.getRootArray(i), field)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isRoot(IField field) {
        if (field == null) {
            return false;
        }
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isRoot;
            Boolean isRoot2;
            Roots roots = this.getRoots();
            if (roots != null && (isRoot2 = this.isRoot(field, roots)) != null) {
                return isRoot2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (roots = modulesConfig.getApplication().getRoots()) != null && (isRoot = this.isRoot(field, roots)) != null) {
                return isRoot;
            }
        }
        return false;
    }

    public boolean isRoot(String className, String fieldName) {
        return this.isRoot(className + "." + fieldName);
    }

    public boolean isRoot(String fieldName) {
        return this.isRoot(this.getField(fieldName));
    }

    public void ensureRoot(IField field) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureRoot(field, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureRoot(IField field, MultiChangeSignaller signaller) {
        if (!this.isRoot(field)) {
            IType fieldType = this.getFieldType(field);
            if (fieldType != null && !ConfigurationHelper.isInterface(fieldType) && !this.isAdaptable(fieldType)) {
                this.internalEnsureAdaptable(fieldType, signaller);
            }
            if (this.isTransient(field)) {
                this.ensureNotTransient(field, signaller);
            }
            this.internalEnsureRoot(ConfigurationHelper.getFullName(field), signaller);
        }
    }

    public IType getFieldType(IField field) {
        try {
            String sig = field.getTypeSignature();
            IType declaringType = field.getDeclaringType();
            String typeName = JdtUtils.getResolvedTypeName(sig, declaringType);
            if (typeName != null) {
                return JdtUtils.findType(this.m_javaProject, typeName);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return null;
    }

    public IField getField(String fieldName) {
        int lastDot = fieldName.lastIndexOf(46);
        if (lastDot != -1) {
            String declaringTypeName = fieldName.substring(0, lastDot);
            try {
                IType declaringType = JdtUtils.findType(this.m_javaProject, declaringTypeName);
                if (declaringType != null) {
                    return declaringType.getField(fieldName.substring(lastDot + 1));
                }
            }
            catch (JavaModelException jme) {
                // empty catch block
            }
        }
        return null;
    }

    public IType getFieldType(String fieldName) {
        IField field = this.getField(fieldName);
        if (field != null) {
            try {
                String sig = field.getTypeSignature();
                IType declaringType = field.getDeclaringType();
                String typeName = JdtUtils.getResolvedTypeName(sig, declaringType);
                return JdtUtils.findType(this.m_javaProject, typeName);
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
        }
        return null;
    }

    public void ensureRoot(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureRoot(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureRoot(String fieldName, MultiChangeSignaller signaller) {
        if (!this.isRoot(fieldName)) {
            IType fieldType = this.getFieldType(fieldName);
            if (fieldType != null && !this.isAdaptable(fieldType)) {
                this.ensureAdaptable(fieldType, signaller);
            }
            if (this.isTransient(fieldName)) {
                this.ensureNotTransient(fieldName, signaller);
            }
            this.internalEnsureRoot(fieldName, signaller);
        }
    }

    public void internalEnsureRoot(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureRoot(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureRoot(String fieldName, MultiChangeSignaller signaller) {
        this.ensureRoots().addNewRoot().setFieldName(fieldName);
        signaller.rootsChanged = true;
    }

    public void ensureNotRoot(IField field) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotRoot(field, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotRoot(IField field, MultiChangeSignaller signaller) {
        if (field != null && this.isRoot(field)) {
            this.baseEnsureNotRoot(field, signaller);
        }
    }

    public void baseEnsureNotRoot(IField field, MultiChangeSignaller signaller) {
        this.internalEnsureNotRoot(field, signaller);
    }

    public void internalEnsureNotRoot(IField field) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotRoot(field, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotRoot(IField field, MultiChangeSignaller signaller) {
        this.internalEnsureNotRoot(ConfigurationHelper.getFullName(field), signaller);
    }

    public void ensureNotRoot(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotRoot(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotRoot(String fieldName, MultiChangeSignaller signaller) {
        if (this.isRoot(fieldName)) {
            this.baseEnsureNotRoot(fieldName, signaller);
        }
    }

    public void baseEnsureNotRoot(String fieldName, MultiChangeSignaller signaller) {
        this.internalEnsureNotRoot(fieldName, signaller);
    }

    public void internalEnsureNotRoot(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotRoot(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotRoot(String fieldName, MultiChangeSignaller signaller) {
        Roots roots = this.getRoots();
        if (roots != null) {
            int size = roots.sizeOfRootArray();
            for (int i = size - 1; i >= 0; --i) {
                if (!fieldName.equals(roots.getRootArray(i).getFieldName())) continue;
                roots.removeRoot(i);
                signaller.rootsChanged = true;
            }
            this.testRemoveRoots();
        }
    }

    public void renameRoot(String fieldName, String newFieldName) {
        if (this.isRoot(fieldName)) {
            this.internalRenameRoot(fieldName, newFieldName);
            this.m_plugin.fireRootsChanged(this.m_project);
        }
    }

    public void internalRenameRoot(String fieldName, String newFieldName) {
        Roots roots = this.getRoots();
        if (roots != null) {
            for (int i = 0; i < roots.sizeOfRootArray(); ++i) {
                Root root = roots.getRootArray(i);
                if (!fieldName.equals(root.getFieldName())) continue;
                root.setFieldName(newFieldName);
                return;
            }
        }
    }

    public boolean isTransient(IField field) {
        return field != null && this.isTransient(ConfigurationHelper.getFullName(field));
    }

    public boolean isTransient(String className, String fieldName) {
        return this.isTransient(className + "." + fieldName);
    }

    private Boolean isTransient(String fieldName, TransientFields transientFields) {
        if (transientFields != null) {
            for (int i = 0; i < transientFields.sizeOfFieldNameArray(); ++i) {
                if (!fieldName.equals(transientFields.getFieldNameArray(i))) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isTransient(String fieldName) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isTransient;
            Boolean isTransient2;
            TransientFields transientFields = this.getTransientFields();
            if (transientFields != null && (isTransient2 = this.isTransient(fieldName, transientFields)) != null) {
                return isTransient2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (transientFields = modulesConfig.getApplication().getTransientFields()) != null && (isTransient = this.isTransient(fieldName, transientFields)) != null) {
                return isTransient;
            }
        }
        return false;
    }

    public void ensureTransient(IField field) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureTransient(field, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureTransient(IField field, MultiChangeSignaller signaller) {
        if (field != null && !this.isTransient(field)) {
            IType declaringType;
            if (this.isRoot(field)) {
                this.internalEnsureNotRoot(field, signaller);
            }
            if (!this.isAdaptable(declaringType = field.getDeclaringType())) {
                this.internalEnsureAdaptable(declaringType, signaller);
            }
            this.internalEnsureTransient(ConfigurationHelper.getFullName(field), signaller);
        }
    }

    public void ensureTransient(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureTransient(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureTransient(String fieldName, MultiChangeSignaller signaller) {
        if (!this.isTransient(fieldName)) {
            IType fieldType;
            IField field = this.getField(fieldName);
            if (field != null && !this.isAdaptable(fieldType = field.getDeclaringType())) {
                this.ensureAdaptable(fieldType, signaller);
            }
            if (this.isRoot(fieldName)) {
                this.ensureNotRoot(fieldName, signaller);
            }
            this.internalEnsureTransient(fieldName, signaller);
        }
    }

    public void internalEnsureTransient(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureTransient(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureTransient(String fieldName, MultiChangeSignaller signaller) {
        this.ensureTransientFields().addFieldName(fieldName);
        signaller.transientFieldsChanged = true;
    }

    public void ensureNotTransient(IField field) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotTransient(field, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotTransient(IField field, MultiChangeSignaller signaller) {
        if (field != null) {
            this.ensureNotTransient(ConfigurationHelper.getFullName(field), signaller);
        }
    }

    public void ensureNotTransient(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotTransient(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotTransient(String fieldName, MultiChangeSignaller signaller) {
        if (this.isTransient(fieldName)) {
            this.internalEnsureNotTransient(fieldName, signaller);
        }
    }

    public void internalEnsureNotTransient(String fieldName) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotTransient(fieldName, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotTransient(String fieldName, MultiChangeSignaller signaller) {
        TransientFields transients = this.getTransientFields();
        if (transients != null) {
            for (int i = transients.sizeOfFieldNameArray() - 1; i >= 0; --i) {
                if (!fieldName.equals(transients.getFieldNameArray(i))) continue;
                transients.removeFieldName(i);
                signaller.transientFieldsChanged = true;
            }
            this.testRemoveTransientFields();
        }
    }

    private TransientFields getTransientFields() {
        DsoApplication dsoApp = this.getDsoApplication();
        return dsoApp != null ? dsoApp.getTransientFields() : null;
    }

    private TransientFields ensureTransientFields() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        TransientFields transients = dsoApp.getTransientFields();
        if (transients == null) {
            transients = dsoApp.addNewTransientFields();
        }
        return transients;
    }

    private void testRemoveTransientFields() {
        TransientFields transients;
        DsoApplication dsoApp = this.getDsoApplication();
        if (dsoApp != null && (transients = dsoApp.getTransientFields()) != null && transients.sizeOfFieldNameArray() == 0) {
            dsoApp.unsetTransientFields();
            this.testRemoveDsoApplication();
        }
    }

    public boolean matches(String expression, MemberInfo methodInfo) {
        return this.m_patternHelper.matchesMember(expression, methodInfo);
    }

    public boolean matches(String expression, IMethod method) {
        return this.m_patternHelper.matchesMethod(expression, method);
    }

    public boolean isDistributedMethod(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding != null && !binding.getDeclaringClass().isInterface()) {
            return this.isDistributedMethod(PatternHelper.methodDecl2IMethod(methodDecl));
        }
        return false;
    }

    public boolean isDistributedMethod(IMethod method) {
        MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
        return methodInfo != null && this.isDistributedMethod(methodInfo);
    }

    private Boolean isDistributedMethod(MethodInfo methodInfo, DistributedMethods distributedMethods) {
        if (distributedMethods != null) {
            for (int i = 0; i < distributedMethods.sizeOfMethodExpressionArray(); ++i) {
                String expr = distributedMethods.getMethodExpressionArray(i).getStringValue();
                if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isDistributedMethod(MethodInfo methodInfo) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isDistributedMethod;
            Boolean isDistributedMethod2;
            DistributedMethods distributedMethods = this.getDistributedMethods();
            if (distributedMethods != null && (isDistributedMethod2 = this.isDistributedMethod(methodInfo, distributedMethods)) != null) {
                return isDistributedMethod2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (distributedMethods = modulesConfig.getApplication().getDistributedMethods()) != null && (isDistributedMethod = this.isDistributedMethod(methodInfo, distributedMethods)) != null) {
                return isDistributedMethod;
            }
        }
        return false;
    }

    public void ensureDistributedMethod(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureDistributedMethod(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureDistributedMethod(IMethod method, MultiChangeSignaller signaller) {
        if (!this.isDistributedMethod(method)) {
            this.internalEnsureDistributedMethod(method, signaller);
        }
    }

    public void internalEnsureDistributedMethod(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureDistributedMethod(method, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureDistributedMethod(IMethod method, MultiChangeSignaller signaller) {
        IType declaringType = method.getDeclaringType();
        if (!this.isAdaptable(declaringType)) {
            this.internalEnsureAdaptable(declaringType, signaller);
        }
        DistributedMethods methods = this.ensureDistributedMethods();
        DistributedMethods.MethodExpression methodExpression = methods.addNewMethodExpression();
        try {
            methodExpression.setStringValue(PatternHelper.getJavadocSignature(method));
        }
        catch (JavaModelException jme) {
            this.openError("Error ensuring method '" + method.getElementName() + "' distributed", jme);
            return;
        }
        signaller.distributedMethodsChanged = true;
    }

    public void ensureLocalMethod(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureLocalMethod(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureLocalMethod(IMethod method, MultiChangeSignaller signaller) {
        if (this.isDistributedMethod(method)) {
            this.internalEnsureLocalMethod(method, signaller);
        }
    }

    public void internalEnsureLocalMethod(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureLocalMethod(method, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureLocalMethod(IMethod method, MultiChangeSignaller signaller) {
        DistributedMethods methods = this.getDistributedMethods();
        if (methods != null) {
            for (int i = methods.sizeOfMethodExpressionArray() - 1; i >= 0; --i) {
                String expr = methods.getMethodExpressionArray(i).getStringValue();
                if (!this.m_patternHelper.matchesMethod(expr, method)) continue;
                methods.removeMethodExpression(i);
                signaller.distributedMethodsChanged = true;
            }
            this.testRemoveDistributedMethods();
        }
    }

    public boolean isLocked(IMethod method) {
        try {
            if (!method.getDeclaringType().isInterface()) {
                return this.isAutolocked(method) || this.isNameLocked(method);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    public boolean isLocked(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding != null && !binding.getDeclaringClass().isInterface()) {
            return this.isLocked(PatternHelper.methodDecl2IMethod(methodDecl));
        }
        return false;
    }

    public boolean isAutolocked(IJavaElement element) {
        if (element instanceof IMethod) {
            return this.isAutolocked((IMethod)element);
        }
        if (element instanceof IType) {
            return this.isAutolocked((IType)element);
        }
        if (element instanceof ICompilationUnit) {
            return this.isAutolocked((ICompilationUnit)element);
        }
        if (element instanceof IPackageDeclaration) {
            return this.isAutolocked((IPackageDeclaration)element);
        }
        if (element instanceof IPackageFragment) {
            return this.isAutolocked((IPackageFragment)element);
        }
        if (element instanceof IJavaProject) {
            return this.isAutolocked((IJavaProject)element);
        }
        return false;
    }

    public XmlObject getLock(IMethod method) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
            Locks locks = this.getLocks();
            if (locks != null) {
                String expr;
                int i;
                for (i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
                    Autolock autolock = locks.getAutolockArray(i);
                    expr = autolock.getMethodExpression();
                    if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                    return autolock;
                }
                for (i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
                    NamedLock namedLock = locks.getNamedLockArray(i);
                    expr = namedLock.getMethodExpression();
                    if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                    return namedLock;
                }
            }
        }
        return null;
    }

    public boolean isAutolocked(IMethod method) {
        try {
            if (!method.getDeclaringType().isInterface()) {
                MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
                return methodInfo != null && this.isAutolocked(methodInfo);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private Boolean isAutolocked(MethodInfo methodInfo, Locks locks) {
        if (locks != null) {
            for (int i = 0; i < locks.sizeOfAutolockArray(); ++i) {
                Autolock autolock = locks.getAutolockArray(i);
                String expr = autolock.getMethodExpression();
                if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isAutolocked(MethodInfo methodInfo) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isAutolocked;
            Boolean isAutolocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isAutolocked2 = this.isAutolocked(methodInfo, locks)) != null) {
                return isAutolocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isAutolocked = this.isAutolocked(methodInfo, locks)) != null) {
                return isAutolocked;
            }
        }
        return false;
    }

    public boolean isAutolocked(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding != null && !binding.getDeclaringClass().isInterface()) {
            return this.isAutolocked(PatternHelper.methodDecl2IMethod(methodDecl));
        }
        return false;
    }

    public Boolean isAutolocked(IType type, Locks locks) {
        if (locks != null) {
            String typeExpr = PatternHelper.getExecutionPattern(type);
            for (int i = 0; i < locks.sizeOfAutolockArray(); ++i) {
                Autolock autolock = locks.getAutolockArray(i);
                String expr = autolock.getMethodExpression();
                if (!typeExpr.equals(expr)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isAutolocked(IType type) {
        try {
            if (type.isInterface()) {
                return false;
            }
        }
        catch (JavaModelException jme) {
            // empty catch block
        }
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isAutolocked;
            Boolean isAutolocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isAutolocked2 = this.isAutolocked(type, locks)) != null) {
                return isAutolocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isAutolocked = this.isAutolocked(type, locks)) != null) {
                return isAutolocked;
            }
        }
        return false;
    }

    public boolean isAutolocked(ICompilationUnit cu) {
        IType primaryType = cu.findPrimaryType();
        return primaryType != null ? this.isAutolocked(primaryType) : false;
    }

    public boolean isAutolocked(IPackageDeclaration packageDecl) {
        Locks locks;
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null && (locks = this.getLocks()) != null) {
            String fragExpr = PatternHelper.getExecutionPattern(packageDecl);
            for (int i = 0; i < locks.sizeOfAutolockArray(); ++i) {
                Autolock autolock = locks.getAutolockArray(i);
                String expr = autolock.getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAutolocked(IPackageFragment fragment) {
        Locks locks;
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null && (locks = this.getLocks()) != null) {
            String fragExpr = PatternHelper.getExecutionPattern(fragment);
            for (int i = 0; i < locks.sizeOfAutolockArray(); ++i) {
                Autolock autolock = locks.getAutolockArray(i);
                String expr = autolock.getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isAutolocked(IJavaProject javaProject) {
        IPackageFragment[] fragments;
        if (javaProject != null && (fragments = ConfigurationHelper.getSourceFragments(javaProject)).length > 0) {
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isAutolocked(fragments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean isNameLocked(IJavaElement element) {
        if (element instanceof IMethod) {
            return this.isNameLocked((IMethod)element);
        }
        if (element instanceof IType) {
            return this.isNameLocked((IType)element);
        }
        if (element instanceof IPackageDeclaration) {
            return this.isNameLocked((IPackageDeclaration)element);
        }
        if (element instanceof IPackageFragment) {
            return this.isNameLocked((IPackageFragment)element);
        }
        if (element instanceof IJavaProject) {
            return this.isNameLocked((IJavaProject)element);
        }
        return false;
    }

    public boolean isNameLocked(IMethod method) {
        try {
            if (!method.getDeclaringType().isInterface()) {
                MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
                return methodInfo != null && this.isNameLocked(methodInfo);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return false;
    }

    private Boolean isNameLocked(MethodInfo methodInfo, Locks locks) {
        if (locks != null) {
            for (int i = 0; i < locks.sizeOfNamedLockArray(); ++i) {
                NamedLock namedLock = locks.getNamedLockArray(i);
                String expr = namedLock.getMethodExpression();
                if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isNameLocked(MethodInfo methodInfo) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isNameLocked;
            Boolean isNameLocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isNameLocked2 = this.isNameLocked(methodInfo, locks)) != null) {
                return isNameLocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isNameLocked = this.isNameLocked(methodInfo, locks)) != null) {
                return isNameLocked;
            }
        }
        return false;
    }

    public boolean isNameLocked(MethodDeclaration methodDecl) {
        IMethodBinding binding = methodDecl.resolveBinding();
        if (binding != null && !binding.getDeclaringClass().isInterface()) {
            return this.isNameLocked(PatternHelper.methodDecl2IMethod(methodDecl));
        }
        return false;
    }

    private Boolean isNameLocked(IType type, Locks locks) {
        if (locks != null) {
            String typeExpr = PatternHelper.getExecutionPattern(type);
            for (int i = 0; i < locks.sizeOfNamedLockArray(); ++i) {
                NamedLock namedLock = locks.getNamedLockArray(i);
                String expr = namedLock.getMethodExpression();
                if (!typeExpr.equals(expr)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isNameLocked(IType type) {
        try {
            if (type.isInterface()) {
                return false;
            }
        }
        catch (JavaModelException jme) {
            // empty catch block
        }
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isNameLocked;
            Boolean isNameLocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isNameLocked2 = this.isNameLocked(type, locks)) != null) {
                return isNameLocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isNameLocked = this.isNameLocked(type, locks)) != null) {
                return isNameLocked;
            }
        }
        return false;
    }

    private Boolean isNameLocked(IPackageDeclaration packageDecl, Locks locks) {
        String fragExpr = PatternHelper.getExecutionPattern(packageDecl);
        for (int i = 0; i < locks.sizeOfNamedLockArray(); ++i) {
            NamedLock namedLock = locks.getNamedLockArray(i);
            String expr = namedLock.getMethodExpression();
            if (!fragExpr.equals(expr)) continue;
            return Boolean.TRUE;
        }
        return null;
    }

    public boolean isNameLocked(IPackageDeclaration packageDecl) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isNameLocked;
            Boolean isNameLocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isNameLocked2 = this.isNameLocked(packageDecl, locks)) != null) {
                return isNameLocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isNameLocked = this.isNameLocked(packageDecl, locks)) != null) {
                return isNameLocked;
            }
        }
        return false;
    }

    private Boolean isNameLocked(IPackageFragment fragment, Locks locks) {
        if (locks != null) {
            String fragExpr = PatternHelper.getExecutionPattern(fragment);
            for (int i = 0; i < locks.sizeOfNamedLockArray(); ++i) {
                NamedLock namedLock = locks.getNamedLockArray(i);
                String expr = namedLock.getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isNameLocked(IPackageFragment fragment) {
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Boolean isNameLocked;
            Boolean isNameLocked2;
            Locks locks = this.getLocks();
            if (locks != null && (isNameLocked2 = this.isNameLocked(fragment, locks)) != null) {
                return isNameLocked2;
            }
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            if (modulesConfig != null && (locks = modulesConfig.getApplication().getLocks()) != null && (isNameLocked = this.isNameLocked(fragment, locks)) != null) {
                return isNameLocked;
            }
        }
        return false;
    }

    public boolean isNameLocked(IJavaProject javaProject) {
        IPackageFragment[] fragments;
        if (javaProject != null && (fragments = ConfigurationHelper.getSourceFragments(javaProject)).length > 0) {
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isNameLocked(fragments[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public void ensureNameLocked(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(element, element.getElementName(), LockLevel.WRITE, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IJavaElement element, MultiChangeSignaller signaller) {
        this.ensureNameLocked(element, element.getElementName(), LockLevel.WRITE, signaller);
    }

    public void ensureNameLocked(IJavaElement element, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(element, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IJavaElement element, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (element instanceof IMethod) {
            this.ensureNameLocked((IMethod)element, name, level, signaller);
        } else if (element instanceof IType) {
            this.ensureNameLocked((IType)element, name, level, signaller);
        } else if (element instanceof IPackageDeclaration) {
            this.ensureNameLocked((IPackageDeclaration)element, name, level, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureNameLocked((IPackageFragment)element, name, level, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureNameLocked((IJavaProject)element, name, level, signaller);
        }
    }

    public void ensureNameLocked(IMethod method, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(method, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IMethod method, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isNameLocked(method)) {
            this.internalEnsureNameLocked(method, name, level, signaller);
        }
    }

    public NamedLock addNewNamedLock(String name, IMethod method, LockLevel.Enum level, MultiChangeSignaller signaller) throws JavaModelException {
        return this.addNewNamedLock(name, PatternHelper.getJavadocSignature(method), level, signaller);
    }

    public NamedLock addNewNamedLock(String name, String expr, LockLevel.Enum level, MultiChangeSignaller signaller) {
        Locks locks = this.ensureLocks();
        NamedLock lock = locks.addNewNamedLock();
        lock.setMethodExpression(expr);
        lock.setLockLevel(level);
        lock.setLockName(name);
        signaller.namedLocksChanged = true;
        for (int i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
            Autolock autoLock = locks.getAutolockArray(i);
            if (!expr.equals(autoLock.getMethodExpression())) continue;
            locks.removeAutolock(i);
            signaller.autolocksChanged = true;
        }
        return lock;
    }

    public void internalEnsureNameLocked(IMethod method, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        IType declaringType = method.getDeclaringType();
        if (!this.isAdaptable(declaringType)) {
            this.internalEnsureAdaptable(declaringType);
            signaller.includeRulesChanged = true;
        }
        try {
            this.addNewNamedLock(name, PatternHelper.getJavadocSignature(method), level, signaller);
        }
        catch (JavaModelException jme) {
            this.openError("Error ensuring method '" + method.getElementName() + "' name-locked", jme);
            return;
        }
    }

    public void ensureNameLocked(IType type, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(type, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IType type, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isNameLocked(type)) {
            this.internalEnsureNameLocked(type, name, level, signaller);
        }
    }

    public void internalEnsureNameLocked(IType type, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNameLocked(type, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNameLocked(IType type, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(type)) {
            this.internalEnsureAdaptable(type, signaller);
        }
        this.addNewNamedLock(name, PatternHelper.getExecutionPattern(type), level, signaller);
    }

    public void ensureNameLocked(IPackageDeclaration packageDecl, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(packageDecl, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IPackageDeclaration packageDecl, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isNameLocked(packageDecl)) {
            this.internalEnsureNameLocked(packageDecl, name, level, signaller);
        }
    }

    public void internalEnsureNameLocked(IPackageDeclaration packageDecl, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNameLocked(packageDecl, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNameLocked(IPackageDeclaration packageDecl, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(packageDecl)) {
            this.internalEnsureAdaptable(packageDecl, signaller);
        }
        this.addNewNamedLock(name, PatternHelper.getExecutionPattern(packageDecl), level, signaller);
    }

    public void ensureNameLocked(IPackageFragment fragment, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(fragment, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IPackageFragment fragment, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isNameLocked(fragment)) {
            this.internalEnsureNameLocked(fragment, name, level, signaller);
        }
    }

    public void internalEnsureNameLocked(IPackageFragment fragment, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNameLocked(fragment, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNameLocked(IPackageFragment fragment, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(fragment)) {
            this.internalEnsureAdaptable(fragment, signaller);
        }
        this.addNewNamedLock(name, PatternHelper.getExecutionPattern(fragment), level, signaller);
    }

    public void ensureNameLocked(IJavaProject javaProject, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNameLocked(javaProject, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNameLocked(IJavaProject javaProject, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (javaProject != null && !this.isNameLocked(javaProject)) {
            this.internalEnsureNameLocked(javaProject, name, level, signaller);
        }
    }

    public void internalEnsureNameLocked(IJavaProject javaProject, String name, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNameLocked(javaProject, name, level, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNameLocked(IJavaProject javaProject, String name, LockLevel.Enum level, MultiChangeSignaller signaller) {
        IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
        for (int i = 0; i < fragments.length; ++i) {
            if (this.isNameLocked(fragments[i])) continue;
            this.internalEnsureNameLocked(fragments[i], name, level, signaller);
        }
    }

    public void ensureAutolocked(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof IMethod) {
            this.ensureAutolocked((IMethod)element, signaller);
        } else if (element instanceof IType) {
            this.ensureAutolocked((IType)element, signaller);
        } else if (element instanceof ICompilationUnit) {
            this.ensureAutolocked((ICompilationUnit)element, signaller);
        } else if (element instanceof IPackageDeclaration) {
            this.ensureAutolocked((IPackageDeclaration)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureAutolocked((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureAutolocked((IJavaProject)element, signaller);
        }
    }

    public void ensureAutolocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IMethod method, MultiChangeSignaller signaller) {
        if (!this.isAutolocked(method)) {
            this.internalEnsureAutolocked(method, LockLevel.WRITE, signaller);
        }
    }

    public void ensureAutolocked(IMethod method, LockLevel.Enum level, MultiChangeSignaller signaller) {
        if (!this.isAutolocked(method)) {
            this.internalEnsureAutolocked(method, level, signaller);
        }
    }

    public void internalEnsureAutolocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAutolocked(method, LockLevel.WRITE, signaller);
        signaller.signal(this.m_project);
    }

    public Autolock addNewAutolock(IMethod method, LockLevel.Enum level, MultiChangeSignaller signaller) throws JavaModelException {
        return this.addNewAutolock(PatternHelper.getJavadocSignature(method), level, signaller);
    }

    public Autolock addNewAutolock(String expr, LockLevel.Enum level) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        Autolock lock = this.addNewAutolock(expr, level, signaller);
        signaller.signal(this.m_project);
        return lock;
    }

    public Autolock addNewAutolock(String expr, LockLevel.Enum level, MultiChangeSignaller signaller) {
        Locks locks = this.ensureLocks();
        Autolock lock = locks.addNewAutolock();
        lock.setMethodExpression(expr);
        lock.setLockLevel(level);
        signaller.autolocksChanged = true;
        for (int i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
            NamedLock namedLock = locks.getNamedLockArray(i);
            if (!expr.equals(namedLock.getMethodExpression())) continue;
            locks.removeNamedLock(i);
            signaller.namedLocksChanged = true;
        }
        return lock;
    }

    public void internalEnsureAutolocked(IMethod method, LockLevel.Enum level, MultiChangeSignaller signaller) {
        IType declaringType = method.getDeclaringType();
        if (!this.isAdaptable(declaringType)) {
            this.internalEnsureAdaptable(declaringType, signaller);
        }
        try {
            this.addNewAutolock(PatternHelper.getJavadocSignature(method), level, signaller);
        }
        catch (JavaModelException jme) {
            this.openError("Error ensuring method '" + method.getElementName() + "' auto-locked", jme);
            return;
        }
    }

    public void ensureAutolocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IType type, MultiChangeSignaller signaller) {
        if (!this.isAutolocked(type)) {
            this.internalEnsureAutolocked(type, signaller);
        }
    }

    public void internalEnsureAutolocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAutolocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAutolocked(IType type, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(type)) {
            this.internalEnsureAdaptable(type, signaller);
        }
        this.addNewAutolock(PatternHelper.getExecutionPattern(type), LockLevel.WRITE, signaller);
    }

    public void ensureAutolocked(ICompilationUnit cu, MultiChangeSignaller signaller) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            this.ensureAutolocked(primaryType, signaller);
        }
    }

    public void ensureAutolocked(ICompilationUnit cu) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            this.ensureAutolocked(primaryType);
        }
    }

    public void ensureAutolocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (!this.isAutolocked(packageDecl)) {
            this.internalEnsureAutolocked(packageDecl, signaller);
        }
    }

    public void internalEnsureAutolocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAutolocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAutolocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(packageDecl)) {
            this.internalEnsureAdaptable(packageDecl, signaller);
        }
        this.addNewAutolock(PatternHelper.getExecutionPattern(packageDecl), LockLevel.WRITE, signaller);
    }

    public void ensureAutolocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (!this.isAutolocked(fragment)) {
            this.internalEnsureAutolocked(fragment, signaller);
        }
    }

    public void internalEnsureAutolocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAutolocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAutolocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (!this.isAdaptable(fragment)) {
            this.internalEnsureAdaptable(fragment, signaller);
        }
        this.addNewAutolock(PatternHelper.getExecutionPattern(fragment), LockLevel.WRITE, signaller);
    }

    public void ensureAutolocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureAutolocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureAutolocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null && !this.isAutolocked(javaProject)) {
            this.internalEnsureAutolocked(javaProject, signaller);
        }
    }

    public void internalEnsureAutolocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureAutolocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureAutolocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null) {
            IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isAutolocked(fragments[i])) continue;
                this.internalEnsureAutolocked(fragments[i], signaller);
            }
        }
    }

    public void ensureNotNameLocked(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof IMethod) {
            this.ensureNotNameLocked((IMethod)element, signaller);
        } else if (element instanceof IType) {
            this.ensureNotNameLocked((IType)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureNotNameLocked((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureNotNameLocked((IJavaProject)element, signaller);
        }
    }

    public void ensureNotNameLocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IMethod method, MultiChangeSignaller signaller) {
        MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
        if (methodInfo != null) {
            this.ensureNotNameLocked(methodInfo, signaller);
        }
    }

    public void ensureNotNameLocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        if (this.isNameLocked(methodInfo)) {
            this.internalEnsureNotNameLocked(methodInfo, signaller);
        }
    }

    public void internalEnsureNotNameLocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotNameLocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotNameLocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            for (int i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
                String expr = locks.getNamedLockArray(i).getMethodExpression();
                if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                locks.removeNamedLock(i);
                signaller.namedLocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotNameLocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IType type, MultiChangeSignaller signaller) {
        if (this.isNameLocked(type)) {
            this.internalEnsureNotNameLocked(type, signaller);
        }
    }

    public void internalEnsureNotNameLocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotNameLocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotNameLocked(IType type, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String typeExpr = PatternHelper.getExecutionPattern(type);
            for (int i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
                String expr = locks.getNamedLockArray(i).getMethodExpression();
                if (!typeExpr.equals(expr)) continue;
                locks.removeNamedLock(i);
                signaller.namedLocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotNameLocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (this.isNameLocked(packageDecl)) {
            this.internalEnsureNotNameLocked(packageDecl, signaller);
        }
    }

    public void internalEnsureNotNameLocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotNameLocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotNameLocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String fragExpr = PatternHelper.getExecutionPattern(packageDecl);
            for (int i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
                String expr = locks.getNamedLockArray(i).getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                locks.removeNamedLock(i);
                signaller.namedLocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotNameLocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (this.isNameLocked(fragment)) {
            this.internalEnsureNotNameLocked(fragment, signaller);
        }
    }

    public void internalEnsureNotNameLocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotNameLocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotNameLocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String fragExpr = PatternHelper.getExecutionPattern(fragment);
            for (int i = locks.sizeOfNamedLockArray() - 1; i >= 0; --i) {
                String expr = locks.getNamedLockArray(i).getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                locks.removeNamedLock(i);
                signaller.namedLocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotNameLocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotNameLocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotNameLocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null && this.isNameLocked(javaProject)) {
            this.internalEnsureNotNameLocked(javaProject, signaller);
        }
    }

    public void internalEnsureNotNameLocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotNameLocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotNameLocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
        for (int i = 0; i < fragments.length; ++i) {
            if (!this.isNameLocked(fragments[i])) continue;
            this.internalEnsureNotNameLocked(fragments[i], signaller);
        }
    }

    public void ensureNotAutolocked(IJavaElement element) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(element, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IJavaElement element, MultiChangeSignaller signaller) {
        if (element instanceof IMethod) {
            this.ensureNotAutolocked((IMethod)element, signaller);
        } else if (element instanceof IType) {
            this.ensureNotAutolocked((IType)element, signaller);
        } else if (element instanceof ICompilationUnit) {
            this.ensureNotAutolocked((ICompilationUnit)element, signaller);
        } else if (element instanceof IPackageFragment) {
            this.ensureNotAutolocked((IPackageFragment)element, signaller);
        } else if (element instanceof IJavaProject) {
            this.ensureNotAutolocked((IJavaProject)element, signaller);
        }
    }

    public void ensureNotAutolocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IMethod method, MultiChangeSignaller signaller) {
        MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
        if (methodInfo != null) {
            this.ensureNotAutolocked(methodInfo, signaller);
        }
    }

    public void ensureNotAutolocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        if (this.isAutolocked(methodInfo)) {
            this.internalEnsureNotAutolocked(methodInfo, signaller);
        }
    }

    public void internalEnsureNotAutolocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAutolocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAutolocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            for (int i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
                String expr = locks.getAutolockArray(i).getMethodExpression();
                if (!this.m_patternHelper.matchesMember(expr, (MemberInfo)methodInfo)) continue;
                locks.removeAutolock(i);
                signaller.autolocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotAutolocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IType type, MultiChangeSignaller signaller) {
        if (this.isAutolocked(type)) {
            this.internalEnsureNotAutolocked(type, signaller);
        }
    }

    public void internalEnsureNotAutolocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAutolocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAutolocked(IType type, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String typeExpr = PatternHelper.getExecutionPattern(type);
            for (int i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
                String expr = locks.getAutolockArray(i).getMethodExpression();
                if (!typeExpr.equals(expr)) continue;
                locks.removeAutolock(i);
                signaller.autolocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotAutolocked(ICompilationUnit cu) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            this.ensureNotAutolocked(primaryType);
        }
    }

    public void ensureNotAutolocked(ICompilationUnit cu, MultiChangeSignaller signaller) {
        IType primaryType = cu.findPrimaryType();
        if (primaryType != null) {
            this.ensureNotAutolocked(primaryType, signaller);
        }
    }

    public void ensureNotAutolocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (this.isAutolocked(packageDecl)) {
            this.internalEnsureNotAutolocked(packageDecl, signaller);
        }
    }

    public void internalEnsureNotAutolocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAutolocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAutolocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String fragExpr = PatternHelper.getExecutionPattern(packageDecl);
            for (int i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
                String expr = locks.getAutolockArray(i).getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                locks.removeAutolock(i);
                signaller.autolocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotAutolocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (this.isAutolocked(fragment)) {
            this.internalEnsureNotAutolocked(fragment, signaller);
        }
    }

    public void internalEnsureNotAutolocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAutolocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAutolocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        Locks locks = this.getLocks();
        if (locks != null) {
            String fragExpr = PatternHelper.getExecutionPattern(fragment);
            for (int i = locks.sizeOfAutolockArray() - 1; i >= 0; --i) {
                String expr = locks.getAutolockArray(i).getMethodExpression();
                if (!fragExpr.equals(expr)) continue;
                locks.removeAutolock(i);
                signaller.autolocksChanged = true;
            }
            this.testRemoveLocks();
        }
    }

    public void ensureNotAutolocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotAutolocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotAutolocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null && this.isAutolocked(javaProject)) {
            this.internalEnsureNotAutolocked(javaProject, signaller);
        }
    }

    public void internalEnsureNotAutolocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotAutolocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotAutolocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
        for (int i = 0; i < fragments.length; ++i) {
            if (!this.isAutolocked(fragments[i])) continue;
            this.internalEnsureNotAutolocked(fragments[i], signaller);
        }
    }

    public void ensureNotLocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotLocked(method, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotLocked(IMethod method, MultiChangeSignaller signaller) {
        MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
        if (methodInfo != null) {
            this.ensureNotLocked(methodInfo, signaller);
        }
    }

    public void ensureNotLocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotLocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotLocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        if (methodInfo != null) {
            if (this.isAutolocked(methodInfo)) {
                this.internalEnsureNotAutolocked(methodInfo, signaller);
            }
            if (this.isNameLocked(methodInfo)) {
                this.internalEnsureNotNameLocked(methodInfo, signaller);
            }
        }
    }

    public void internalEnsureNotLocked(IMethod method) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotLocked(method, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotLocked(IMethod method, MultiChangeSignaller signaller) {
        MethodInfo methodInfo = this.m_patternHelper.getMethodInfo(method);
        if (method != null) {
            this.internalEnsureNotLocked(methodInfo, signaller);
        }
    }

    public void internalEnsureNotLocked(MethodInfo methodInfo) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotLocked(methodInfo, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotLocked(MethodInfo methodInfo, MultiChangeSignaller signaller) {
        if (this.isAutolocked(methodInfo)) {
            this.internalEnsureNotAutolocked(methodInfo, signaller);
        }
        if (this.isNameLocked(methodInfo)) {
            this.internalEnsureNotNameLocked(methodInfo, signaller);
        }
    }

    public void ensureNotLocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotLocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotLocked(IType type, MultiChangeSignaller signaller) {
        if (this.isAutolocked(type)) {
            this.internalEnsureNotAutolocked(type, signaller);
        }
        if (this.isNameLocked(type)) {
            this.internalEnsureNotNameLocked(type, signaller);
        }
    }

    public void internalEnsureNotLocked(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotLocked(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotLocked(IType type, MultiChangeSignaller signaller) {
        if (this.isAutolocked(type)) {
            this.internalEnsureNotAutolocked(type, signaller);
        }
        if (this.isNameLocked(type)) {
            this.internalEnsureNotNameLocked(type, signaller);
        }
    }

    public void ensureNotLocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotLocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotLocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (this.isAutolocked(fragment)) {
            this.internalEnsureNotAutolocked(fragment, signaller);
        }
        if (this.isNameLocked(fragment)) {
            this.internalEnsureNotNameLocked(fragment, signaller);
        }
    }

    public void internalEnsureNotLocked(IPackageDeclaration packageDecl) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotLocked(packageDecl, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotLocked(IPackageDeclaration packageDecl, MultiChangeSignaller signaller) {
        if (this.isAutolocked(packageDecl)) {
            this.internalEnsureNotAutolocked(packageDecl, signaller);
        }
        if (this.isNameLocked(packageDecl)) {
            this.internalEnsureNotNameLocked(packageDecl, signaller);
        }
    }

    public void internalEnsureNotLocked(IPackageFragment fragment) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotLocked(fragment, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotLocked(IPackageFragment fragment, MultiChangeSignaller signaller) {
        if (this.isAutolocked(fragment)) {
            this.internalEnsureNotAutolocked(fragment, signaller);
        }
        if (this.isNameLocked(fragment)) {
            this.internalEnsureNotNameLocked(fragment, signaller);
        }
    }

    public void ensureNotLocked(IJavaProject javaProject) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotLocked(javaProject, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotLocked(IJavaProject javaProject, MultiChangeSignaller signaller) {
        if (javaProject != null) {
            IPackageFragment[] fragments = ConfigurationHelper.getSourceFragments(javaProject);
            for (int i = 0; i < fragments.length; ++i) {
                if (this.isAutolocked(fragments[i])) {
                    this.internalEnsureNotAutolocked(fragments[i], signaller);
                }
                if (!this.isNameLocked(fragments[i])) continue;
                this.internalEnsureNotNameLocked(fragments[i], signaller);
            }
        }
    }

    public boolean isBootJarClass(ICompilationUnit module) {
        return this.isBootJarClass(module.findPrimaryType());
    }

    public boolean isBootJarClass(IType type) {
        return this.isBootJarClass(PatternHelper.getFullyQualifiedName(type));
    }

    private Boolean isBootJarClass(String className, AdditionalBootJarClasses abjc) {
        if (abjc != null) {
            String[] includes = abjc.getIncludeArray();
            for (int i = 0; i < includes.length; ++i) {
                if (!this.m_patternHelper.matchesClass(includes[i], className)) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    public boolean isBootJarClass(String className) {
        Boolean isBootJarClass;
        Boolean isBootJarClass2;
        AdditionalBootJarClasses abjc = this.getAdditionalBootJarClasses();
        if (abjc != null && (isBootJarClass2 = this.isBootJarClass(className, abjc)) != null) {
            return isBootJarClass2;
        }
        ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
        if (modulesConfig != null && (abjc = modulesConfig.getApplication().getAdditionalBootJarClasses()) != null && (isBootJarClass = this.isBootJarClass(className, abjc)) != null) {
            return isBootJarClass;
        }
        return false;
    }

    public void ensureBootJarClass(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureBootJarClass(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureBootJarClass(ICompilationUnit module, MultiChangeSignaller signaller) {
        this.ensureBootJarClass(module.findPrimaryType(), signaller);
    }

    public void ensureBootJarClass(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureBootJarClass(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureBootJarClass(IType type, MultiChangeSignaller signaller) {
        this.ensureBootJarClass(PatternHelper.getFullyQualifiedName(type), signaller);
    }

    public void internalEnsureBootJarClass(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureBootJarClass(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureBootJarClass(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureBootJarClass(PatternHelper.getFullyQualifiedName(type), signaller);
    }

    public void ensureBootJarClass(String className) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureBootJarClass(className, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureBootJarClass(String className, MultiChangeSignaller signaller) {
        if (this.isInstrumentationNotNeeded(className)) {
            return;
        }
        if (!this.isBootJarClass(className)) {
            this.internalEnsureBootJarClass(className, signaller);
        }
    }

    public void internalEnsureBootJarClass(String className) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureBootJarClass(className, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureBootJarClass(String className, MultiChangeSignaller signaller) {
        if (this.isInstrumentationNotNeeded(className)) {
            return;
        }
        this.ensureAdditionalBootJarClasses().addInclude(className);
        signaller.bootClassesChanged = true;
    }

    public void ensureNotBootJarClass(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotBootJarClass(module, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotBootJarClass(ICompilationUnit module, MultiChangeSignaller signaller) {
        if (module != null) {
            this.internalEnsureNotBootJarClass(module, signaller);
        }
    }

    public void internalEnsureNotBootJarClass(ICompilationUnit module) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotBootJarClass(module, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotBootJarClass(ICompilationUnit module, MultiChangeSignaller signaller) {
        this.internalEnsureNotBootJarClass(module.findPrimaryType(), signaller);
    }

    public void ensureNotBootJarClass(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotBootJarClass(type, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotBootJarClass(IType type, MultiChangeSignaller signaller) {
        if (type != null && this.isBootJarClass(type)) {
            this.internalEnsureNotBootJarClass(type, signaller);
        }
    }

    public void internalEnsureNotBootJarClass(IType type) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotBootJarClass(type, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotBootJarClass(IType type, MultiChangeSignaller signaller) {
        this.internalEnsureNotBootJarClass(PatternHelper.getFullyQualifiedName(type), signaller);
    }

    public void ensureNotBootJarClass(String className) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.ensureNotBootJarClass(className, signaller);
        signaller.signal(this.m_project);
    }

    public void ensureNotBootJarClass(String className, MultiChangeSignaller signaller) {
        if (this.isBootJarClass(className)) {
            this.internalEnsureNotBootJarClass(className, signaller);
        }
    }

    public void internalEnsureNotBootJarClass(String className) {
        MultiChangeSignaller signaller = new MultiChangeSignaller();
        this.internalEnsureNotBootJarClass(className, signaller);
        signaller.signal(this.m_project);
    }

    public void internalEnsureNotBootJarClass(String className, MultiChangeSignaller signaller) {
        AdditionalBootJarClasses classes = this.getAdditionalBootJarClasses();
        if (classes != null) {
            String[] includes = classes.getIncludeArray();
            for (int i = includes.length - 1; i >= 0; --i) {
                if (!this.m_patternHelper.matchesClass(includes[i], className)) continue;
                classes.removeInclude(i);
                signaller.includeRulesChanged = true;
            }
            this.testRemoveAdditionalBootJarClasses();
        }
    }

    public boolean hasBootJarClasses() {
        AdditionalBootJarClasses classes = this.getAdditionalBootJarClasses();
        return classes != null && classes.sizeOfIncludeArray() > 0;
    }

    public boolean hasModules() {
        Modules modules = this.getModules();
        return modules != null && modules.sizeOfModuleArray() > 0;
    }

    public void validateAll() {
        if (this.getConfig() != null) {
            this.validateRoots();
            this.validateTransientFields();
            this.validateBootJarClasses();
            this.validateModules();
        }
    }

    private static String getRawString(XmlString xmlString) {
        int end;
        if (xmlString == null) {
            return null;
        }
        String s = xmlString.toString();
        if (s != null && (end = (s = s.substring(s.indexOf(62) + 1)).indexOf(60)) != -1) {
            s = s.substring(0, end);
        }
        return s;
    }

    public void validateLocks() {
        this.clearConfigProblemMarkersOfType(LOCK_PROBLEM_MARKER);
        Locks locks = this.getLocks();
        if (locks != null) {
            int i;
            Autolock[] autoLocks = locks.getAutolockArray();
            NamedLock[] namedLocks = locks.getNamedLockArray();
            if (autoLocks != null) {
                for (i = 0; i < autoLocks.length; ++i) {
                    this.validateLockMethodExpression(ConfigurationHelper.getRawString((XmlString)autoLocks[i].xgetMethodExpression()));
                }
            }
            if (namedLocks != null) {
                for (i = 0; i < namedLocks.length; ++i) {
                    this.validateLockMethodExpression(ConfigurationHelper.getRawString((XmlString)namedLocks[i].xgetMethodExpression()));
                }
            }
        }
    }

    public void validateRoots() {
        this.clearConfigProblemMarkersOfType(ROOT_PROBLEM_MARKER);
        Roots roots = this.getRoots();
        if (roots != null) {
            Root[] rootArray = roots.getRootArray();
            for (int i = 0; i < rootArray.length; ++i) {
                this.validateRoot(rootArray[i]);
            }
        }
    }

    private static boolean isInterface(IType type) {
        try {
            return type.isInterface();
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    private static boolean isPrimitive(IType type) {
        try {
            String name = type.getFullyQualifiedName();
            return PRIMITIVES.contains(name);
        }
        catch (Exception e) {
            return false;
        }
    }

    private void validateRoot(Root root) {
        IField field;
        IType fieldType;
        String rootName = ConfigurationHelper.getRawString((XmlString)root.xgetFieldName());
        String msg = this.validateField(rootName);
        if (!(msg != null || (fieldType = this.getFieldType(field = this.getField(root.getFieldName()))) == null || ConfigurationHelper.isInterface(fieldType) || ConfigurationHelper.isPrimitive(fieldType) || this.isAdaptable(fieldType) || this.isBootJarClass(fieldType) || this.m_plugin.isBootClass(this.m_project, fieldType) || this.isInstrumentationNotNeeded(fieldType))) {
            String fullName = PatternHelper.getFullyQualifiedName(fieldType);
            msg = "Root type '" + fullName + "' not instrumented";
        }
        if (msg != null) {
            this.reportConfigProblem(rootName, msg, ROOT_PROBLEM_MARKER);
        }
    }

    public void validateTransientFields() {
        this.clearConfigProblemMarkersOfType(TRANSIENT_PROBLEM_MARKER);
        TransientFields transientFields = this.getTransientFields();
        if (transientFields != null) {
            for (int i = 0; i < transientFields.sizeOfFieldNameArray(); ++i) {
                String field = ConfigurationHelper.getRawString((XmlString)transientFields.xgetFieldNameArray(i));
                this.validateTransientField(field);
            }
        }
    }

    private void validateTransientField(String fieldName) {
        IField field;
        IType declaringType;
        String msg = this.validateField(fieldName);
        if (msg == null && (declaringType = (field = this.getField(fieldName)).getDeclaringType()) != null && !this.isAdaptable(declaringType) && !this.isBootJarClass(declaringType)) {
            String fullName = PatternHelper.getFullyQualifiedName(declaringType);
            msg = "Declaring type '" + fullName + "' not instrumented";
        }
        if (msg != null) {
            this.reportConfigProblem(fieldName, msg, TRANSIENT_PROBLEM_MARKER);
        }
    }

    public void validateInstrumentedClasses() {
        this.clearConfigProblemMarkersOfType(INSTRUMENTED_PROBLEM_MARKER);
        InstrumentedClasses instrumentedClasses = this.getInstrumentedClasses();
        if (instrumentedClasses != null) {
            this.validateIncludes(instrumentedClasses);
            this.validateExcludes(instrumentedClasses);
        }
    }

    private void validateIncludes(InstrumentedClasses instrumentedClasses) {
        for (int i = 0; i < instrumentedClasses.sizeOfIncludeArray(); ++i) {
            Include include = instrumentedClasses.getIncludeArray(i);
            String expr = ConfigurationHelper.getRawString((XmlString)include.xgetClassExpression());
            this.validateInstrumentedTypeExpression(expr);
        }
    }

    private void validateExcludes(InstrumentedClasses instrumentedClasses) {
        for (int i = 0; i < instrumentedClasses.sizeOfExcludeArray(); ++i) {
            String exclude = ConfigurationHelper.getRawString((XmlString)instrumentedClasses.xgetExcludeArray(i));
            this.validateInstrumentedTypeExpression(exclude);
        }
    }

    private void validateInstrumentedTypeExpression(String typeExpr) {
        String expr;
        String msg = null;
        String string = expr = typeExpr != null ? typeExpr.trim() : null;
        if (expr != null && (expr.indexOf(42) != -1 || expr.indexOf(43) != -1)) {
            return;
        }
        try {
            if (expr != null && JdtUtils.findType(this.m_javaProject, expr) != null) {
                return;
            }
        }
        catch (JavaModelException jme) {
            // empty catch block
        }
        if (expr != null && expr.length() > 0) {
            String prefix = this.findTypeExpressionPrefix(expr);
            try {
                int j;
                IPackageFragment fragment;
                int i;
                IPackageFragment[] fragments = this.m_javaProject.getPackageFragments();
                for (i = 0; i < fragments.length; ++i) {
                    fragment = fragments[i];
                    if (fragment.getKind() != 1 || !fragment.getElementName().startsWith(prefix)) continue;
                    ICompilationUnit[] cus = fragment.getCompilationUnits();
                    for (j = 0; j < cus.length; ++j) {
                        ICompilationUnit cu = cus[j];
                        String cuType = PatternHelper.getFullyQualifiedName(cu.findPrimaryType());
                        if (!cuType.startsWith(prefix)) continue;
                        IType[] types = cus[j].getAllTypes();
                        for (int k = 0; k < types.length; ++k) {
                            IType type = types[k];
                            if (type.isInterface() || !this.matchesType(expr, type)) continue;
                            return;
                        }
                    }
                }
                for (i = 0; i < fragments.length; ++i) {
                    fragment = fragments[i];
                    if (fragment.getKind() != 2 || !fragment.getElementName().startsWith(prefix)) continue;
                    IClassFile[] classFiles = fragment.getClassFiles();
                    for (j = 0; j < classFiles.length; ++j) {
                        IType type = classFiles[j].getType();
                        String typeName = PatternHelper.getFullyQualifiedName(type);
                        int flags = type.getFlags();
                        if (!typeName.startsWith(prefix) || type.isInterface() || type.isAnonymous() || type.isMember() || type.isEnum() || type.isAnnotation() || Flags.isProtected((int)flags) || Flags.isPrivate((int)flags) || Flags.isStatic((int)flags) || !this.matchesType(expr, type)) continue;
                        return;
                    }
                }
                msg = "No type matches expression '" + expr + "'";
            }
            catch (JavaModelException jme) {
                msg = jme.getMessage();
            }
        } else {
            msg = "Empty type expression";
        }
        if (msg != null) {
            this.reportConfigProblem(typeExpr, msg, INSTRUMENTED_PROBLEM_MARKER);
        }
    }

    private String findTypeExpressionPrefix(String typeExpr) {
        String[] elems = StringUtils.split((String)typeExpr, (char)'.');
        char[] codes = new char[]{'*', '?', '.', '$'};
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < elems.length; ++i) {
            String elem = elems[i];
            if (elem.length() <= 0 || !StringUtils.containsNone((String)elems[i], (char[])codes)) continue;
            list.add(elem);
        }
        return StringUtils.join((Object[])list.toArray(), (char)'.');
    }

    private boolean matchesType(String typeExpr, IType type) {
        String name = PatternHelper.getFullyQualifiedName(type);
        int nameLen = name.length();
        int exprLen = typeExpr.length();
        if (typeExpr.equals(name)) {
            return true;
        }
        for (int z = 0; z < exprLen; ++z) {
            char ec = typeExpr.charAt(z);
            if (z != nameLen && name.charAt(z) == ec) continue;
            if (ec != '.' && ec != '*' && ec != '?') break;
            return this.m_patternHelper.matchesType(typeExpr, type);
        }
        return false;
    }

    private void validateLockMethodExpression(String methodExpr) {
        String msg = this.validateMethodExpression(methodExpr);
        if (msg != null) {
            this.reportConfigProblem(methodExpr, msg, LOCK_PROBLEM_MARKER);
        }
    }

    public void validateDistributedMethods() {
        this.clearConfigProblemMarkersOfType(DISTRIBUTED_METHOD_PROBLEM_MARKER);
        DistributedMethods distributedMethods = this.getDistributedMethods();
        if (distributedMethods != null) {
            for (int i = 0; i < distributedMethods.sizeOfMethodExpressionArray(); ++i) {
                String methodExpr = distributedMethods.getMethodExpressionArray(i).getStringValue();
                this.validateDistributedMethodExpression(methodExpr);
            }
        }
    }

    private void validateDistributedMethodExpression(String methodExpr) {
        String msg = this.validateMethodExpression(methodExpr);
        if (msg != null) {
            this.reportConfigProblem(methodExpr, msg, DISTRIBUTED_METHOD_PROBLEM_MARKER);
        }
    }

    private String validateField(String fullName) {
        int lastDotIndex;
        String msg = null;
        if (fullName != null) {
            fullName = fullName.trim();
        }
        if (fullName != null && fullName.length() > 0 && (lastDotIndex = fullName.lastIndexOf(46)) != -1) {
            String className = fullName.substring(0, lastDotIndex).replace('$', '.');
            String fieldName = fullName.substring(lastDotIndex + 1);
            try {
                IType type = JdtUtils.findType(this.m_javaProject, className);
                if (type == null) {
                    msg = "Class not found: " + className;
                } else {
                    IField field = type.getField(fieldName);
                    if (field == null || !field.exists()) {
                        msg = "No such field: " + fieldName;
                    }
                }
            }
            catch (JavaModelException jme) {
                msg = jme.getMessage();
            }
        } else {
            msg = "Must be a fully-qualified field name";
        }
        return msg;
    }

    private String validateMethodExpression(String methodExpr) {
        String msg = null;
        if (methodExpr != null && methodExpr.length() > 0) {
            try {
                this.m_patternHelper.testValidateMethodExpression(methodExpr);
            }
            catch (Exception e) {
                return e.getMessage();
            }
            try {
                int j;
                int i;
                String prefix = this.findMethodExpressionPrefix(methodExpr);
                if (prefix != null && prefix.length() > 0) {
                    try {
                        IType type = JdtUtils.findType(this.m_javaProject, prefix);
                        if (type != null) {
                            IMethod[] methods = type.getMethods();
                            for (int m = 0; m < methods.length; ++m) {
                                if (!this.m_patternHelper.matchesMethod(methodExpr, methods[m])) continue;
                                return null;
                            }
                        }
                    }
                    catch (JavaModelException jme) {
                        // empty catch block
                    }
                }
                IPackageFragment[] fragments = this.m_javaProject.getPackageFragments();
                for (i = 0; i < fragments.length; ++i) {
                    IPackageFragment fragment = fragments[i];
                    if (fragment.getKind() != 1 || !fragment.getElementName().startsWith(prefix)) continue;
                    ICompilationUnit[] cus = fragment.getCompilationUnits();
                    for (j = 0; j < cus.length; ++j) {
                        ICompilationUnit cu = cus[j];
                        String cuType = PatternHelper.getFullyQualifiedName(cu.findPrimaryType());
                        if (!cuType.startsWith(prefix)) continue;
                        IType[] types = cus[j].getAllTypes();
                        for (int k = 0; k < types.length; ++k) {
                            IType type = types[k];
                            if (type.isInterface() || type.isAnonymous() || !this.matchesMethod(methodExpr, type)) continue;
                            return null;
                        }
                    }
                }
                for (i = 0; i < fragments.length; ++i) {
                    IPackageFragment fragment = fragments[i];
                    if (fragment.getKind() != 2 || !fragment.getElementName().startsWith(prefix)) continue;
                    IClassFile[] classFiles = fragment.getClassFiles();
                    for (j = 0; j < classFiles.length; ++j) {
                        IType type = classFiles[j].getType();
                        String typeName = PatternHelper.getFullyQualifiedName(type);
                        int flags = type.getFlags();
                        if (!typeName.startsWith(prefix) || type.isInterface() || type.isAnonymous() || type.isMember() || type.isEnum() || type.isAnnotation() || Flags.isPrivate((int)flags) || Flags.isProtected((int)flags) || Flags.isStatic((int)flags) || !this.matchesMethod(methodExpr, type)) continue;
                        return null;
                    }
                }
                msg = "No method matching expression '" + methodExpr + "'";
            }
            catch (JavaModelException jme) {
                msg = jme.getMessage();
            }
        } else {
            msg = "Must be a fully-qualified method name";
        }
        return msg;
    }

    private String findMethodExpressionPrefix(String methodExpr) {
        String elem;
        String[] comps = StringUtils.split((String)methodExpr);
        String exprBody = comps.length > 1 ? comps[1] : comps[0];
        String[] elems = StringUtils.split((String)exprBody, (char)'.');
        char[] codes = new char[]{'*', '?', '(', ')', '$'};
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < elems.length && (elem = elems[i]).length() > 0 && StringUtils.containsNone((String)elems[i], (char[])codes); ++i) {
            list.add(elem);
        }
        return StringUtils.join((Object[])list.toArray(), (char)'.');
    }

    private boolean matchesMethod(String methodExpr, IType type) {
        String[] comps = StringUtils.split((String)methodExpr);
        String exprBody = comps.length > 1 ? comps[1] : comps[0];
        int exprBodyLen = exprBody.length();
        String name = PatternHelper.getFullyQualifiedName(type);
        int nameLen = name.length();
        for (int z = 0; z < exprBodyLen; ++z) {
            char ebc = exprBody.charAt(z);
            if (z != nameLen && ebc == name.charAt(z)) continue;
            if (ebc == '.' || ebc == '*' || ebc == '?' || ebc == '(') {
                try {
                    IMethod[] methods = type.getMethods();
                    for (int m = 0; m < methods.length; ++m) {
                        IMethod method = methods[m];
                        if (!this.m_patternHelper.matchesMethod(methodExpr, method)) continue;
                        return true;
                    }
                }
                catch (JavaModelException jme) {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public void validateBootJarClasses() {
        this.clearConfigProblemMarkersOfType(BOOT_CLASS_PROBLEM_MARKER);
        AdditionalBootJarClasses classes = this.getAdditionalBootJarClasses();
        if (classes != null) {
            for (int i = 0; i < classes.sizeOfIncludeArray(); ++i) {
                String include = ConfigurationHelper.getRawString((XmlString)classes.xgetIncludeArray(i));
                this.validateBootJarClass(include);
            }
        }
    }

    private void validateBootJarClass(String classname) {
        String msg = null;
        String expr = classname;
        if (expr != null) {
            expr = expr.trim();
        }
        if (this.isInstrumentationNotNeeded(classname)) {
            msg = "Type '" + classname + "' should never be instrumented";
        } else {
            BootClassHelper bch = this.m_plugin.getBootClassHelper(this.m_project);
            if (bch != null && bch.isAdaptable(classname)) {
                msg = "Type '" + classname + "' is a pre-instrumented (default) boot type";
            } else {
                try {
                    if (expr != null && JdtUtils.findType(this.m_javaProject, expr) == null) {
                        msg = "Cannot resolve type '" + expr + "'";
                    }
                }
                catch (JavaModelException jme) {
                    msg = "Cannot resolve type '" + expr + "'";
                }
            }
        }
        if (msg != null) {
            this.reportConfigProblem(classname, msg, BOOT_CLASS_PROBLEM_MARKER);
        }
    }

    private void validateModules() {
        this.clearConfigProblemMarkersOfType(MODULE_PROBLEM_MARKER);
        this.clearConfigProblemMarkersOfType(MODULE_REPO_PROBLEM_MARKER);
        Modules modules = this.getModules();
        if (modules != null) {
            ModulesConfiguration modulesConfig = this.m_plugin.getModulesConfiguration(this.m_project);
            for (String string : modules.getRepositoryArray()) {
                if (string.startsWith("file:")) {
                    this.reportConfigProblem(string, "File URLs have been deprecated - use file path instead", MODULE_REPO_PROBLEM_MARKER);
                    continue;
                }
                File file = new File(ParameterSubstituter.substitute((String)string));
                if (!file.exists()) {
                    this.reportConfigProblem(string, "Repository does not exist", MODULE_REPO_PROBLEM_MARKER);
                    continue;
                }
                if (file.isDirectory()) continue;
                this.reportConfigProblem(string, "Repository is not a directory", MODULE_REPO_PROBLEM_MARKER);
            }
            for (String string : modules.getModuleArray()) {
                BundleException error;
                ModuleInfo moduleInfo = modulesConfig.getModuleInfo((Module)string);
                if (moduleInfo == null || (error = moduleInfo.getError()) == null) continue;
                String text = string.getName();
                this.reportConfigProblem(text, error.getMessage(), MODULE_PROBLEM_MARKER);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportConfigProblem(String configText, String msg, String markerType) {
        ConfigurationEditor editor = this.m_plugin.getConfigurationEditor(this.m_project);
        if (editor != null) {
            editor.applyProblemToText(configText, msg, markerType);
        } else {
            IFile file = this.m_plugin.getConfigurationFile(this.m_project);
            InputStream in = null;
            try {
                in = file.getContents();
                String text = IOUtils.toString((InputStream)in);
                Document doc = new Document(text);
                this.applyProblemToText((IDocument)doc, configText, msg, markerType);
            }
            catch (Exception e) {
                this.m_plugin.openError("Problem reporting config problem", e);
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    public void applyProblemToText(IDocument doc, String text, String msg, String markerType) {
        TcPlugin plugin = TcPlugin.getDefault();
        FindReplaceDocumentAdapter finder = new FindReplaceDocumentAdapter(doc);
        try {
            text = "\\Q" + text + "\\E";
            IRegion region = finder.find(0, text, true, true, false, true);
            if (region != null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                int start = region.getOffset();
                int end = start + region.getLength();
                int line = doc.getLineOfOffset(start) - 1;
                MarkerUtilities.setMessage(map, (String)msg);
                MarkerUtilities.setLineNumber(map, (int)line);
                MarkerUtilities.setCharStart(map, (int)start);
                MarkerUtilities.setCharEnd(map, (int)end);
                map.put("priority", 2);
                map.put("severity", 1);
                map.put("location", "line " + line);
                IFile configFile = plugin.getConfigurationFile(this.m_project);
                MarkerUtilities.createMarker((IResource)configFile, map, (String)markerType);
            }
        }
        catch (Exception e2) {
            plugin.openError("Problem creating marker '" + markerType + "'", e2);
        }
    }

    public TcConfigDocument.TcConfig getConfig() {
        return this.m_plugin.getConfiguration(this.m_project);
    }

    private DsoApplication ensureDsoApplication() {
        DsoApplication dsoApp = null;
        TcConfigDocument.TcConfig config = this.getConfig();
        if (config != null) {
            Application app = config.getApplication();
            if (app == null) {
                app = config.addNewApplication();
            }
            if ((dsoApp = app.getDso()) == null) {
                dsoApp = app.addNewDso();
                dsoApp.addNewInstrumentedClasses();
            }
        }
        return dsoApp;
    }

    private Client getClient() {
        TcConfigDocument.TcConfig config = this.getConfig();
        return config != null ? config.getClients() : null;
    }

    private Application getApplication() {
        TcConfigDocument.TcConfig config = this.getConfig();
        return config != null ? config.getApplication() : null;
    }

    private void testRemoveApplication() {
        Application app = this.getApplication();
        if (app != null && !app.isSetDso()) {
            this.getConfig().unsetApplication();
        }
    }

    private DsoApplication getDsoApplication() {
        Application app = this.getApplication();
        return app != null ? app.getDso() : null;
    }

    private void testRemoveDsoApplication() {
        DsoApplication dsoApp = this.getDsoApplication();
        if (dsoApp != null) {
            boolean hasClasses;
            InstrumentedClasses classes = dsoApp.getInstrumentedClasses();
            boolean bl = hasClasses = classes != null && (classes.sizeOfExcludeArray() > 0 || classes.sizeOfIncludeArray() > 0);
            if (!(dsoApp.isSetAdditionalBootJarClasses() || dsoApp.isSetDistributedMethods() || hasClasses || dsoApp.isSetLocks() || dsoApp.isSetRoots() || dsoApp.isSetTransientFields())) {
                this.getApplication().unsetDso();
                this.testRemoveApplication();
            }
        }
    }

    private Roots getRoots() {
        DsoApplication dsoApp = this.getDsoApplication();
        return dsoApp != null ? dsoApp.getRoots() : null;
    }

    private Roots ensureRoots() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        Roots roots = dsoApp.getRoots();
        return roots != null ? roots : dsoApp.addNewRoots();
    }

    private void testRemoveRoots() {
        Roots roots;
        DsoApplication dsoApp = this.getDsoApplication();
        if (dsoApp != null && (roots = dsoApp.getRoots()).sizeOfRootArray() == 0) {
            dsoApp.unsetRoots();
            this.testRemoveDsoApplication();
        }
    }

    private DistributedMethods getDistributedMethods() {
        DsoApplication dsoApp = this.getDsoApplication();
        return dsoApp != null ? dsoApp.getDistributedMethods() : null;
    }

    private DistributedMethods ensureDistributedMethods() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        DistributedMethods methods = dsoApp.getDistributedMethods();
        if (methods == null) {
            methods = dsoApp.addNewDistributedMethods();
        }
        return methods;
    }

    private void testRemoveDistributedMethods() {
        DistributedMethods methods = this.getDistributedMethods();
        if (methods != null && methods.sizeOfMethodExpressionArray() == 0) {
            this.getDsoApplication().unsetDistributedMethods();
            this.testRemoveDsoApplication();
        }
    }

    private Locks getLocks() {
        DsoApplication dsoApp = this.getDsoApplication();
        return dsoApp != null ? dsoApp.getLocks() : null;
    }

    private Locks ensureLocks() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        Locks locks = dsoApp.getLocks();
        if (locks == null) {
            locks = dsoApp.addNewLocks();
        }
        return locks;
    }

    private void testRemoveLocks() {
        Locks locks = this.getLocks();
        if (locks != null && locks.sizeOfAutolockArray() == 0 && locks.sizeOfNamedLockArray() == 0) {
            this.getDsoApplication().unsetLocks();
            this.testRemoveDsoApplication();
        }
    }

    private InstrumentedClasses getInstrumentedClasses() {
        DsoApplication dsoApp = this.getDsoApplication();
        return dsoApp != null ? dsoApp.getInstrumentedClasses() : null;
    }

    private InstrumentedClasses ensureInstrumentedClasses() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        InstrumentedClasses classes = dsoApp.getInstrumentedClasses();
        if (classes == null) {
            classes = dsoApp.addNewInstrumentedClasses();
        }
        return classes;
    }

    private void testRemoveInstrumentedClasses() {
        InstrumentedClasses ic = this.getInstrumentedClasses();
        if (ic != null && ic.sizeOfExcludeArray() == 0 && ic.sizeOfIncludeArray() == 0) {
            this.getDsoApplication().unsetInstrumentedClasses();
            this.testRemoveDsoApplication();
        }
    }

    private Modules getModules() {
        Client client = this.getClient();
        return client != null ? client.getModules() : null;
    }

    private AdditionalBootJarClasses getAdditionalBootJarClasses() {
        return this.ensureDsoApplication().getAdditionalBootJarClasses();
    }

    private AdditionalBootJarClasses ensureAdditionalBootJarClasses() {
        DsoApplication dsoApp = this.ensureDsoApplication();
        AdditionalBootJarClasses abjc = dsoApp.getAdditionalBootJarClasses();
        return abjc != null ? abjc : dsoApp.addNewAdditionalBootJarClasses();
    }

    private void testRemoveAdditionalBootJarClasses() {
        AdditionalBootJarClasses abjc;
        DsoApplication dsoApp = this.getDsoApplication();
        if (dsoApp != null && (abjc = dsoApp.getAdditionalBootJarClasses()).sizeOfIncludeArray() == 0) {
            dsoApp.unsetAdditionalBootJarClasses();
            this.testRemoveDsoApplication();
        }
    }

    public Servers getServers() {
        TcConfigDocument.TcConfig config = this.getConfig();
        return config != null ? config.getServers() : null;
    }

    private static IPackageFragment[] getSourceFragments(IJavaProject javaProject) {
        ArrayList<IPackageFragment> list = new ArrayList<IPackageFragment>();
        try {
            IPackageFragment[] fragments = javaProject.getPackageFragments();
            for (int i = 0; i < fragments.length; ++i) {
                if (!ConfigurationHelper.isSourceFragment(fragments[i])) continue;
                list.add(fragments[i]);
            }
        }
        catch (JavaModelException javaModelException) {
            // empty catch block
        }
        return list.toArray(new IPackageFragment[0]);
    }

    private static boolean isSourceFragment(IPackageFragment fragment) {
        try {
            return fragment.getKind() == 1 && ConfigurationHelper.hasCompilationUnits(fragment);
        }
        catch (JavaModelException jme) {
            return false;
        }
    }

    private static boolean hasCompilationUnits(IPackageFragment fragment) {
        try {
            IResource resource = fragment.getResource();
            int type = resource.getType();
            IFolder container = null;
            switch (type) {
                case 4: {
                    IProject project = (IProject)resource;
                    String name = fragment.getElementName();
                    if (name.equals("")) {
                        container = project;
                        break;
                    }
                    String path = fragment.getElementName().replace('.', '/');
                    container = project.getFolder(project.getLocation().append(path));
                    break;
                }
                case 2: {
                    container = (IFolder)resource;
                }
            }
            if (container != null) {
                IResource[] members = container.members();
                for (int i = 0; i < members.length; ++i) {
                    IResource member = members[i];
                    if (member.getType() != 1 || !member.getFileExtension().equals("java")) continue;
                    return true;
                }
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        return false;
    }

    private void openError(String msg, Throwable t) {
        this.m_plugin.openError(msg, t);
    }

    public ConfigurationEditor getConfigurationEditor() {
        return this.m_plugin.getConfigurationEditor(this.m_project);
    }

    private void clearConfigProblemMarkersOfType(String markerType) {
        this.m_plugin.clearConfigProblemMarkersOfType(this.m_project, markerType);
    }
}

