/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.terracotta.dso.TcPlugin;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClasspathProvider
extends StandardClasspathProvider {
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) {
        IPath[] paths;
        IPath jarPath = TcPlugin.getDefault().getLibDirPath().append("tc.jar");
        if (jarPath.toFile().exists()) {
            return new IRuntimeClasspathEntry[]{JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath.removeLastSegments(1).append("resources")), JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)jarPath.makeAbsolute())};
        }
        ArrayList<IRuntimeClasspathEntry> list = new ArrayList<IRuntimeClasspathEntry>();
        for (IPath path : paths = ClasspathProvider.gatherDevClasspathEntries()) {
            list.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path));
        }
        return list.toArray(new IRuntimeClasspathEntry[0]);
    }

    public static String makeDevClasspath() {
        IPath[] paths = ClasspathProvider.gatherDevClasspathEntries();
        StringBuffer sb = new StringBuffer();
        String sep = System.getProperty("path.separator");
        for (int i = 0; i < paths.length; ++i) {
            if (i > 0) {
                sb.append(sep);
            }
            sb.append(paths[i].toOSString());
        }
        return sb.toString();
    }

    private static Collection<File> listArchives(File dir) {
        Collection c = FileUtils.listFiles((File)dir, (String[])new String[]{"jar"}, (boolean)false);
        HashSet<File> result = new HashSet<File>();
        Iterator iter = c.iterator();
        while (iter.hasNext()) {
            result.add((File)iter.next());
        }
        return result;
    }

    private static IPath[] gatherDevClasspathEntries() {
        String dir3;
        String[] dirs;
        IPath location = TcPlugin.getDefault().getLocation();
        ArrayList<Object> list = new ArrayList<Object>();
        IPath buildPath = location.append("..");
        for (String dir2 : dirs = new String[]{"deploy", "deploy-api", "common", "common-api", "management", "management-api", "aspectwerkz", "sigarstats", "thirdparty", "dso-common", "dso-common-jdk16", "dso-l1", "dso-l1-api", "dso-l2", "dso-l2-common", "dso-statistics", "dso-statistics-api", "tim-get-tool", "tim-api"}) {
            IPath classesPath = buildPath.append(dir2).append("build.eclipse").append("src.classes");
            if (!classesPath.toFile().exists()) continue;
            list.add(classesPath);
        }
        list.add(buildPath.append("common").append("build.eclipse").append("tests.base.classes"));
        final ArrayList<File> fileList = new ArrayList<File>();
        for (String dir3 : dirs) {
            File libDir = location.append("..").append(dir3).append("lib").toFile();
            if (!libDir.exists()) continue;
            fileList.addAll(ClasspathProvider.listArchives(libDir));
        }
        final File dependencies = location.append("..").append("dependencies").append("lib").toFile();
        File ivy = null;
        File projectDir = null;
        dir3 = null;
        try {
            String[] arr$ = dirs;
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                String dir2;
                dir3 = dir2 = arr$[i$];
                projectDir = location.append("..").append(dir3).toFile();
                ivy = new File(projectDir + File.separator + "ivy.xml");
                if (!ivy.exists()) continue;
                SAXParserFactory factory = SAXParserFactory.newInstance();
                SAXParser parser = factory.newSAXParser();
                parser.parse((InputStream)new FileInputStream(ivy), new DefaultHandler(){

                    public void startElement(String uri, String localName, String qName, Attributes attributes) {
                        if (qName.equals("dependency")) {
                            String jar = attributes.getValue("name") + "-" + attributes.getValue("rev");
                            File jarFile = new File(dependencies + File.separator + jar + ".jar");
                            fileList.add(jarFile);
                        }
                    }
                });
            }
        }
        catch (Throwable e) {
            TcPlugin.getDefault().openError("Problem Parsing ivy.xml file in: " + dir3, e);
        }
        for (File file : fileList) {
            if (file.getName().startsWith("org.eclipse")) continue;
            list.add(new Path(file.getAbsolutePath()));
        }
        return list.toArray(new IPath[list.size()]);
    }
}

