/*
 * Decompiled with CFR 0.152.
 */
package org.terracotta.dso;

import com.tc.object.LiteralValues;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.terracotta.dso.BootJarHelper;
import org.terracotta.dso.PatternHelper;
import org.terracotta.dso.TcPlugin;

public class BootClassHelper {
    private Set<String> m_bootClasses = new HashSet<String>();

    public static String getBootJarName(IJavaProject javaProject) {
        String bootJarName = BootJarHelper.getHelper().getBootJarName(javaProject);
        if (bootJarName != null) {
            return bootJarName;
        }
        try {
            IPath jrePath;
            IRuntimeClasspathEntry jreEntry = JavaRuntime.computeJREEntry((IJavaProject)javaProject);
            String jreEntryPath = null;
            if (jreEntry != null && (jrePath = jreEntry.getPath()) != null) {
                jreEntryPath = jrePath.makeAbsolute().toPortableString();
            }
            bootJarName = BootJarHelper.getHelper().getBootJarName(jreEntryPath);
        }
        catch (Exception e) {
            TcPlugin.getDefault().openError("Initializing BootClassHelper", e);
        }
        return bootJarName;
    }

    public static boolean canGetBootTypes(IJavaProject javaProject) {
        String bootJarName = BootClassHelper.getBootJarName(javaProject);
        File bootJarFile = javaProject.getProject().getLocation().append(bootJarName).toFile();
        File bootTypesCacheFile = BootClassHelper.getBootTypesCacheFile(bootJarName);
        return bootJarFile.exists() || bootTypesCacheFile.exists();
    }

    public BootClassHelper(IJavaProject javaProject) {
        this(javaProject, BootClassHelper.getBootJarName(javaProject));
    }

    public static File getBootTypesCacheFile(String bootJarName) {
        return TcPlugin.getDefault().getStateLocation().append(bootJarName + ".cache").toFile();
    }

    public BootClassHelper(IJavaProject javaProject, String bootJarName) {
        if (bootJarName == null) {
            return;
        }
        try {
            File bootCacheFile = BootClassHelper.getBootTypesCacheFile(bootJarName);
            if (bootCacheFile.exists()) {
                String s;
                FileReader fReader = new FileReader(bootCacheFile);
                BufferedReader bufReader = new BufferedReader(fReader);
                while ((s = bufReader.readLine()) != null) {
                    this.m_bootClasses.add(s);
                }
                return;
            }
            File bootJarFile = javaProject.getProject().getLocation().append(bootJarName).toFile();
            if (bootJarFile.exists()) {
                JarFile jarFile = new JarFile(bootJarFile, false);
                Enumeration<JarEntry> e = jarFile.entries();
                while (e.hasMoreElements()) {
                    JarEntry entry = e.nextElement();
                    String entryName = entry.getName();
                    if (!entryName.endsWith(".class") || entryName.startsWith("com/tc")) continue;
                    entryName = entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.');
                    if (BootClassHelper.isForeign(entry)) continue;
                    this.m_bootClasses.add(entryName);
                }
                jarFile.close();
            }
        }
        catch (Exception e) {
            TcPlugin.getDefault().openError("Initializing BootClassHelper", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cacheBootTypes(File bootJarFile) {
        File cacheFile = BootClassHelper.getBootTypesCacheFile(bootJarFile.getName());
        OutputStreamWriter fWriter = null;
        JarFile jarFile = null;
        try {
            jarFile = new JarFile(bootJarFile, false);
            fWriter = new FileWriter(cacheFile);
            String nl = System.getProperty("line.separator");
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String entryName = entry.getName();
                if (!entryName.endsWith(".class") || entryName.startsWith("com/tc")) continue;
                entryName = entryName.substring(0, entryName.lastIndexOf(46)).replace('/', '.');
                if (BootClassHelper.isForeign(entry)) continue;
                fWriter.write(entryName);
                fWriter.write(nl);
            }
        }
        catch (Exception e) {
            TcPlugin.getDefault().openError("Cacheing boot types", e);
        }
        finally {
            if (fWriter != null) {
                try {
                    fWriter.close();
                }
                catch (Exception ignore) {}
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (Exception ignore) {}
            }
        }
    }

    private static String getJarEntryAttributeValue(JarEntry entry, String attributeName) throws IOException {
        Attributes attributes = entry.getAttributes();
        if (attributes == null) {
            throw new AssertionError((Object)("Invalid jar file: No attributes for jar entry: " + entry.getName()));
        }
        String value = attributes.getValue(attributeName);
        if (value == null) {
            throw new AssertionError((Object)("Invalid jar file: No " + attributeName + " attribute for jar entry: " + entry.getName()));
        }
        return value;
    }

    public static boolean isForeign(JarEntry entry) throws IOException {
        return Boolean.valueOf(BootClassHelper.getJarEntryAttributeValue(entry, "Foreign"));
    }

    public boolean isAdaptable(ICompilationUnit module) {
        return module != null ? this.isAdaptable(module.findPrimaryType()) : false;
    }

    public boolean isAdaptable(IClassFile classFile) {
        try {
            return classFile != null ? this.isAdaptable(classFile.getType()) : false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isAdaptable(IType type) {
        if (type != null) {
            return this.isAdaptable(PatternHelper.getFullyQualifiedName(type));
        }
        return false;
    }

    public boolean isAdaptable(String fullName) {
        return LiteralValues.isLiteral((String)fullName) || this.m_bootClasses != null && this.m_bootClasses.contains(fullName);
    }
}

