/*
 * Decompiled with CFR 0.152.
 */
package com.tc.util;

import com.tc.util.Assert;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SparseList<T>
implements Iterable<T> {
    private final Map<Integer, T> map = new HashMap<Integer, T>();
    private int lastIndex = -1;

    public T insert(int index, T object) {
        if (index > this.lastIndex) {
            this.lastIndex = index;
        }
        return this.map.put(index, object);
    }

    @Override
    public Iterator<T> iterator() {
        return new SparseListIterator<T>(this.map, this.lastIndex);
    }

    private static class SparseListIterator<T>
    implements Iterator<T> {
        private final Map<Integer, T> map;
        private final int lastIndex;
        private int nextIndex;

        public SparseListIterator(Map<Integer, T> map, int lastIndex) {
            this.map = map;
            this.lastIndex = lastIndex;
            this.nextIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex <= this.lastIndex;
        }

        @Override
        public T next() {
            T next = null;
            while (null == next) {
                Assert.assertTrue((this.nextIndex <= this.lastIndex ? 1 : 0) != 0);
                next = this.map.get(this.nextIndex);
                ++this.nextIndex;
            }
            return next;
        }
    }
}

