/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.management.TerracottaManagement;
import com.tc.net.core.TCConnectionManager;
import com.tc.net.groups.GroupManager;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.net.protocol.transport.ConnectionPolicy;
import com.tc.object.net.ChannelStats;
import com.tc.object.net.DSOChannelManagerMBean;
import com.tc.objectserver.core.api.ServerConfigurationContext;
import com.tc.objectserver.core.impl.ServerManagementContext;
import com.tc.objectserver.entity.VoltronMessageSink;
import com.tc.objectserver.handler.VoltronMessageHandler;
import com.tc.stats.AbstractNotifyingMBean;
import com.tc.stats.Client;
import com.tc.stats.api.DSOMBean;
import com.tc.util.DaemonThreadFactory;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import javax.management.Attribute;
import javax.management.AttributeList;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DSO
extends AbstractNotifyingMBean
implements DSOMBean {
    private static final Logger logger = LoggerFactory.getLogger(DSO.class);
    static final int DEFAULT_JMX_REMOTE_PORT = 5000;
    private final MBeanServer mbeanServer;
    private final Set<ObjectName> clientObjectNames = new LinkedHashSet<ObjectName>();
    private final Map<ObjectName, Client> clientMap = new HashMap<ObjectName, Client>();
    private final DSOChannelManagerMBean channelMgr;
    private final TCConnectionManager connections;
    private final GroupManager group;
    private final ChannelStats channelStats;
    private final ConnectionPolicy connectionPolicy;
    private final VoltronMessageHandler messageHandler;
    private final VoltronMessageSink messageSink;
    private volatile int jmxRemotePort = 5000;
    private volatile JMXConnectorServer jmxConnectorServer;
    private Registry registry;
    private final ExecutorService pool = Executors.newCachedThreadPool(new DaemonThreadFactory("dso-mbean-"));
    private static final AttributeList EMPTY_ATTR_LIST = new AttributeList();
    private static final Object[] SIMPLE_INVOKE_PARAMS = new Object[0];
    private static final String[] SIMPLE_INVOKE_SIG = new String[0];

    public DSO(ServerManagementContext managementContext, ServerConfigurationContext configContext, MBeanServer mbeanServer) throws NotCompliantMBeanException {
        super(DSOMBean.class);
        this.mbeanServer = mbeanServer;
        this.channelMgr = managementContext.getChannelManager();
        this.channelStats = managementContext.getChannelStats();
        this.connectionPolicy = managementContext.getConnectionPolicy();
        this.messageHandler = managementContext.getVoltronMessageHandler();
        this.messageSink = managementContext.getVoltronMessageSink();
        this.connections = managementContext.getConnectionManager();
        this.group = configContext.getL2Coordinator().getGroupManager();
        this.channelMgr.addEventListener((ChannelManagerEventListener)new ChannelManagerListener());
        configContext.addShutdownItem(this.pool::shutdown);
        this.setupClients();
    }

    public void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ObjectName[] getClients() {
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            return this.clientObjectNames.toArray(new ObjectName[this.clientObjectNames.size()]);
        }
    }

    @Override
    public int getBufferCount() {
        return this.connections.getBufferCount();
    }

    @Override
    public int getGroupBufferCount() {
        return this.group.getBufferCount();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Client> getConnectedClients() {
        Map<ObjectName, Client> map = this.clientMap;
        synchronized (map) {
            return new ArrayList<Client>(this.clientMap.values());
        }
    }

    private void setupClients() {
        MessageChannel[] channels;
        for (MessageChannel channel : channels = this.channelMgr.getActiveChannels()) {
            this.addClientMBean(channel);
        }
    }

    private ObjectName makeClientObjectName(MessageChannel channel) {
        try {
            return TerracottaManagement.createObjectName((TerracottaManagement.Type)TerracottaManagement.Type.Client, (String)(channel.getProductID().toString() + "" + channel.getChannelID().toLong()), (TerracottaManagement.MBeanDomain)TerracottaManagement.MBeanDomain.PUBLIC);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeClientMBean(MessageChannel channel) {
        ObjectName clientName = this.makeClientObjectName(channel);
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            try {
                if (this.mbeanServer.isRegistered(clientName)) {
                    this.sendNotification("dso.client.detached", clientName);
                    this.mbeanServer.unregisterMBean(clientName);
                }
            }
            catch (Exception e) {
                logger.error("Exception: ", (Throwable)e);
            }
            finally {
                this.clientObjectNames.remove(clientName);
                Client client = this.clientMap.remove(clientName);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addClientMBean(MessageChannel channel) {
        Set<ObjectName> set = this.clientObjectNames;
        synchronized (set) {
            ObjectName clientName = this.makeClientObjectName(channel);
            if (this.mbeanServer.isRegistered(clientName)) {
                logger.debug("channel MBean already registered for name " + clientName);
                return;
            }
            try {
                Client client = new Client(this.mbeanServer, channel, this.channelStats, this.channelMgr.getClientIDFor(channel.getChannelID()));
                this.mbeanServer.registerMBean(client, clientName);
                this.clientObjectNames.add(clientName);
                this.clientMap.put(clientName, client);
                this.sendNotification("dso.client.attached", clientName);
            }
            catch (Exception e) {
                logger.error("Unable to register terracotta client MBean", (Throwable)e);
            }
        }
    }

    private static Exception newPlainException(Exception e) {
        String type = e.getClass().getName();
        if (type.startsWith("java.") || type.startsWith("javax.")) {
            return e;
        }
        RuntimeException result = new RuntimeException(e.getMessage());
        result.setStackTrace(e.getStackTrace());
        return result;
    }

    @Override
    public Map<ObjectName, Exception> setAttribute(Set<ObjectName> onSet, String attrName, Object attrValue) {
        HashMap<ObjectName, Exception> result = new HashMap<ObjectName, Exception>();
        Iterator<ObjectName> onIter = onSet.iterator();
        Attribute attribute = new Attribute(attrName, attrValue);
        while (onIter.hasNext()) {
            ObjectName on = onIter.next();
            try {
                this.mbeanServer.setAttribute(on, attribute);
            }
            catch (Exception e) {
                result.put(on, DSO.newPlainException(e));
            }
        }
        return result;
    }

    @Override
    public Map<ObjectName, Exception> setAttribute(String attrName, Map<ObjectName, Object> attrMap) {
        HashMap<ObjectName, Exception> result = new HashMap<ObjectName, Exception>();
        for (Map.Entry<ObjectName, Object> entry : attrMap.entrySet()) {
            ObjectName on = entry.getKey();
            try {
                Attribute attribute = new Attribute(attrName, entry.getValue());
                this.mbeanServer.setAttribute(on, attribute);
            }
            catch (Exception e) {
                result.put(on, DSO.newPlainException(e));
            }
        }
        return result;
    }

    @Override
    public Map<ObjectName, Map<String, Object>> getAttributeMap(Map<ObjectName, Set<String>> attributeMap, long timeout, TimeUnit unit) {
        HashMap<ObjectName, Map<String, Object>> result = new HashMap<ObjectName, Map<String, Object>>();
        ArrayList<AttributeListTask> tasks = new ArrayList<AttributeListTask>();
        for (Map.Entry<ObjectName, Set<String>> entry : attributeMap.entrySet()) {
            tasks.add(new AttributeListTask(entry.getKey(), entry.getValue()));
        }
        try {
            List results = this.pool.invokeAll(tasks, timeout, unit);
            for (Future future : results) {
                if (!future.isDone() || future.isCancelled()) continue;
                try {
                    SourcedAttributeList sal = (SourcedAttributeList)future.get();
                    Iterator attrIter = sal.attributeList.iterator();
                    HashMap<String, Object> onMap = new HashMap<String, Object>();
                    while (attrIter.hasNext()) {
                        Attribute attr = (Attribute)attrIter.next();
                        onMap.put(attr.getName(), attr.getValue());
                    }
                    result.put(sal.objectName, onMap);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException | RejectedExecutionException exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public Map<ObjectName, Object> invoke(Set<ObjectName> onSet, String operation, long timeout, TimeUnit unit) {
        return this.invoke(onSet, operation, timeout, unit, SIMPLE_INVOKE_PARAMS, SIMPLE_INVOKE_SIG);
    }

    @Override
    public Map<ObjectName, Object> invoke(Set<ObjectName> onSet, String operation, long timeout, TimeUnit unit, Object[] args, String[] sigs) {
        HashMap<ObjectName, Object> result = new HashMap<ObjectName, Object>();
        ArrayList<SimpleInvokeTask> tasks = new ArrayList<SimpleInvokeTask>();
        Iterator<ObjectName> onIter = onSet.iterator();
        while (onIter.hasNext()) {
            tasks.add(new SimpleInvokeTask(onIter.next(), operation, args, sigs));
        }
        try {
            List results = this.pool.invokeAll(tasks, timeout, unit);
            for (Future future : results) {
                if (!future.isDone() || future.isCancelled()) continue;
                try {
                    SimpleInvokeResult sir = (SimpleInvokeResult)future.get();
                    result.put(sir.objectName, sir.result);
                }
                catch (CancellationException cancellationException) {
                }
                catch (ExecutionException executionException) {}
            }
        }
        catch (InterruptedException | RejectedExecutionException exception) {
            // empty catch block
        }
        return result;
    }

    @Override
    public int getCurrentClientCount() {
        return this.connectionPolicy.getNumberOfActiveConnections();
    }

    @Override
    public int getClientHighCount() {
        return this.connectionPolicy.getConnectionHighWatermark();
    }

    @Override
    public String getJmxRemotePort() {
        return String.valueOf(this.jmxRemotePort);
    }

    @Override
    public void setJmxRemotePort(String port) {
        if (this.jmxConnectorServer == null) {
            this.jmxRemotePort = Integer.parseInt(port);
        }
    }

    @Override
    public String startJMXRemote() {
        if (this.jmxConnectorServer != null) {
            return "JMX remote already started at port: " + this.jmxRemotePort;
        }
        try {
            this.registry = LocateRegistry.createRegistry(this.jmxRemotePort);
            JMXServiceURL url = new JMXServiceURL("service:jmx:rmi://localhost/jndi/rmi://localhost:" + this.jmxRemotePort + "/jmxrmi");
            this.jmxConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(url, null, this.mbeanServer);
            this.jmxConnectorServer.start();
            return "Successfully started jmx remote at port " + this.jmxRemotePort;
        }
        catch (Throwable t) {
            return "Caught exception while starting jmx at port " + this.jmxRemotePort + ": " + t.getLocalizedMessage();
        }
    }

    @Override
    public String stopJMXRemote() {
        try {
            if (this.jmxConnectorServer != null) {
                this.jmxConnectorServer.stop();
                this.jmxConnectorServer = null;
                UnicastRemoteObject.unexportObject(this.registry, true);
                return "Successfully stopped jmx remote at port " + this.jmxRemotePort;
            }
            return "JmxConnectorServer is not running";
        }
        catch (Throwable t) {
            return "Caught exception while stopping jmx remote at port " + this.jmxRemotePort + ": " + t.getLocalizedMessage();
        }
    }

    @Override
    public int getCurrentBackoff() {
        return this.messageHandler.currentBackoff();
    }

    @Override
    public boolean isDirectExecution() {
        return this.messageHandler.isDirect();
    }

    @Override
    public void setDirectExecution(boolean activate) {
        this.messageHandler.setDirect(activate);
    }

    @Override
    public void setBackoffActive(boolean active) {
        this.messageHandler.setUseBackoff(active);
    }

    @Override
    public boolean isBackoffActive() {
        return this.messageHandler.isUseBackoff();
    }

    @Override
    public boolean isCurrentlyDirect() {
        return this.messageHandler.currentlyDirect();
    }

    @Override
    public long getMaxBackoffTime() {
        return this.messageHandler.getMaxBackoffTime();
    }

    @Override
    public long getBackoffCount() {
        return this.messageHandler.backoffCount();
    }

    @Override
    public void setAlwaysHydrate(boolean hydrate) {
        this.messageSink.setAlwaysHydrate(hydrate);
    }

    @Override
    public boolean isAlwaysHydrate() {
        return this.messageSink.isAlwaysHydrate();
    }

    private class SimpleInvokeTask
    implements Callable<SimpleInvokeResult> {
        private final ObjectName objectName;
        private final String operation;
        private final Object[] arguments;
        private final String[] signatures;

        SimpleInvokeTask(ObjectName objectName, String operation, Object[] arguments, String[] signatures) {
            this.objectName = objectName;
            this.operation = operation;
            this.arguments = arguments;
            this.signatures = signatures;
        }

        @Override
        public SimpleInvokeResult call() {
            Object result;
            try {
                result = DSO.this.mbeanServer.invoke(this.objectName, this.operation, this.arguments, this.signatures);
            }
            catch (Exception e) {
                result = e;
            }
            return new SimpleInvokeResult(this.objectName, result);
        }
    }

    private static class SimpleInvokeResult {
        final ObjectName objectName;
        final Object result;

        private SimpleInvokeResult(ObjectName objectName, Object result) {
            this.objectName = objectName;
            this.result = result;
        }
    }

    private class AttributeListTask
    implements Callable<SourcedAttributeList> {
        private final ObjectName objectName;
        private final Set<String> attributeSet;

        AttributeListTask(ObjectName objectName, Set<String> attributeSet) {
            this.objectName = objectName;
            this.attributeSet = attributeSet;
        }

        @Override
        public SourcedAttributeList call() {
            AttributeList attributeList;
            try {
                attributeList = DSO.this.mbeanServer.getAttributes(this.objectName, this.attributeSet.toArray(new String[0]));
            }
            catch (Exception e) {
                attributeList = EMPTY_ATTR_LIST;
            }
            return new SourcedAttributeList(this.objectName, attributeList);
        }
    }

    private static class SourcedAttributeList {
        final ObjectName objectName;
        final AttributeList attributeList;

        private SourcedAttributeList(ObjectName objectName, AttributeList attributeList) {
            this.objectName = objectName;
            this.attributeList = attributeList;
        }
    }

    private class ChannelManagerListener
    implements ChannelManagerEventListener {
        private ChannelManagerListener() {
        }

        public void channelCreated(MessageChannel channel) {
            if (!channel.getProductID().isInternal()) {
                DSO.this.addClientMBean(channel);
            }
        }

        public void channelRemoved(MessageChannel channel) {
            if (!channel.getProductID().isInternal()) {
                DSO.this.removeClientMBean(channel);
            }
        }
    }
}

