/*
 * Decompiled with CFR 0.152.
 */
package com.tc.stats;

import com.tc.management.AbstractTerracottaMBean;
import com.tc.management.beans.l1.L1InfoMBean;
import com.tc.net.ClientID;
import com.tc.net.TCSocketAddress;
import com.tc.net.protocol.tcm.ChannelID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.net.ChannelStats;
import com.tc.objectserver.handshakemanager.ClientHandshakeMonitoringInfo;
import com.tc.stats.api.ClientMBean;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Map;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerNotification;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Client
extends AbstractTerracottaMBean
implements ClientMBean,
NotificationListener {
    private static final Logger logger = LoggerFactory.getLogger(Client.class);
    private L1InfoMBean l1InfoBean;
    private final MessageChannel channel;
    private final ClientHandshakeMonitoringInfo minfo;
    private final ClientID clientID;
    private static final MBeanNotificationInfo[] NOTIFICATION_INFO;

    public Client(MBeanServer mbeanServer, MessageChannel channel, ChannelStats channelStats, ClientID clientID) throws NotCompliantMBeanException {
        super(ClientMBean.class, true);
        this.channel = channel;
        this.clientID = clientID;
        this.minfo = (ClientHandshakeMonitoringInfo)channel.getAttachment(ClientHandshakeMonitoringInfo.MONITORING_INFO_ATTACHMENT);
    }

    public void reset() {
    }

    @Override
    public long getClientID() {
        return this.clientID.toLong();
    }

    @Override
    public String getNodeID() {
        return this.clientID.toString();
    }

    @Override
    public ChannelID getChannelID() {
        return this.channel.getChannelID();
    }

    @Override
    public String getRemoteAddress() {
        InetSocketAddress addr = this.channel.getRemoteAddress();
        if (addr == null) {
            return "not connected";
        }
        return TCSocketAddress.getCanonicalStringForm((InetSocketAddress)addr);
    }

    @Override
    public void killClient() {
        logger.warn("Killing Client on JMX Request :" + this.channel);
        this.channel.close();
    }

    @Override
    public int getRemotePID() {
        if (this.minfo != null) {
            return this.minfo.getPid();
        }
        return -1;
    }

    @Override
    public String getRemoteName() {
        if (this.minfo != null) {
            return this.minfo.getName();
        }
        return "";
    }

    @Override
    public String getRemoteUUID() {
        if (this.minfo != null) {
            return this.minfo.getUuid();
        }
        return "";
    }

    @Override
    public String getVersion() {
        if (this.minfo != null) {
            return this.minfo.getVersion();
        }
        return "";
    }

    @Override
    public String getRevision() {
        if (this.minfo != null) {
            return this.minfo.getRevision();
        }
        return "";
    }

    private void beanRegistered(ObjectName beanName) {
    }

    @Override
    public void handleNotification(Notification notification, Object handback) {
        String type = notification.getType();
        if (notification instanceof MBeanServerNotification) {
            MBeanServerNotification mbsn = (MBeanServerNotification)notification;
            if (type.equals("JMX.mbean.registered")) {
                this.beanRegistered(mbsn.getMBeanName());
            }
        }
    }

    public String getConfig() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getConfig();
    }

    public String getEnvironment() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getEnvironment();
    }

    public Map<String, Object> getStatistics() {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.getStatistics();
    }

    public String takeThreadDump(long requestMillis) {
        if (this.l1InfoBean == null) {
            return null;
        }
        return this.l1InfoBean.takeThreadDump(requestMillis);
    }

    public MBeanNotificationInfo[] getNotificationInfo() {
        return Arrays.asList(NOTIFICATION_INFO).toArray(EMPTY_NOTIFICATION_INFO);
    }

    static {
        String[] notifTypes = new String[]{};
        String name = Notification.class.getName();
        String description = "DSOClient event";
        NOTIFICATION_INFO = new MBeanNotificationInfo[]{new MBeanNotificationInfo(notifTypes, name, "DSOClient event")};
    }
}

