/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.classloader.BuiltinService;
import com.tc.services.DelegatingServiceRegistry;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.MappedStateCollector;
import com.tc.services.TerracottaServiceProviderRegistry;
import com.tc.util.Assert;
import java.io.Closeable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.terracotta.configuration.Configuration;
import org.terracotta.entity.PlatformConfiguration;
import org.terracotta.entity.ServiceProvider;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.ServiceProviderConfiguration;
import org.terracotta.server.ServerEnv;

public class TerracottaServiceProviderRegistryImpl
implements TerracottaServiceProviderRegistry {
    private static final Logger logger = LoggerFactory.getLogger(TerracottaServiceProviderRegistryImpl.class);
    private final Set<ServiceProvider> serviceProviders = new LinkedHashSet<ServiceProvider>();
    private final Set<ImplementationProvidedServiceProvider> implementationProvidedServiceProviders = new LinkedHashSet<ImplementationProvidedServiceProvider>();
    private boolean hasCreatedSubRegistries;

    @Override
    public void initialize(PlatformConfiguration platformConfiguration, Configuration configuration) {
        List serviceProviderConfigurationList = configuration.getServiceConfigurations();
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        if (serviceProviderConfigurationList != null) {
            for (ServiceProviderConfiguration config : serviceProviderConfigurationList) {
                Class serviceClazz = config.getServiceProviderType();
                try {
                    ServiceProvider provider = (ServiceProvider)serviceClazz.newInstance();
                    if (!provider.initialize(config, platformConfiguration)) continue;
                    this.registerNewServiceProvider(provider);
                }
                catch (IllegalAccessException | InstantiationException ie) {
                    logger.error("caught exception while initializing service " + serviceClazz, (Throwable)ie);
                    throw new RuntimeException(ie);
                }
            }
        }
        this.loadClasspathBuiltins(platformConfiguration);
    }

    public void shutdown() {
        this.serviceProviders.forEach(TerracottaServiceProviderRegistryImpl::closeCloseable);
        this.implementationProvidedServiceProviders.forEach(TerracottaServiceProviderRegistryImpl::closeCloseable);
    }

    private static void closeCloseable(Object p) {
        try {
            if (p instanceof Closeable) {
                ((Closeable)p).close();
            } else if (p instanceof AutoCloseable) {
                ((AutoCloseable)p).close();
            }
        }
        catch (Exception e) {
            logger.info("exception closing service", (Throwable)e);
        }
    }

    private void loadClasspathBuiltins(PlatformConfiguration platformConfiguration) {
        List providers = ServerEnv.getServer().getImplementations(ServiceProvider.class);
        for (Class clazz : providers) {
            try {
                ServiceProvider service;
                if (!clazz.isAnnotationPresent(BuiltinService.class)) {
                    logger.warn("service:" + clazz.getName() + " is registered as a builtin but is not properly annotated with @BuiltinService.  This builtin will not be loaded");
                    continue;
                }
                if (!this.serviceProviders.stream().noneMatch(sp -> sp.getClass().getName().equals(clazz.getName())) || !(service = (ServiceProvider)clazz.newInstance()).initialize(null, platformConfiguration)) continue;
                this.registerNewServiceProvider(service);
            }
            catch (Throwable i) {
                logger.error("caught exception while initializing service {} from loader {}", (Object)clazz, (Object)clazz.getClassLoader());
                throw new Error(i);
            }
        }
    }

    @Override
    public void registerExternal(ServiceProvider service) {
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        this.registerNewServiceProvider(service);
    }

    @Override
    public void registerImplementationProvided(ImplementationProvidedServiceProvider service) {
        Assert.assertFalse((boolean)this.hasCreatedSubRegistries);
        logger.info("Registering implementation-provided service " + service);
        this.implementationProvidedServiceProviders.add(service);
    }

    @Override
    public DelegatingServiceRegistry subRegistry(long consumerID) {
        if (consumerID > 0L) {
            this.hasCreatedSubRegistries = true;
        }
        return new DelegatingServiceRegistry(consumerID, this.serviceProviders.toArray(new ServiceProvider[this.serviceProviders.size()]), this.implementationProvidedServiceProviders.toArray(new ImplementationProvidedServiceProvider[this.implementationProvidedServiceProviders.size()]));
    }

    @Override
    public void clearServiceProvidersState() {
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            try {
                serviceProvider.prepareForSynchronization();
            }
            catch (ServiceProviderCleanupException e) {
                throw new RuntimeException(e);
            }
        }
        for (ImplementationProvidedServiceProvider builtInServiceProvider : this.implementationProvidedServiceProviders) {
            try {
                builtInServiceProvider.clear();
            }
            catch (ServiceProviderCleanupException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void notifyServerDidBecomeActive() {
        for (ImplementationProvidedServiceProvider builtInServiceProvider : this.implementationProvidedServiceProviders) {
            builtInServiceProvider.serverDidBecomeActive();
        }
    }

    private void registerNewServiceProvider(ServiceProvider service) {
        logger.info("Initializing " + service);
        Objects.requireNonNull(service);
        this.serviceProviders.add(service);
    }

    public boolean hasUserProvidedServiceProvider(Class<?> serviceInterface) {
        boolean hasProvider = false;
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            if (!serviceProvider.getProvidedServiceTypes().contains(serviceInterface)) continue;
            hasProvider = true;
            break;
        }
        return hasProvider;
    }

    public Map<String, ?> getStateMap() {
        PrintWriter p;
        StringWriter w;
        MappedStateCollector dump;
        LinkedHashMap map = new LinkedHashMap();
        ArrayList<Object> services = new ArrayList<Object>(this.serviceProviders.size());
        map.put("services", services);
        for (ServiceProvider serviceProvider : this.serviceProviders) {
            try {
                dump = new MappedStateCollector(serviceProvider.getClass().getName());
                serviceProvider.addStateTo(dump.subStateDumpCollector(serviceProvider.getClass().getName()));
                services.add(dump.getMap());
            }
            catch (Throwable t) {
                w = new StringWriter();
                p = new PrintWriter(w);
                t.printStackTrace(p);
                services.add(w.toString());
            }
        }
        for (ImplementationProvidedServiceProvider implementationProvidedServiceProvider : this.implementationProvidedServiceProviders) {
            try {
                dump = new MappedStateCollector(implementationProvidedServiceProvider.getClass().getName());
                implementationProvidedServiceProvider.addStateTo(dump);
                services.add(dump.getMap());
            }
            catch (Throwable t) {
                w = new StringWriter();
                p = new PrintWriter(w);
                t.printStackTrace(p);
                services.add(w.toString());
            }
        }
        return map;
    }
}

