/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class ResponseWaiter
implements Future<Void> {
    private boolean done;
    private final long start = System.currentTimeMillis();

    ResponseWaiter() {
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public synchronized boolean isDone() {
        return this.done;
    }

    @Override
    public synchronized Void get() throws InterruptedException, ExecutionException {
        while (!this.done) {
            this.wait();
        }
        System.out.println("returning " + this);
        return null;
    }

    @Override
    public synchronized Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        long timeoutTime = unit.toNanos(timeout) + System.nanoTime();
        while (!this.done) {
            long waitTime = TimeUnit.NANOSECONDS.toMillis(timeoutTime - System.nanoTime());
            if (waitTime <= 0L) {
                throw new TimeoutException();
            }
            this.wait(waitTime);
        }
        return null;
    }

    synchronized void done() {
        this.done = true;
        this.notifyAll();
    }

    public String toString() {
        return "ResponseWaiter{" + System.identityHashCode(this) + ", time=" + (System.currentTimeMillis() - this.start) + '}';
    }
}

