/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.exception.TCNotRunningException;
import com.tc.logging.TCLogging;
import com.tc.server.TCServer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.EnumSet;
import org.terracotta.entity.StateDumpCollector;
import org.terracotta.entity.StateDumpable;
import org.terracotta.monitoring.PlatformService;
import org.terracotta.monitoring.PlatformStopException;
import org.terracotta.server.ServerEnv;
import org.terracotta.server.StopAction;

public class PlatformServiceImpl
implements PlatformService,
StateDumpable {
    private final TCServer tcServer;

    public PlatformServiceImpl(TCServer tcServer) {
        this.tcServer = tcServer;
    }

    public void dumpPlatformState() {
        this.tcServer.dump();
    }

    public void stopPlatform() {
        this.tcServer.stop(new StopAction[0]);
    }

    public long uptime() {
        return System.currentTimeMillis() - this.tcServer.getStartTime();
    }

    public void fatalError(String description) {
        TCLogging.getConsoleLogger().error("A fatal error occurred: " + description);
        System.exit(3);
    }

    public InputStream getPlatformConfiguration() {
        return new ByteArrayInputStream(ServerEnv.getServer().getConfiguration().getBytes(Charset.defaultCharset()));
    }

    private StopAction[] convert(PlatformService.RestartMode mode) {
        switch (mode) {
            case STOP_AND_RESTART: {
                return EnumSet.of(StopAction.RESTART).toArray(new StopAction[0]);
            }
            case STOP_ONLY: {
                return EnumSet.noneOf(StopAction.class).toArray(new StopAction[0]);
            }
            case ZAP_AND_RESTART: {
                return EnumSet.of(StopAction.ZAP, StopAction.RESTART).toArray(new StopAction[0]);
            }
            case ZAP_AND_STOP: {
                return EnumSet.of(StopAction.ZAP).toArray(new StopAction[0]);
            }
        }
        return EnumSet.noneOf(StopAction.class).toArray(new StopAction[0]);
    }

    public void stopPlatformIfPassive(PlatformService.RestartMode restartMode) throws PlatformStopException {
        this.tcServer.stopIfPassive(this.convert(restartMode));
        throw new TCNotRunningException("shutdown as PASSIVE");
    }

    public void stopPlatformIfActive(PlatformService.RestartMode restartMode) throws PlatformStopException {
        this.tcServer.stopIfActive(this.convert(restartMode));
        throw new TCNotRunningException("shutdown as ACTIVE");
    }

    public void stopPlatform(PlatformService.RestartMode restartMode) {
        this.tcServer.stop(this.convert(restartMode));
        throw new TCNotRunningException("shutdown");
    }

    public void addStateTo(StateDumpCollector stateDumpCollector) {
        stateDumpCollector.addState("tcServerState", (Object)this.tcServer.getState());
        stateDumpCollector.addState("tcServerConfig", (Object)this.tcServer.getConfig());
    }
}

