/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import java.io.Serializable;
import java.util.Collection;
import org.slf4j.Logger;
import org.terracotta.monitoring.IStripeMonitoring;
import org.terracotta.monitoring.PlatformServer;

class IStripeMonitoringWrapper
implements IStripeMonitoring {
    private final Collection<IStripeMonitoring> underlying;
    private final Logger logger;

    public IStripeMonitoringWrapper(Collection<IStripeMonitoring> underlying, Logger logger) {
        this.underlying = underlying;
        this.logger = logger;
    }

    public void serverDidBecomeActive(PlatformServer self) {
        try {
            this.underlying.forEach(u -> u.serverDidBecomeActive(self));
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking serverDidBecomeActive", (Throwable)e);
        }
    }

    public void serverDidJoinStripe(PlatformServer server) {
        try {
            this.underlying.forEach(u -> u.serverDidJoinStripe(server));
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking serverDidJoinStripe", (Throwable)e);
        }
    }

    public void serverDidLeaveStripe(PlatformServer server) {
        try {
            this.underlying.forEach(u -> u.serverDidLeaveStripe(server));
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking serverDidLeaveStripe", (Throwable)e);
        }
    }

    public boolean addNode(PlatformServer sender, String[] parents, String name, Serializable value) {
        try {
            return this.underlying.stream().map(u -> u.addNode(sender, parents, name, value)).reduce(Boolean.TRUE, (m, n) -> m & n);
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking addNode", (Throwable)e);
            return false;
        }
    }

    public boolean removeNode(PlatformServer sender, String[] parents, String name) {
        try {
            return this.underlying.stream().map(u -> u.removeNode(sender, parents, name)).reduce(Boolean.TRUE, (m, n) -> m & n);
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking removeNode", (Throwable)e);
            return false;
        }
    }

    public void pushBestEffortsData(PlatformServer sender, String name, Serializable data) {
        try {
            this.underlying.forEach(u -> u.pushBestEffortsData(sender, name, data));
        }
        catch (Exception e) {
            this.logger.warn("caught exception while invoking pushBestEffortsData", (Throwable)e);
        }
    }
}

