/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.async.api.Sink;
import com.tc.bytes.TCByteBuffer;
import com.tc.bytes.TCByteBufferFactory;
import com.tc.entity.VoltronEntityMessage;
import com.tc.exception.ServerException;
import com.tc.net.ClientID;
import com.tc.object.ClientInstanceID;
import com.tc.object.EntityDescriptor;
import com.tc.object.EntityID;
import com.tc.object.FetchID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.CreateMessage;
import com.tc.objectserver.entity.DestroyMessage;
import com.tc.objectserver.entity.ReconfigureMessage;
import com.tc.objectserver.handler.RetirementManager;
import com.tc.util.Assert;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.terracotta.entity.EntityMessage;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.ExplicitRetirementHandle;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EntityMessengerService<M extends EntityMessage, R extends EntityResponse>
implements IEntityMessenger<M, R>,
ManagedEntity.LifecycleListener {
    private final AtomicLong NEXT_FAKE_TXN_ID = new AtomicLong();
    private final Sink<VoltronEntityMessage> messageSink;
    private final boolean waitForReceived;
    private final RetirementManager retirementManager;
    private final MessageCodec<M, R> codec;
    private final EntityDescriptor fakeDescriptor;
    private final EntityDescriptor lifecycleDescriptor;
    private final ConcurrentHashMap<ExplicitRetirementHandle, Handle> retirementHandles = new ConcurrentHashMap();

    public EntityMessengerService(Sink<VoltronEntityMessage> messageSink, ManagedEntity owningEntity, boolean waitForReceived) {
        Assert.assertNotNull(messageSink);
        Assert.assertNotNull((Object)owningEntity);
        this.messageSink = messageSink;
        this.waitForReceived = waitForReceived;
        this.retirementManager = owningEntity.getRetirementManager();
        Assert.assertTrue((null != this.retirementManager ? 1 : 0) != 0);
        this.codec = owningEntity.getCodec();
        Assert.assertNotNull(this.codec);
        this.fakeDescriptor = EntityDescriptor.createDescriptorForInvoke((FetchID)new FetchID(owningEntity.getConsumerID()), (ClientInstanceID)ClientInstanceID.NULL_ID);
        this.lifecycleDescriptor = EntityDescriptor.createDescriptorForLifecycle((EntityID)owningEntity.getID(), (long)owningEntity.getVersion());
    }

    public void destroySelf() {
        this.messageSink.addToSink((Object)new DestroyMessage(this.lifecycleDescriptor));
    }

    public void create(String type, String name, long version, byte[] configuration) {
        this.messageSink.addToSink((Object)new CreateMessage(type, name, version, configuration));
    }

    public void reconfigureSelf(byte[] configuration) {
        this.messageSink.addToSink((Object)new ReconfigureMessage(this.lifecycleDescriptor, configuration));
    }

    public void messageSelf(M message) throws MessageCodecException {
        this.messageSelf(message, null);
    }

    public void messageSelf(M message, Consumer<IEntityMessenger.MessageResponse<R>> response) throws MessageCodecException {
        this.scheduleMessage(message, response);
    }

    public ExplicitRetirementHandle deferRetirement(String tag, M originalMessageToDefer, M futureMessage) {
        this.retirementManager.deferRetirement((EntityMessage)originalMessageToDefer, (EntityMessage)futureMessage);
        return new Handle(this, tag, (EntityMessage)futureMessage);
    }

    public void messageSelfAndDeferRetirement(M originalMessageToDefer, M newMessageToSchedule) throws MessageCodecException {
        this.messageSelfAndDeferRetirement(originalMessageToDefer, newMessageToSchedule, null);
    }

    public void messageSelfAndDeferRetirement(M originalMessageToDefer, M newMessageToSchedule, Consumer<IEntityMessenger.MessageResponse<R>> response) throws MessageCodecException {
        this.retirementManager.deferRetirement((EntityMessage)originalMessageToDefer, (EntityMessage)newMessageToSchedule);
        this.scheduleMessage(newMessageToSchedule, response);
    }

    @Override
    public synchronized void entityCreated(ManagedEntity sender) {
    }

    @Override
    public synchronized void entityDestroyed(ManagedEntity sender) {
    }

    private void scheduleMessage(M message, Consumer<IEntityMessenger.MessageResponse<R>> response) throws MessageCodecException {
        FakeEntityMessage interEntityMessage = this.encodeAsFake(message, response);
        this.retirementManager.registerServerMessage((EntityMessage)message);
        this.messageSink.addToSink((Object)interEntityMessage);
    }

    private FakeEntityMessage encodeAsFake(M message, Consumer<IEntityMessenger.MessageResponse<R>> response) throws MessageCodecException {
        byte[] serializedMessage = this.codec.encodeMessage(message);
        FakeEntityMessage<R> interEntityMessage = new FakeEntityMessage<R>(this.fakeDescriptor, (EntityMessage)message, TCByteBufferFactory.wrap((byte[])serializedMessage), response, this.waitForReceived);
        return interEntityMessage;
    }

    public static class Handle
    implements ExplicitRetirementHandle {
        private final String tag;
        private final M futureMessage;
        private final long nowTimeNS;
        private final boolean active = true;
        final /* synthetic */ EntityMessengerService this$0;

        private Handle(String tag, M futureMessage) {
            this.this$0 = this$0;
            this.tag = tag;
            this.futureMessage = futureMessage;
            this.nowTimeNS = System.nanoTime();
            ((EntityMessengerService)this$0).retirementHandles.put(this, this);
        }

        public String getTag() {
            return this.tag;
        }

        public void release() throws MessageCodecException {
            if (this.this$0.retirementHandles.remove(this) != null) {
                this.this$0.messageSelf(this.futureMessage);
            }
        }

        public void release(Consumer consumer) throws MessageCodecException {
            if (this.this$0.retirementHandles.remove(this) != null) {
                this.this$0.messageSelf(this.futureMessage, consumer);
            }
        }

        public boolean isActive() {
            return true;
        }

        public long getCreationTimeMS() {
            return TimeUnit.MILLISECONDS.convert(this.nowTimeNS, TimeUnit.NANOSECONDS);
        }

        public String toString() {
            return "ExplicitRetirementHandle: { active=true tag=" + this.tag + " age=" + this.nowTimeNS + "ns";
        }
    }

    public class FakeEntityMessage<R extends EntityResponse>
    implements VoltronEntityMessage {
        private final EntityDescriptor descriptor;
        private final EntityMessage identityMessage;
        private final TCByteBuffer message;
        private final Consumer<IEntityMessenger.MessageResponse<R>> response;
        private final boolean waitForReceived;

        public FakeEntityMessage(EntityDescriptor descriptor, EntityMessage identityMessage, TCByteBuffer message, Consumer<IEntityMessenger.MessageResponse<R>> response, boolean waitForReceived) {
            Assert.assertNotNull((Object)message);
            this.descriptor = descriptor;
            this.identityMessage = identityMessage;
            this.message = message.asReadOnlyBuffer();
            this.response = response;
            this.waitForReceived = waitForReceived;
        }

        public ClientID getSource() {
            return ClientID.NULL_ID;
        }

        public TransactionID getTransactionID() {
            return new TransactionID(EntityMessengerService.this.NEXT_FAKE_TXN_ID.incrementAndGet());
        }

        public EntityDescriptor getEntityDescriptor() {
            return this.descriptor;
        }

        public boolean doesRequireReplication() {
            return true;
        }

        public boolean doesRequestReceived() {
            return this.waitForReceived;
        }

        public boolean doesRequestRetired() {
            return false;
        }

        public VoltronEntityMessage.Type getVoltronType() {
            return VoltronEntityMessage.Type.INVOKE_ACTION;
        }

        public TCByteBuffer getExtendedData() {
            return this.message.duplicate();
        }

        public TransactionID getOldestTransactionOnClient() {
            return TransactionID.NULL_ID;
        }

        public EntityMessage getEntityMessage() {
            return this.identityMessage;
        }

        public Consumer<byte[]> getCompletionHandler() {
            return this.response == null ? null : raw -> this.response.accept(new IEntityMessenger.MessageResponse((byte[])raw){
                final /* synthetic */ byte[] val$raw;
                {
                    this.val$raw = byArray;
                }

                public boolean wasExceptionThrown() {
                    return false;
                }

                public Exception getException() {
                    return null;
                }

                public EntityResponse getResponse() {
                    try {
                        return EntityMessengerService.this.codec.decodeResponse(this.val$raw);
                    }
                    catch (MessageCodecException codec) {
                        throw new RuntimeException(codec);
                    }
                }
            });
        }

        public Consumer<ServerException> getExceptionHandler() {
            return this.response == null ? null : exception -> this.response.accept(new IEntityMessenger.MessageResponse((ServerException)((Object)exception)){
                final /* synthetic */ ServerException val$exception;
                {
                    this.val$exception = serverException;
                }

                public boolean wasExceptionThrown() {
                    return true;
                }

                public Exception getException() {
                    return this.val$exception;
                }

                public EntityResponse getResponse() {
                    return null;
                }
            });
        }
    }
}

