/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.async.api.Sink;
import com.tc.entity.VoltronEntityMessage;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.EntityMessengerConfiguration;
import com.tc.services.EntityMessengerService;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.util.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Function;
import org.terracotta.entity.IEntityMessenger;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.StateDumpCollector;

public class EntityMessengerProvider
implements ImplementationProvidedServiceProvider {
    private Sink<VoltronEntityMessage> messageSink;
    private boolean serverIsActive;

    @Override
    public <T> T getService(long consumerID, ManagedEntity owningEntity, ServiceConfiguration<T> configuration) {
        Assert.assertNotNull(this.messageSink);
        Assert.assertNotNull((Object)owningEntity);
        T service = null;
        if (this.serverIsActive) {
            boolean waitForReceived = true;
            if (configuration instanceof EntityMessengerConfiguration) {
                waitForReceived = ((EntityMessengerConfiguration)configuration).isWaitForReceived();
            } else if (configuration instanceof Function) {
                waitForReceived = (Boolean)((Function)configuration).apply("PASSIVE_CONFIRMATION");
            }
            EntityMessengerService es = new EntityMessengerService(this.messageSink, owningEntity, Optional.ofNullable(waitForReceived).orElse(false));
            owningEntity.addLifecycleListener(es);
            service = configuration.getServiceType().cast(es);
        }
        return service;
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        return Collections.singleton(IEntityMessenger.class);
    }

    @Override
    public void clear() throws ServiceProviderCleanupException {
    }

    @Override
    public void serverDidBecomeActive() {
        Assert.assertNotNull(this.messageSink);
        this.serverIsActive = true;
    }

    public void setMessageSink(Sink<VoltronEntityMessage> messageSink) {
        Assert.assertNotNull(messageSink);
        this.messageSink = messageSink;
    }

    @Override
    public void addStateTo(StateDumpCollector stateDumpCollector) {
        StateDumpCollector dumpCollector = stateDumpCollector.subStateDumpCollector(this.getClass().getCanonicalName());
        dumpCollector.addState("isServerActive", (Object)this.serverIsActive);
    }
}

