/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.net.NodeID;
import com.tc.object.ClientInstanceID;
import com.tc.object.tx.TransactionID;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.objectserver.entity.ClientDescriptorImpl;
import com.tc.services.ClientAccount;
import com.tc.util.Assert;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ClientDescriptor;
import org.terracotta.entity.EntityResponse;
import org.terracotta.entity.MessageCodec;
import org.terracotta.entity.MessageCodecException;

public class EntityClientCommunicatorService
implements ClientCommunicator {
    private final ConcurrentMap<NodeID, ClientAccount> clientAccounts;
    private final ManagedEntity owningEntity;

    public EntityClientCommunicatorService(ConcurrentMap<NodeID, ClientAccount> clientAccounts, ManagedEntity owningEntity) {
        Assert.assertNotNull(clientAccounts);
        Assert.assertNotNull((Object)owningEntity);
        this.clientAccounts = clientAccounts;
        this.owningEntity = owningEntity;
    }

    public void sendNoResponse(ClientDescriptor clientDescriptor, EntityResponse message) throws MessageCodecException {
        ClientDescriptorImpl rawDescriptor = (ClientDescriptorImpl)clientDescriptor;
        ClientAccount clientAccount = (ClientAccount)this.clientAccounts.get(rawDescriptor.getNodeID());
        if (clientAccount != null) {
            ClientInstanceID clientInstance = rawDescriptor.getClientInstanceID();
            byte[] payload = this.serialize(this.owningEntity.getCodec(), message);
            clientAccount.sendNoResponse(clientInstance, payload);
        }
    }

    public void sendInvokeMessage(ClientDescriptor clientDescriptor, long invokeID, EntityResponse message) throws MessageCodecException {
        ClientDescriptorImpl rawDescriptor = (ClientDescriptorImpl)clientDescriptor;
        ClientAccount clientAccount = (ClientAccount)this.clientAccounts.get(rawDescriptor.getNodeID());
        if (clientAccount != null) {
            TransactionID tid = new TransactionID(invokeID);
            byte[] payload = this.serialize(this.owningEntity.getCodec(), message);
            clientAccount.sendInvokeMessage(tid, payload);
        }
    }

    public void closeClientConnection(ClientDescriptor clientDescriptor) {
        ClientDescriptorImpl descriptor = (ClientDescriptorImpl)clientDescriptor;
        this.clientAccounts.computeIfPresent((NodeID)descriptor.getNodeID(), (node, account) -> {
            account.close();
            return null;
        });
    }

    private <R extends EntityResponse> byte[] serialize(MessageCodec<?, R> codec, EntityResponse response) throws MessageCodecException {
        return codec.encodeResponse(response);
    }
}

