/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.services.InternalServiceRegistry;
import com.tc.util.Assert;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceException;
import org.terracotta.entity.ServiceProvider;

public class DelegatingServiceRegistry
implements InternalServiceRegistry {
    private final long consumerID;
    private final Collection<ServiceProvider> serviceProviders;
    private final Collection<ImplementationProvidedServiceProvider> implementationProvidedServiceProviders;
    private ManagedEntity owningEntity;

    public DelegatingServiceRegistry(long consumerID, ServiceProvider[] providers, ImplementationProvidedServiceProvider[] implementationProvidedProviders) {
        this.consumerID = consumerID;
        this.serviceProviders = Collections.unmodifiableCollection(Arrays.asList(providers));
        this.implementationProvidedServiceProviders = Collections.unmodifiableCollection(Arrays.asList(implementationProvidedProviders));
    }

    public <T> T getService(ServiceConfiguration<T> configuration) throws ServiceException {
        T builtInService = this.getBuiltInService(configuration);
        T externalService = this.getExternalService(configuration);
        if (null != builtInService && null != externalService) {
            throw new ServiceException("Both built-in and external service found for type: " + configuration.getServiceType());
        }
        return null != builtInService ? builtInService : externalService;
    }

    public <T> Collection<T> getServices(ServiceConfiguration<T> configuration) {
        return this.getExternalServices(configuration);
    }

    @Override
    public void setOwningEntity(ManagedEntity entity) {
        Assert.assertNull((Object)this.owningEntity);
        Assert.assertNotNull((Object)entity);
        this.owningEntity = entity;
    }

    private <T> T getBuiltInService(ServiceConfiguration<T> configuration) throws ServiceException {
        Class serviceType = configuration.getServiceType();
        T service = null;
        for (ImplementationProvidedServiceProvider provider : this.implementationProvidedServiceProviders) {
            T oneService;
            if (!provider.getProvidedServiceTypes().contains(serviceType) || null == (oneService = provider.getService(this.consumerID, this.owningEntity, configuration))) continue;
            if (null != service) {
                throw new ServiceException("Multiple built-in service providers matched for type: " + serviceType);
            }
            service = oneService;
        }
        return service;
    }

    private <T> T getExternalService(ServiceConfiguration<T> configuration) throws ServiceException {
        Class serviceType = configuration.getServiceType();
        Object theService = null;
        for (ServiceProvider provider : this.serviceProviders) {
            Object oneService;
            if (!provider.getProvidedServiceTypes().contains(serviceType) || null == (oneService = provider.getService(this.consumerID, configuration))) continue;
            if (theService != null) {
                throw new ServiceException("Multiple service providers matched for type: " + serviceType);
            }
            theService = oneService;
        }
        return (T)theService;
    }

    private <T> Collection<T> getExternalServices(ServiceConfiguration<T> configuration) {
        Class serviceType = configuration.getServiceType();
        ArrayList<Object> choices = new ArrayList<Object>();
        for (ServiceProvider provider : this.serviceProviders) {
            Object oneService;
            if (!provider.getProvidedServiceTypes().contains(serviceType) || (oneService = provider.getService(this.consumerID, configuration)) == null) continue;
            choices.add(oneService);
        }
        return choices;
    }
}

