/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.net.NodeID;
import com.tc.net.core.ProductID;
import com.tc.net.protocol.tcm.ChannelManagerEventListener;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.objectserver.api.ManagedEntity;
import com.tc.services.ClientAccount;
import com.tc.services.ClientMessageSender;
import com.tc.services.EntityClientCommunicatorService;
import com.tc.services.ImplementationProvidedServiceProvider;
import com.tc.util.Assert;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.terracotta.entity.ClientCommunicator;
import org.terracotta.entity.ServiceConfiguration;
import org.terracotta.entity.ServiceProviderCleanupException;
import org.terracotta.entity.StateDumpCollector;

public class CommunicatorService
implements ImplementationProvidedServiceProvider,
ChannelManagerEventListener {
    private final ConcurrentMap<NodeID, ClientAccount> clientAccounts = new ConcurrentHashMap<NodeID, ClientAccount>();
    private final ClientMessageSender sender;
    private boolean serverIsActive;
    private boolean wasInitialized;

    public CommunicatorService(ClientMessageSender sender) {
        this.sender = sender;
    }

    @Override
    public void addStateTo(StateDumpCollector stateDumpCollector) {
        ImplementationProvidedServiceProvider.super.addStateTo(stateDumpCollector);
    }

    public void channelCreated(MessageChannel channel) {
        if (channel.getProductID() != ProductID.DIAGNOSTIC) {
            this.clientAccounts.put(channel.getRemoteNodeID(), new ClientAccount(this.sender, channel));
        }
    }

    public void channelRemoved(MessageChannel channel) {
        ClientAccount clientAccount = (ClientAccount)this.clientAccounts.remove(channel.getRemoteNodeID());
        if (clientAccount != null) {
            clientAccount.close();
        }
    }

    @Override
    public <T> T getService(long consumerID, ManagedEntity owningEntity, ServiceConfiguration<T> configuration) {
        Assert.assertTrue((boolean)this.wasInitialized);
        Assert.assertNotNull((Object)owningEntity);
        T serviceToReturn = null;
        if (this.serverIsActive) {
            EntityClientCommunicatorService service = new EntityClientCommunicatorService(this.clientAccounts, owningEntity);
            serviceToReturn = configuration.getServiceType().cast(service);
        }
        return serviceToReturn;
    }

    @Override
    public Collection<Class<?>> getProvidedServiceTypes() {
        return Collections.singleton(ClientCommunicator.class);
    }

    public void close() {
        this.clientAccounts.values().stream().forEach(a -> a.close());
        this.clientAccounts.clear();
    }

    @Override
    public void clear() throws ServiceProviderCleanupException {
    }

    @Override
    public void serverDidBecomeActive() {
        Assert.assertTrue((boolean)this.wasInitialized);
        this.serverIsActive = true;
    }

    public void initialized() {
        this.wasInitialized = true;
    }
}

