/*
 * Decompiled with CFR 0.152.
 */
package com.tc.services;

import com.tc.net.ClientID;
import com.tc.net.protocol.tcm.MessageChannel;
import com.tc.object.ClientInstanceID;
import com.tc.object.tx.TransactionID;
import com.tc.services.ClientMessageSender;

public class ClientAccount {
    private final ClientID clientID;
    private final ClientMessageSender sender;
    private final MessageChannel channel;
    private volatile boolean open = true;

    ClientAccount(ClientMessageSender sender, MessageChannel channel) {
        this.sender = sender;
        this.clientID = (ClientID)channel.getRemoteNodeID();
        this.channel = channel;
    }

    synchronized void sendNoResponse(ClientInstanceID clientInstance, byte[] payload) {
        if (this.open) {
            this.sender.send(this.clientID, clientInstance, payload);
        }
    }

    synchronized void sendInvokeMessage(TransactionID transaction, byte[] payload) {
        if (this.open) {
            this.sender.send(this.clientID, transaction, payload);
        }
    }

    synchronized void close() {
        if (this.channel.isOpen()) {
            this.channel.close();
        }
        this.open = false;
    }
}

